/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class CollectionTypePropertiesDialogEx
extends AbstractDatatypePropertiesDialog {
    private CollectionType collectionType;
    private JButton bnDataType;
    private TypeElement typeElement;
    private SelectDataTypeDialog datatypeDialog = null;
    private String[] TYPES = new String[]{"ARRAY", "COLLECTION"};
    private JComboBox cbCollectionType;
    private JIntegerField ifMaxElement;

    public CollectionTypePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("CollectionTypePropertiesDialogEx.CollectionTypeProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof CollectionType) {
            this.collectionType = (CollectionType)object;
            this.initDefaults(false);
            this.cbCollectionType.setSelectedItem(this.collectionType.getType());
            try {
                this.ifMaxElement.setValue((long)this.collectionType.getMaxElement());
            }
            catch (NumberFormatException e) {
                this.ifMaxElement.setValue(1L);
            }
            this.ifMaxElement.setEnabled(!this.isCollectionTypeSelected() && this.isEditable());
            this.typeElement = new TypeElement(this.collectionType.getDesignPart(), null);
            this.typeElement.setDesign(this.collectionType.getDesign());
            this.typeElement.setParent(this.collectionType);
            this.collectionType.getElementType().copyDataType(this.typeElement);
            this.bnDataType.setText(this.typeElement.getDataType());
            this.initUsedInAttributes(this.collectionType, (short)4);
            this.initUsedInColumns();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator it = this.collectionType.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.collectionType.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.collectionType.setName(this.tfName.getText());
        this.collectionType.setComment(this.taComments.getText());
        this.collectionType.setNotes(this.taNotes.getText());
        this.typeElement.copyDataType(this.collectionType.getElementType());
        this.collectionType.getElementType().setTypeID(this.typeElement.getTypeID());
        this.collectionType.setType((String)this.cbCollectionType.getSelectedItem());
        if (this.ifMaxElement.isEnabled()) {
            this.collectionType.setMaxElement(this.ifMaxElement.getIntValue());
        }
        this.setResponsibleParties();
        this.setDocuments();
        CollectionTypePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.collectionType.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.collectionType.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getUsedInPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "COLLECTIONTYPE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbCollectionType = new JLabel(LB_COLLECTIONTYPE);
        lbCollectionType.setPreferredSize(this.getDefaultSize());
        this.cbCollectionType = new JComboBox<String>(this.TYPES);
        this.cbCollectionType.setPreferredSize(this.getDefaultSize());
        this.cbCollectionType.setMaximumRowCount(8);
        this.cbCollectionType.setEnabled(this.isEditable());
        this.cbCollectionType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionTypePropertiesDialogEx.this.ifMaxElement.setEnabled(!CollectionTypePropertiesDialogEx.this.isCollectionTypeSelected());
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbCollectionType, this.cbCollectionType));
        JLabel lbMaxElement = new JLabel(LB_MAX_ELEMENTS);
        lbMaxElement.setPreferredSize(this.getDefaultSize());
        this.ifMaxElement = new JIntegerField();
        this.ifMaxElement.setPreferredSize(this.getDefaultSize());
        this.ifMaxElement.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbMaxElement, this.ifMaxElement));
        JLabel lbType = new JLabel(LB_DATATYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(this.getDefaultSize());
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionTypePropertiesDialogEx.this.datatypeDialog = new SelectDataTypeDialog(CollectionTypePropertiesDialogEx.this.getAppView(), CollectionTypePropertiesDialogEx.this.typeElement, CollectionTypePropertiesDialogEx.this.bnDataType);
                CollectionTypePropertiesDialogEx.this.datatypeDialog.initProperties(false);
                CollectionTypePropertiesDialogEx.this.datatypeDialog.showDialog();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbType, this.bnDataType));
    }

    private boolean isCollectionTypeSelected() {
        if (this.cbCollectionType.getSelectedItem().equals(this.TYPES[1])) {
            this.ifMaxElement.setValue(1L);
            return true;
        }
        return false;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }
}

