/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;

public class MethodPropertiesDialogEx
extends AbstractPropertiesDialog {
    private Method method;
    private JCheckBox chConstructor;
    private JCheckBox chOverriding;
    private JComboBox cbOverrided;
    private JButton bnDataType;
    private JButton bnRemoveReturn;
    private MethodParam temp;
    private JTable pTable;
    private List pList;
    private int counter = 0;
    private JPanel pnParameters;
    private JPanel pnBody;
    private JTextArea taBody;

    public MethodPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public MethodPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("MethodPropertiesDialogEx.MethodProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Method) {
            this.method = (Method)object;
            this.initDefaults(false);
            this.chConstructor.setSelected(this.method.isConstructor());
            this.chOverriding.setSelected(this.method.isOverriding());
            this.fillComboItems(this.getInheritedMethods(), this.cbOverrided, true);
            this.cbOverrided.setSelectedItem(this.method.getOverridedMethod());
            MethodParam returnValue = this.method.getReturnValue();
            if (returnValue != null) {
                this.temp = new MethodParam(this.method.getDesignPart());
                returnValue.copyDataType(this.temp);
                this.bnDataType.setText(returnValue.getDataType());
            } else {
                this.bnDataType.setText(Messages.getString("MethodPropertiesDialogEx.NoReturn"));
                this.bnRemoveReturn.setEnabled(false);
            }
            this.pList.addAll(this.method.getParameters());
            this.taBody.setText(this.method.getBody());
            this.dynamicPropertiesList.clear();
            Iterator it = this.method.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.method.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        MethodPropertiesDialogEx.stopCellEditing(this.pTable);
        MethodPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.method.setName(this.tfName.getText());
        this.method.setComment(this.taComments.getText());
        this.method.setNotes(this.taNotes.getText());
        this.method.setConstructor(this.chConstructor.isSelected());
        this.method.setOverriding(this.chOverriding.isSelected());
        this.method.setOverridedMethod((Method)this.cbOverrided.getSelectedItem());
        this.method.setBody(this.taBody.getText());
        this.method.setReturnValue(this.temp);
        Object[] params = this.method.getParameters().toArray();
        for (int i = 0; i < params.length; ++i) {
            if (this.pList.contains(params[i])) continue;
            this.method.removeParameter((MethodParam)params[i]);
        }
        Iterator it = this.pList.iterator();
        int k = 0;
        while (it.hasNext()) {
            MethodParam param = (MethodParam)it.next();
            this.method.addParameter(k, param);
            ++k;
        }
        this.method.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.method.setProperty(dp.getName(), dp.getValue());
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getParametersPanel());
        this.addToTree(root, this.getBodyPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "METHOD_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbConstructor = new JLabel(LB_CONSTRUCTOR);
        lbConstructor.setPreferredSize(this.getDefaultSize());
        this.chConstructor = new JCheckBox();
        this.chConstructor.setPreferredSize(this.getDefaultSize());
        this.chConstructor.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbConstructor, this.chConstructor));
        JLabel lbOverriding = new JLabel(LB_OVERRIDING);
        lbOverriding.setPreferredSize(this.getDefaultSize());
        this.chOverriding = new JCheckBox();
        this.chOverriding.setPreferredSize(this.getDefaultSize());
        this.chOverriding.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbOverriding, this.chOverriding));
        JLabel lbOverrided = new JLabel(LB_OVERRIDED_METHOD);
        lbOverrided.setPreferredSize(this.getDefaultSize());
        this.cbOverrided = new JComboBox();
        this.cbOverrided.setPreferredSize(this.getDefaultSize());
        this.cbOverrided.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbOverrided, this.cbOverrided));
        JLabel lbReturnValue = new JLabel(LB_RETURN_VALUE);
        lbReturnValue.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(new Dimension(FIELD_WIDTH + 80, 20));
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MethodParam mp = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                if (MethodPropertiesDialogEx.this.temp != null) {
                    MethodPropertiesDialogEx.this.temp.copyDataType(mp);
                }
                SelectDataTypeDialog datatypeDialog = new SelectDataTypeDialog(MethodPropertiesDialogEx.this.getAppView(), mp, MethodPropertiesDialogEx.this.bnDataType);
                datatypeDialog.initProperties(false);
                int result = datatypeDialog.showDialog();
                if (result == 1) {
                    if (MethodPropertiesDialogEx.this.temp == null) {
                        MethodPropertiesDialogEx.this.temp = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                    }
                    mp.copyDataType(MethodPropertiesDialogEx.this.temp);
                    MethodPropertiesDialogEx.this.bnRemoveReturn.setEnabled(true);
                }
            }
        });
        JPanel jpDatatype = this.createRow(lbReturnValue, this.bnDataType);
        this.bnRemoveReturn = new JButton(GUIConfiguration.getInstance().getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.bnRemoveReturn.setToolTipText(BTN_REMOVE);
        this.bnRemoveReturn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MethodPropertiesDialogEx.this.temp = null;
                MethodPropertiesDialogEx.this.bnDataType.setText(Messages.getString("MethodPropertiesDialogEx.NoReturn"));
                MethodPropertiesDialogEx.this.bnRemoveReturn.setEnabled(false);
            }
        });
        this.addRowToGeneralPanel(this.createRow(jpDatatype, this.bnRemoveReturn, true));
    }

    private Object[] getInheritedMethods() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (StructuredType st = this.method.getStructuredType().getParentType(); st != null; st = st.getParentType()) {
            for (int i = 0; i < st.getMethods().length; ++i) {
                result.add(st.getMethod(i));
            }
        }
        return result.toArray();
    }

    protected String generateName() {
        String name = Messages.getString("MethodPropertiesDialogEx.Arg");
        int newNumber = 0;
        int lastNumber = this.pList.size();
        if (lastNumber != 0) {
            newNumber = this.counter = lastNumber + 1;
        } else {
            ++this.counter;
            newNumber = this.counter;
        }
        String attrName = name.concat(Integer.toString(newNumber));
        while (this.attributeExists(attrName)) {
            newNumber = ++this.counter;
            attrName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return attrName;
    }

    private boolean attributeExists(String name) {
        for (int i = 0; i < this.pList.size(); ++i) {
            MethodParam param = (MethodParam)this.pList.get(i);
            if (!name.equalsIgnoreCase(param.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean moveToIndex(DesignObject object, int index) {
        if (this.pList.contains(object) && this.pList.size() > index && index >= 0) {
            this.pList.remove(object);
            this.pList.add(index, object);
            return true;
        }
        return false;
    }

    protected JPanel getParametersPanel() {
        if (this.pnParameters == null) {
            this.pnParameters = this.createPage(Messages.getString("MethodPropertiesDialogEx.Parameters"));
            this.pList = new ArrayList();
            this.pTable = new JTable(new ParamModel());
            this.pTable.setSelectionMode(0);
            this.pTable.getColumnModel().getColumn(1).setCellEditor(new DatatypeEditor());
            JScrollPane scrollpane = new JScrollPane(this.pTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MethodParam param = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                        param.setName(MethodPropertiesDialogEx.this.generateName());
                        param.setDesign(MethodPropertiesDialogEx.this.method.getDesign());
                        MethodPropertiesDialogEx.this.pList.add(param);
                        MethodPropertiesDialogEx.this.pTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (objectNumber != -1 && MethodPropertiesDialogEx.this.pList.size() > 0 && objectNumber < MethodPropertiesDialogEx.this.pList.size()) {
                            MethodPropertiesDialogEx.this.pList.remove(objectNumber);
                            MethodPropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                JButton btnMoveUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
                btnMoveUp.setToolTipText(BTN_MOVE_UP);
                btnMoveUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (objectNumber > -1 && objectNumber < MethodPropertiesDialogEx.this.pList.size()) {
                            DesignObject obj = (DesignObject)MethodPropertiesDialogEx.this.pList.get(objectNumber);
                            MethodPropertiesDialogEx.this.moveToIndex(obj, objectNumber - 1);
                            MethodPropertiesDialogEx.this.pTable.changeSelection(objectNumber - 1, 0, false, false);
                            MethodPropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                JButton btnMoveDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
                btnMoveDown.setToolTipText(BTN_MOVE_DOWN);
                btnMoveDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (objectNumber > -1 && objectNumber < MethodPropertiesDialogEx.this.pList.size()) {
                            DesignObject obj = (DesignObject)MethodPropertiesDialogEx.this.pList.get(objectNumber);
                            MethodPropertiesDialogEx.this.moveToIndex(obj, objectNumber + 1);
                            MethodPropertiesDialogEx.this.pTable.changeSelection(objectNumber + 1, 0, false, false);
                            MethodPropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                JToolBar toolBar = new JToolBar(0);
                toolBar.setFloatable(false);
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
                toolBar.add(btnMoveUp);
                toolBar.add(btnMoveDown);
                buttonGeneral.add(toolBar);
            }
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnParameters.add(aPanel);
        }
        return this.pnParameters;
    }

    protected JPanel getBodyPanel() {
        if (this.pnBody == null) {
            this.pnBody = this.createPage(Messages.getString("MethodPropertiesDialogEx.Body"));
            this.taBody = new JTextArea();
            this.taBody.setEnabled(this.isEditable());
            this.pnBody.add(new JScrollPane(this.taBody));
        }
        return this.pnBody;
    }

    public class DatatypeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        protected static final String EDIT = "edit";
        JButton button = new JButton();
        MethodParam param;

        public DatatypeEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.param = (MethodParam)value;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.param;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                MethodParam temp = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                this.param.copyDataType(temp);
                SelectDataTypeDialog datatypeDialog = new SelectDataTypeDialog(MethodPropertiesDialogEx.this.getAppView(), temp, null);
                datatypeDialog.initProperties(false);
                int result = datatypeDialog.showDialog();
                if (result == 1) {
                    temp.copyDataType(this.param);
                }
                this.fireEditingStopped();
            }
        }
    }

    private class ParamModel
    extends AbstractTableModel {
        private ParamModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return MethodPropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("MethodPropertiesDialogEx.Name");
            }
            if (column == 1) {
                return Messages.getString("MethodPropertiesDialogEx.Datatype");
            }
            if (column == 2) {
                return Messages.getString("MethodPropertiesDialogEx.DefaultValue");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return MethodPropertiesDialogEx.this.isEditable();
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            MethodParam param = (MethodParam)MethodPropertiesDialogEx.this.pList.get(row);
            if (column == 0) {
                param.setName(String.valueOf(aValue));
            } else if (column == 2) {
                param.setDefaultValue(String.valueOf(aValue));
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            MethodParam param = (MethodParam)MethodPropertiesDialogEx.this.pList.get(row);
            if (col == 0) {
                return param.getName();
            }
            if (col == 1) {
                return param;
            }
            if (col == 2) {
                return param.getDefaultValue();
            }
            return new Integer(row * col);
        }
    }
}

