/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectLogicalTypeDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectDataTypeDialog
extends CustomDialog {
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private DataTypeObject object;
    private JPanel buttonPanel;
    private JPanel general;
    private JButton bnLogicalType;
    private JButton btDataType;
    private JDialog dialog;
    private ButtonGroup bGroup;
    private JRadioButton rbDomain;
    private JComboBox cbDomain;
    private JRadioButton rbLogicalType;
    private JRadioButton rbDistinctType;
    private JRadioButton rbStructuredType;
    private SelectLogicalTypeDialog logicalDialog = null;
    private JComboBox cbDistinctType;
    private JComboBox cbStructuredType;
    private int result = 0;
    private JCheckBox chbReference;
    private JRadioButton rbCollectionType;
    private JComboBox cbCollectionType;
    protected boolean canExit = true;
    private CollectionType temp;
    private static int DEFAULT_COMBO_MAX_ROW_COUNT = 8;
    private static Dimension dim = new Dimension(150, 20);

    public SelectDataTypeDialog(ApplicationView view, DataTypeObject object, JButton btDataType) {
        super(view);
        this.object = object;
        this.btDataType = btDataType;
        this.general = new JPanel(new SpringLayout());
        this.general.setBorder(BorderFactory.createEtchedBorder(0));
        this.add((Component)this.general, "Center");
        JPanel bottomPanel = this.getButtonPanel();
        this.add((Component)bottomPanel, "South");
        this.general.setPreferredSize(new Dimension(350, 195));
    }

    private void initGeneral() {
        this.bGroup = new ButtonGroup();
        if (this.object != null) {
            this.initDomain();
        }
        this.initLogicalType();
        this.initDistinctType();
        this.initStructuredType();
        this.initCollectionType();
    }

    private void initDomain() {
        this.rbDomain = new JRadioButton(Messages.getString("SelectDataTypeDialog.Domain"));
        this.rbDomain.addActionListener(new RadioListener());
        this.bGroup.add(this.rbDomain);
        this.general.add(this.rbDomain);
        this.setObjectConstraints(this.rbDomain, 10, 15);
        this.cbDomain = new JComboBox();
        this.cbDomain.setPreferredSize(dim);
        this.cbDomain.setMaximumRowCount(DEFAULT_COMBO_MAX_ROW_COUNT);
        this.cbDomain.setBackground(Color.WHITE);
        this.general.add(this.cbDomain);
        this.setObjectConstraints(this.cbDomain, 180, 15);
    }

    private void initLogicalType() {
        this.rbLogicalType = new JRadioButton(Messages.getString("SelectDataTypeDialog.LogicalType"));
        this.rbLogicalType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbLogicalType);
        this.general.add(this.rbLogicalType);
        this.setObjectConstraints(this.rbLogicalType, 10, 45);
        this.bnLogicalType = new JButton(Messages.getString("SelectDataTypeDialog.Logical"));
        this.bnLogicalType.setFont(new Font(this.bnLogicalType.getFont().getName(), 0, this.bnLogicalType.getFont().getSize()));
        this.bnLogicalType.setPreferredSize(dim);
        this.bnLogicalType.setHorizontalAlignment(0);
        this.general.add(this.bnLogicalType);
        this.setObjectConstraints(this.bnLogicalType, 180, 45);
    }

    private void initDistinctType() {
        this.rbDistinctType = new JRadioButton(Messages.getString("SelectDataTypeDialog.DistinctType"));
        this.rbDistinctType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbDistinctType);
        this.general.add(this.rbDistinctType);
        this.setObjectConstraints(this.rbDistinctType, 10, 75);
        this.cbDistinctType = new JComboBox();
        this.cbDistinctType.setFont(new Font(this.cbDistinctType.getFont().getName(), 0, this.cbDistinctType.getFont().getSize()));
        this.cbDistinctType.setPreferredSize(dim);
        this.cbDistinctType.setMaximumRowCount(DEFAULT_COMBO_MAX_ROW_COUNT);
        this.cbDistinctType.setBackground(Color.WHITE);
        this.general.add(this.cbDistinctType);
        this.setObjectConstraints(this.cbDistinctType, 180, 75);
    }

    private void initCollectionType() {
        this.rbCollectionType = new JRadioButton(Messages.getString("SelectDataTypeDialog.CollectionType"));
        this.rbCollectionType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbCollectionType);
        this.general.add(this.rbCollectionType);
        this.setObjectConstraints(this.rbCollectionType, 10, 105);
        this.cbCollectionType = new JComboBox();
        this.cbCollectionType.setFont(new Font(this.cbCollectionType.getFont().getName(), 0, this.cbCollectionType.getFont().getSize()));
        this.cbCollectionType.setPreferredSize(dim);
        this.cbCollectionType.setMaximumRowCount(DEFAULT_COMBO_MAX_ROW_COUNT);
        this.cbCollectionType.setBackground(Color.WHITE);
        this.general.add(this.cbCollectionType);
        this.setObjectConstraints(this.cbCollectionType, 180, 105);
    }

    private void initStructuredType() {
        this.rbStructuredType = new JRadioButton(Messages.getString("SelectDataTypeDialog.StructuredType"));
        this.rbStructuredType.addActionListener(new RadioListener());
        this.bGroup.add(this.rbStructuredType);
        this.general.add(this.rbStructuredType);
        this.setObjectConstraints(this.rbStructuredType, 10, 135);
        this.cbStructuredType = new JComboBox();
        this.cbStructuredType.setFont(new Font(this.cbStructuredType.getFont().getName(), 0, this.cbStructuredType.getFont().getSize()));
        this.cbStructuredType.setPreferredSize(dim);
        this.cbStructuredType.setMaximumRowCount(DEFAULT_COMBO_MAX_ROW_COUNT);
        this.cbStructuredType.setBackground(Color.WHITE);
        this.general.add(this.cbStructuredType);
        this.setObjectConstraints(this.cbStructuredType, 180, 135);
        this.chbReference = new JCheckBox(Messages.getString("SelectDataTypeDialog.Reference"));
        this.general.add(this.chbReference);
        this.setObjectConstraints(this.chbReference, 175, 165);
    }

    public int showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            JButton ok = new JButton(Messages.getString("SelectDataTypeDialog.OK"));
            ok.setMnemonic(79);
            ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectDataTypeDialog.this.setProperties();
                    if (SelectDataTypeDialog.this.canExit) {
                        SelectDataTypeDialog.this.result = 1;
                        SelectDataTypeDialog.this.close();
                    }
                    SelectDataTypeDialog.this.canExit = true;
                }
            });
            JButton cancel = new JButton(Messages.getString("SelectDataTypeDialog.Cancel"));
            cancel.setMnemonic(67);
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectDataTypeDialog.this.result = 0;
                    SelectDataTypeDialog.this.close();
                }
            });
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(ok);
            this.buttonPanel.add(cancel);
            this.buttonPanel.add(bnHelp);
        }
        return this.buttonPanel;
    }

    protected void setObjectConstraints(Component c, int x, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    public void initProperties(final boolean usePreferredList) {
        Iterator it;
        this.initGeneral();
        this.cbDomain.removeAllItems();
        this.cbDistinctType.removeAllItems();
        this.cbStructuredType.removeAllItems();
        this.cbCollectionType.removeAllItems();
        if (usePreferredList) {
            it = this.getApplicationView().getSettings().getPrefDomains().iterator();
            while (it.hasNext()) {
                this.cbDomain.addItem(it.next());
            }
        } else {
            it = this.object.getDesign().getDomainSet().iterator();
            while (it.hasNext()) {
                this.cbDomain.addItem(it.next());
            }
        }
        if (this.object.getType() instanceof Domain) {
            this.cbDomain.setSelectedItem(this.object.getType());
        } else if (this.object.getType() instanceof LogicalDatatype) {
            this.bnLogicalType.setText(this.object.getDataType());
        } else {
            this.bnLogicalType.setText(this.object.getDesign().getLogicalDatatypeSet().getDefaultType().getName());
        }
        this.bnLogicalType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDataTypeDialog.this.logicalDialog = new SelectLogicalTypeDialog(SelectDataTypeDialog.this.getApplicationView(), SelectDataTypeDialog.this.object, SelectDataTypeDialog.this.bnLogicalType, SelectDataTypeDialog.this.object.getSelectedRDBMSType().getName(), usePreferredList);
                SelectDataTypeDialog.this.logicalDialog.initProperties();
                SelectDataTypeDialog.this.logicalDialog.show();
            }
        });
        it = this.object.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            this.cbDistinctType.addItem(it.next());
        }
        if (this.object.getType() instanceof DistinctType) {
            this.cbDistinctType.setSelectedItem(this.object.getType());
        }
        it = this.object.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            this.cbStructuredType.addItem(it.next());
        }
        if (this.object.getType() instanceof StructuredType) {
            this.cbStructuredType.setSelectedItem(this.object.getType());
        }
        it = this.object.getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            this.cbCollectionType.addItem(it.next());
        }
        if (this.object.getType() instanceof CollectionType) {
            this.cbCollectionType.setSelectedItem(this.object.getType());
        }
        if (this.object instanceof TypeElement) {
            this.cbCollectionType.removeItem(((TypeElement)this.object).getParent());
        }
        if (this.object.getType() instanceof Domain) {
            this.rbDomain.setSelected(true);
            this.rbDomain.requestFocus();
            this.cbDomain.setEnabled(true);
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(false);
            this.cbCollectionType.setEnabled(false);
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
            this.rbLogicalType.setSelected(false);
        } else if (this.object.getType() instanceof LogicalDatatype) {
            this.cbDomain.setEnabled(false);
            this.bnLogicalType.setEnabled(true);
            this.cbDistinctType.setEnabled(false);
            this.cbCollectionType.setEnabled(false);
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
            this.rbLogicalType.setSelected(true);
            this.rbLogicalType.requestFocus();
        } else if (this.object.getType() instanceof DistinctType) {
            this.cbDomain.setEnabled(false);
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(true);
            this.cbCollectionType.setEnabled(false);
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
            this.rbDistinctType.setSelected(true);
            this.rbDistinctType.requestFocus();
        } else if (this.object.getType() instanceof StructuredType) {
            this.cbDomain.setEnabled(false);
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(false);
            this.cbCollectionType.setEnabled(false);
            this.cbStructuredType.setEnabled(true);
            this.chbReference.setEnabled(true);
            this.chbReference.setSelected(this.object.isReference());
            this.rbStructuredType.setSelected(true);
            this.rbStructuredType.requestFocus();
        } else if (this.object.getType() instanceof CollectionType) {
            this.cbDomain.setEnabled(false);
            this.bnLogicalType.setEnabled(false);
            this.cbDistinctType.setEnabled(false);
            this.cbCollectionType.setEnabled(true);
            this.rbCollectionType.setSelected(true);
            this.rbCollectionType.requestFocus();
            this.cbStructuredType.setEnabled(false);
            this.chbReference.setEnabled(false);
            this.chbReference.setSelected(false);
        } else {
            this.rbDomain.setSelected(true);
            this.rbDomain.requestFocus();
            this.cbDomain.setEnabled(true);
            this.cbDistinctType.setEnabled(false);
            this.cbStructuredType.setEnabled(false);
        }
    }

    private void setProperties() {
        if (this.rbDomain.isSelected()) {
            this.object.setType((Domain)this.cbDomain.getSelectedItem());
            this.object.setReference(false);
        } else if (this.rbDistinctType.isSelected()) {
            this.object.setSize("");
            this.object.setPrecision(0);
            this.object.setScale(0);
            this.object.setType((DesignObject)this.cbDistinctType.getSelectedItem());
        } else if (this.rbStructuredType.isSelected()) {
            this.object.setSize("");
            this.object.setPrecision(0);
            this.object.setScale(0);
            this.object.setType((DesignObject)this.cbStructuredType.getSelectedItem());
            this.object.setReference(this.chbReference.isSelected());
        } else if (this.rbCollectionType.isSelected()) {
            if (this.object instanceof TypeElement) {
                this.temp = (CollectionType)((TypeElement)this.object).getParent();
                this.hasValidContainment((CollectionType)this.cbCollectionType.getSelectedItem());
            }
            if (this.canExit) {
                this.object.setSize("");
                this.object.setPrecision(0);
                this.object.setScale(0);
                this.object.setType((DesignObject)this.cbCollectionType.getSelectedItem());
            }
        }
        if (this.btDataType != null) {
            this.btDataType.setText(this.object.getDataType());
        }
    }

    private void hasValidContainment(CollectionType object) {
        if (object.getElementType() != null && object.getElementType().getType() instanceof CollectionType) {
            CollectionType ct = (CollectionType)object.getElementType().getType();
            if (this.temp == ct) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("SelectDataTypeDialog.CyclicContainment"), this.cbCollectionType.getSelectedItem()), Messages.getString("SelectDataTypeDialog.ForbidenCyclicContainment"), 0);
                this.canExit = false;
                return;
            }
            this.hasValidContainment(ct);
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectDataTypeDialog.SelectDataType"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "DATATYPE_DIALOG";
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (SelectDataTypeDialog.this.rbDomain.isSelected()) {
                SelectDataTypeDialog.this.cbDomain.setEnabled(true);
                SelectDataTypeDialog.this.bnLogicalType.setEnabled(false);
                SelectDataTypeDialog.this.cbDistinctType.setEnabled(false);
                SelectDataTypeDialog.this.cbCollectionType.setEnabled(false);
                SelectDataTypeDialog.this.cbStructuredType.setEnabled(false);
                SelectDataTypeDialog.this.chbReference.setSelected(false);
                SelectDataTypeDialog.this.chbReference.setEnabled(false);
            } else if (SelectDataTypeDialog.this.rbLogicalType.isSelected()) {
                SelectDataTypeDialog.this.cbDomain.setEnabled(false);
                SelectDataTypeDialog.this.bnLogicalType.setEnabled(true);
                SelectDataTypeDialog.this.cbDistinctType.setEnabled(false);
                SelectDataTypeDialog.this.cbCollectionType.setEnabled(false);
                SelectDataTypeDialog.this.cbStructuredType.setEnabled(false);
                SelectDataTypeDialog.this.chbReference.setEnabled(false);
                SelectDataTypeDialog.this.chbReference.setSelected(false);
            } else if (SelectDataTypeDialog.this.rbDistinctType.isSelected()) {
                SelectDataTypeDialog.this.cbDomain.setEnabled(false);
                SelectDataTypeDialog.this.bnLogicalType.setEnabled(false);
                SelectDataTypeDialog.this.cbDistinctType.setEnabled(true);
                SelectDataTypeDialog.this.cbCollectionType.setEnabled(false);
                SelectDataTypeDialog.this.cbStructuredType.setEnabled(false);
                SelectDataTypeDialog.this.chbReference.setEnabled(false);
                SelectDataTypeDialog.this.chbReference.setSelected(false);
            } else if (SelectDataTypeDialog.this.rbStructuredType.isSelected()) {
                SelectDataTypeDialog.this.cbDomain.setEnabled(false);
                SelectDataTypeDialog.this.bnLogicalType.setEnabled(false);
                SelectDataTypeDialog.this.cbDistinctType.setEnabled(false);
                SelectDataTypeDialog.this.cbCollectionType.setEnabled(false);
                SelectDataTypeDialog.this.cbStructuredType.setEnabled(true);
                SelectDataTypeDialog.this.chbReference.setEnabled(true);
                SelectDataTypeDialog.this.chbReference.setSelected(SelectDataTypeDialog.this.object.isReference());
            } else if (SelectDataTypeDialog.this.rbCollectionType.isSelected()) {
                SelectDataTypeDialog.this.cbDomain.setEnabled(false);
                SelectDataTypeDialog.this.bnLogicalType.setEnabled(false);
                SelectDataTypeDialog.this.cbDistinctType.setEnabled(false);
                SelectDataTypeDialog.this.cbCollectionType.setEnabled(true);
                SelectDataTypeDialog.this.cbStructuredType.setEnabled(false);
                SelectDataTypeDialog.this.chbReference.setEnabled(false);
                SelectDataTypeDialog.this.chbReference.setSelected(false);
            }
        }
    }
}

