/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;
import oracle.ide.Ide;

public class TypeElementPropertiesDialogEx
extends AbstractPropertiesDialog {
    private TypeElement typeElement;
    private JButton bnDataType;
    private SelectDataTypeDialog datatypeDialog = null;
    private TypeElement temp;
    private JCheckBox chMandatory;
    private boolean usePreferredList = false;

    public TypeElementPropertiesDialogEx(ApplicationView view, DesignObject object, boolean usePreferred) {
        super(view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    public TypeElementPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object, boolean usePreferred) {
        super(owner, view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TypeElementPropertiesDialogEx.AttributeProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof TypeElement) {
            this.typeElement = (TypeElement)object;
            this.initDefaults(false);
            this.bnDataType.setText(this.typeElement.getDataType());
            this.chMandatory.setSelected(this.typeElement.isMandatory());
            this.temp = new TypeElement(this.typeElement.getDesignPart(), this.typeElement.getStructuredType());
            this.temp.setDesign(this.typeElement.getDesign());
            this.typeElement.copyDataType(this.temp);
            this.dynamicPropertiesList.clear();
            Iterator it = this.typeElement.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.typeElement.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.typeElement.setName(this.tfName.getText());
        this.typeElement.setComment(this.taComments.getText());
        this.typeElement.setNotes(this.taNotes.getText());
        this.typeElement.setMandatory(this.chMandatory.isSelected());
        this.temp.copyDataType(this.typeElement);
        this.typeElement.updateReference();
        TypeElementPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.typeElement.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.typeElement.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "STRUCTUREDTYPE_ATTRIBUTE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbType = new JLabel(LB_DATATYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(this.getDefaultSize());
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeElement te = new TypeElement(TypeElementPropertiesDialogEx.this.typeElement.getDesignPart(), TypeElementPropertiesDialogEx.this.typeElement.getStructuredType());
                te.setDesign(TypeElementPropertiesDialogEx.this.typeElement.getDesign());
                TypeElementPropertiesDialogEx.this.temp.copyDataType(te);
                TypeElementPropertiesDialogEx.this.datatypeDialog = new SelectDataTypeDialog(TypeElementPropertiesDialogEx.this.getAppView(), te, TypeElementPropertiesDialogEx.this.bnDataType);
                TypeElementPropertiesDialogEx.this.datatypeDialog.initProperties(TypeElementPropertiesDialogEx.this.usePreferredList);
                int result = TypeElementPropertiesDialogEx.this.datatypeDialog.showDialog();
                while (result == 1 && !TypeElementPropertiesDialogEx.this.hasValidContainment(TypeElementPropertiesDialogEx.this.typeElement.getStructuredType(), te)) {
                    result = TypeElementPropertiesDialogEx.this.datatypeDialog.showDialog();
                }
                if (result == 1 && TypeElementPropertiesDialogEx.this.hasValidContainment(TypeElementPropertiesDialogEx.this.typeElement.getStructuredType(), te)) {
                    te.copyDataType(TypeElementPropertiesDialogEx.this.temp);
                } else {
                    TypeElementPropertiesDialogEx.this.bnDataType.setText(TypeElementPropertiesDialogEx.this.temp.getDataType());
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbType, this.bnDataType));
        JLabel lbMandatory = new JLabel(LB_MANDATORY);
        lbMandatory.setPreferredSize(this.getDefaultSize());
        this.chMandatory = new JCheckBox();
        this.chMandatory.setPreferredSize(this.getDefaultSize());
        this.chMandatory.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbMandatory, this.chMandatory));
    }

    private boolean hasValidContainment(StructuredType owner, TypeElement inte) {
        TypeElement ct;
        TypeElement te = inte;
        if (inte.getType() instanceof CollectionType && (ct = ((CollectionType)inte.getType()).getElementType()).getType() instanceof StructuredType) {
            te = ct;
        }
        if (te.getType() instanceof StructuredType) {
            StructuredType st = (StructuredType)te.getType();
            if (!te.isReference()) {
                if (owner.isParentOf(st) || st.isParentOf(owner)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypeElementPropertiesDialogEx.TypePartOf"), st.getName(), owner.getName()), Messages.getString("TypeElementPropertiesDialogEx.ForbidenSelfContainment"), 0);
                    return false;
                }
                if (st.containsElementOfStructuredType(owner)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypeElementPropertiesDialogEx.CyclicContainment"), st.getName()), Messages.getString("TypeElementPropertiesDialogEx.ForbidenCyclicContainment"), 0);
                    return false;
                }
            }
        }
        return true;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }
}

