/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_Attribute;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeCaseType;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeMaxNameLength;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeValidCharacters;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.domains.AVTEditor;
import oracle.dbtools.crest.swingui.admin.domains.CECheckConstraint;
import oracle.dbtools.crest.swingui.admin.domains.ValueListEditorEx;
import oracle.dbtools.crest.swingui.editor.DatatypeDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.LogicalTypeDialog;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.OSEnvironment;

public class AttributePropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private static final String EMPTY_VALUE = "";
    private Attribute attribute;
    private JTextField tfSynonym;
    private JTextField tfAbbreviation;
    private JTextField tfLongName;
    private JCheckBox chAllowNulls;
    private JButton bnDataType;
    private JComboBox cbScope;
    private JComboBox cbTypeSubstitution;
    private JTextField tfEntity;
    private JTextField tfConstraintName;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultValue;
    private JComboBox cbSourceType;
    private JTextField tfFormulaDesc;
    private List permittedTypes;
    private StructuredType currentST = null;
    private List subTypes;
    private JPanel pnLevels;
    private JTable lTable;
    private static final String VIEW_EDIT = Messages.getString("AttributePropertiesDialogEx.ViewEdit");
    private JTextField tfSource;
    private JTree tree;
    private boolean usePreferredList = false;
    private JComboBox cbSensitiveTypes;
    private JTextField tfSensitiveTypeDesc;
    private JCheckBox chDeprecated;
    private JPanel pnConstraint;
    private JCheckBox chUseDomainConstraints;
    private JButton btnConstraint;
    private JButton btnAVT;
    private JButton btnValueList;
    private CECheckConstraint checkEditor = null;
    private ValueListEditorEx valuesEditor = null;
    private Dimension labelSize = null;

    public AttributePropertiesDialogEx(ApplicationView view, DesignObject object, boolean usePreferred) {
        super(view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    public AttributePropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object, boolean usePreferred) {
        super(owner, view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("AttributePropertiesDialogEx.AttributeProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return OSEnvironment.isMacOS() ? 650 : 630;
    }

    @Override
    protected int getMinimumHeight() {
        return OSEnvironment.isMacOS() ? 680 : 600;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Attribute) {
            this.attribute = (Attribute)object;
            this.initDefaults();
            boolean enableDescr = !ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && !this.attribute.isFKElement();
            this.taComments.setEditable(enableDescr);
            this.taCommentsInRDBMS.setEditable(enableDescr);
            this.taNotes.setEditable(enableDescr);
            boolean keepFKNamesSync = this.getAppView().getSettings().isKeepFKNamesSynchronized();
            if (this.attribute.isFKAttribute() && keepFKNamesSync || this.attribute.isNameFixed()) {
                this.tfName.setEnabled(false);
            }
            this.tfSynonym.setText(this.attribute.getSynonym());
            this.tfAbbreviation.setText(this.attribute.getPreferredAbbreviation());
            this.tfLongName.setText(this.attribute.getLongName());
            this.chAllowNulls.setSelected(this.attribute.getNullsAllowed());
            if (this.attribute.isPKElement() || this.attribute.isUnique() || this.attribute.isFKAttribute()) {
                this.chAllowNulls.setEnabled(false);
            }
            boolean updatable = this.isEditable() && this.attribute.getContainer() != null && !this.attribute.getContainer().isBST() && !this.attribute.isNested();
            this.tfName.setEnabled(updatable && !this.attribute.isNameFixed());
            this.bnDataType.setEnabled(updatable);
            this.bnDataType.setText(this.attribute.getGenericDatatypeString());
            if (this.attribute.getContainer() != null) {
                this.tfEntity.setText(this.attribute.getContainer().getName());
            }
            this.tfConstraintName.setText(this.attribute.getConstraintName());
            this.setDefaultValueUI();
            this.chUseDomainConstraints.setSelected(this.attribute.getUseDomainConstraints());
            this.fillComboItems(ContainedObject.SOURCE_TYPE_STATES_DISPLAY, this.cbSourceType, false);
            String sourceType = this.translate(this.attribute.getSourceType(), ContainedObject.SOURCE_TYPE_STATES_INTERNAL, ContainedObject.SOURCE_TYPE_STATES_DISPLAY);
            this.cbSourceType.setSelectedItem(sourceType);
            if (sourceType != null && (sourceType.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || sourceType.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE))) {
                this.tfFormulaDesc.setEnabled(true);
                this.tfFormulaDesc.setText(this.attribute.getFormulaDesc());
            } else {
                this.tfFormulaDesc.setEnabled(false);
                this.tfFormulaDesc.setText(EMPTY_VALUE);
            }
            this.initScope();
            this.tfSource.setText(this.attribute.getSource());
            if (this.attribute.isAllowSubtypeSubstitution()) {
                if (this.attribute.isRestrictedTypeSubstitution()) {
                    this.cbTypeSubstitution.setSelectedItem("RESTRICTED");
                } else {
                    this.cbTypeSubstitution.setSelectedItem("ALL");
                }
            } else {
                this.cbTypeSubstitution.setSelectedItem("NONE");
            }
            if (this.attribute.getDataType() instanceof StructuredType && !this.attribute.isReference()) {
                this.cbTypeSubstitution.setEnabled(true);
                this.currentST = (StructuredType)this.attribute.getDataType();
                this.permittedTypes.addAll(this.attribute.getPermittedSubTypes());
                this.subTypes = this.currentST.getAllInstantiableSubTypes(true);
            } else {
                this.cbTypeSubstitution.setEnabled(false);
            }
            if (this.attribute.getCheck() != null) {
                this.btnConstraint.setText(this.isEditable() ? VIEW_EDIT : Messages.getString("AttributePropertiesDialogEx.View"));
            }
            this.btnConstraint.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.btnAVT.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.btnValueList.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.cbSensitiveTypes.addItem(null);
            Iterator it = this.getAppView().getSensitiveTypeSet().iterator();
            while (it.hasNext()) {
                this.cbSensitiveTypes.addItem(it.next());
            }
            this.cbSensitiveTypes.setSelectedItem(this.attribute.getSensitiveType());
            this.tfSensitiveTypeDesc.setText(this.attribute.getSensitiveTypeDescription());
            this.chDeprecated.setSelected(this.attribute.isDeprecated());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            it = this.attribute.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.attribute.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.attribute.setName(this.tfName.getText());
        this.attribute.setComment(this.taComments.getText());
        this.attribute.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.attribute.setNotes(this.taNotes.getText());
        this.attribute.setConstraintName(this.tfConstraintName.getText());
        if (this.cbDefaultValue.isVisible()) {
            this.attribute.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
        } else {
            this.attribute.setDefaultValue(this.tfDefaultValue.getText());
        }
        this.attribute.setSynonym(this.tfSynonym.getText());
        this.attribute.setNullsAllowed(this.chAllowNulls.isSelected());
        this.attribute.setPreferredAbbreviation(this.tfAbbreviation.getText());
        this.attribute.setUseDomainConstraints(this.chUseDomainConstraints.isSelected());
        this.attribute.setSourceType(this.translate((String)this.cbSourceType.getSelectedItem(), ContainedObject.SOURCE_TYPE_STATES_DISPLAY, ContainedObject.SOURCE_TYPE_STATES_INTERNAL));
        this.attribute.setFormulaDesc(this.tfFormulaDesc.getText());
        if (this.cbScope.getSelectedItem() != null) {
            this.attribute.setScopeId(((ContainerObject)this.cbScope.getSelectedItem()).getObjectID());
        } else {
            this.attribute.setScopeId(null);
        }
        String typs = (String)this.cbTypeSubstitution.getSelectedItem();
        if ("NONE".equals(typs)) {
            this.attribute.setAllowSubtypeSubstitution(false);
            this.attribute.setRestrictedTypeSubstitution(false);
        } else if ("ALL".equals(typs)) {
            this.attribute.setRestrictedTypeSubstitution(false);
            this.attribute.setAllowSubtypeSubstitution(true);
        } else {
            this.attribute.setRestrictedTypeSubstitution(true);
            this.attribute.setAllowSubtypeSubstitution(true);
        }
        if (this.attribute.getCheck() != null && this.attribute.getCheck().isEmpty()) {
            this.attribute.setCheck(null);
        }
        if (this.attribute.getValueList() != null && this.attribute.getValueList().isEmpty()) {
            this.attribute.setValueList(null);
        }
        if (this.attribute.getCheck() != null) {
            this.btnConstraint.setText(VIEW_EDIT);
        }
        this.attribute.setSource(this.tfSource.getText());
        this.attribute.setSensitiveType((SensitiveType)this.cbSensitiveTypes.getSelectedItem());
        this.attribute.setSensitiveTypeDescription(this.tfSensitiveTypeDesc.getText());
        this.attribute.setDeprecated(this.chDeprecated.isSelected());
        List list = this.attribute.getPermittedSubTypes();
        list.clear();
        list.addAll(this.permittedTypes);
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        AttributePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.attribute.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.attribute.setProperty(dp.getName(), dp.getValue());
        }
        this.tfLongName.setText(this.attribute.getLongName());
        this.checkNamingOptions();
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRAttributeMaxNameLength(), this.attribute);
        this.checkDesignRule(new DRAttributeCaseType(), this.attribute);
        this.checkDesignRule(new DRAttributeValidCharacters(), this.attribute);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getConstraintPanel());
        this.addToTree(root, this.getPermittedSubtypesPanel());
        this.addToTree(root, this.getEngineeringPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "ATTRIBUTE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbAbbr = new JLabel(LB_PREF_ABBREVIATION);
        lbAbbr.setPreferredSize(this.getDefaultSize());
        this.tfAbbreviation = new JTextField();
        this.tfAbbreviation.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAbbr, this.tfAbbreviation));
        JLabel lbLongName = new JLabel(LB_LONG_NAME);
        lbLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbLongName, this.tfLongName));
        JLabel lbAllowNulls = new JLabel(LB_ALLOW_NULLS);
        lbAllowNulls.setPreferredSize(this.getDefaultSize());
        this.chAllowNulls = new JCheckBox();
        this.chAllowNulls.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAllowNulls, this.chAllowNulls));
        JLabel lbDataType = new JLabel(LB_DATA_TYPE);
        lbDataType.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(new Dimension(FIELD_WIDTH + 80, 20));
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatatypeDialog datatypeDialog = new DatatypeDialog(AttributePropertiesDialogEx.this, AttributePropertiesDialogEx.this.getAppView(), AttributePropertiesDialogEx.this.attribute, AttributePropertiesDialogEx.this.bnDataType);
                datatypeDialog.initProperties(AttributePropertiesDialogEx.this.usePreferredList);
                datatypeDialog.showDialog();
                if (AttributePropertiesDialogEx.this.attribute.getDataType() instanceof StructuredType && !AttributePropertiesDialogEx.this.attribute.isReference() && AttributePropertiesDialogEx.this.attribute.getDataType() != AttributePropertiesDialogEx.this.currentST) {
                    AttributePropertiesDialogEx.this.currentST = (StructuredType)AttributePropertiesDialogEx.this.attribute.getDataType();
                    AttributePropertiesDialogEx.this.subTypes = AttributePropertiesDialogEx.this.currentST.getAllInstantiableSubTypes(true);
                }
                AttributePropertiesDialogEx.this.bnDataType.setText(AttributePropertiesDialogEx.this.attribute.getGenericDatatypeString());
            }
        });
        this.bnDataType.addChangeListener(new DatatypeListener());
        JPanel jpDatatype = this.createRow(lbDataType, this.bnDataType);
        JButton bnProps = new JButton("...");
        bnProps.setToolTipText(Messages.getString("AttributePropertiesDialogEx.DatatypeProperties"));
        bnProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignObject sel = null;
                if (AttributePropertiesDialogEx.this.attribute.getUse() == 0) {
                    sel = AttributePropertiesDialogEx.this.attribute.getDomain();
                } else if (AttributePropertiesDialogEx.this.attribute.getUse() == 2) {
                    sel = AttributePropertiesDialogEx.this.attribute.getDistinctType();
                } else if (AttributePropertiesDialogEx.this.attribute.getUse() == 3) {
                    sel = AttributePropertiesDialogEx.this.attribute.getStructuredType();
                } else if (AttributePropertiesDialogEx.this.attribute.getUse() == 4) {
                    sel = AttributePropertiesDialogEx.this.attribute.getCollectionType();
                }
                if (sel != null) {
                    sel.showModal = ((AttributePropertiesDialogEx)AttributePropertiesDialogEx.this).attribute.showModal;
                    sel.showPropertyDialog();
                } else if (AttributePropertiesDialogEx.this.attribute.getUse() == 1) {
                    LogicalTypeDialog logicalDialog = !AttributePropertiesDialogEx.this.isEditable() || AttributePropertiesDialogEx.this.attribute.getContainer().isBST() || AttributePropertiesDialogEx.this.attribute.isNested() ? new LogicalTypeDialog(AttributePropertiesDialogEx.this.getAppView(), AttributePropertiesDialogEx.this.attribute, AttributePropertiesDialogEx.this.attribute.getSelectedRDBMSType().getName(), AttributePropertiesDialogEx.this.usePreferredList) : new LogicalTypeDialog(AttributePropertiesDialogEx.this.getAppView(), AttributePropertiesDialogEx.this.attribute, AttributePropertiesDialogEx.this.bnDataType, AttributePropertiesDialogEx.this.attribute.getSelectedRDBMSType().getName(), AttributePropertiesDialogEx.this.usePreferredList);
                    logicalDialog.setVisible(true);
                }
                AttributePropertiesDialogEx.this.bnDataType.setText(AttributePropertiesDialogEx.this.attribute.getGenericDatatypeString());
            }
        });
        this.addRowToGeneralPanel(this.createRow(jpDatatype, bnProps, true));
        JLabel lbEntity = new JLabel(LB_ENTITY);
        lbEntity.setPreferredSize(this.getDefaultSize());
        this.tfEntity = new JTextField();
        this.tfEntity.setPreferredSize(this.getDefaultSize());
        this.tfEntity.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbEntity, this.tfEntity));
        JLabel lbSource = new JLabel(LB_SOURCE_NAME);
        lbSource.setPreferredSize(this.getDefaultSize());
        this.tfSource = new JTextField();
        this.tfSource.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSource, this.tfSource));
        JLabel lbSourceType = new JLabel(LB_SOURCE_TYPE);
        lbSourceType.setPreferredSize(this.getDefaultSize());
        this.cbSourceType = new JComboBox();
        this.cbSourceType.setPreferredSize(this.getDefaultSize());
        this.cbSourceType.setMaximumRowCount(8);
        this.cbSourceType.addActionListener(new SourceTypeListener());
        this.addRowToGeneralPanel(this.createRow(lbSourceType, this.cbSourceType));
        JLabel lbFormulaDesc = new JLabel(LB_FORMULA_DESC);
        lbFormulaDesc.setPreferredSize(this.getDefaultSize());
        this.tfFormulaDesc = new JTextField();
        this.tfFormulaDesc.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbFormulaDesc, this.tfFormulaDesc));
        JLabel lbScope = new JLabel(LB_SCOPE);
        lbScope.setPreferredSize(this.getDefaultSize());
        this.cbScope = new JComboBox();
        this.cbScope.setPreferredSize(this.getDefaultSize());
        this.cbScope.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbScope, this.cbScope));
        JLabel lbAllowSubtypeSubstitution = new JLabel(LB_SUBTYPE_SUBSTITUTION);
        lbAllowSubtypeSubstitution.setPreferredSize(this.getDefaultSize());
        this.cbTypeSubstitution = new JComboBox<String>(ContainedObjectWithDomain.SUBST_OPTIONS);
        this.cbTypeSubstitution.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAllowSubtypeSubstitution, this.cbTypeSubstitution));
        JLabel lbSensitiveType = new JLabel(LB_SENSITIVE_TYPE);
        lbSensitiveType.setPreferredSize(this.getDefaultSize());
        this.cbSensitiveTypes = new JComboBox();
        this.cbSensitiveTypes.setPreferredSize(this.tfName.getPreferredSize());
        this.addRowToGeneralPanel(this.createRow(lbSensitiveType, this.cbSensitiveTypes));
        JLabel lbSensitiveTypeDesc = new JLabel(LB_SENSITIVE_TYPE_DESC);
        lbSensitiveTypeDesc.setPreferredSize(this.getDefaultSize());
        this.tfSensitiveTypeDesc = new JTextField();
        this.tfSensitiveTypeDesc.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSensitiveTypeDesc, this.tfSensitiveTypeDesc));
        JLabel lbDeprecated = new JLabel(LB_DEPRECATED);
        lbDeprecated.setPreferredSize(this.getDefaultSize());
        this.chDeprecated = new JCheckBox();
        this.chDeprecated.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDeprecated, this.chDeprecated));
    }

    private void initScope() {
        if (this.attribute.isReference() && this.attribute.getUse() == 3) {
            this.cbScope.removeAllItems();
            this.cbScope.addItem(null);
            StructuredType attStructType = this.attribute.getStructuredType();
            Iterator it = ((LogicalDesign)this.attribute.getDesignPart()).getEntitySet().iterator();
            while (it.hasNext()) {
                Entity t = (Entity)it.next();
                if (!t.isBST() || !attStructType.isParentOf(t.getBasedOnStructuredType())) continue;
                this.cbScope.addItem(t);
            }
            this.cbScope.setSelectedItem(this.attribute.getScope());
            this.cbScope.setEnabled(true);
        } else {
            this.cbScope.setEnabled(false);
        }
    }

    protected JPanel getPermittedSubtypesPanel() {
        if (this.pnLevels == null) {
            this.pnLevels = this.createPage(Messages.getString("AttributePropertiesDialogEx.PermittedSubtypes"));
            this.permittedTypes = new ArrayList();
            this.subTypes = new ArrayList();
            this.lTable = new JTable(new DataModel());
            this.lTable.setSelectionMode(0);
            this.lTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = AttributePropertiesDialogEx.this.lTable.getSelectedRow()) != -1 && AttributePropertiesDialogEx.this.subTypes.size() > 0 && row < AttributePropertiesDialogEx.this.subTypes.size()) {
                        DesignObject dobj = (DesignObject)AttributePropertiesDialogEx.this.subTypes.get(row);
                        dobj.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.lTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AttributePropertiesDialogEx.this.lTable.getSelectedRow();
                    if (row != -1 && AttributePropertiesDialogEx.this.subTypes.size() > 0 && row < AttributePropertiesDialogEx.this.subTypes.size()) {
                        DesignObject dobj = (DesignObject)AttributePropertiesDialogEx.this.subTypes.get(row);
                        dobj.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnLevels.add(pPanel);
        }
        return this.pnLevels;
    }

    private Dimension getLabelDefaultSize() {
        if (this.labelSize == null) {
            this.labelSize = new Dimension(200, 20);
        }
        return this.labelSize;
    }

    protected JPanel getConstraintPanel() {
        if (this.pnConstraint == null) {
            this.pnConstraint = this.createPage(Messages.getString("AttributePropertiesDialogEx.DefaultAndConstraint"));
            JPanel pnMain = new JPanel(new BorderLayout());
            JPanel jpanel = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbConstraintName = new JLabel(Messages.getString("AttributePropertiesDialogEx.ConstraintName"));
            lbConstraintName.setPreferredSize(this.getLabelDefaultSize());
            this.tfConstraintName = new JTextField();
            this.tfConstraintName.setPreferredSize(this.getDefaultSize());
            jpanel.add(this.createRow(lbConstraintName, this.tfConstraintName));
            JLabel lbDefaultValue = new JLabel(LB_DEFAULT_VALUE);
            lbDefaultValue.setPreferredSize(this.getLabelDefaultSize());
            JPanel pnDefaultValue = new JPanel();
            OverlayLayout overlay = new OverlayLayout(pnDefaultValue);
            pnDefaultValue.setLayout(overlay);
            this.cbDefaultValue = new JComboBox();
            this.cbDefaultValue.setPreferredSize(this.getDefaultSize());
            this.cbDefaultValue.setVisible(false);
            pnDefaultValue.add(this.cbDefaultValue);
            this.tfDefaultValue = new JTextField();
            this.tfDefaultValue.setPreferredSize(this.getDefaultSize());
            this.tfDefaultValue.setVisible(true);
            pnDefaultValue.add(this.tfDefaultValue);
            jpanel.add(this.createRow(lbDefaultValue, pnDefaultValue));
            JLabel lbUseDomainConstraints = new JLabel(LB_USE_DOMAIN_CONSTRAINTS);
            lbUseDomainConstraints.setPreferredSize(this.getLabelDefaultSize());
            this.chUseDomainConstraints = new JCheckBox();
            this.chUseDomainConstraints.setPreferredSize(this.getDefaultSize());
            this.chUseDomainConstraints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePropertiesDialogEx.this.btnConstraint.setEnabled(!AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    AttributePropertiesDialogEx.this.btnAVT.setEnabled(!AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    AttributePropertiesDialogEx.this.btnValueList.setEnabled(!AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    if (AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected()) {
                        AttributePropertiesDialogEx.this.attribute.setCheck(null);
                    }
                }
            });
            jpanel.add(this.createRow(lbUseDomainConstraints, this.chUseDomainConstraints));
            JLabel lbConstraint = new JLabel(LB_CONSTRAINT);
            lbConstraint.setPreferredSize(this.getLabelDefaultSize());
            this.btnConstraint = new JButton();
            this.btnConstraint.setHorizontalAlignment(0);
            this.btnConstraint.setPreferredSize(this.getDefaultSize());
            this.btnConstraint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePropertiesDialogEx.this.attribute.setUseDomainConstraints(false);
                    if (AttributePropertiesDialogEx.this.attribute.getCheck() == null) {
                        CheckConstraint check = new CheckConstraint();
                        AttributePropertiesDialogEx.this.attribute.setCheck(check);
                    }
                    if (AttributePropertiesDialogEx.this.attribute.getCheck().getDesign() == null) {
                        AttributePropertiesDialogEx.this.attribute.getCheck().setDesign(AttributePropertiesDialogEx.this.attribute.getDesign());
                    }
                    if (AttributePropertiesDialogEx.this.checkEditor == null) {
                        AttributePropertiesDialogEx.this.checkEditor = new CECheckConstraint((Dialog)AttributePropertiesDialogEx.this, AttributePropertiesDialogEx.this.getAppView(), !AttributePropertiesDialogEx.this.isEditable());
                    }
                    AttributePropertiesDialogEx.this.checkEditor.configureEditComponentFor(AttributePropertiesDialogEx.this.attribute.getCheck());
                    AttributePropertiesDialogEx.this.checkEditor.doEditing(AttributePropertiesDialogEx.this.attribute.getCheck());
                }
            });
            jpanel.add(this.createRow(lbConstraint, this.btnConstraint));
            JLabel lbAVT = new JLabel(LB_RANGES);
            lbAVT.setPreferredSize(this.getLabelDefaultSize());
            this.btnAVT = new JButton(LB_VALUES);
            this.btnAVT.setPreferredSize(this.getDefaultSize());
            this.btnAVT.setHorizontalAlignment(0);
            this.btnAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePropertiesDialogEx.this.attribute.setUseDomainConstraints(false);
                    AVTEditor avtEditor = new AVTEditor((Dialog)AttributePropertiesDialogEx.this, !AttributePropertiesDialogEx.this.isEditable());
                    avtEditor.configureEditComponentFor(AttributePropertiesDialogEx.this.attribute, AttributePropertiesDialogEx.this.attribute.getLogicalDatatype());
                    avtEditor.doEditing(AttributePropertiesDialogEx.this.attribute);
                }
            });
            jpanel.add(this.createRow(lbAVT, this.btnAVT));
            JLabel lbValueList = new JLabel(LB_VALUE_LIST);
            lbValueList.setPreferredSize(this.getLabelDefaultSize());
            this.btnValueList = new JButton(LB_VALUES);
            this.btnValueList.setPreferredSize(this.getDefaultSize());
            this.btnValueList.setHorizontalAlignment(0);
            this.btnValueList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePropertiesDialogEx.this.attribute.setUseDomainConstraints(false);
                    if (AttributePropertiesDialogEx.this.attribute.getValueList() == null) {
                        ConstraintEnumeration valueList = new ConstraintEnumeration();
                        AttributePropertiesDialogEx.this.attribute.setValueList(valueList);
                    }
                    if (AttributePropertiesDialogEx.this.valuesEditor == null) {
                        AttributePropertiesDialogEx.this.valuesEditor = new ValueListEditorEx((Dialog)AttributePropertiesDialogEx.this, !AttributePropertiesDialogEx.this.isEditable());
                    }
                    AttributePropertiesDialogEx.this.valuesEditor.configureEditComponentFor(AttributePropertiesDialogEx.this.attribute.getValueList());
                    AttributePropertiesDialogEx.this.valuesEditor.doEditing(AttributePropertiesDialogEx.this.attribute);
                }
            });
            jpanel.add(this.createRow(lbValueList, this.btnValueList));
            pnMain.add((Component)jpanel, "North");
            this.pnConstraint.add(pnMain);
        }
        return this.pnConstraint;
    }

    @Override
    protected void onApply() {
        super.onApply();
        this.setDefaultValueUI();
    }

    private void setDefaultValueUI() {
        Object[] vals = this.attribute.getValues().toArray();
        if (vals != null && vals.length > 0) {
            Object[] defs = new Object[vals.length + 1];
            defs[0] = EMPTY_VALUE;
            int sel = 0;
            String def = this.attribute.getDefaultValue();
            for (int i = 0; i < vals.length; ++i) {
                defs[i + 1] = vals[i];
                if (def == null || !def.equals(vals[i].toString())) continue;
                sel = i + 1;
            }
            this.cbDefaultValue.setModel(new DefaultComboBoxModel<Object>(defs));
            this.cbDefaultValue.setSelectedIndex(sel);
            this.cbDefaultValue.setVisible(true);
            this.tfDefaultValue.setVisible(false);
        } else {
            this.tfDefaultValue.setText(this.attribute.getDefaultValue());
            this.tfDefaultValue.setVisible(true);
            this.cbDefaultValue.setVisible(false);
        }
    }

    @Override
    protected void onCancel() {
        if (this.attribute.getCheck() != null && this.attribute.getCheck().isEmpty()) {
            this.attribute.setCheck(null);
        }
        super.onCancel();
    }

    private JPanel getImpactAnalysisPanel() {
        final AttributePropertiesDialogEx owner = this;
        JPanel pnImpact = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = AttributePropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        if (obj instanceof AbstractMDObject) {
                            ((AbstractMDObject)obj).showPropertyDialog(owner);
                        } else {
                            obj.showPropertyDialog();
                        }
                    } else {
                        if (AttributePropertiesDialogEx.this.tree.isCollapsed(path)) {
                            AttributePropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            AttributePropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_Attribute(this.attribute, null, true), false);
        ImpactTreeRenderer renderer = new ImpactTreeRenderer();
        this.tree.setModel(treeDesign);
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AttributePropertiesDialogEx.this.subTypes.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AttributePropertiesDialogEx.Permitted");
            }
            if (column == 1) {
                return Messages.getString("AttributePropertiesDialogEx.Name");
            }
            return AttributePropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StructuredType st = (StructuredType)AttributePropertiesDialogEx.this.subTypes.get(row);
            if (col == 1) {
                return st.getName();
            }
            if (col == 0) {
                return AttributePropertiesDialogEx.this.permittedTypes.contains(st);
            }
            return AttributePropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            StructuredType st = (StructuredType)AttributePropertiesDialogEx.this.subTypes.get(row);
            if (col == 0) {
                if (((Boolean)aValue).booleanValue()) {
                    if (!AttributePropertiesDialogEx.this.permittedTypes.contains(st)) {
                        AttributePropertiesDialogEx.this.permittedTypes.add(st);
                    }
                } else {
                    AttributePropertiesDialogEx.this.permittedTypes.remove(st);
                }
            }
        }
    }

    private class DatatypeListener
    implements ChangeListener {
        private DatatypeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            AttributePropertiesDialogEx.this.initScope();
            AttributePropertiesDialogEx.this.cbTypeSubstitution.setEnabled(AttributePropertiesDialogEx.this.attribute.getDataType() instanceof StructuredType && !AttributePropertiesDialogEx.this.attribute.isReference());
        }
    }

    private class SourceTypeListener
    implements ActionListener {
        private SourceTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String type = (String)AttributePropertiesDialogEx.this.cbSourceType.getSelectedItem();
            if (type != null) {
                if (type.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || type.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE)) {
                    AttributePropertiesDialogEx.this.tfFormulaDesc.setEnabled(true);
                } else {
                    AttributePropertiesDialogEx.this.tfFormulaDesc.setEnabled(false);
                    AttributePropertiesDialogEx.this.tfFormulaDesc.setText(AttributePropertiesDialogEx.EMPTY_VALUE);
                }
            }
        }
    }
}

