/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;

public class InheritanceRelationPropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private InheritanceRelation relation;
    private JTextField tfLongName;
    private JComboBox cbSource;
    private JComboBox cbTarget;

    public InheritanceRelationPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("InheritanceRelationPropertiesDialogEx.InheritanceRelationProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof InheritanceRelation) {
            this.relation = (InheritanceRelation)object;
            this.initDefaults();
            this.tfLongName.setText(this.relation.toString());
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDesign().getEntitySet().toArray(), this.cbSource, false);
            this.cbSource.setSelectedItem(this.relation.getSourceEntity());
            this.fillComboItems(this.getDesignObject().getDesign().getLogicalDesign().getEntitySet().toArray(), this.cbTarget, false);
            this.cbTarget.setSelectedItem(this.relation.getTargetEntity());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator it = this.relation.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.relation.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.relation.setName(this.tfName.getText());
        this.relation.setComment(this.taComments.getText());
        this.relation.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.relation.setNotes(this.taNotes.getText());
        this.relation.setSourceEntity((Entity)this.cbSource.getSelectedItem());
        this.relation.setTargetEntity((Entity)this.cbTarget.getSelectedItem());
        this.relation.setSourceTV(this.relation.getSourceTVEntity());
        this.relation.setTargetTV(this.relation.getTargetTVEntity());
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        InheritanceRelationPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.relation.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.relation.setProperty(dp.getName(), dp.getValue());
        }
        this.tfLongName.setText(this.relation.toString());
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getEngineeringPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "INHERITANCE_RELATION_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbLongName = new JLabel(LB_LONG_NAME);
        lbLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbLongName, this.tfLongName));
        JLabel lbSource = new JLabel(LB_SUPER_TYPE);
        lbSource.setPreferredSize(this.getDefaultSize());
        this.cbSource = new JComboBox();
        this.cbSource.setPreferredSize(this.getDefaultSize());
        this.cbSource.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbSource, this.cbSource));
        JLabel lbTarget = new JLabel(LB_SUB_TYPE);
        lbTarget.setPreferredSize(this.getDefaultSize());
        this.cbTarget = new JComboBox();
        this.cbTarget.setPreferredSize(this.getDefaultSize());
        this.cbTarget.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbTarget, this.cbTarget));
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        return null;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }
}

