/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.FEJoinPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.multidimensional.MeasurePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.PresummarizedLevelsDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SlicePropertiesDialogEx;

public class CubePropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Cube cube;
    private JCheckBox chVirtual;
    private JCheckBox chPartitioned;
    private JComboBox cbPartDimension;
    private oracle.dbtools.crest.model.design.multidimensional.Dimension curDimension;
    private Hierarchy curHierarchy;
    private JComboBox cbFullCubeMaterialization;
    private JComboBox cbPartHierarchy;
    private JComboBox cbPartLevel;
    private JPanel pnPartDescription;
    private JTextArea taPartDescription;
    private JCheckBox chGlobalComp;
    private JCheckBox chCompressedComposites;
    private JPanel pnEntities;
    private JList selectedEntList;
    private JList allEntList;
    private DefaultListModel allEntModel;
    private DefaultListModel selectedEntModel;
    private JButton btnAddEnt;
    private JButton btnRemoveEnt;
    private JCheckBox chbUseFactEnt;
    private List selEntList;
    private List allEntities;
    private JPanel pnJoins;
    private JTable scTable;
    private List joins;
    private JPanel pnDimensions;
    private JTable dimTable;
    private List dimList;
    private Map linkMap;
    JButton btnUp;
    JButton btnDown;
    private JButton btnSummaryLevels;
    private JPanel pnCubeMeasures;
    private JTable mTable;
    private List mList;
    private List newMeasures;
    private List deletedMeasures;
    private JPanel pnSlices;
    private JTable sTable;
    private List sList;
    private List newSlices;
    private List deletedSlices;
    private JPanel pnSQLAccess2OracleAW;
    private List sqlList;
    private JTable sqlTable;
    private List newSQLList;
    private static final Dimension defaultSize = new Dimension(240, 20);

    public CubePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public CubePropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("CubePropertiesDialogEx.CubeProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return 700;
    }

    @Override
    protected int getMinimumHeight() {
        return 440;
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Cube) {
            this.cube = (Cube)object;
            this.initDefaults(false);
            this.allEntities.addAll(this.cube.getMultidimensionalDesign().getAllColntainers());
            this.selEntList.addAll(this.cube.getFactEntities());
            this.joins.addAll(this.cube.getJoins());
            this.chVirtual.setSelected(this.cube.isVirtual());
            this.chPartitioned.setSelected(this.cube.isPartitioned());
            this.curDimension = this.cube.getPartDimension();
            this.fillComboItems(this.cube.getDimensions().toArray(), this.cbPartDimension, false);
            this.cbPartDimension.setSelectedItem(this.cube.getPartDimension());
            this.cbPartDimension.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.cbPartDimension.getSelectedItem();
                    if (dim != CubePropertiesDialogEx.this.curDimension) {
                        CubePropertiesDialogEx.this.curDimension = dim;
                        CubePropertiesDialogEx.this.fillComboItems(dim.getHierarchies().toArray(), CubePropertiesDialogEx.this.cbPartHierarchy, false);
                        if (dim.getHierarchies().size() > 0) {
                            Hierarchy hier = (Hierarchy)dim.getHierarchies().getElement(0);
                            CubePropertiesDialogEx.this.cbPartHierarchy.setSelectedItem(hier);
                            CubePropertiesDialogEx.this.fillComboItems(hier.getLevels().toArray(), CubePropertiesDialogEx.this.cbPartLevel, false);
                            if (hier.getLevels().size() > 0) {
                                CubePropertiesDialogEx.this.cbPartLevel.setSelectedItem(hier.getLevels().get(0));
                            }
                        }
                    }
                }
            });
            if (this.cube.isPartitioned() && this.cube.getPartDimension() != null) {
                this.fillComboItems(this.cube.getPartDimension().getHierarchies().toArray(), this.cbPartHierarchy, false);
                this.cbPartHierarchy.setSelectedItem(this.cube.getPartHierarchy());
                this.curHierarchy = this.cube.getPartHierarchy();
            }
            if (this.cube.isPartitioned() && this.cube.getPartDimension() != null && this.cube.getPartHierarchy() != null) {
                this.fillComboItems(this.cube.getPartHierarchy().getLevels().toArray(), this.cbPartLevel, false);
                this.cbPartLevel.setSelectedItem(this.cube.getPartLevel());
            }
            this.chGlobalComp.setSelected(this.cube.isUseGlobalComposites());
            this.chCompressedComposites.setSelected(this.cube.isCompressedComposites());
            this.dimList.addAll(this.cube.getDimensions());
            for (oracle.dbtools.crest.model.design.multidimensional.Dimension dim : this.cube.getDimensions()) {
                RollupLink rl = this.cube.getRollUpLink(dim);
                this.linkMap.put(dim.getObjectID(), rl);
            }
            this.mList.addAll(this.cube.getMeasures());
            this.sList.addAll(this.cube.getPrecalculatedSlices());
            this.sqlList.addAll(this.cube.getSQLDefinitions());
            this.taDescription.setText(this.cube.getDescription());
            this.taPartDescription.setText(this.cube.getPartitioningDescription());
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.updateSlicesCombo();
            this.fillEntLists();
            this.dynamicPropertiesList.clear();
            Iterator it = this.cube.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.cube.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        int i;
        int col = this.dimTable.getEditingColumn();
        int row = this.dimTable.getEditingRow();
        if (row >= 0 && col >= 0) {
            this.dimTable.getCellEditor(row, col).stopCellEditing();
        }
        this.cube.setName(this.tfName.getText());
        this.cube.setComment(this.taComments.getText());
        this.cube.setNotes(this.taNotes.getText());
        this.cube.setDescription(this.taDescription.getText());
        this.cube.setVirtual(this.chVirtual.isSelected());
        this.cube.setPartitioned(this.chPartitioned.isSelected());
        this.cube.setPartitioningDescription(this.taPartDescription.getText());
        this.cube.setPartDimension((oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbPartDimension.getSelectedItem());
        this.cube.setPartHierarchy((Hierarchy)this.cbPartHierarchy.getSelectedItem());
        this.cube.setPartLevel((Level)this.cbPartLevel.getSelectedItem());
        this.cube.setFullCubeMaterialization((Slice)this.cbFullCubeMaterialization.getSelectedItem());
        this.cube.getMeasures().clear();
        this.cube.setUseGlobalComposites(this.chGlobalComp.isSelected());
        this.cube.setCompressedComposites(this.chCompressedComposites.isSelected());
        for (AbstractMDObject object : this.mList) {
            ((Measure)object).setCube(this.cube);
            this.cube.addMeasure((Measure)object);
        }
        for (AbstractMDObject object : this.deletedMeasures) {
            object.remove();
        }
        this.cube.getPrecalculatedSlices().clear();
        for (AbstractMDObject object : this.sList) {
            this.cube.addPrecalculatedSlice((Slice)object);
        }
        for (AbstractMDObject object : this.deletedSlices) {
            object.remove();
        }
        int entsize = this.selectedEntModel.size();
        this.cube.getFactEntities().clear();
        for (i = 0; i < entsize; ++i) {
            this.cube.addFactEntity((ContainerObject)this.selectedEntModel.getElementAt(i));
        }
        this.cube.getJoins().clear();
        for (i = 0; i < this.joins.size(); ++i) {
            this.cube.addFactEntitiesJoin((FactEntitiesJoin)this.joins.get(i));
        }
        for (i = 0; i < this.dimList.size(); ++i) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.dimList.get(i);
            this.cube.moveToIndex(dim, i);
        }
        this.updateSlicesCombo();
        this.cube.getSQLDefinitions().clear();
        this.cube.getSQLDefinitions().addAll(this.sqlList);
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        this.newMeasures.clear();
        this.newSlices.clear();
        CubePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.cube.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.cube.setProperty(dp.getName(), dp.getValue());
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getEntitiesPanel());
        this.addToTree(root, this.getJoinsPanel());
        this.addToTree(root, this.getDimensionsPanel());
        this.addToTree(root, this.getCubeMeasuresPanel());
        this.addToTree(root, this.getSlicesPanel());
        this.addToTree(root, this.getOracleNamesPanel());
        this.addToTree(root, this.getSQLAccess2OracleAWPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getPartDescriptionPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "CUBE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbVirtual = new JLabel(LB_VIRTUAL);
        lbVirtual.setPreferredSize(this.getDefaultSize());
        this.chVirtual = new JCheckBox();
        this.chVirtual.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbVirtual, this.chVirtual));
        JLabel lbPartitioned = new JLabel(LB_PARTITIONED);
        lbPartitioned.setPreferredSize(this.getDefaultSize());
        this.chPartitioned = new JCheckBox();
        this.chPartitioned.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbPartitioned, this.chPartitioned));
        JLabel lbDimension = new JLabel(LB_PART_DIMENSION);
        lbDimension.setPreferredSize(this.getDefaultSize());
        this.cbPartDimension = new JComboBox();
        this.cbPartDimension.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDimension, this.cbPartDimension));
        JLabel lbHierarchy = new JLabel(LB_PART_HIERARCHY);
        lbHierarchy.setPreferredSize(this.getDefaultSize());
        this.cbPartHierarchy = new JComboBox();
        this.cbPartHierarchy.setPreferredSize(this.getDefaultSize());
        this.cbPartHierarchy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Hierarchy hier = (Hierarchy)CubePropertiesDialogEx.this.cbPartHierarchy.getSelectedItem();
                    if (hier != CubePropertiesDialogEx.this.curHierarchy) {
                        CubePropertiesDialogEx.this.curHierarchy = hier;
                        CubePropertiesDialogEx.this.fillComboItems(hier.getLevels().toArray(), CubePropertiesDialogEx.this.cbPartLevel, false);
                        if (hier.getLevels().size() > 0) {
                            CubePropertiesDialogEx.this.cbPartLevel.setSelectedItem(hier.getLevels().get(0));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbHierarchy, this.cbPartHierarchy));
        JLabel lbLevel = new JLabel(LB_PART_LEVEL);
        lbLevel.setPreferredSize(this.getDefaultSize());
        this.cbPartLevel = new JComboBox();
        this.cbPartLevel.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbLevel, this.cbPartLevel));
        JLabel lbGlobalComp = new JLabel(LB_GLOBAL_COMPOSITES);
        lbGlobalComp.setPreferredSize(this.getDefaultSize());
        lbGlobalComp.setToolTipText(Messages.getString("CubePropertiesDialogEx.OracleAWCubeGlobalComposites"));
        this.chGlobalComp = new JCheckBox();
        this.chGlobalComp.setPreferredSize(this.getDefaultSize());
        this.chGlobalComp.setToolTipText(lbGlobalComp.getToolTipText());
        this.addRowToGeneralPanel(this.createRow(lbGlobalComp, this.chGlobalComp));
        JLabel lbCompressedComposites = new JLabel(LB_COMPRESSED_COMPOSITES);
        lbCompressedComposites.setPreferredSize(this.getDefaultSize());
        lbCompressedComposites.setToolTipText(Messages.getString("CubePropertiesDialogEx.OracleCubeCompressedComposites"));
        this.chCompressedComposites = new JCheckBox();
        this.chCompressedComposites.setPreferredSize(this.getDefaultSize());
        this.chCompressedComposites.setToolTipText(lbCompressedComposites.getToolTipText());
        this.addRowToGeneralPanel(this.createRow(lbCompressedComposites, this.chCompressedComposites));
        JLabel lbFullCubeMaterialization = new JLabel(LB_MATERIALIZATION);
        lbFullCubeMaterialization.setPreferredSize(this.getDefaultSize());
        this.cbFullCubeMaterialization = new JComboBox();
        this.cbFullCubeMaterialization.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbFullCubeMaterialization, this.cbFullCubeMaterialization));
    }

    private void updateSlicesCombo() {
        this.cbFullCubeMaterialization.removeAllItems();
        this.cbFullCubeMaterialization.addItem(null);
        for (int i = 0; i < this.sList.size(); ++i) {
            this.cbFullCubeMaterialization.addItem(this.sList.get(i));
        }
        this.cbFullCubeMaterialization.setSelectedItem(this.cube.getFullCubeMaterialization());
    }

    protected JPanel getPartDescriptionPanel() {
        if (this.pnPartDescription == null) {
            this.pnPartDescription = this.createPage(Messages.getString("CubePropertiesDialogEx.PartitioningDescription"));
            this.taPartDescription = new JTextArea();
            this.pnPartDescription.add(new JScrollPane(this.taPartDescription));
        }
        return this.pnPartDescription;
    }

    protected JPanel getEntitiesPanel() {
        if (this.pnEntities == null) {
            this.pnEntities = this.createPage(Messages.getString("CubePropertiesDialogEx.Entities"));
            this.selEntList = new ArrayList();
            this.allEntities = new ArrayList();
            JPanel jpanel = new JPanel();
            BoxLayout bl = new BoxLayout(jpanel, 2);
            jpanel.setLayout(bl);
            this.pnEntities.add((Component)jpanel, "Center");
            this.initAllEntitiesList(jpanel);
            this.initEntitiesButtons(jpanel);
            this.initSelectedEntitiesList(jpanel);
            this.chbUseFactEnt = new JCheckBox(Messages.getString("CubePropertiesDialogEx.ListFactEntitiesOnly"));
            this.chbUseFactEnt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CubePropertiesDialogEx.this.updateEntLists();
                }
            });
            this.pnEntities.add((Component)this.chbUseFactEnt, "South");
        }
        return this.pnEntities;
    }

    private void updateEntLists() {
        this.selEntList.clear();
        for (int i = 0; i < this.selectedEntModel.size(); ++i) {
            ContainerObject item = (ContainerObject)this.selectedEntModel.getElementAt(i);
            if (!this.chbUseFactEnt.isSelected()) {
                this.selEntList.add(item);
                continue;
            }
            if (!(item instanceof ContainerWithKeyObject) || !((ContainerWithKeyObject)item).getTypeID().equalsIgnoreCase("1")) continue;
            this.selEntList.add(item);
        }
        this.allEntModel.clear();
        this.selectedEntModel.clear();
        this.fillEntLists();
    }

    private void fillEntLists() {
        for (ContainerObject next : this.allEntities) {
            if (!this.chbUseFactEnt.isSelected()) {
                if (!this.selEntList.contains(next)) {
                    this.allEntModel.addElement(next);
                    continue;
                }
                this.selectedEntModel.addElement(next);
                continue;
            }
            if (!(next instanceof ContainerWithKeyObject) || !((ContainerWithKeyObject)next).getTypeID().equalsIgnoreCase("1")) continue;
            if (!this.selEntList.contains(next)) {
                this.allEntModel.addElement(next);
                continue;
            }
            this.selectedEntModel.addElement(next);
        }
    }

    private void initAllEntitiesList(JPanel jpanel) {
        JPanel pnAttributes = new JPanel(new BorderLayout());
        pnAttributes.setBorder(BorderFactory.createTitledBorder(Messages.getString("CubePropertiesDialogEx.Available")));
        pnAttributes.setPreferredSize(new Dimension(100, 100));
        this.allEntModel = new DefaultListModel();
        this.allEntList = new JList(this.allEntModel);
        ListSelectionModel listSelectionModel = this.allEntList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllEntitiesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allEntList);
        sp.setPreferredSize(new Dimension(145, 220));
        pnAttributes.add(sp);
        jpanel.add(pnAttributes);
    }

    private void initSelectedEntitiesList(JPanel jpanel) {
        JPanel pnSelected = new JPanel(new BorderLayout());
        pnSelected.setBorder(BorderFactory.createTitledBorder(Messages.getString("CubePropertiesDialogEx.Selected")));
        pnSelected.setPreferredSize(new Dimension(100, 100));
        this.selectedEntModel = new DefaultListModel();
        this.selectedEntList = new JList(this.selectedEntModel);
        ListSelectionModel listSelectionModel = this.selectedEntList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedEntitiesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedEntList);
        sp.setPreferredSize(new Dimension(145, 220));
        pnSelected.add(sp);
        jpanel.add(pnSelected);
    }

    private void initEntitiesButtons(JPanel jpanel) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddEnt = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddEnt.setPreferredSize(new Dimension(32, 32));
        this.btnAddEnt.addActionListener(new AddEntitiesActionListener());
        this.btnAddEnt.setEnabled(false);
        this.btnAddEnt.setToolTipText(BTN_ADD);
        this.btnRemoveEnt = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveEnt.setPreferredSize(new Dimension(32, 32));
        this.btnRemoveEnt.setEnabled(false);
        this.btnRemoveEnt.addActionListener(new RemoveEntitiesActionListener());
        this.btnRemoveEnt.setToolTipText(BTN_REMOVE);
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.btnAddEnt);
        verticalBox.add(this.btnRemoveEnt);
        verticalBox.add(Box.createVerticalGlue());
        jpanel.add(verticalBox);
    }

    private List getSelectedEntities() {
        ArrayList list = new ArrayList();
        int entsize = this.selectedEntModel.size();
        for (int i = 0; i < entsize; ++i) {
            list.add(this.selectedEntModel.getElementAt(i));
        }
        return list;
    }

    protected JPanel getJoinsPanel() {
        if (this.pnJoins == null) {
            this.pnJoins = this.createPage(Messages.getString("CubePropertiesDialogEx.Joins"));
            this.joins = new ArrayList();
            this.scTable = new JTable(new JoinsTableModel());
            this.scTable.setSelectionMode(0);
            this.scTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = CubePropertiesDialogEx.this.scTable.getSelectedRow()) > -1 && CubePropertiesDialogEx.this.joins.size() > 0 && row < CubePropertiesDialogEx.this.joins.size()) {
                        FactEntitiesJoin join = (FactEntitiesJoin)CubePropertiesDialogEx.this.joins.get(row);
                        FEJoinPropertiesDialogEx dialog = new FEJoinPropertiesDialogEx(CubePropertiesDialogEx.this.getAppView(), join, CubePropertiesDialogEx.this.getSelectedEntities());
                        dialog.initProperties(join);
                        dialog.setModal(true);
                        dialog.show();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.scTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = CubePropertiesDialogEx.this.scTable.getSelectedRow();
                    if (row > -1 && CubePropertiesDialogEx.this.joins.size() > 0 && row < CubePropertiesDialogEx.this.joins.size()) {
                        FactEntitiesJoin join = (FactEntitiesJoin)CubePropertiesDialogEx.this.joins.get(row);
                        FEJoinPropertiesDialogEx dialog = new FEJoinPropertiesDialogEx(CubePropertiesDialogEx.this.getAppView(), join, CubePropertiesDialogEx.this.getSelectedEntities());
                        dialog.initProperties(join);
                        dialog.setModal(true);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(Messages.getString("CubePropertiesDialogEx.AddJoinsNumberEntities"));
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FactEntitiesJoin join = ((MultidimensionalDesign)CubePropertiesDialogEx.this.cube.getDesignPart()).createFactEntitiesJoin();
                        FEJoinPropertiesDialogEx dialog = new FEJoinPropertiesDialogEx(CubePropertiesDialogEx.this.getAppView(), join, CubePropertiesDialogEx.this.getSelectedEntities());
                        dialog.initProperties(join);
                        dialog.setModal(true);
                        dialog.show();
                        if (dialog.isApplied) {
                            CubePropertiesDialogEx.this.joins.add(join);
                            CubePropertiesDialogEx.this.scTable.updateUI();
                        } else {
                            join.remove();
                        }
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = CubePropertiesDialogEx.this.scTable.getSelectedRow();
                        if (objectNumber != -1 && CubePropertiesDialogEx.this.joins.size() > 0 && objectNumber < CubePropertiesDialogEx.this.joins.size()) {
                            CubePropertiesDialogEx.this.joins.remove(objectNumber);
                            CubePropertiesDialogEx.this.scTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnJoins.add(aPanel);
        }
        return this.pnJoins;
    }

    protected JPanel getDimensionsPanel() {
        if (this.pnDimensions == null) {
            this.pnDimensions = this.createPage(Messages.getString("CubePropertiesDialogEx.Dimensions"));
            this.dimList = new ArrayList();
            this.linkMap = new TreeMap();
            this.dimTable = new JTable(new DimensionTableModel());
            this.dimTable.setSelectionMode(0);
            this.dimTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    oracle.dbtools.crest.model.design.multidimensional.Dimension dim;
                    int row;
                    if (e.getClickCount() == 2 && (row = CubePropertiesDialogEx.this.dimTable.getSelectedRow()) != -1 && CubePropertiesDialogEx.this.dimList.size() > 0 && row < CubePropertiesDialogEx.this.dimList.size() && !(dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(row)).isDialogVisible()) {
                        dim.showModal = true;
                        dim.showPropertyDialog();
                        CubePropertiesDialogEx.this.dimTable.updateUI();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.dimTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    oracle.dbtools.crest.model.design.multidimensional.Dimension dim;
                    int row = CubePropertiesDialogEx.this.dimTable.getSelectedRow();
                    if (row != -1 && CubePropertiesDialogEx.this.dimList.size() > 0 && row < CubePropertiesDialogEx.this.dimList.size() && !(dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(row)).isDialogVisible()) {
                        dim.showModal = true;
                        dim.showPropertyDialog();
                        CubePropertiesDialogEx.this.dimTable.updateUI();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                this.btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
                this.btnUp.setToolTipText(BTN_MOVE_UP);
                this.btnUp.addActionListener(new MoveUpAction());
                this.btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
                this.btnDown.setToolTipText(BTN_MOVE_DOWN);
                this.btnDown.addActionListener(new MoveDownAction());
                toolBar.addSeparator();
                toolBar.add(this.btnUp);
                toolBar.add(this.btnDown);
            }
            this.btnSummaryLevels = new JButton(configuration.getIcon("LEVEL_ICON", this.getPreferredIconSize()));
            this.btnSummaryLevels.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.SetOracleAWPresummarizedLevels"));
            this.btnSummaryLevels.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = CubePropertiesDialogEx.this.dimTable.getSelectedRow();
                    if (row != -1 && CubePropertiesDialogEx.this.dimList.size() > 0 && row < CubePropertiesDialogEx.this.dimList.size()) {
                        oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(row);
                        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension> list = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension>();
                        list.add(dim);
                        ArrayList levels = new ArrayList();
                        levels.addAll(dim.getSummaryLevels());
                        String title = MessageFormat.format(Messages.getString("MeasurePropertiesDialogEx.SummaryLevelsFor"), dim.getName());
                        PresummarizedLevelsDialog sld = new PresummarizedLevelsDialog(CubePropertiesDialogEx.this.getAppView(), list, levels, title);
                        sld.setVisible(true);
                        if (CubePropertiesDialogEx.this.isEditable()) {
                            dim.applySummarLevels(levels);
                        }
                    }
                }
            });
            toolBar.addSeparator();
            toolBar.add(this.btnSummaryLevels);
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnDimensions.add(pPanel);
        }
        return this.pnDimensions;
    }

    public boolean moveToIndex(Object object, int index) {
        if (this.dimList.contains(object) && this.dimList.size() > index && index >= 0) {
            this.dimList.remove(object);
            this.dimList.add(index, object);
            return true;
        }
        return false;
    }

    protected JPanel getCubeMeasuresPanel() {
        if (this.pnCubeMeasures == null) {
            this.pnCubeMeasures = this.createPage(Messages.getString("CubePropertiesDialogEx.Measures"));
            this.mList = new ArrayList();
            this.newMeasures = new ArrayList();
            this.deletedMeasures = new ArrayList();
            this.mTable = new JTable(new MeasureTableModel());
            this.mTable.setSelectionMode(0);
            this.mTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Measure measure;
                    int row;
                    if (e.getClickCount() == 2 && (row = CubePropertiesDialogEx.this.mTable.getSelectedRow()) != -1 && CubePropertiesDialogEx.this.mList.size() > 0 && row < CubePropertiesDialogEx.this.mList.size() && !(measure = (Measure)CubePropertiesDialogEx.this.mList.get(row)).isDialogVisible()) {
                        measure.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        MeasurePropertiesDialogEx dialog = new MeasurePropertiesDialogEx((Dialog)CubePropertiesDialogEx.this, CubePropertiesDialogEx.this.getAppView(), measure);
                        dialog.initProperties(measure);
                        dialog.show();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.mTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Measure measure;
                    int row = CubePropertiesDialogEx.this.mTable.getSelectedRow();
                    if (row != -1 && CubePropertiesDialogEx.this.mList.size() > 0 && row < CubePropertiesDialogEx.this.mList.size() && !(measure = (Measure)CubePropertiesDialogEx.this.mList.get(row)).isDialogVisible()) {
                        measure.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        MeasurePropertiesDialogEx dialog = new MeasurePropertiesDialogEx((Dialog)CubePropertiesDialogEx.this, CubePropertiesDialogEx.this.getAppView(), measure);
                        dialog.initProperties(measure);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Measure measure = ((MultidimensionalDesign)CubePropertiesDialogEx.this.cube.getDesignPart()).createMeasure();
                        measure.setCube(CubePropertiesDialogEx.this.cube);
                        CubePropertiesDialogEx.this.mList.add(measure);
                        CubePropertiesDialogEx.this.newMeasures.add(measure);
                        CubePropertiesDialogEx.this.mTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = CubePropertiesDialogEx.this.mTable.getSelectedRow();
                        if (objectNumber != -1 && CubePropertiesDialogEx.this.mList.size() > 0 && objectNumber < CubePropertiesDialogEx.this.mList.size()) {
                            CubePropertiesDialogEx.this.deletedMeasures.add(CubePropertiesDialogEx.this.mList.get(objectNumber));
                            CubePropertiesDialogEx.this.mList.remove(objectNumber);
                            CubePropertiesDialogEx.this.mTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnCubeMeasures.add(pPanel);
        }
        return this.pnCubeMeasures;
    }

    protected JPanel getSlicesPanel() {
        if (this.pnSlices == null) {
            this.pnSlices = this.createPage(Messages.getString("CubePropertiesDialogEx.PrecalculatedSlices"));
            this.sList = new ArrayList();
            this.newSlices = new ArrayList();
            this.deletedSlices = new ArrayList();
            this.sTable = new JTable(new SliceTableModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Slice slice;
                    int row;
                    if (e.getClickCount() == 2 && (row = CubePropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && CubePropertiesDialogEx.this.sList.size() > 0 && row < CubePropertiesDialogEx.this.sList.size() && !(slice = (Slice)CubePropertiesDialogEx.this.sList.get(row)).isDialogVisible()) {
                        slice.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        SlicePropertiesDialogEx dialog = new SlicePropertiesDialogEx((Dialog)CubePropertiesDialogEx.this, CubePropertiesDialogEx.this.getAppView(), slice);
                        dialog.initProperties(slice);
                        dialog.show();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.sTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Slice slice;
                    int row = CubePropertiesDialogEx.this.sTable.getSelectedRow();
                    if (row != -1 && CubePropertiesDialogEx.this.sList.size() > 0 && row < CubePropertiesDialogEx.this.sList.size() && !(slice = (Slice)CubePropertiesDialogEx.this.sList.get(row)).isDialogVisible()) {
                        slice.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        SlicePropertiesDialogEx dialog = new SlicePropertiesDialogEx((Dialog)CubePropertiesDialogEx.this, CubePropertiesDialogEx.this.getAppView(), slice);
                        dialog.initProperties(slice);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Slice slice = ((MultidimensionalDesign)CubePropertiesDialogEx.this.cube.getDesignPart()).createSlice();
                        slice.setCube(CubePropertiesDialogEx.this.cube);
                        CubePropertiesDialogEx.this.newSlices.add(slice);
                        CubePropertiesDialogEx.this.sList.add(slice);
                        CubePropertiesDialogEx.this.sTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = CubePropertiesDialogEx.this.sTable.getSelectedRow();
                        if (objectNumber != -1 && CubePropertiesDialogEx.this.sList.size() > 0 && objectNumber < CubePropertiesDialogEx.this.sList.size()) {
                            CubePropertiesDialogEx.this.deletedSlices.add(CubePropertiesDialogEx.this.sList.get(objectNumber));
                            CubePropertiesDialogEx.this.sList.remove(objectNumber);
                            CubePropertiesDialogEx.this.sTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnSlices.add(pPanel);
        }
        return this.pnSlices;
    }

    protected JPanel getSQLAccess2OracleAWPanel() {
        if (this.pnSQLAccess2OracleAW == null) {
            this.pnSQLAccess2OracleAW = this.createPage(Messages.getString("CubePropertiesDialogEx.SQLAccessOracleAW"));
            this.sqlList = new ArrayList();
            this.newSQLList = new ArrayList();
            this.sqlTable = new JTable(new SQLToAWTableModel());
            this.sqlTable.setSelectionMode(0);
            this.sqlTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SQLAccessToAW sc;
                    int row;
                    if (e.getClickCount() == 2 && (row = CubePropertiesDialogEx.this.sqlTable.getSelectedRow()) > -1 && CubePropertiesDialogEx.this.sqlList.size() > 0 && row < CubePropertiesDialogEx.this.sqlList.size() && !(sc = (SQLAccessToAW)CubePropertiesDialogEx.this.sqlList.get(row)).isDialogVisible()) {
                        sc.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        sc.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.sqlTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLAccessToAW sc;
                    int row = CubePropertiesDialogEx.this.sqlTable.getSelectedRow();
                    if (row > -1 && CubePropertiesDialogEx.this.sqlList.size() > 0 && row < CubePropertiesDialogEx.this.sqlList.size() && !(sc = (SQLAccessToAW)CubePropertiesDialogEx.this.sqlList.get(row)).isDialogVisible()) {
                        sc.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        sc.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLAccessToAW sql = CubePropertiesDialogEx.this.cube.getMultidimensionalDesign().createSQLAccessToAW();
                        sql.setCube(CubePropertiesDialogEx.this.cube);
                        CubePropertiesDialogEx.this.newSQLList.add(sql);
                        CubePropertiesDialogEx.this.sqlList.add(sql);
                        CubePropertiesDialogEx.this.sqlTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = CubePropertiesDialogEx.this.sqlTable.getSelectedRow();
                        if (objectNumber != -1 && CubePropertiesDialogEx.this.sqlList.size() > 0 && objectNumber < CubePropertiesDialogEx.this.sqlList.size()) {
                            CubePropertiesDialogEx.this.sqlList.remove(objectNumber);
                            CubePropertiesDialogEx.this.sqlTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnSQLAccess2OracleAW.add(aPanel);
        }
        return this.pnSQLAccess2OracleAW;
    }

    @Override
    protected void onCancel() {
        for (Slice slice : this.newSlices) {
            slice.remove();
        }
        for (Measure measure : this.newMeasures) {
            measure.remove();
        }
        for (SQLAccessToAW sql : this.newSQLList) {
            sql.remove();
        }
        super.onCancel();
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class SQLToAWTableModel
    extends AbstractTableModel {
        private SQLToAWTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.sqlList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CubePropertiesDialogEx.Name");
            }
            if (column == 1) {
                return Messages.getString("CubePropertiesDialogEx.MeasureAlias");
            }
            if (column == 2) {
                return Messages.getString("CubePropertiesDialogEx.WhereClause");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SQLAccessToAW object = (SQLAccessToAW)CubePropertiesDialogEx.this.sqlList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class SliceTableModel
    extends AbstractTableModel {
        private SliceTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CubePropertiesDialogEx.PrecalculatedSlices");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Slice slice = (Slice)CubePropertiesDialogEx.this.sList.get(row);
            if (col == 0) {
                return slice.getName();
            }
            return new Integer(row * col);
        }
    }

    private class MeasureTableModel
    extends AbstractTableModel {
        private MeasureTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.mList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CubePropertiesDialogEx.Measures");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Measure measure = (Measure)CubePropertiesDialogEx.this.mList.get(row);
            if (col == 0) {
                return measure.getName();
            }
            return new Integer(row * col);
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = CubePropertiesDialogEx.this.dimTable.getSelectedRow();
            if (objectNumber < CubePropertiesDialogEx.this.dimList.size() - 1) {
                oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(objectNumber);
                CubePropertiesDialogEx.this.moveToIndex(dim, objectNumber + 1);
                CubePropertiesDialogEx.this.dimTable.changeSelection(objectNumber + 1, 0, false, false);
                CubePropertiesDialogEx.this.dimTable.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = CubePropertiesDialogEx.this.dimTable.getSelectedRow();
            if (objectNumber > 0) {
                oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(objectNumber);
                CubePropertiesDialogEx.this.moveToIndex(dim, objectNumber - 1);
                CubePropertiesDialogEx.this.dimTable.changeSelection(objectNumber - 1, 0, false, false);
                CubePropertiesDialogEx.this.dimTable.updateUI();
            }
        }
    }

    private class DimensionTableModel
    extends AbstractTableModel {
        String[] names = new String[]{Messages.getString("CubePropertiesDialogEx.Dimension"), Messages.getString("CubePropertiesDialogEx.DefaultOperator"), Messages.getString("CubePropertiesDialogEx.IsSparse")};

        private DimensionTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.dimList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.names[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!CubePropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0 || c == 1) {
                return String.class;
            }
            return Boolean.class;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(row);
            if (col == 1) {
                RollupLink rl = (RollupLink)CubePropertiesDialogEx.this.linkMap.get(dim.getObjectID());
                if (value instanceof String) {
                    rl.setDefaultAggregationOperator((String)value);
                }
            } else if (col == 2) {
                RollupLink rl = (RollupLink)CubePropertiesDialogEx.this.linkMap.get(dim.getObjectID());
                if (value instanceof Boolean) {
                    boolean sparse = (Boolean)value;
                    rl.setSparseDimension(sparse);
                }
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(row);
            if (col == 0) {
                return dim.getName();
            }
            if (col == 1) {
                RollupLink rl = (RollupLink)CubePropertiesDialogEx.this.linkMap.get(dim.getObjectID());
                return rl.getDefaultAggregationOperator();
            }
            if (col == 2) {
                RollupLink rl = (RollupLink)CubePropertiesDialogEx.this.linkMap.get(dim.getObjectID());
                return new Boolean(rl.isSparseDimension());
            }
            return new Integer(row * col);
        }
    }

    private class JoinsTableModel
    extends AbstractTableModel {
        private JoinsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.joins.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CubePropertiesDialogEx.JoinName");
            }
            if (column == 1) {
                return Messages.getString("CubePropertiesDialogEx.LeftEntity");
            }
            if (column == 2) {
                return Messages.getString("CubePropertiesDialogEx.RightEntity");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            FactEntitiesJoin object = (FactEntitiesJoin)CubePropertiesDialogEx.this.joins.get(row);
            if (col == 0) {
                return object.getName();
            }
            if (col == 1) {
                if (object.getLeftEntity() != null) {
                    return object.getLeftEntity().getName();
                }
                return "";
            }
            if (col == 2) {
                if (object.getRightEntity() != null) {
                    return object.getRightEntity().getName();
                }
                return "";
            }
            return new Integer(row * col);
        }
    }

    private class RemoveEntitiesActionListener
    implements ActionListener {
        private RemoveEntitiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!CubePropertiesDialogEx.this.selectedEntModel.isEmpty()) {
                Object[] selectedObjects = CubePropertiesDialogEx.this.selectedEntList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (CubePropertiesDialogEx.this.allEntModel.contains(ob)) continue;
                    CubePropertiesDialogEx.this.allEntModel.addElement(ob);
                    CubePropertiesDialogEx.this.selectedEntModel.removeElement(ob);
                }
            }
        }
    }

    private class AddEntitiesActionListener
    implements ActionListener {
        private AddEntitiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!CubePropertiesDialogEx.this.allEntModel.isEmpty()) {
                Object[] selectedObjects = CubePropertiesDialogEx.this.allEntList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (CubePropertiesDialogEx.this.selectedEntModel.contains(ob)) continue;
                    CubePropertiesDialogEx.this.selectedEntModel.addElement(ob);
                    CubePropertiesDialogEx.this.allEntModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedEntitiesListSelectionHandler
    implements ListSelectionListener {
        private SelectedEntitiesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (CubePropertiesDialogEx.this.isEditable() && !e.getValueIsAdjusting()) {
                if (CubePropertiesDialogEx.this.selectedEntList.getSelectedIndex() == -1) {
                    CubePropertiesDialogEx.this.btnRemoveEnt.setEnabled(false);
                } else {
                    CubePropertiesDialogEx.this.btnRemoveEnt.setEnabled(true);
                }
            }
        }
    }

    private class AllEntitiesListSelectionHandler
    implements ListSelectionListener {
        private AllEntitiesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (CubePropertiesDialogEx.this.isEditable() && !e.getValueIsAdjusting()) {
                if (CubePropertiesDialogEx.this.allEntList.getSelectedIndex() == -1) {
                    CubePropertiesDialogEx.this.btnAddEnt.setEnabled(false);
                } else {
                    CubePropertiesDialogEx.this.btnAddEnt.setEnabled(true);
                }
            }
        }
    }
}

