/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;

public class DimensionPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Dimension dimension;
    private JCheckBox chNatKeys;
    private JCheckBox chTimeDimension;
    private JPanel pnHierarchies;
    private JTable hTable;
    private List hList;
    private JPanel pnLevels;
    private JTable lTable;
    private List lList;
    private JPanel pnSCA;
    private JTable sTable;
    private List sList;
    private JPanel pnCalcMembers;
    private JTable pcmTable;
    private List permanentCMList;

    public DimensionPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DimensionPropertiesDialogEx.DimensionProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Dimension) {
            this.dimension = (Dimension)object;
            this.initDefaults(false);
            this.taDescription.setText(this.dimension.getDescription());
            this.chNatKeys.setSelected(this.dimension.isUseNaturalKeys());
            this.chTimeDimension.setSelected(this.dimension.isTimeDimension());
            Iterator it = this.dimension.getHierarchies().iterator();
            while (it.hasNext()) {
                this.hList.add(it.next());
            }
            this.lList.addAll(this.dimension.getAllLevels());
            this.updateList();
            this.permanentCMList.addAll(this.dimension.getPermanentCalcMembers());
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            it = this.dimension.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.dimension.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        int col = this.pcmTable.getEditingColumn();
        int row = this.pcmTable.getEditingRow();
        if (row >= 0 && col >= 0) {
            this.pcmTable.getCellEditor(row, col).stopCellEditing();
        }
        this.dimension.setName(this.tfName.getText());
        this.dimension.setComment(this.taComments.getText());
        this.dimension.setNotes(this.taNotes.getText());
        this.dimension.setDescription(this.taDescription.getText());
        this.dimension.setTimeDimension(this.chTimeDimension.isSelected());
        this.dimension.setUseNaturalKeys(this.chNatKeys.isSelected());
        this.dimension.getPermanentCalcMembers().clear();
        this.dimension.getPermanentCalcMembers().addAll(this.permanentCMList);
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        this.updateList();
        DimensionPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.dimension.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.dimension.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getHierarchiesPanel());
        this.addToTree(root, this.getLevelsPanel());
        this.addToTree(root, this.getSCAPanel());
        this.addToTree(root, this.getCalcMembersPanel());
        this.addToTree(root, this.getOracleNamesPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "DIMENSION_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbNatKeys = new JLabel(LB_USE_NATURAL_KEYS);
        lbNatKeys.setPreferredSize(this.getDefaultSize());
        this.chNatKeys = new JCheckBox();
        this.chNatKeys.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbNatKeys, this.chNatKeys));
        JLabel lbTimeDimension = new JLabel(LB_TIME_DIMENSION);
        lbTimeDimension.setPreferredSize(this.getDefaultSize());
        this.chTimeDimension = new JCheckBox();
        this.chTimeDimension.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbTimeDimension, this.chTimeDimension));
    }

    protected JPanel getHierarchiesPanel() {
        if (this.pnHierarchies == null) {
            this.pnHierarchies = this.createPage(Messages.getString("DimensionPropertiesDialogEx.Hierarchies"));
            this.hList = new ArrayList();
            this.hTable = new JTable(new HierarchyTableModel());
            this.hTable.setSelectionMode(0);
            this.hTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = DimensionPropertiesDialogEx.this.hTable.getSelectedRow()) != -1 && DimensionPropertiesDialogEx.this.hList.size() > 0 && row < DimensionPropertiesDialogEx.this.hList.size()) {
                        Hierarchy hierarchy = (Hierarchy)DimensionPropertiesDialogEx.this.hList.get(row);
                        hierarchy.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.hTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = DimensionPropertiesDialogEx.this.hTable.getSelectedRow();
                    if (row != -1 && DimensionPropertiesDialogEx.this.hList.size() > 0 && row < DimensionPropertiesDialogEx.this.hList.size()) {
                        Hierarchy hierarchy = (Hierarchy)DimensionPropertiesDialogEx.this.hList.get(row);
                        hierarchy.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnHierarchies.add(pPanel);
        }
        return this.pnHierarchies;
    }

    protected JPanel getLevelsPanel() {
        if (this.pnLevels == null) {
            this.pnLevels = this.createPage(Messages.getString("DimensionPropertiesDialogEx.Levels"));
            this.lList = new ArrayList();
            this.lTable = new JTable(new LevelTableModel());
            this.lTable.setSelectionMode(0);
            this.lTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = DimensionPropertiesDialogEx.this.lTable.getSelectedRow()) != -1 && DimensionPropertiesDialogEx.this.lList.size() > 0 && row < DimensionPropertiesDialogEx.this.lList.size()) {
                        Level level = (Level)DimensionPropertiesDialogEx.this.lList.get(row);
                        level.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.lTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = DimensionPropertiesDialogEx.this.lTable.getSelectedRow();
                    if (row != -1 && DimensionPropertiesDialogEx.this.lList.size() > 0 && row < DimensionPropertiesDialogEx.this.lList.size()) {
                        Level level = (Level)DimensionPropertiesDialogEx.this.lList.get(row);
                        level.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnLevels.add(pPanel);
        }
        return this.pnLevels;
    }

    private void updateList() {
        this.sList.clear();
        this.sList.addAll(this.getSCHAElements());
        this.sTable.updateUI();
    }

    private List getSCHAElements() {
        ArrayList<SCHAElement> result = new ArrayList<SCHAElement>();
        for (Level level : this.dimension.getAllLevels()) {
            for (int i = 0; i < level.getSlowChangingAttributes().size(); ++i) {
                SlowChangingAttribute scha = (SlowChangingAttribute)level.getSlowChangingAttributes().get(i);
                if (SlowChangingAttribute.TYPES[0].equalsIgnoreCase(scha.getType())) continue;
                result.add(new SCHAElement(level, scha));
            }
        }
        return result;
    }

    protected JPanel getSCAPanel() {
        if (this.pnSCA == null) {
            this.pnSCA = this.createPage(Messages.getString("DimensionPropertiesDialogEx.SlowChangingAttributes"));
            this.sList = new ArrayList();
            this.sTable = new JTable(new SCATableModel());
            this.sTable.setSelectionMode(0);
            this.sTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = DimensionPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && DimensionPropertiesDialogEx.this.sList.size() > 0 && row < DimensionPropertiesDialogEx.this.sList.size()) {
                        SCHAElement element = (SCHAElement)DimensionPropertiesDialogEx.this.sList.get(row);
                        element.getLevel().showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.sTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = DimensionPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (row != -1 && DimensionPropertiesDialogEx.this.sList.size() > 0 && row < DimensionPropertiesDialogEx.this.sList.size()) {
                        SCHAElement element = (SCHAElement)DimensionPropertiesDialogEx.this.sList.get(row);
                        element.getLevel().showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnSCA.add(pPanel);
        }
        return this.pnSCA;
    }

    protected JPanel getCalcMembersPanel() {
        if (this.pnCalcMembers == null) {
            this.pnCalcMembers = this.createPage(Messages.getString("DimensionPropertiesDialogEx.CalculatedMembers"));
            this.permanentCMList = new ArrayList();
            this.pcmTable = new JTable(new PermanentCalcMemberTableModel());
            this.pcmTable.setSelectionMode(0);
            this.pcmTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() != 2 || (row = DimensionPropertiesDialogEx.this.pcmTable.getSelectedRow()) <= -1 || DimensionPropertiesDialogEx.this.permanentCMList.size() <= 0 || row < DimensionPropertiesDialogEx.this.permanentCMList.size()) {
                        // empty if block
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.pcmTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String name = DimensionPropertiesDialogEx.this.generatePCMName("PCM_", DimensionPropertiesDialogEx.this.permanentCMList);
                        Dimension dimension = DimensionPropertiesDialogEx.this.dimension;
                        dimension.getClass();
                        Dimension.PermanentCalcMember pcm = dimension.new Dimension.PermanentCalcMember(name);
                        DimensionPropertiesDialogEx.this.permanentCMList.add(pcm);
                        DimensionPropertiesDialogEx.this.pcmTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = DimensionPropertiesDialogEx.this.pcmTable.getSelectedRow();
                        if (objectNumber != -1 && DimensionPropertiesDialogEx.this.permanentCMList.size() > 0 && objectNumber < DimensionPropertiesDialogEx.this.permanentCMList.size()) {
                            DimensionPropertiesDialogEx.this.permanentCMList.remove(objectNumber);
                            DimensionPropertiesDialogEx.this.pcmTable.updateUI();
                        }
                    }
                });
                JToolBar toolBar = new JToolBar(0);
                toolBar.setFloatable(false);
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
                buttonGeneral.add(toolBar);
            }
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnCalcMembers.add(aPanel);
        }
        return this.pnCalcMembers;
    }

    private String generatePCMName(String template, List list) {
        int i = list.size();
        String name = template + String.valueOf(i);
        boolean found = true;
        while (found) {
            found = false;
            for (int k = 0; k < list.size(); ++k) {
                Dimension.PermanentCalcMember pcm;
                name = template + String.valueOf(i);
                if (!name.equalsIgnoreCase((pcm = (Dimension.PermanentCalcMember)list.get(k)).getName())) continue;
                found = true;
                break;
            }
            ++i;
        }
        return name;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class PermanentCalcMemberTableModel
    extends AbstractTableModel {
        private PermanentCalcMemberTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DimensionPropertiesDialogEx.this.permanentCMList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DimensionPropertiesDialogEx.Name");
            }
            if (column == 1) {
                return Messages.getString("DimensionPropertiesDialogEx.Expression");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return DimensionPropertiesDialogEx.this.isEditable();
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Dimension.PermanentCalcMember object = (Dimension.PermanentCalcMember)DimensionPropertiesDialogEx.this.permanentCMList.get(row);
            if (col == 0) {
                return object.getName();
            }
            if (col == 1) {
                return object.getExpression();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Dimension.PermanentCalcMember object = (Dimension.PermanentCalcMember)DimensionPropertiesDialogEx.this.permanentCMList.get(row);
            if (col == 0) {
                object.setName((String)value);
            } else if (col == 1) {
                object.setExpression((String)value);
            }
        }
    }

    class SCHAElement {
        private Level level;
        private SlowChangingAttribute scha;

        public SCHAElement(Level level, SlowChangingAttribute scha) {
            this.level = level;
            this.scha = scha;
        }

        public Level getLevel() {
            return this.level;
        }

        public SlowChangingAttribute getSlowChangingAttribute() {
            return this.scha;
        }
    }

    private class SCATableModel
    extends AbstractTableModel {
        private SCATableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DimensionPropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Messages.getString("DimensionPropertiesDialogEx.Level");
                }
                case 1: {
                    return Messages.getString("DimensionPropertiesDialogEx.Attribute");
                }
                case 2: {
                    return Messages.getString("DimensionPropertiesDialogEx.Type");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SCHAElement schae = (SCHAElement)DimensionPropertiesDialogEx.this.sList.get(row);
            switch (col) {
                case 0: {
                    return schae.getLevel().getName();
                }
                case 1: {
                    return schae.getSlowChangingAttribute().getLongName();
                }
                case 2: {
                    return schae.getSlowChangingAttribute().getType();
                }
            }
            return new Integer(row * col);
        }
    }

    private class LevelTableModel
    extends AbstractTableModel {
        private LevelTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DimensionPropertiesDialogEx.this.lList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DimensionPropertiesDialogEx.Levels");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Level object = (Level)DimensionPropertiesDialogEx.this.lList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class HierarchyTableModel
    extends AbstractTableModel {
        private HierarchyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DimensionPropertiesDialogEx.this.hList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DimensionPropertiesDialogEx.Hierarchies");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Hierarchy object = (Hierarchy)DimensionPropertiesDialogEx.this.hList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }
}

