/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;

public class FEJoinPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private FactEntitiesJoin feJoin;
    private JComboBox cbLeftEntity;
    private JComboBox cbRightEntity;
    private JComboBox cbExistingRelation;
    private JComboBox cbCardinality;
    private List entities;
    private JComboBox cbDominant;
    private Entity cLeftEnt;
    private Entity cRightEnt;
    private List lcolumns;
    private List rcolumns;
    private JComboBox lcombo;
    private JComboBox rcombo;
    private JTable scTable;
    private JButton btnAdd;
    private JButton btnRemove;
    private JPanel pnAttributePairs;
    public boolean isApplied = false;

    public FEJoinPropertiesDialogEx(ApplicationView view, DesignObject object, List entities) {
        super(view, object);
        this.entities = entities;
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbLeftEntity = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.LeftEntityL"));
        lbLeftEntity.setPreferredSize(this.getDefaultSize());
        this.cbLeftEntity = new JComboBox();
        this.cbLeftEntity.setPreferredSize(this.getDefaultSize());
        this.cbLeftEntity.setEnabled(this.isEditable());
        this.cbLeftEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FEJoinPropertiesDialogEx.this.updateRelationCombo();
                Entity ent = (Entity)FEJoinPropertiesDialogEx.this.cbLeftEntity.getSelectedItem();
                if (ent != null) {
                    FEJoinPropertiesDialogEx.this.lcombo.setModel(new DefaultComboBoxModel<ContainedObject>(ent.getElements()));
                } else {
                    FEJoinPropertiesDialogEx.this.lcombo.removeAllItems();
                }
                FEJoinPropertiesDialogEx.this.lcolumns.clear();
                FEJoinPropertiesDialogEx.this.rcolumns.clear();
                FEJoinPropertiesDialogEx.this.scTable.updateUI();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbLeftEntity, this.cbLeftEntity));
        JLabel lbRightEntity = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.RightEntityL"));
        lbRightEntity.setPreferredSize(this.getDefaultSize());
        this.cbRightEntity = new JComboBox();
        this.cbRightEntity.setPreferredSize(this.getDefaultSize());
        this.cbRightEntity.setEnabled(this.isEditable());
        this.cbRightEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FEJoinPropertiesDialogEx.this.updateRelationCombo();
                Entity ent = (Entity)FEJoinPropertiesDialogEx.this.cbRightEntity.getSelectedItem();
                if (ent != null) {
                    FEJoinPropertiesDialogEx.this.rcombo.setModel(new DefaultComboBoxModel<ContainedObject>(ent.getElements()));
                } else {
                    FEJoinPropertiesDialogEx.this.rcombo.removeAllItems();
                }
                FEJoinPropertiesDialogEx.this.lcolumns.clear();
                FEJoinPropertiesDialogEx.this.rcolumns.clear();
                FEJoinPropertiesDialogEx.this.scTable.updateUI();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbRightEntity, this.cbRightEntity));
        JLabel lbExistingRel = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.ExistingRelation"));
        lbExistingRel.setPreferredSize(this.getDefaultSize());
        this.cbExistingRelation = new JComboBox();
        this.cbExistingRelation.setPreferredSize(this.getDefaultSize());
        this.cbExistingRelation.setEnabled(this.isEditable());
        this.cbExistingRelation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FEJoinPropertiesDialogEx.this.updateCardinality();
                FEJoinPropertiesDialogEx.this.updateColumnsData();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbExistingRel, this.cbExistingRelation));
        JLabel lbCardinality = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.Cardinality"));
        lbCardinality.setPreferredSize(this.getDefaultSize());
        this.cbCardinality = new JComboBox<String>(FactEntitiesJoin.POSSIBLE_CARDINALITY);
        this.cbCardinality.setPreferredSize(this.getDefaultSize());
        this.cbCardinality.setEnabled(this.isEditable());
        this.cbCardinality.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FEJoinPropertiesDialogEx.this.updateCardinality();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbCardinality, this.cbCardinality));
        JLabel lbDominan = new JLabel(Messages.getString("FEJoinPropertiesDialogEx.DominantRole"));
        lbDominan.setPreferredSize(this.getDefaultSize());
        this.cbDominant = new JComboBox<String>(FactEntitiesJoin.POSSIBLE_CARDINALITY);
        this.cbDominant.setPreferredSize(this.getDefaultSize());
        this.cbDominant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FEJoinPropertiesDialogEx.this.updateColumnsData();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbDominan, this.cbDominant));
    }

    private void updateRelationCombo() {
        Entity rEnt = (Entity)this.cbRightEntity.getSelectedItem();
        Entity lEnt = (Entity)this.cbLeftEntity.getSelectedItem();
        if (lEnt != this.cLeftEnt || rEnt != this.cRightEnt) {
            if (lEnt != null && rEnt != null) {
                List list = lEnt.getAllRelationsTo(rEnt);
                if (list.size() > 0) {
                    list.add(0, null);
                    this.cbExistingRelation.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
                } else {
                    this.cbExistingRelation.removeAllItems();
                }
            } else {
                this.cbExistingRelation.removeAllItems();
            }
            this.cLeftEnt = lEnt;
            this.cRightEnt = rEnt;
            this.updateCardinality();
            this.updateColumnsData();
        }
    }

    private void updateColumnsData() {
        if (this.isEditable()) {
            if (this.cLeftEnt != null & this.cRightEnt != null) {
                Relation rel = (Relation)this.cbExistingRelation.getSelectedItem();
                if (rel != null) {
                    this.btnAdd.setEnabled(false);
                    this.btnRemove.setEnabled(false);
                    this.fillColumns(rel);
                } else {
                    this.btnAdd.setEnabled(true);
                    this.btnRemove.setEnabled(true);
                }
            } else {
                this.btnAdd.setEnabled(false);
                this.btnRemove.setEnabled(false);
            }
        }
    }

    private void fillColumns(Relation rel) {
        if (rel != null) {
            String card = (String)this.cbCardinality.getSelectedItem();
            if (FactEntitiesJoin.CARD_ONE_TO_MANY.equalsIgnoreCase(card)) {
                ContainedObject[] lattrs;
                ContainedObject[] rattrs;
                this.lcolumns.clear();
                this.rcolumns.clear();
                if (this.cLeftEnt.getPK() != null && (rattrs = this.cRightEnt.getAllElementsGeneratedBy(rel.getObjectID())).length == (lattrs = this.cLeftEnt.getPK().getElements()).length) {
                    for (int i = 0; i < lattrs.length; ++i) {
                        this.lcolumns.add(lattrs[i]);
                        this.rcolumns.add(rattrs[i]);
                    }
                }
            } else if (FactEntitiesJoin.CARD_MANY_TO_ONE.equalsIgnoreCase(card)) {
                this.lcolumns.clear();
                this.rcolumns.clear();
                if (this.cRightEnt.getPK() != null) {
                    ContainedObject[] lattrs = this.cLeftEnt.getAllElementsGeneratedBy(rel.getObjectID());
                    ContainedObject[] rattrs = this.cRightEnt.getPK().getElements();
                    if (rattrs.length == lattrs.length) {
                        for (int i = 0; i < lattrs.length; ++i) {
                            this.lcolumns.add(lattrs[i]);
                            this.rcolumns.add(rattrs[i]);
                        }
                    }
                }
            } else if (FactEntitiesJoin.CARD_ONE_TO_ONE.equalsIgnoreCase(card)) {
                Entity doment = (Entity)this.cbDominant.getSelectedItem();
                if (doment == this.cLeftEnt) {
                    ContainedObject[] lattrs;
                    ContainedObject[] rattrs;
                    this.lcolumns.clear();
                    this.rcolumns.clear();
                    if (this.cLeftEnt.getPK() != null && (rattrs = this.cRightEnt.getAllElementsGeneratedBy(rel.getObjectID())).length == (lattrs = this.cLeftEnt.getPK().getElements()).length) {
                        for (int i = 0; i < lattrs.length; ++i) {
                            this.lcolumns.add(lattrs[i]);
                            this.rcolumns.add(rattrs[i]);
                        }
                    }
                } else if (doment == this.cRightEnt) {
                    this.lcolumns.clear();
                    this.rcolumns.clear();
                    if (this.cRightEnt.getPK() != null) {
                        ContainedObject[] lattrs = this.cLeftEnt.getAllElementsGeneratedBy(rel.getObjectID());
                        ContainedObject[] rattrs = this.cRightEnt.getPK().getElements();
                        if (rattrs.length == lattrs.length) {
                            for (int i = 0; i < lattrs.length; ++i) {
                                this.lcolumns.add(lattrs[i]);
                                this.rcolumns.add(rattrs[i]);
                            }
                        }
                    }
                }
            }
        }
        this.scTable.updateUI();
    }

    private void updateCardinality() {
        Relation rel = (Relation)this.cbExistingRelation.getSelectedItem();
        if (rel != null) {
            this.cbCardinality.setEnabled(false);
            String card = FactEntitiesJoin.getCardinalityOf(rel, this.cLeftEnt, this.cRightEnt);
            this.cbCardinality.setSelectedItem(card);
        } else {
            this.cbCardinality.setEnabled(false);
            this.cbCardinality.setSelectedItem(FactEntitiesJoin.CARD_ONE_TO_ONE);
        }
        this.updateDominant();
    }

    private void updateDominant() {
        Entity rEnt = (Entity)this.cbRightEntity.getSelectedItem();
        Entity lEnt = (Entity)this.cbLeftEntity.getSelectedItem();
        if (lEnt != null && rEnt != null) {
            if (this.cbExistingRelation.getSelectedItem() != null && FactEntitiesJoin.CARD_ONE_TO_ONE.equalsIgnoreCase((String)this.cbCardinality.getSelectedItem())) {
                Entity[] ents = new Entity[]{lEnt, rEnt};
                this.cbDominant.setModel(new DefaultComboBoxModel<Entity>(ents));
                this.cbDominant.setEnabled(this.isEditable());
            } else {
                this.cbDominant.setEnabled(false);
                this.cbDominant.removeAllItems();
            }
        } else {
            this.cbDominant.setEnabled(false);
            this.cbDominant.removeAllItems();
        }
    }

    @Override
    public String getCaption() {
        return Messages.getString("FEJoinPropertiesDialogEx.JoinProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "JOIN_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof FactEntitiesJoin) {
            this.feJoin = (FactEntitiesJoin)object;
            this.initDefaults(false);
            this.fillComboItems(this.entities.toArray(), this.cbLeftEntity, true);
            this.fillComboItems(this.entities.toArray(), this.cbRightEntity, true);
            this.cbLeftEntity.setSelectedItem(this.feJoin.getLeftEntity());
            this.cbRightEntity.setSelectedItem(this.feJoin.getRightEntity());
            this.cbExistingRelation.setSelectedItem(this.feJoin.getUsedRelation());
            this.cLeftEnt = this.feJoin.getLeftEntity();
            this.cRightEnt = this.feJoin.getRightEntity();
            if (this.feJoin.getUsedRelation() == null) {
                this.cbCardinality.setSelectedItem(this.feJoin.getCardinality());
                this.lcolumns.addAll(this.feJoin.getLeftAttributes());
                this.rcolumns.addAll(this.feJoin.getRightAttributes());
            }
            this.cbDominant.setSelectedItem(this.feJoin.getDominantEntity());
            this.updateColumnsData();
            this.dynamicPropertiesList.clear();
            Iterator it = this.feJoin.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.feJoin.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.lcolumns = new ArrayList();
        this.rcolumns = new ArrayList();
        this.lcombo = new JComboBox();
        this.rcombo = new JComboBox();
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getAttributePairsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.feJoin.setName(this.tfName.getText());
        this.feJoin.setComment(this.taComments.getText());
        this.feJoin.setNotes(this.taNotes.getText());
        this.feJoin.setLeftEntity((Entity)this.cbLeftEntity.getSelectedItem());
        this.feJoin.setRightEntity((Entity)this.cbRightEntity.getSelectedItem());
        this.feJoin.setUsedRelation((Relation)this.cbExistingRelation.getSelectedItem());
        this.feJoin.setCardinality((String)this.cbCardinality.getSelectedItem());
        this.feJoin.setDominantEntity((Entity)this.cbDominant.getSelectedItem());
        this.feJoin.getLeftAttributes().clear();
        this.feJoin.getLeftAttributes().addAll(this.lcolumns);
        this.feJoin.getRightAttributes().clear();
        this.feJoin.getRightAttributes().addAll(this.rcolumns);
        this.isApplied = true;
        FEJoinPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.feJoin.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.feJoin.setProperty(dp.getName(), dp.getValue());
        }
    }

    private void updateJTable(JTable jtable) {
        int row = jtable.getEditingRow();
        int col = jtable.getEditingColumn();
        if (row > -1 && col > -1) {
            jtable.getCellEditor(row, col).stopCellEditing();
        }
        jtable.updateUI();
    }

    protected JPanel getAttributePairsPanel() {
        if (this.pnAttributePairs == null) {
            this.pnAttributePairs = this.createPage(Messages.getString("FEJoinPropertiesDialogEx.AttributePairs"));
            JoinsTableModel jtm = new JoinsTableModel();
            this.scTable = new JTable(jtm);
            this.scTable.setSelectionMode(0);
            JScrollPane scrollpane = new JScrollPane(this.scTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(Messages.getString("FEJoinPropertiesDialogEx.AddPairOfAttributes"));
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FEJoinPropertiesDialogEx.this.lcolumns.add(null);
                        FEJoinPropertiesDialogEx.this.rcolumns.add(null);
                        FEJoinPropertiesDialogEx.this.updateJTable(FEJoinPropertiesDialogEx.this.scTable);
                        FEJoinPropertiesDialogEx.this.scTable.updateUI();
                    }
                });
                this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = FEJoinPropertiesDialogEx.this.scTable.getSelectedRow();
                        if (objectNumber != -1 && FEJoinPropertiesDialogEx.this.lcolumns.size() > 0 && objectNumber < FEJoinPropertiesDialogEx.this.lcolumns.size()) {
                            int col = FEJoinPropertiesDialogEx.this.scTable.getEditingColumn();
                            int row = FEJoinPropertiesDialogEx.this.scTable.getEditingRow();
                            if (row >= 0 && col >= 0) {
                                FEJoinPropertiesDialogEx.this.scTable.getCellEditor(row, col).stopCellEditing();
                            }
                            FEJoinPropertiesDialogEx.this.lcolumns.remove(objectNumber);
                            FEJoinPropertiesDialogEx.this.rcolumns.remove(objectNumber);
                            FEJoinPropertiesDialogEx.this.updateJTable(FEJoinPropertiesDialogEx.this.scTable);
                            FEJoinPropertiesDialogEx.this.scTable.updateUI();
                        }
                    }
                });
                JToolBar toolBar = new JToolBar(0);
                toolBar.setFloatable(false);
                toolBar.add(this.btnAdd);
                toolBar.add(this.btnRemove);
                buttonGeneral.add(toolBar);
            }
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnAttributePairs.add(pPanel);
            TableColumn column = null;
            block4: for (int i = 0; i < 2; ++i) {
                column = this.scTable.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        column.setCellEditor(new DefaultCellEditor(this.lcombo));
                        continue block4;
                    }
                    case 1: {
                        column.setCellEditor(new DefaultCellEditor(this.rcombo));
                    }
                }
            }
        }
        return this.pnAttributePairs;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class JoinsTableModel
    extends AbstractTableModel {
        private JoinsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FEJoinPropertiesDialogEx.this.lcolumns.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                if (FEJoinPropertiesDialogEx.this.cLeftEnt != null) {
                    return FEJoinPropertiesDialogEx.this.cLeftEnt.getName();
                }
                return Messages.getString("FEJoinPropertiesDialogEx.LeftEntity");
            }
            if (column == 1) {
                if (FEJoinPropertiesDialogEx.this.cLeftEnt != null) {
                    return FEJoinPropertiesDialogEx.this.cRightEnt.getName();
                }
                return Messages.getString("FEJoinPropertiesDialogEx.RightEntity");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!FEJoinPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return FEJoinPropertiesDialogEx.this.cbExistingRelation.getSelectedItem() == null;
        }

        public Class getColumnClass(int c) {
            return JComboBox.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return FEJoinPropertiesDialogEx.this.lcolumns.get(row);
            }
            if (col == 1) {
                return FEJoinPropertiesDialogEx.this.rcolumns.get(row);
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0) {
                FEJoinPropertiesDialogEx.this.lcolumns.set(row, aValue);
            } else if (column == 1) {
                FEJoinPropertiesDialogEx.this.rcolumns.set(row, aValue);
            }
            super.setValueAt(aValue, row, column);
        }
    }
}

