/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.SelectAttributesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;

public class RollupLinkPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private RollupLink link;
    private JButton bnChildLevel;
    private JButton bnParentLevel;
    private JTable aTable;
    private List aList;
    private ContainerObject factEntity;
    private JComboBox cbFactEntity;
    private String chl;
    private String pl;
    private JCheckBox chRolePlaying;
    private JCheckBox chSparse;
    private JTextField tfAggrOperator;
    private JPanel pnAttributes;
    private JLabel lbChildLevel;
    private JLabel lbParentLevel;
    private static final Dimension defaultSize = new Dimension(210, 20);

    public RollupLinkPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public RollupLinkPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    @Override
    protected int getMinimumWidth() {
        return 630;
    }

    private void initGeneral() {
        this.lbChildLevel = new JLabel(this.chl);
        this.lbChildLevel.setPreferredSize(this.getDefaultSize());
        this.bnChildLevel = new JButton();
        this.bnChildLevel.setPreferredSize(this.getDefaultSize());
        this.bnChildLevel.setHorizontalAlignment(0);
        this.bnChildLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RollupLinkPropertiesDialogEx.this.link.getChildLevel() != null) {
                    RollupLinkPropertiesDialogEx.this.link.getChildLevel().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(this.lbChildLevel, this.bnChildLevel));
        this.lbParentLevel = new JLabel(this.pl);
        this.lbParentLevel.setPreferredSize(this.getDefaultSize());
        this.bnParentLevel = new JButton();
        this.bnParentLevel.setPreferredSize(this.getDefaultSize());
        this.bnParentLevel.setHorizontalAlignment(0);
        this.bnParentLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RollupLinkPropertiesDialogEx.this.link.getParentLevel() != null) {
                    RollupLinkPropertiesDialogEx.this.link.getParentLevel().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(this.lbParentLevel, this.bnParentLevel));
        JLabel lbRolePlaying = new JLabel(Messages.getString("RollupLinkPropertiesDialogEx.RolePlaying"));
        lbRolePlaying.setPreferredSize(this.getDefaultSize());
        this.chRolePlaying = new JCheckBox();
        this.chRolePlaying.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbRolePlaying, this.chRolePlaying));
        JLabel lbFactEntity = new JLabel(Messages.getString("RollupLinkPropertiesDialogEx.FactEntity"));
        lbFactEntity.setPreferredSize(this.getDefaultSize());
        this.cbFactEntity = new JComboBox();
        this.cbFactEntity.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbFactEntity, this.cbFactEntity));
        this.cbFactEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RollupLinkPropertiesDialogEx.this.aTable != null) {
                    RollupLinkPropertiesDialogEx.this.factEntity = (ContainerObject)RollupLinkPropertiesDialogEx.this.cbFactEntity.getSelectedItem();
                    RollupLinkPropertiesDialogEx.this.aList.clear();
                    RollupLinkPropertiesDialogEx.this.aTable.updateUI();
                }
            }
        });
        JLabel lbSparseDim = new JLabel(Messages.getString("RollupLinkPropertiesDialogEx.SparseDimension"));
        lbSparseDim.setPreferredSize(this.getDefaultSize());
        this.chSparse = new JCheckBox();
        this.chSparse.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSparseDim, this.chSparse));
        JLabel lbAggrOperator = new JLabel(Messages.getString("RollupLinkPropertiesDialogEx.DefaultAggrOperator"));
        lbAggrOperator.setPreferredSize(this.getDefaultSize());
        this.tfAggrOperator = new JTextField();
        this.tfAggrOperator.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAggrOperator, this.tfAggrOperator));
    }

    @Override
    public String getCaption() {
        if (this.getDesignObject() != null && ((RollupLink)this.getDesignObject()).getChildLevel() instanceof Cube && ((RollupLink)this.getDesignObject()).getParentLevel() instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
            return Messages.getString("RollupLinkPropertiesDialogEx.DimensionUsage");
        }
        return Messages.getString("RollupLinkPropertiesDialogEx.RollupLinkProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "ROLLUP_LINK_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof RollupLink) {
            this.link = (RollupLink)object;
            this.initDefaults(false);
            this.taDescription.setText(this.link.getDescription());
            if (this.link != null && this.link.getChildLevel() instanceof Cube && this.link.getParentLevel() instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                this.chl = Messages.getString("RollupLinkPropertiesDialogEx.Cube");
                this.pl = Messages.getString("RollupLinkPropertiesDialogEx.Dimension");
            } else {
                this.chl = LB_CHILD_LEVEL;
                this.pl = LB_PARENT_LEVEL;
            }
            this.lbChildLevel.setText(this.chl);
            this.lbParentLevel.setText(this.pl);
            String sourceName = this.link.getChildLevel() != null ? this.link.getChildLevel().getName() : Messages.getString("RollupLinkPropertiesDialogEx.NONE");
            this.bnChildLevel.setText(sourceName);
            String parentName = this.link.getParentLevel() != null ? this.link.getParentLevel().getName() : Messages.getString("RollupLinkPropertiesDialogEx.NONE");
            this.bnParentLevel.setText(parentName);
            this.chRolePlaying.setSelected(this.link.isRolePlaying());
            if (this.link.getChildLevel() instanceof Cube) {
                this.factEntity = this.link.getFactEntity();
                this.fillComboItems(((Cube)this.link.getChildLevel()).getFactEntities().toArray(), this.cbFactEntity, true);
                this.cbFactEntity.setSelectedItem(this.factEntity);
                if (this.aList.size() == 0) {
                    this.aList.addAll(((RollupLink)this.getDesignObject()).getChildToParentAttributes());
                }
                if (this.aTable != null) {
                    this.aTable.updateUI();
                }
                this.chSparse.setSelected(this.link.isSparseDimension());
                this.tfAggrOperator.setText(this.link.getDefaultAggregationOperator());
            } else {
                this.cbFactEntity.setEnabled(false);
                this.chSparse.setEnabled(false);
                this.tfAggrOperator.setEnabled(false);
                this.chRolePlaying.setEnabled(false);
            }
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator it = this.link.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.link.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private boolean checkChildToParent() {
        RollupLink rollupLink = (RollupLink)this.getDesignObject();
        if (rollupLink.getChildLevel() != null && rollupLink.getChildLevel() instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
            return false;
        }
        if (rollupLink.getChildLevel() != null && rollupLink.getParentLevel() != null) {
            if (rollupLink.getChildLevel() instanceof Level && ((Level)rollupLink.getChildLevel()).getLevelEntity() != null && rollupLink.getParentLevel() instanceof Level && ((Level)rollupLink.getChildLevel()).getLevelEntity() == ((Level)rollupLink.getParentLevel()).getLevelEntity()) {
                return false;
            }
            if (rollupLink.getChildLevel() instanceof Cube && ((Cube)rollupLink.getChildLevel()).getFactEntity() == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.aList = new ArrayList();
        this.addToTree(root, this.getGeneralPanel());
        if (this.checkChildToParent()) {
            this.aList.addAll(((RollupLink)this.getDesignObject()).getChildToParentAttributes());
            this.addToTree(root, this.getAttributesPanel());
        }
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        TVLink tvlink;
        Link ownlink;
        this.link.setName(this.tfName.getText());
        this.link.setComment(this.taComments.getText());
        this.link.setNotes(this.taNotes.getText());
        this.link.setDescription(this.taDescription.getText());
        this.link.getChildToParentAttributes().clear();
        this.link.setFactEntity(this.factEntity);
        this.link.setRolePlaying(this.chRolePlaying.isSelected());
        if (this.link.getChildLevel() instanceof Cube) {
            this.link.setDefaultAggregationOperator(this.tfAggrOperator.getText());
            this.link.setSparseDimension(this.chSparse.isSelected());
        }
        for (ContainedObject object : this.aList) {
            this.link.addChildToParentAttribute(object);
        }
        this.setResponsibleParties();
        this.setDocuments();
        TopView tv = this.link.getChildLevel().getTopView();
        if (tv != null && tv.getCellView() != null && tv.getCellView().getDiagram() != null) {
            tv.getCellView().getDiagram().repaint();
        }
        if ((ownlink = this.link.getLink()) != null && (tvlink = (TVLink)ownlink.getTopView()) != null) {
            Label label = tvlink.getLabel(1);
            if (label != null) {
                label.setText(this.tfName.getText());
            }
            tvlink.displayLabels();
        }
        RollupLinkPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.link.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.link.setProperty(dp.getName(), dp.getValue());
        }
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("RollupLinkPropertiesDialogEx.ChildToParentAttributes"));
            this.aTable = new JTable(new AttributeModel());
            this.aTable.setSelectionMode(0);
            this.aTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = RollupLinkPropertiesDialogEx.this.aTable.getSelectedRow()) > -1 && RollupLinkPropertiesDialogEx.this.aList.size() > 0 && row < RollupLinkPropertiesDialogEx.this.aList.size()) {
                        ContainedObject attribute = (ContainedObject)RollupLinkPropertiesDialogEx.this.aList.get(row);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.aTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = RollupLinkPropertiesDialogEx.this.aTable.getSelectedRow();
                    if (row > -1 && RollupLinkPropertiesDialogEx.this.aList.size() > 0 && row < RollupLinkPropertiesDialogEx.this.aList.size()) {
                        ContainedObject attribute = (ContainedObject)RollupLinkPropertiesDialogEx.this.aList.get(row);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ContainerObject ent = null;
                        if (RollupLinkPropertiesDialogEx.this.link.getChildLevel() instanceof Cube) {
                            ent = RollupLinkPropertiesDialogEx.this.factEntity;
                        } else if (RollupLinkPropertiesDialogEx.this.link.getChildLevel() instanceof Level) {
                            ent = ((Level)RollupLinkPropertiesDialogEx.this.link.getChildLevel()).getLevelEntity();
                        }
                        SelectAttributesDialog dialog = new SelectAttributesDialog(RollupLinkPropertiesDialogEx.this.getAppView(), RollupLinkPropertiesDialogEx.this.aList, ent);
                        dialog.setVisible(true);
                        RollupLinkPropertiesDialogEx.this.aTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = RollupLinkPropertiesDialogEx.this.aTable.getSelectedRow();
                        if (objectNumber != -1 && RollupLinkPropertiesDialogEx.this.aList.size() > 0 && objectNumber < RollupLinkPropertiesDialogEx.this.aList.size()) {
                            RollupLinkPropertiesDialogEx.this.aList.remove(objectNumber);
                            RollupLinkPropertiesDialogEx.this.aTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnAttributes.add(pPanel);
        }
        return this.pnAttributes;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class AttributeModel
    extends AbstractTableModel {
        private AttributeModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return RollupLinkPropertiesDialogEx.this.aList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("RollupLinkPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ContainedObject attribute = (ContainedObject)RollupLinkPropertiesDialogEx.this.aList.get(row);
            if (col == 0) {
                return attribute.getLongName();
            }
            return new Integer(row * col);
        }
    }
}

