/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectDescriptiveAttributesDialog
extends JDialog
implements AbstractEditorConstants {
    private List aList;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private DefaultListModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    protected JPanel generalPanel;
    private ContainerObject selectedEntity;
    private Level level;
    List copyList = new ArrayList();

    public SelectDescriptiveAttributesDialog(ApplicationView view, List aList, ContainerObject selectedEntity, Level level) {
        super(view.getFrame());
        this.level = level;
        this.selectedEntity = selectedEntity;
        this.setModal(true);
        this.aList = aList;
        this.setTitle(Messages.getString("SelectDescriptiveAttributesDialog.SelectDescriptiveAttributes"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectDescriptiveAttributesDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allAttributesModel = new DefaultListModel();
        this.selectedAttributesModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private SlowChangingAttribute getSCAforAttr(List list, ContainedObject attr) {
        for (SlowChangingAttribute sca : list) {
            if (sca.getAttribute() != attr) continue;
            return sca;
        }
        return null;
    }

    private boolean containsAttribute(ContainedObject attribute) {
        for (SlowChangingAttribute scha : this.aList) {
            if (scha.getAttribute() != attribute) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.initAllAttributesList();
        this.initAttributesButtons();
        this.initSelectedAttributesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = this.aList.iterator();
        while (it.hasNext()) {
            SlowChangingAttribute scha = (SlowChangingAttribute)it.next();
            if (scha.getAttribute() == null) continue;
            this.selectedAttributesModel.addElement(new AttributeItem(scha.getAttribute()));
        }
        ArrayList list = new ArrayList();
        if (this.selectedEntity != null) {
            if (this.selectedEntity instanceof Entity) {
                list.addAll(((Entity)this.selectedEntity).getHierarchicalAttributes());
            } else {
                list.addAll(this.selectedEntity.getElementsCollection());
            }
            Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
            it = list.iterator();
        } else if (this.level != null) {
            list.addAll(this.level.getMultidimensionalDesign().getAttributes());
            Collections.sort(list, ModelObjectSet.LONG_NAME_COMPARATOR);
            it = list.iterator();
        }
        if (it != null) {
            while (it.hasNext()) {
                ContainedObject next = (ContainedObject)it.next();
                if (this.containsAttribute(next)) continue;
                this.allAttributesModel.addElement(new AttributeItem(next));
            }
        }
    }

    private void initAllAttributesList() {
        JPanel attributesList = new JPanel();
        this.allAttributesList = new JList(this.allAttributesModel);
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allAttributesList);
        sp.setPreferredSize(new Dimension(220, 300));
        attributesList.add(sp);
        this.generalPanel.add((Component)attributesList, "West");
    }

    private void initSelectedAttributesList() {
        JPanel selectedList = new JPanel();
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedAttributesList);
        sp.setPreferredSize(new Dimension(220, 300));
        selectedList.add(sp);
        this.generalPanel.add((Component)selectedList, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initAttributesButtons() {
        JPanel buttonsPanel = new JPanel();
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(Messages.getString("SelectDescriptiveAttributesDialog.Add"));
        this.btnRemoveAttributes = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(Messages.getString("SelectDescriptiveAttributesDialog.Remove"));
        toolBar.add(this.btnAddAttributes);
        toolBar.add(this.btnRemoveAttributes);
        buttonsPanel.add(toolBar);
        buttonsPanel.setPreferredSize(new Dimension(32, 300));
        this.generalPanel.add((Component)buttonsPanel, "Center");
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectDescriptiveAttributesDialog.this.selectedAttributesList.getSelectedIndex() == -1) {
                    SelectDescriptiveAttributesDialog.this.btnRemoveAttributes.setEnabled(false);
                } else {
                    SelectDescriptiveAttributesDialog.this.btnRemoveAttributes.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectDescriptiveAttributesDialog.this.allAttributesList.getSelectedIndex() == -1) {
                    SelectDescriptiveAttributesDialog.this.btnAddAttributes.setEnabled(false);
                } else {
                    SelectDescriptiveAttributesDialog.this.btnAddAttributes.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectDescriptiveAttributesDialog.this.selectedAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectDescriptiveAttributesDialog.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectDescriptiveAttributesDialog.this.allAttributesModel.contains(ob)) continue;
                    SelectDescriptiveAttributesDialog.this.allAttributesModel.addElement(ob);
                    SelectDescriptiveAttributesDialog.this.selectedAttributesModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectDescriptiveAttributesDialog.this.allAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectDescriptiveAttributesDialog.this.allAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectDescriptiveAttributesDialog.this.selectedAttributesModel.contains(ob)) continue;
                    SelectDescriptiveAttributesDialog.this.selectedAttributesModel.addElement(ob);
                    SelectDescriptiveAttributesDialog.this.allAttributesModel.removeElement(ob);
                }
            }
        }
    }

    private class AttributeItem {
        private ContainedObject attribute = null;

        public AttributeItem(ContainedObject attribute) {
            this.attribute = attribute;
        }

        public ContainedObject getAttribute() {
            return this.attribute;
        }

        public String toString() {
            if (this.attribute != null) {
                return this.attribute.getLongName();
            }
            return "";
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectDescriptiveAttributesDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectDescriptiveAttributesDialog.this.copyList.clear();
            SelectDescriptiveAttributesDialog.this.copyList.addAll(SelectDescriptiveAttributesDialog.this.aList);
            SelectDescriptiveAttributesDialog.this.aList.clear();
            for (int i = 0; i < SelectDescriptiveAttributesDialog.this.selectedAttributesModel.size(); ++i) {
                AttributeItem item = (AttributeItem)SelectDescriptiveAttributesDialog.this.selectedAttributesModel.getElementAt(i);
                SlowChangingAttribute sca = SelectDescriptiveAttributesDialog.this.getSCAforAttr(SelectDescriptiveAttributesDialog.this.copyList, item.getAttribute());
                if (sca == null) {
                    sca = new SlowChangingAttribute(SelectDescriptiveAttributesDialog.this.level, item.getAttribute());
                }
                SelectDescriptiveAttributesDialog.this.aList.add(sca);
            }
            SelectDescriptiveAttributesDialog.this.dispose();
        }
    }
}

