/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectElementsDialog
extends JDialog
implements AbstractEditorConstants {
    private List aList;
    private List allElements;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private DefaultListModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    protected JPanel generalPanel;
    public boolean cancel = true;

    public SelectElementsDialog(ApplicationView view, List allElements, List selectedElements) {
        super(view.getFrame());
        this.setModal(true);
        this.aList = selectedElements;
        this.allElements = allElements;
        this.setTitle(Messages.getString("SelectElementsDialog.SelectElements"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectElementsDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allAttributesModel = new DefaultListModel();
        this.selectedAttributesModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init() {
        this.initAllAttributesList();
        this.initAttributesButtons();
        this.initSelectedAttributesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = this.aList.iterator();
        while (it.hasNext()) {
            this.selectedAttributesModel.addElement(new ElementItem(it.next()));
        }
        for (Object next : this.allElements) {
            if (this.aList.contains(next)) continue;
            this.allAttributesModel.addElement(new ElementItem(next));
        }
    }

    private void initAllAttributesList() {
        JPanel attributesList = new JPanel();
        this.allAttributesList = new JList(this.allAttributesModel);
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allAttributesList);
        sp.setPreferredSize(new Dimension(220, 300));
        attributesList.add(sp);
        this.generalPanel.add((Component)attributesList, "West");
    }

    private void initSelectedAttributesList() {
        JPanel selectedList = new JPanel();
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedAttributesList);
        sp.setPreferredSize(new Dimension(220, 300));
        selectedList.add(sp);
        this.generalPanel.add((Component)selectedList, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initAttributesButtons() {
        JPanel buttonsPanel = new JPanel();
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(Messages.getString("SelectElementsDialog.Add"));
        this.btnRemoveAttributes = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(Messages.getString("SelectElementsDialog.Remove"));
        toolBar.add(this.btnAddAttributes);
        toolBar.add(this.btnRemoveAttributes);
        buttonsPanel.add(toolBar);
        buttonsPanel.setPreferredSize(new Dimension(32, 300));
        this.generalPanel.add((Component)buttonsPanel, "Center");
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectElementsDialog.this.selectedAttributesList.getSelectedIndex() == -1) {
                    SelectElementsDialog.this.btnRemoveAttributes.setEnabled(false);
                } else {
                    SelectElementsDialog.this.btnRemoveAttributes.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectElementsDialog.this.allAttributesList.getSelectedIndex() == -1) {
                    SelectElementsDialog.this.btnAddAttributes.setEnabled(false);
                } else {
                    SelectElementsDialog.this.btnAddAttributes.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectElementsDialog.this.selectedAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectElementsDialog.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectElementsDialog.this.allAttributesModel.contains(ob)) continue;
                    SelectElementsDialog.this.allAttributesModel.addElement(ob);
                    SelectElementsDialog.this.selectedAttributesModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectElementsDialog.this.allAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectElementsDialog.this.allAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectElementsDialog.this.selectedAttributesModel.contains(ob)) continue;
                    SelectElementsDialog.this.selectedAttributesModel.addElement(ob);
                    SelectElementsDialog.this.allAttributesModel.removeElement(ob);
                }
            }
        }
    }

    private class ElementItem {
        private Object element = null;

        public ElementItem(Object element) {
            this.element = element;
        }

        public Object getElement() {
            return this.element;
        }

        public String toString() {
            if (this.element != null) {
                if (this.element instanceof DesignObject) {
                    return ((DesignObject)this.element).getLongName();
                }
                return this.element.toString();
            }
            return "";
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectElementsDialog.this.cancel = true;
            SelectElementsDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectElementsDialog.this.cancel = false;
            SelectElementsDialog.this.aList.clear();
            for (int i = 0; i < SelectElementsDialog.this.selectedAttributesModel.size(); ++i) {
                ElementItem item = (ElementItem)SelectElementsDialog.this.selectedAttributesModel.getElementAt(i);
                SelectElementsDialog.this.aList.add(item.getElement());
            }
            SelectElementsDialog.this.dispose();
        }
    }
}

