/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.SelectAttributesDialog;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class InfoStructurePropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private InfoStructure structure;
    private List aList;
    private JTable aTable;
    private JPanel pnAttributes;
    private List eList;
    private JTable eTable;
    private JPanel pnEntity;
    private ArrayList ifList;
    private JPanel pnInformation;
    private JTable iftable;
    private JIntegerField ifVolume;
    private JIntegerField ifPercent;
    private JComboBox cbGrowthRateUnit;
    private JPanel pnVolumeInfo;

    public InfoStructurePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("InfoStructurePropertiesDialogEx.InformationStructureProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof InfoStructure) {
            this.structure = (InfoStructure)object;
            this.initDefaults(false);
            this.tfSynonym.setText(this.structure.getSynonym());
            this.aList.addAll(this.structure.getAttributes());
            this.updateEntityList();
            this.ifList.addAll(this.structure.getInfoFlows());
            this.ifVolume.setValue((long)this.structure.getVolume());
            this.ifPercent.setValue((long)this.structure.getGrowthRatePercent());
            this.cbGrowthRateUnit.setSelectedItem(this.translate(this.structure.getGrowthRateUnit(), InfoStructure.GROWTH_RATE_UNITS, InfoStructure.GROWTH_RATE_UNITS_DISPLAY));
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator it = this.structure.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.structure.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.structure.setName(this.tfName.getText());
        this.structure.setNotes(this.taNotes.getText());
        this.structure.setComment(this.taComments.getText());
        this.structure.setSynonym(this.tfSynonym.getText());
        this.structure.setVolume(this.ifVolume.getIntValue());
        this.structure.setGrowthRatePercent(this.ifPercent.getIntValue());
        this.structure.setGrowthRateUnit(this.translate((String)this.cbGrowthRateUnit.getSelectedItem(), InfoStructure.GROWTH_RATE_UNITS_DISPLAY, InfoStructure.GROWTH_RATE_UNITS));
        this.structure.getAttributes().clear();
        for (Attribute attribute : this.aList) {
            this.structure.addAttribute(attribute);
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        InfoStructurePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.structure.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.structure.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getAttributesPanel());
        this.addToTree(root, this.getEntityPanel());
        this.addToTree(root, this.getInformationFlowsPanel());
        this.addToTree(root, this.getVolumeInfoPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "INFORMATION_STRUCTURE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
    }

    private JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("InfoStructurePropertiesDialogEx.Attributes"));
            this.aList = new ArrayList();
            this.aTable = new JTable(new AttributesModel());
            this.aTable.setSelectionMode(0);
            this.aTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = InfoStructurePropertiesDialogEx.this.aTable.getSelectedRow()) > -1 && InfoStructurePropertiesDialogEx.this.aList.size() > 0 && row < InfoStructurePropertiesDialogEx.this.aList.size()) {
                        Attribute attribute = (Attribute)InfoStructurePropertiesDialogEx.this.aList.get(row);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.aTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = InfoStructurePropertiesDialogEx.this.aTable.getSelectedRow();
                    if (row > -1 && InfoStructurePropertiesDialogEx.this.aList.size() > 0 && row < InfoStructurePropertiesDialogEx.this.aList.size()) {
                        Attribute attribute = (Attribute)InfoStructurePropertiesDialogEx.this.aList.get(row);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectAttributesDialog dialog = new SelectAttributesDialog(InfoStructurePropertiesDialogEx.this.getAppView(), InfoStructurePropertiesDialogEx.this.aList);
                        dialog.show();
                        InfoStructurePropertiesDialogEx.this.aTable.updateUI();
                        InfoStructurePropertiesDialogEx.this.updateEntityList();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = InfoStructurePropertiesDialogEx.this.aTable.getSelectedRow();
                        if (objectNumber != -1 && InfoStructurePropertiesDialogEx.this.aList.size() > 0 && objectNumber < InfoStructurePropertiesDialogEx.this.aList.size()) {
                            InfoStructurePropertiesDialogEx.this.aList.remove(objectNumber);
                            InfoStructurePropertiesDialogEx.this.aTable.updateUI();
                            InfoStructurePropertiesDialogEx.this.updateEntityList();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 165));
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnAttributes.add(aPanel);
        }
        return this.pnAttributes;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("InfoStructurePropertiesDialogEx.Entities"));
            this.eList = new ArrayList();
            this.eTable = new JTable(new EntityModel());
            this.eTable.setSelectionMode(0);
            this.eTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = InfoStructurePropertiesDialogEx.this.eTable.getSelectedRow()) != -1 && InfoStructurePropertiesDialogEx.this.eList.size() > 0 && row < InfoStructurePropertiesDialogEx.this.eList.size()) {
                        Entity entity = (Entity)InfoStructurePropertiesDialogEx.this.eList.get(row);
                        entity.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.eTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("InfoStructurePropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = InfoStructurePropertiesDialogEx.this.eTable.getSelectedRow();
                    if (row != -1 && InfoStructurePropertiesDialogEx.this.eList.size() > 0 && row < InfoStructurePropertiesDialogEx.this.eList.size()) {
                        Entity entity = (Entity)InfoStructurePropertiesDialogEx.this.eList.get(row);
                        entity.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 165));
            JPanel ePanel = new JPanel(new BorderLayout());
            ePanel.add((Component)buttonGeneral, "North");
            ePanel.add(scrollpane);
            this.pnEntity.add(ePanel);
        }
        return this.pnEntity;
    }

    private JPanel getInformationFlowsPanel() {
        if (this.pnInformation == null) {
            this.pnInformation = this.createPage(Messages.getString("InfoStructurePropertiesDialogEx.InformationFlows"));
            this.ifList = new ArrayList();
            this.iftable = new JTable(new InformationFlowsModel());
            this.iftable.setSelectionMode(0);
            this.iftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = InfoStructurePropertiesDialogEx.this.iftable.getSelectedRow()) != -1 && InfoStructurePropertiesDialogEx.this.ifList.size() > 0 && row < InfoStructurePropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)InfoStructurePropertiesDialogEx.this.ifList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.iftable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("InfoStructurePropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = InfoStructurePropertiesDialogEx.this.iftable.getSelectedRow();
                    if (row != -1 && InfoStructurePropertiesDialogEx.this.ifList.size() > 0 && row < InfoStructurePropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)InfoStructurePropertiesDialogEx.this.ifList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 165));
            JPanel ifPanel = new JPanel(new BorderLayout());
            ifPanel.add((Component)buttonGeneral, "North");
            ifPanel.add(scrollpane);
            this.pnInformation.add(ifPanel);
        }
        return this.pnInformation;
    }

    private JPanel getVolumeInfoPanel() {
        if (this.pnVolumeInfo == null) {
            this.pnVolumeInfo = this.createPage(Messages.getString("InfoStructurePropertiesDialogEx.VolumeInformation"));
            JPanel jpanel = new JPanel(new BorderLayout(10, 10));
            JLabel lbVolume = new JLabel(LB_VOLUME);
            lbVolume.setPreferredSize(this.getDefaultSize());
            this.ifVolume = new JIntegerField();
            this.ifVolume.setPreferredSize(this.getDefaultSize());
            this.ifVolume.setFont(this.ifVolume.getFont().deriveFont(0));
            jpanel.add((Component)this.createRow(lbVolume, this.ifVolume), "North");
            JPanel pnGrowt = new JPanel(new BorderLayout(20, 20));
            JPanel pnGrowthRate = new JPanel(new GridLayout(0, 1, 20, 20));
            pnGrowthRate.setBorder(BorderFactory.createTitledBorder(Messages.getString("InfoStructurePropertiesDialogEx.GrowthRate")));
            JLabel lbPercent = new JLabel(LB_PERCENT);
            lbPercent.setPreferredSize(this.getDefaultSize());
            this.ifPercent = new JIntegerField();
            this.ifPercent.setPreferredSize(this.getDefaultSize());
            this.ifPercent.setFont(this.ifPercent.getFont().deriveFont(0));
            pnGrowthRate.add(this.createRow(lbPercent, this.ifPercent));
            JLabel lbGrowthRate = new JLabel(LB_GROWTH_RATE_UNIT);
            lbGrowthRate.setPreferredSize(this.getDefaultSize());
            this.cbGrowthRateUnit = new JComboBox<String>(InfoStructure.GROWTH_RATE_UNITS_DISPLAY);
            this.cbGrowthRateUnit.setFont(this.cbGrowthRateUnit.getFont().deriveFont(0));
            this.cbGrowthRateUnit.setPreferredSize(this.getDefaultSize());
            pnGrowthRate.add(this.createRow(lbGrowthRate, this.cbGrowthRateUnit));
            pnGrowt.add((Component)pnGrowthRate, "North");
            jpanel.add((Component)pnGrowt, "Center");
            this.pnVolumeInfo.add(jpanel);
        }
        return this.pnVolumeInfo;
    }

    private void updateEntityList() {
        this.eList.clear();
        for (Attribute attribute : this.aList) {
            if (this.eList.contains(attribute.getContainer())) continue;
            this.eList.add(attribute.getContainer());
        }
        this.eTable.updateUI();
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class InformationFlowsModel
    extends AbstractTableModel {
        private InformationFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return InfoStructurePropertiesDialogEx.this.ifList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("InfoStructurePropertiesDialogEx.InformationFlow");
            }
            if (column == 1) {
                return Messages.getString("InfoStructurePropertiesDialogEx.Synonym");
            }
            if (column == 2) {
                return Messages.getString("InfoStructurePropertiesDialogEx.Diagram");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Flow flow = (Flow)InfoStructurePropertiesDialogEx.this.ifList.get(row);
            if (col == 0) {
                return flow.getName();
            }
            if (col == 1) {
                return flow.getSynonym();
            }
            if (col == 2) {
                return flow.getDesignPart().getName();
            }
            return new Integer(row * col);
        }
    }

    private class EntityModel
    extends AbstractTableModel {
        private EntityModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return InfoStructurePropertiesDialogEx.this.eList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("InfoStructurePropertiesDialogEx.Entities");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Entity entity = (Entity)InfoStructurePropertiesDialogEx.this.eList.get(row);
            if (col == 0) {
                return entity.getName();
            }
            return new Integer(row * col);
        }
    }

    private class AttributesModel
    extends AbstractTableModel {
        private AttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return InfoStructurePropertiesDialogEx.this.aList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("InfoStructurePropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Attribute attribute = (Attribute)InfoStructurePropertiesDialogEx.this.aList.get(row);
            if (col == 0) {
                return attribute.getLongName();
            }
            return new Integer(row * col);
        }
    }
}

