/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class NewEventDialog
extends JDialog
implements AbstractEditorConstants {
    private DesignPart designPart;
    private List eList;
    private JPanel generalPanel;
    private JTextField tfName;
    private JRadioButton rbClock;
    private JRadioButton rbPerson;
    private JRadioButton rbStorage;
    private int type = 1;
    private String name = "No_Name";
    private List allList = new ArrayList();
    private JTable allTable;
    private JRadioButton rbNew;
    private JRadioButton rbAll;

    public NewEventDialog(ApplicationView view, DesignPart designPart, List eList) {
        super(view.getFrame());
        this.setModal(true);
        this.designPart = designPart;
        this.eList = eList;
        this.setTitle(Messages.getString("NewEventDialog.AddEvent"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewEventDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        JPanel pnTop = new JPanel(new GridLayout(0, 1));
        pnTop.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.SelectEvent")));
        RadioListener listener = new RadioListener();
        this.rbNew = new JRadioButton(Messages.getString("NewEventDialog.NewEvent"));
        this.rbNew.addActionListener(listener);
        this.rbNew.setMnemonic(78);
        this.rbAll = new JRadioButton(Messages.getString("NewEventDialog.AvailableEvent"));
        this.rbAll.addActionListener(listener);
        this.rbAll.setMnemonic(65);
        this.rbNew.setSelected(true);
        ButtonGroup bnGroup = new ButtonGroup();
        bnGroup.add(this.rbNew);
        bnGroup.add(this.rbAll);
        pnTop.add(this.rbNew);
        pnTop.add(this.rbAll);
        JPanel pnNewEvent = new JPanel(new BorderLayout());
        pnNewEvent.add((Component)pnTop, "North");
        JPanel pnCenter = new JPanel(new BorderLayout());
        pnCenter.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.NewEvent")));
        JPanel pnName = new JPanel();
        pnName.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.Name")));
        this.name = "Event_" + String.valueOf(designPart.getDesign().getProcessModel().getEventSet().size() + 1);
        this.tfName = new JTextField(this.name, 20);
        pnName.add(this.tfName);
        pnCenter.add((Component)pnName, "North");
        JPanel pnType = new JPanel(new GridLayout(0, 1));
        pnType.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.Type")));
        TypeListener typeListener = new TypeListener();
        this.rbClock = new JRadioButton(Messages.getString("NewEventDialog.ClockCalendar"));
        this.rbClock.addActionListener(typeListener);
        this.rbClock.setMnemonic(67);
        this.rbClock.setSelected(true);
        this.rbPerson = new JRadioButton(Messages.getString("NewEventDialog.Person"));
        this.rbPerson.addActionListener(typeListener);
        this.rbPerson.setMnemonic(80);
        this.rbStorage = new JRadioButton(Messages.getString("NewEventDialog.Storage"));
        this.rbStorage.addActionListener(typeListener);
        this.rbStorage.setMnemonic(83);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbClock);
        group.add(this.rbPerson);
        group.add(this.rbStorage);
        pnType.add(this.rbClock);
        pnType.add(this.rbPerson);
        pnType.add(this.rbStorage);
        pnCenter.add(pnType);
        pnNewEvent.add(pnCenter);
        this.generalPanel.add((Component)pnNewEvent, "North");
        JPanel pnAllEvents = new JPanel(new BorderLayout());
        pnAllEvents.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.AllEvents")));
        this.allList.addAll(this.getAllEvents());
        this.allTable = new JTable(new AllEventsModel());
        this.allTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.allTable);
        scrollpane.setPreferredSize(new Dimension(240, 180));
        pnAllEvents.add(scrollpane);
        this.generalPanel.add(pnAllEvents);
        this.getContentPane().add((Component)this.generalPanel, "Center");
        this.enableControls(this.rbNew.isSelected());
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setPreferredSize(bnCancel.getPreferredSize());
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void enableControls(boolean enable) {
        this.tfName.setEnabled(enable);
        this.rbClock.setEnabled(enable);
        this.rbPerson.setEnabled(enable);
        this.rbStorage.setEnabled(enable);
        this.allTable.setEnabled(!enable);
        this.allTable.clearSelection();
        if (enable) {
            this.allTable.setBackground(Color.LIGHT_GRAY);
        } else {
            this.allTable.setBackground(Color.WHITE);
        }
    }

    private List getAllEvents() {
        ArrayList<Event> list = new ArrayList<Event>();
        int length = ((DataFlowDesign)this.designPart).getProcessModel().getEventSet().size();
        for (int i = 0; i < length; ++i) {
            Event event = (Event)((DataFlowDesign)this.designPart).getProcessModel().getEventSet().getElement(i);
            if (event.getEventType() == 0 || this.eList.contains(event)) continue;
            list.add(event);
        }
        return list;
    }

    private String getEventType(int type) {
        switch (type) {
            case 1: {
                return Messages.getString("NewEventDialog.ClockCalendar");
            }
            case 2: {
                return Messages.getString("NewEventDialog.Person");
            }
            case 3: {
                return Messages.getString("NewEventDialog.Storage");
            }
        }
        return "";
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewEventDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NewEventDialog.this.rbNew.isSelected()) {
                Event event = NewEventDialog.this.designPart.getDesign().getProcessModel().getEventSet().createEvent(null, NewEventDialog.this.type);
                if (!"".equalsIgnoreCase(NewEventDialog.this.tfName.getText())) {
                    event.setName(NewEventDialog.this.tfName.getText());
                } else {
                    event.setName(NewEventDialog.this.name);
                }
                NewEventDialog.this.eList.add(event);
            } else {
                int row = NewEventDialog.this.allTable.getSelectedRow();
                if (row != -1 && NewEventDialog.this.allList.size() > 0 && row < NewEventDialog.this.allList.size()) {
                    Event event = (Event)NewEventDialog.this.allList.get(row);
                    NewEventDialog.this.eList.add(event);
                }
            }
            NewEventDialog.this.dispose();
        }
    }

    private class TypeListener
    implements ActionListener {
        private TypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton source = (JRadioButton)e.getSource();
            if (source == NewEventDialog.this.rbClock) {
                NewEventDialog.this.type = 1;
            } else if (source == NewEventDialog.this.rbPerson) {
                NewEventDialog.this.type = 2;
            } else if (source == NewEventDialog.this.rbStorage) {
                NewEventDialog.this.type = 3;
            } else {
                NewEventDialog.this.type = 1;
            }
        }
    }

    private class AllEventsModel
    extends AbstractTableModel {
        private AllEventsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return NewEventDialog.this.allList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("NewEventDialog.Event");
            }
            if (column == 1) {
                return Messages.getString("NewEventDialog.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Event event = (Event)NewEventDialog.this.allList.get(row);
            if (col == 0) {
                return event.getName();
            }
            if (col == 1) {
                return NewEventDialog.this.getEventType(event.getEventType());
            }
            return new Integer(row * col);
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewEventDialog.this.enableControls(NewEventDialog.this.rbNew.isSelected());
        }
    }
}

