/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.EventPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.editor.process.NewEventDialog;
import oracle.dbtools.crest.swingui.editor.process.SelectSourceElementsDialog;
import oracle.dbtools.crest.swingui.editor.process.SelectTransformationTaskDialog;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ProcessPropertiesDialogEx
extends AbstractPropertiesDialog {
    private Process process;
    private JTextField tfSynonym;
    private JTextField tfFilterCondition;
    private JTextField tfJoinCondition;
    private JComboBox cbType;
    private static final String[] TYPES = new String[]{Messages.getString("ProcessPropertiesDialogEx.Primitive"), Messages.getString("ProcessPropertiesDialogEx.Composite"), Messages.getString("ProcessPropertiesDialogEx.UseTransformationTask")};
    private TransformationTask transformationTask;
    private JButton btnTransformationTask;
    private List paramsWrappers;
    private InputParamsModel inputParamsModel;
    private JPanel pnMode;
    private JComboBox cbMode;
    private JIntegerField ifMinTransactions;
    private JComboBox cbTimeUnit;
    private JIntegerField ifResponseTime;
    private JComboBox cbResponseTimeUnit;
    private JIntegerField ifFreqTimes;
    private JComboBox cbFreqTimeUnit;
    private JComboBox cbPriority;
    private JPanel pnFreqPriority;
    private JRadioButton rbNoPeaks;
    private JCheckBox chb_12_1_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.121am"));
    private JCheckBox chb_1_2_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.12am"));
    private JCheckBox chb_2_3_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.23am"));
    private JCheckBox chb_3_4_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.34am"));
    private JCheckBox chb_4_5_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.45am"));
    private JCheckBox chb_5_6_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.56am"));
    private JCheckBox chb_6_7_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.67am"));
    private JCheckBox chb_7_8_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.78am"));
    private JCheckBox chb_8_9_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.89am"));
    private JCheckBox chb_9_10_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.910am"));
    private JCheckBox chb_10_11_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.1011am"));
    private JCheckBox chb_11_12_AM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.1112am"));
    private JCheckBox chb_12_1_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.121pm"));
    private JCheckBox chb_1_2_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.12pm"));
    private JCheckBox chb_2_3_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.23pm"));
    private JCheckBox chb_3_4_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.34pm"));
    private JCheckBox chb_4_5_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.45pm"));
    private JCheckBox chb_5_6_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.56pm"));
    private JCheckBox chb_6_7_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.67pm"));
    private JCheckBox chb_7_8_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.78pm"));
    private JCheckBox chb_8_9_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.89pm"));
    private JCheckBox chb_9_10_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.910pm"));
    private JCheckBox chb_10_11_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.1011pm"));
    private JCheckBox chb_11_12_PM = new JCheckBox(Messages.getString("ProcessPropertiesDialogEx.1112pm"));
    private JCheckBox[] CHB_PEAKS = new JCheckBox[]{this.chb_12_1_AM, this.chb_1_2_AM, this.chb_2_3_AM, this.chb_3_4_AM, this.chb_4_5_AM, this.chb_5_6_AM, this.chb_6_7_AM, this.chb_7_8_AM, this.chb_8_9_AM, this.chb_9_10_AM, this.chb_10_11_AM, this.chb_11_12_AM, this.chb_12_1_PM, this.chb_1_2_PM, this.chb_2_3_PM, this.chb_3_4_PM, this.chb_4_5_PM, this.chb_5_6_PM, this.chb_6_7_PM, this.chb_7_8_PM, this.chb_8_9_PM, this.chb_9_10_PM, this.chb_10_11_PM, this.chb_11_12_PM};
    private JPanel pnPeakPanel;
    private JPanel pnCHB;
    private JPanel pnCol1;
    private JPanel pnCol2;
    private JPanel pnCol3;
    private CheckboxListener chbListener;
    private List isList;
    private JTable etable;
    private List eList;
    private JTable fetable;
    private List feList;
    private JTable istable;
    private JPanel pnInfoStructures;
    private JPanel pnEvents;
    private JTable iftable;
    private JTable oftable;
    private List ifList;
    private List ofList;
    private JPanel pnIncomingFlows;
    private JPanel pnOutgoingFlows;
    private JTable attrTable;
    private JTable entTable;
    private List attrList;
    private List entList;
    private JPanel pnAttributes;
    private JPanel pnEntity;
    private JEditorPane editorPane;
    private JPanel pnFootNote;
    private JTable inParamTable;
    private JPanel pnTaskInParamsMapping;
    private List sList;
    private JTable sTable;
    private JButton btnProperties;
    private JButton btnAdd;
    private JTable tbTarget;
    private List targets = new ArrayList();
    private JButton btnRemove;
    private JComboBox cbTransformationTypes;
    private JPanel pnSourceTargetMapping;
    private JComboBox cbParentDiagram;

    public ProcessPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbFilterCondition = new JLabel(Messages.getString("ProcessPropertiesDialogEx.SourcesFilterCondition"));
        lbFilterCondition.setPreferredSize(this.getDefaultSize());
        this.tfFilterCondition = new JTextField();
        this.tfFilterCondition.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbFilterCondition, this.tfFilterCondition));
        JLabel lbJoinCondition = new JLabel(Messages.getString("ProcessPropertiesDialogEx.SourcesJoinCondition"));
        lbJoinCondition.setPreferredSize(this.getDefaultSize());
        this.tfJoinCondition = new JTextField();
        this.tfJoinCondition.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbJoinCondition, this.tfJoinCondition));
        this.initType();
        JLabel lbParentDiagram = new JLabel(Messages.getString("ProcessPropertiesDialogEx.ParentDiagram"));
        lbParentDiagram.setPreferredSize(this.getDefaultSize());
        this.cbParentDiagram = new JComboBox();
        this.cbParentDiagram.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbParentDiagram, this.cbParentDiagram));
    }

    @Override
    public String getCaption() {
        return Messages.getString("ProcessPropertiesDialogEx.ProcessProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Process) {
            this.process = (Process)object;
            this.initDefaults(false);
            this.tfSynonym.setText(this.process.getSynonym());
            this.tfFilterCondition.setText(this.process.getFilterCondition());
            this.tfJoinCondition.setText(this.process.getJoinCondition());
            this.cbType.setSelectedIndex(this.process.getType());
            if (this.process.isComposite() && this.process.getDiagram() != null && !this.process.getDiagram().isEmpty()) {
                this.cbType.setEnabled(false);
            }
            String name = "";
            this.transformationTask = this.process.getTransformationTask();
            if (this.transformationTask != null) {
                name = this.transformationTask.getTransformationPackage().getName() + "." + this.transformationTask.getName();
            }
            this.btnTransformationTask.setText(name);
            if ("".equalsIgnoreCase(name)) {
                this.btnTransformationTask.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.SetTransformationTask"));
            } else {
                this.btnTransformationTask.setToolTipText(name);
            }
            this.initParentDiagrams();
            this.cbParentDiagram.setSelectedItem(this.process.getDesignPart());
            this.updateType();
            this.initMode();
            this.initFreqPriority();
            this.initPeaks();
            this.isList.addAll(this.process.getInfoStructures());
            this.eList.addAll(this.process.getEvents());
            this.feList.addAll(this.process.getFlowEvents());
            this.ifList.addAll(this.process.getIncomingFlows());
            this.ofList.addAll(this.process.getOutgoingFlows());
            this.attrList.addAll(this.process.getProcessedAttributes(false));
            this.entList.addAll(this.process.getProcessedEntities(false));
            this.editorPane.setText(this.process.getFootNote());
            this.setUpSourcesColumn(this.inParamTable.getColumnModel().getColumn(1));
            this.makeWrapperList();
            this.initSourceTargetMapping();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator it = this.process.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.process.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.process.setName(this.tfName.getText());
        this.process.setNotes(this.taNotes.getText());
        this.process.setComment(this.taComments.getText());
        this.process.setSynonym(this.tfSynonym.getText());
        this.process.setFilterCondition(this.tfFilterCondition.getText());
        this.process.setJoinCondition(this.tfJoinCondition.getText());
        this.process.setTransformationTask(this.transformationTask);
        if (this.cbType.isEnabled()) {
            this.process.setType(this.cbType.getSelectedIndex());
        }
        this.process.setFootNote(this.editorPane.getText());
        this.process.setFrequencyTimes(this.ifFreqTimes.getIntValue());
        this.process.setFrequencyTimeUnit(Process.FREQUENCY_TIME_UNITS[this.cbFreqTimeUnit.getSelectedIndex()]);
        this.process.setPriority(Process.PRIORITY[this.cbPriority.getSelectedIndex()]);
        int type = this.cbMode.getSelectedIndex();
        this.process.setMode(Process.MODES[type]);
        if (this.process.getType() != 1) {
            this.setSourceTargetInfo();
        }
        switch (type) {
            case 1: {
                this.process.setBatchMinimumTransactions(this.ifMinTransactions.getIntValue());
                this.process.setBatchTimeUnit(Process.BATCH_TIME_UNITS[this.cbTimeUnit.getSelectedIndex()]);
                break;
            }
            case 2: {
                this.process.setInteractiveLongestResponseTime(this.ifResponseTime.getIntValue());
                this.process.setInteractiveResponseTimeUnit(Process.INTERACTIVE_RESPONSE_TIME_UNITS[this.cbResponseTimeUnit.getSelectedIndex()]);
            }
        }
        for (int i = 0; i < this.CHB_PEAKS.length; ++i) {
            this.process.getPeakPeriods()[i] = this.CHB_PEAKS[i].isSelected();
        }
        Iterator it = this.eList.iterator();
        this.process.clearEvents(this.process);
        while (it.hasNext()) {
            Event event = (Event)it.next();
            this.process.addEvent(event);
            event.addProcess(this.process);
        }
        if (this.process.getType() == 0) {
            this.setSourceTargetInfo();
        }
        this.updateType();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.process.getParamsWrappers().clear();
        this.process.getParamsWrappers().addAll(this.paramsWrappers);
        ProcessPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.process.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.process.setProperty(dp.getName(), dp.getValue());
        }
        DataFlowDesign parentDFD = (DataFlowDesign)this.cbParentDiagram.getSelectedItem();
        if (parentDFD != null && parentDFD != this.process.getDesignPart()) {
            TopView tv = this.process.getDesignPart().getMainView().getViewFor(this.process);
            Rectangle bounds = null;
            if (tv != null && tv.getCellView() != null) {
                bounds = tv.getCellView().getBounds().getBounds();
            }
            this.process.remove(true);
            this.process.getDesignPart().setDirty(true);
            parentDFD.getProcessSet().addProcess(this.process);
            this.process.setSegmentedStorageName(null);
            TopView newTV = parentDFD.getMainView().getViewFor(this.process);
            if (newTV != null) {
                newTV.getCellView().setNewBounds(bounds);
            }
            parentDFD.setDirty(true);
            if (this.process.getDiagram() != null) {
                this.process.getDiagram().setDirty(true);
            }
        }
    }

    private void initParentDiagrams() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.process.isComposite() && this.process.getDiagram() != null) {
            map.put(this.process.getDiagram().getObjectID(), this.process.getDiagram().getObjectID());
            List childProcs = this.process.getDiagram().getAllProcesses();
            for (Process proc : childProcs) {
                if (!proc.isComposite()) continue;
                map.put(proc.getDiagram().getObjectID(), proc.getDiagram().getObjectID());
            }
        }
        Iterator it = this.process.getDesign().getProcessModel().getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            if (map.get(dfd.getObjectID()) != null) continue;
            this.cbParentDiagram.addItem(dfd);
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getFootNotePanel());
        this.addToTree(root, this.getModePanel());
        this.addToTree(root, this.getFreqPriorityPanel());
        this.addToTree(root, this.getPeakPeriodsPanel());
        this.addToTree(root, this.getInfoStructuresPanel());
        this.addToTree(root, this.getEventsPanel());
        this.addToTree(root, this.getIncomingFlowsPanel());
        this.addToTree(root, this.getOutgoingFlowsPanel());
        this.addToTree(root, this.getAttributesPanel());
        this.addToTree(root, this.getEntityPanel());
        this.addToTree(root, this.getTaskInParamsMappingPanel());
        this.addToTree(root, this.getSourceTargetMappingPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "PROCESS_PROPERTIES_DIALOG";
    }

    private void initType() {
        if (this.getDesignObject() != null && this.getDesignObject() instanceof Process) {
            this.process = (Process)this.getDesignObject();
            JLabel lbType = new JLabel(LB_TYPE);
            lbType.setPreferredSize(this.getDefaultSize());
            this.cbType = new JComboBox<String>(TYPES);
            this.cbType.setFont(this.cbType.getFont().deriveFont(0));
            this.cbType.setPreferredSize(this.getDefaultSize());
            this.addRowToGeneralPanel(this.createRow(lbType, this.cbType));
            JLabel lbTransformationTask = new JLabel(Messages.getString("ProcessPropertiesDialogEx.UseTransformationTask"));
            lbTransformationTask.setPreferredSize(this.getDefaultSize());
            this.btnTransformationTask = new JButton();
            this.btnTransformationTask.setPreferredSize(this.getDefaultSize());
            this.btnTransformationTask.setHorizontalAlignment(0);
            this.btnTransformationTask.setEnabled(this.isEditable());
            this.btnTransformationTask.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectTransformationTaskDialog editor = new SelectTransformationTaskDialog(ProcessPropertiesDialogEx.this.getAppView(), ProcessPropertiesDialogEx.this.transformationTask, ProcessPropertiesDialogEx.this.process);
                    editor.setVisible(true);
                    if (ProcessPropertiesDialogEx.this.transformationTask != editor.getTransformationTask()) {
                        ProcessPropertiesDialogEx.this.transformationTask = editor.getTransformationTask();
                        ProcessPropertiesDialogEx.this.makeWrapperList();
                        ProcessPropertiesDialogEx.this.inputParamsModel.dataChanged();
                    }
                    String name = "";
                    if (ProcessPropertiesDialogEx.this.transformationTask != null) {
                        name = ProcessPropertiesDialogEx.this.transformationTask.getTransformationPackage().getName() + "." + ProcessPropertiesDialogEx.this.transformationTask.getName();
                    }
                    ProcessPropertiesDialogEx.this.btnTransformationTask.setText(name);
                    if ("".equalsIgnoreCase(name)) {
                        ProcessPropertiesDialogEx.this.btnTransformationTask.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.SetTransformationTask"));
                    } else {
                        ProcessPropertiesDialogEx.this.btnTransformationTask.setToolTipText(name);
                    }
                    if (ProcessPropertiesDialogEx.this.transformationTask != null) {
                        ProcessPropertiesDialogEx.this.cbType.setSelectedIndex(2);
                    } else {
                        ProcessPropertiesDialogEx.this.cbType.setSelectedIndex(0);
                    }
                }
            });
            this.addRowToGeneralPanel(this.createRow(lbTransformationTask, this.btnTransformationTask));
        }
    }

    private void makeWrapperList() {
        ArrayList parWrappers = this.process.getTransformationTask() == this.transformationTask ? this.process.getParamsWrappers() : new ArrayList();
        this.paramsWrappers.clear();
        if (this.transformationTask != null) {
            for (ParameterObject param : this.transformationTask.getInputParameters()) {
                Process.ParamWrapper wrapper = this.findWrapper(parWrappers, param);
                if (wrapper == null) {
                    Process process = this.process;
                    process.getClass();
                    this.paramsWrappers.add(process.new Process.ParamWrapper(param));
                    continue;
                }
                if (wrapper.getMappedObject() != null) {
                    // empty if block
                }
                this.paramsWrappers.add(wrapper);
            }
        }
    }

    private Process.ParamWrapper findWrapper(List wrappers, ParameterObject param) {
        for (Process.ParamWrapper wrapper : wrappers) {
            if (wrapper.getParam() != param) continue;
            return wrapper;
        }
        return null;
    }

    private void updateType() {
        if (this.process.getType() == 0 || this.process.getType() == 1) {
            this.btnTransformationTask.setEnabled(false);
        }
    }

    private JPanel getModePanel() {
        if (this.pnMode == null) {
            this.pnMode = this.createPage(Messages.getString("ProcessPropertiesDialogEx.Mode"));
            JPanel pPanel = new JPanel(new BorderLayout());
            JPanel pnBatch = new JPanel(new BorderLayout(10, 10));
            pnBatch.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.InteractiveBatch")));
            JLabel lbMode = new JLabel(LB_MODE);
            lbMode.setPreferredSize(this.getDefaultSize());
            this.cbMode = new JComboBox<String>(Process.MODES_DISPLAY);
            this.cbMode.setFont(this.cbMode.getFont().deriveFont(0));
            this.cbMode.setPreferredSize(this.getDefaultSize());
            this.cbMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ProcessPropertiesDialogEx.this.cbMode.getSelectedIndex();
                    switch (index) {
                        case 0: {
                            ProcessPropertiesDialogEx.this.SetModeControls(false, false);
                            break;
                        }
                        case 1: {
                            ProcessPropertiesDialogEx.this.SetModeControls(true, false);
                            break;
                        }
                        case 2: {
                            ProcessPropertiesDialogEx.this.SetModeControls(false, true);
                            break;
                        }
                        case 3: {
                            ProcessPropertiesDialogEx.this.SetModeControls(false, false);
                            break;
                        }
                        default: {
                            ProcessPropertiesDialogEx.this.SetModeControls(false, false);
                        }
                    }
                }
            });
            pnBatch.add((Component)this.createRow(lbMode, this.cbMode), "North");
            JPanel panelMinTransact = new JPanel(new BorderLayout(10, 10));
            JPanel pnMinTransact = new JPanel(new BorderLayout(10, 10));
            pnMinTransact.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.MinimumAcceptableThroughput")));
            JPanel panelGr = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbMinTransactions = new JLabel(LB_MIN_TRANSACT);
            lbMinTransactions.setPreferredSize(this.getDefaultSize());
            this.ifMinTransactions = new JIntegerField();
            this.ifMinTransactions.setPreferredSize(this.getDefaultSize());
            panelGr.add(this.createRow(lbMinTransactions, this.ifMinTransactions));
            JLabel lbTimeUnit = new JLabel(LB_TIME_UNIT);
            lbTimeUnit.setPreferredSize(this.getDefaultSize());
            this.cbTimeUnit = new JComboBox<String>(Process.BATCH_TIME_UNITS_DISPLAY);
            this.cbTimeUnit.setFont(this.cbTimeUnit.getFont().deriveFont(0));
            this.cbTimeUnit.setPreferredSize(this.getDefaultSize());
            panelGr.add(this.createRow(lbTimeUnit, this.cbTimeUnit));
            pnMinTransact.add((Component)panelGr, "North");
            JPanel pnLongestTimeMain = new JPanel(new BorderLayout(10, 10));
            JPanel pnLongestTime = new JPanel(new BorderLayout(10, 10));
            pnLongestTime.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.LongestAcceptableResponseTime")));
            JPanel panelGr1 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbResponseTime = new JLabel(LB_LONGEST_TIME);
            lbResponseTime.setPreferredSize(this.getDefaultSize());
            this.ifResponseTime = new JIntegerField();
            this.ifResponseTime.setPreferredSize(this.getDefaultSize());
            panelGr1.add(this.createRow(lbResponseTime, this.ifResponseTime));
            JLabel lbResponseTimeUnit = new JLabel(LB_RESPONSE_TIME_UNIT);
            lbResponseTimeUnit.setPreferredSize(this.getDefaultSize());
            this.cbResponseTimeUnit = new JComboBox<String>(Process.INTERACTIVE_RESPONSE_TIME_UNITS_DISPLAY);
            this.cbResponseTimeUnit.setFont(this.cbResponseTimeUnit.getFont().deriveFont(0));
            this.cbResponseTimeUnit.setPreferredSize(this.getDefaultSize());
            panelGr1.add(this.createRow(lbResponseTimeUnit, this.cbResponseTimeUnit));
            pnLongestTime.add((Component)panelGr1, "North");
            pnLongestTimeMain.add((Component)pnLongestTime, "North");
            panelMinTransact.add((Component)pnMinTransact, "North");
            panelMinTransact.add((Component)pnLongestTimeMain, "Center");
            pnBatch.add(panelMinTransact);
            pPanel.add((Component)pnBatch, "Center");
            this.pnMode.add(pPanel);
        }
        return this.pnMode;
    }

    private void SetModeControls(boolean batchEnable, boolean interactiveEnable) {
        this.ifMinTransactions.setEnabled(batchEnable);
        this.cbTimeUnit.setEnabled(batchEnable);
        this.ifResponseTime.setEnabled(interactiveEnable);
        this.cbResponseTimeUnit.setEnabled(interactiveEnable);
    }

    private void initMode() {
        this.ifMinTransactions.setValue((long)this.process.getBatchMinimumTransactions());
        this.cbTimeUnit.setSelectedItem(this.translate(this.process.getBatchTimeUnit(), Process.BATCH_TIME_UNITS, Process.BATCH_TIME_UNITS_DISPLAY));
        this.ifResponseTime.setValue((long)this.process.getInteractiveLongestResponseTime());
        this.cbResponseTimeUnit.setSelectedItem(this.translate(this.process.getInteractiveResponseTimeUnit(), Process.INTERACTIVE_RESPONSE_TIME_UNITS, Process.INTERACTIVE_RESPONSE_TIME_UNITS_DISPLAY));
        this.cbMode.setSelectedItem(this.translate(this.process.getMode(), Process.MODES, Process.MODES_DISPLAY));
    }

    private JPanel getFreqPriorityPanel() {
        if (this.pnFreqPriority == null) {
            this.pnFreqPriority = this.createPage(Messages.getString("ProcessPropertiesDialogEx.FrequencyPriority"));
            JPanel pnFreqPrior = new JPanel(new BorderLayout(0, 20));
            JPanel panelFreq = new JPanel(new BorderLayout(20, 20));
            JPanel pnExpectedFreq = new JPanel(new GridLayout(0, 1, 10, 10));
            panelFreq.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.ExpectedFrequency")));
            JLabel lbFreqTimes = new JLabel(LB_FREQ_TIMES);
            lbFreqTimes.setPreferredSize(this.getDefaultSize());
            this.ifFreqTimes = new JIntegerField();
            this.ifFreqTimes.setPreferredSize(this.getDefaultSize());
            pnExpectedFreq.add(this.createRow(lbFreqTimes, this.ifFreqTimes));
            JLabel lbFreqTimeUnit = new JLabel(LB_FREQ_TIME_UNIT);
            lbFreqTimeUnit.setPreferredSize(this.getDefaultSize());
            this.cbFreqTimeUnit = new JComboBox<String>(Process.FREQUENCY_TIME_UNITS_DISPLAY);
            this.cbFreqTimeUnit.setFont(this.cbFreqTimeUnit.getFont().deriveFont(0));
            this.cbFreqTimeUnit.setPreferredSize(this.getDefaultSize());
            this.cbFreqTimeUnit.setMaximumRowCount(Process.FREQUENCY_TIME_UNITS_DISPLAY.length);
            pnExpectedFreq.add(this.createRow(lbFreqTimeUnit, this.cbFreqTimeUnit));
            panelFreq.add((Component)pnExpectedFreq, "North");
            JPanel panelPriorityMain = new JPanel(new BorderLayout(10, 10));
            JPanel panelPriority = new JPanel(new BorderLayout(10, 10));
            JPanel pnPriority = new JPanel(new GridLayout(0, 1, 10, 10));
            panelPriority.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.Priority")));
            JLabel lbPriority = new JLabel(LB_PRIORITY);
            lbPriority.setPreferredSize(this.getDefaultSize());
            this.cbPriority = new JComboBox<String>(Process.PRIORITY_DISPLAY);
            this.cbPriority.setFont(this.cbPriority.getFont().deriveFont(0));
            this.cbPriority.setPreferredSize(this.getDefaultSize());
            pnPriority.add(this.createRow(lbPriority, this.cbPriority));
            panelPriority.add((Component)pnPriority, "North");
            panelPriorityMain.add((Component)panelPriority, "North");
            pnFreqPrior.add((Component)panelFreq, "North");
            pnFreqPrior.add((Component)panelPriorityMain, "Center");
            this.pnFreqPriority.add((Component)pnFreqPrior, "Center");
        }
        return this.pnFreqPriority;
    }

    private void initFreqPriority() {
        this.ifFreqTimes.setValue((long)this.process.getFrequencyTimes());
        this.cbFreqTimeUnit.setSelectedItem(this.translate(this.process.getFrequencyTimeUnit(), Process.FREQUENCY_TIME_UNITS, Process.FREQUENCY_TIME_UNITS_DISPLAY));
        this.cbPriority.setSelectedItem(this.translate(this.process.getPriority(), Process.PRIORITY, Process.PRIORITY_DISPLAY));
    }

    private JPanel getPeakPeriodsPanel() {
        if (this.pnPeakPanel == null) {
            this.pnPeakPanel = this.createPage(Messages.getString("ProcessPropertiesDialogEx.PeakPeriods"));
            JPanel pnPeaks = new JPanel(new BorderLayout());
            this.rbNoPeaks = new JRadioButton(RB_NO_PEAKS);
            this.rbNoPeaks.setFont(this.rbNoPeaks.getFont().deriveFont(0));
            this.rbNoPeaks.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < ProcessPropertiesDialogEx.this.CHB_PEAKS.length; ++i) {
                        ProcessPropertiesDialogEx.this.CHB_PEAKS[i].setSelected(false);
                    }
                }
            });
            pnPeaks.add((Component)this.rbNoPeaks, "North");
            this.pnCHB = new JPanel(new GridLayout(0, 3));
            this.pnCol1 = new JPanel(new GridLayout(0, 1));
            this.pnCol2 = new JPanel(new GridLayout(0, 1));
            this.pnCol3 = new JPanel(new GridLayout(0, 1));
            this.chbListener = new CheckboxListener();
            this.pnCHB.add(this.pnCol1);
            this.pnCHB.add(this.pnCol2);
            this.pnCHB.add(this.pnCol3);
            pnPeaks.add(this.pnCHB);
            this.pnPeakPanel.add(pnPeaks);
        }
        return this.pnPeakPanel;
    }

    private void setNoPeaks() {
        boolean selected = true;
        for (int i = 0; i < this.CHB_PEAKS.length; ++i) {
            if (!this.CHB_PEAKS[i].isSelected()) continue;
            selected = false;
            break;
        }
        this.rbNoPeaks.setSelected(selected);
    }

    private void initPeaks() {
        int i;
        for (i = 0; i < 8; ++i) {
            this.CHB_PEAKS[i].setFont(this.CHB_PEAKS[i].getFont().deriveFont(0));
            this.pnCol1.add(this.CHB_PEAKS[i]);
            this.CHB_PEAKS[i].addItemListener(this.chbListener);
            this.CHB_PEAKS[i].setSelected(this.process.getPeakPeriods()[i]);
        }
        for (i = 8; i < 16; ++i) {
            this.CHB_PEAKS[i].setFont(this.CHB_PEAKS[i].getFont().deriveFont(0));
            this.pnCol2.add(this.CHB_PEAKS[i]);
            this.CHB_PEAKS[i].addItemListener(this.chbListener);
            this.CHB_PEAKS[i].setSelected(this.process.getPeakPeriods()[i]);
        }
        for (i = 16; i < 24; ++i) {
            this.CHB_PEAKS[i].setFont(this.CHB_PEAKS[i].getFont().deriveFont(0));
            this.pnCol3.add(this.CHB_PEAKS[i]);
            this.CHB_PEAKS[i].addItemListener(this.chbListener);
            this.CHB_PEAKS[i].setSelected(this.process.getPeakPeriods()[i]);
        }
        this.setNoPeaks();
    }

    private JPanel getInfoStructuresPanel() {
        if (this.pnInfoStructures == null) {
            this.pnInfoStructures = this.createPage(Messages.getString("ProcessPropertiesDialogEx.InformationStructures"));
            this.isList = new ArrayList();
            this.istable = new JTable(new InfoStructuresModel());
            this.istable.setSelectionMode(0);
            this.istable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ProcessPropertiesDialogEx.this.istable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.isList.size() > 0 && row < ProcessPropertiesDialogEx.this.isList.size()) {
                        InfoStructure structure = (InfoStructure)ProcessPropertiesDialogEx.this.isList.get(row);
                        structure.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.istable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProcessPropertiesDialogEx.this.istable.getSelectedRow();
                    if (row != -1 && ProcessPropertiesDialogEx.this.isList.size() > 0 && row < ProcessPropertiesDialogEx.this.isList.size()) {
                        InfoStructure structure = (InfoStructure)ProcessPropertiesDialogEx.this.isList.get(row);
                        structure.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)buttonGeneral, "North");
            jPanel.add(scrollpane);
            this.pnInfoStructures.add(jPanel);
        }
        return this.pnInfoStructures;
    }

    private JPanel getEventsPanel() {
        if (this.pnEvents == null) {
            this.pnEvents = this.createPage(Messages.getString("ProcessPropertiesDialogEx.Events"));
            JPanel pPanel = new JPanel(new BorderLayout());
            this.eList = new ArrayList();
            this.etable = new JTable(new EventModel());
            this.etable.setSelectionMode(0);
            this.etable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ProcessPropertiesDialogEx.this.etable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.eList.size() > 0 && row < ProcessPropertiesDialogEx.this.eList.size()) {
                        Event event = (Event)ProcessPropertiesDialogEx.this.eList.get(row);
                        event.showModal = ((ProcessPropertiesDialogEx)ProcessPropertiesDialogEx.this).process.showModal || ProcessPropertiesDialogEx.this.process.showForFirstTime();
                        EventPropertiesDialogEx dialog = new EventPropertiesDialogEx((Dialog)ProcessPropertiesDialogEx.this, ProcessPropertiesDialogEx.this.getAppView(), event);
                        dialog.initProperties(event);
                        dialog.show();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.etable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProcessPropertiesDialogEx.this.etable.getSelectedRow();
                    if (row != -1 && ProcessPropertiesDialogEx.this.eList.size() > 0 && row < ProcessPropertiesDialogEx.this.eList.size()) {
                        Event event = (Event)ProcessPropertiesDialogEx.this.eList.get(row);
                        event.showModal = ((ProcessPropertiesDialogEx)ProcessPropertiesDialogEx.this).process.showModal || ProcessPropertiesDialogEx.this.process.showForFirstTime();
                        EventPropertiesDialogEx dialog = new EventPropertiesDialogEx((Dialog)ProcessPropertiesDialogEx.this, ProcessPropertiesDialogEx.this.getAppView(), event);
                        dialog.initProperties(event);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NewEventDialog dialog = new NewEventDialog(ProcessPropertiesDialogEx.this.getAppView(), ProcessPropertiesDialogEx.this.process.getDesignPart(), ProcessPropertiesDialogEx.this.eList);
                        dialog.setVisible(true);
                        ProcessPropertiesDialogEx.this.etable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = ProcessPropertiesDialogEx.this.etable.getSelectedRow();
                        if (objectNumber != -1 && ProcessPropertiesDialogEx.this.eList.size() > 0 && objectNumber < ProcessPropertiesDialogEx.this.eList.size()) {
                            ProcessPropertiesDialogEx.this.eList.remove(objectNumber);
                            ProcessPropertiesDialogEx.this.etable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 100));
            JPanel pnProcessEvents = new JPanel(new BorderLayout());
            pnProcessEvents.add((Component)buttonGeneral, "North");
            pnProcessEvents.add(scrollpane);
            this.feList = new ArrayList();
            this.fetable = new JTable(new FlowEventModel());
            this.fetable.setSelectionMode(0);
            this.fetable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ProcessPropertiesDialogEx.this.fetable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.feList.size() > 0 && row < ProcessPropertiesDialogEx.this.feList.size()) {
                        Event event = (Event)ProcessPropertiesDialogEx.this.feList.get(row);
                        event.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane2 = new JScrollPane(this.fetable);
            JPanel buttonGeneral2 = new JPanel(new GridLayout(1, 2));
            buttonGeneral2.setPreferredSize(new Dimension(325, 30));
            JButton btnProperties2 = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties2.setToolTipText(BTN_PROPERTIES);
            btnProperties2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProcessPropertiesDialogEx.this.fetable.getSelectedRow();
                    if (row != -1 && ProcessPropertiesDialogEx.this.feList.size() > 0 && row < ProcessPropertiesDialogEx.this.feList.size()) {
                        Event event = (Event)ProcessPropertiesDialogEx.this.feList.get(row);
                        event.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar2 = new JToolBar(0);
            toolBar2.setFloatable(false);
            toolBar2.add(btnProperties2);
            toolBar2.addSeparator();
            buttonGeneral2.add(toolBar2);
            JPanel pnFlowEvents = new JPanel(new BorderLayout());
            pnFlowEvents.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.FlowEvents")));
            pnFlowEvents.add((Component)buttonGeneral2, "North");
            pnFlowEvents.add(scrollpane2);
            pPanel.add((Component)pnProcessEvents, "North");
            pPanel.add((Component)pnFlowEvents, "Center");
            this.pnEvents.add(pPanel);
        }
        return this.pnEvents;
    }

    private JPanel getIncomingFlowsPanel() {
        if (this.pnIncomingFlows == null) {
            this.pnIncomingFlows = this.createPage(Messages.getString("ProcessPropertiesDialogEx.IncomingFlows"));
            this.ifList = new ArrayList();
            this.iftable = new JTable(new IncomingFlowsModel());
            this.iftable.setSelectionMode(0);
            this.iftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ProcessPropertiesDialogEx.this.iftable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.ifList.size() > 0 && row < ProcessPropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)ProcessPropertiesDialogEx.this.ifList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.iftable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProcessPropertiesDialogEx.this.iftable.getSelectedRow();
                    if (row != -1 && ProcessPropertiesDialogEx.this.ifList.size() > 0 && row < ProcessPropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)ProcessPropertiesDialogEx.this.ifList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 320));
            JPanel jfPanel = new JPanel(new BorderLayout());
            jfPanel.add((Component)buttonGeneral, "North");
            jfPanel.add(scrollpane);
            this.pnIncomingFlows.add(jfPanel);
        }
        return this.pnIncomingFlows;
    }

    private JPanel getOutgoingFlowsPanel() {
        if (this.pnOutgoingFlows == null) {
            this.pnOutgoingFlows = this.createPage(Messages.getString("ProcessPropertiesDialogEx.OutgoingFlows"));
            this.ofList = new ArrayList();
            this.oftable = new JTable(new OutgoingFlowsModel());
            this.oftable.setSelectionMode(0);
            this.oftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ProcessPropertiesDialogEx.this.oftable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.ofList.size() > 0 && row < ProcessPropertiesDialogEx.this.ofList.size()) {
                        Flow flow = (Flow)ProcessPropertiesDialogEx.this.ofList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.oftable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProcessPropertiesDialogEx.this.oftable.getSelectedRow();
                    if (row != -1 && ProcessPropertiesDialogEx.this.ofList.size() > 0 && row < ProcessPropertiesDialogEx.this.ofList.size()) {
                        Flow flow = (Flow)ProcessPropertiesDialogEx.this.ofList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 320));
            JPanel jfPanel = new JPanel(new BorderLayout());
            jfPanel.add((Component)buttonGeneral, "North");
            jfPanel.add(scrollpane);
            this.pnOutgoingFlows.add(jfPanel);
        }
        return this.pnOutgoingFlows;
    }

    private JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("ProcessPropertiesDialogEx.ProcessedAttributes"));
            this.attrList = new ArrayList();
            this.attrTable = new JTable(new AttributesModel());
            this.attrTable.setSelectionMode(0);
            TableColumn column = this.attrTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(200);
            this.attrTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ProcessPropertiesDialogEx.this.attrTable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.attrList.size() > 0 && row < ProcessPropertiesDialogEx.this.attrList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.attrList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.attrTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProcessPropertiesDialogEx.this.attrTable.getSelectedRow();
                    if (row != -1 && ProcessPropertiesDialogEx.this.attrList.size() > 0 && row < ProcessPropertiesDialogEx.this.attrList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.attrList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 320));
            JPanel jpanel = new JPanel(new BorderLayout());
            jpanel.add((Component)buttonGeneral, "North");
            jpanel.add(scrollpane);
            this.pnAttributes.add(jpanel);
        }
        return this.pnAttributes;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("ProcessPropertiesDialogEx.ProcessedEntities"));
            this.entList = new ArrayList();
            this.entTable = new JTable(new EntityModel());
            this.entTable.setSelectionMode(0);
            TableColumn column = this.entTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(200);
            this.entTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ProcessPropertiesDialogEx.this.entTable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.entList.size() > 0 && row < ProcessPropertiesDialogEx.this.entList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.entList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.entTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProcessPropertiesDialogEx.this.entTable.getSelectedRow();
                    if (row != -1 && ProcessPropertiesDialogEx.this.entList.size() > 0 && row < ProcessPropertiesDialogEx.this.entList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.entList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 320));
            JPanel jpanel = new JPanel(new BorderLayout());
            jpanel.add((Component)buttonGeneral, "North");
            jpanel.add(scrollpane);
            this.pnEntity.add(jpanel);
        }
        return this.pnEntity;
    }

    private JPanel getFootNotePanel() {
        if (this.pnFootNote == null) {
            this.pnFootNote = this.createPage(Messages.getString("ProcessPropertiesDialogEx.Footnote"));
            JScrollPane scrollPane = new JScrollPane(this.getEditorPane());
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(scrollPane);
            this.pnFootNote.add(panel);
        }
        return this.pnFootNote;
    }

    protected JEditorPane getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JEditorPane();
            this.editorPane.setContentType("text/plain");
            this.editorPane.setPreferredSize(new Dimension(280, 140));
        }
        return this.editorPane;
    }

    private JPanel getTaskInParamsMappingPanel() {
        if (this.pnTaskInParamsMapping == null) {
            this.pnTaskInParamsMapping = this.createPage(Messages.getString("ProcessPropertiesDialogEx.TaskInputParamsMapping"));
            this.paramsWrappers = new ArrayList();
            this.inputParamsModel = new InputParamsModel();
            this.inParamTable = new JTable(this.inputParamsModel);
            this.inParamTable.setSelectionMode(0);
            JScrollPane scrollpane = new JScrollPane(this.inParamTable);
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add(scrollpane);
            this.pnTaskInParamsMapping.add(aPanel);
        }
        return this.pnTaskInParamsMapping;
    }

    private void setUpSourcesColumn(TableColumn attrColumn) {
        JComboBox comboBox = new JComboBox();
        Iterator it = this.process.getSourceElements().iterator();
        while (it.hasNext()) {
            comboBox.addItem(it.next());
        }
        attrColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(Messages.getString("ProcessPropertiesDialogEx.ClickForComboBox"));
        attrColumn.setCellRenderer(renderer);
    }

    private JPanel getSourceTargetMappingPanel() {
        if (this.pnSourceTargetMapping == null) {
            this.pnSourceTargetMapping = this.createPage(Messages.getString("ProcessPropertiesDialogEx.SourceTargetMapping"));
            this.sList = new ArrayList();
            JPanel pnMain = new JPanel(new BorderLayout());
            this.sTable = new JTable(new SourceElementsModel());
            JScrollPane scrollpane = new JScrollPane(this.sTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ProcessPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (row != -1 && ProcessPropertiesDialogEx.this.sList.size() > 0 && row < ProcessPropertiesDialogEx.this.sList.size()) {
                        DesignObject object = (DesignObject)ProcessPropertiesDialogEx.this.sList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectSourceElementsDialog dialog = new SelectSourceElementsDialog(ProcessPropertiesDialogEx.this.getAppView(), ProcessPropertiesDialogEx.this.process, ProcessPropertiesDialogEx.this.sList);
                        dialog.setVisible(true);
                        ProcessPropertiesDialogEx.this.sTable.updateUI();
                        int row = ProcessPropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (row != -1 && !dialog.cancel && row != -1) {
                            TargetElement target = (TargetElement)ProcessPropertiesDialogEx.this.targets.get(row);
                            target.getSources().clear();
                            for (DesignObject object : ProcessPropertiesDialogEx.this.sList) {
                                target.addSource(object);
                            }
                        }
                    }
                });
                this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = ProcessPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (objectNumber != -1 && ProcessPropertiesDialogEx.this.sList.size() > 0 && objectNumber < ProcessPropertiesDialogEx.this.sList.size()) {
                            ProcessPropertiesDialogEx.this.sList.remove(objectNumber);
                            ProcessPropertiesDialogEx.this.sTable.updateUI();
                            int row = ProcessPropertiesDialogEx.this.tbTarget.getSelectedRow();
                            if (row != -1) {
                                TargetElement target = (TargetElement)ProcessPropertiesDialogEx.this.targets.get(row);
                                target.getSources().clear();
                                for (DesignObject object : ProcessPropertiesDialogEx.this.sList) {
                                    target.addSource(object);
                                }
                            }
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAdd);
                toolBar.add(this.btnRemove);
            }
            JPanel pnTargets = new JPanel(new BorderLayout());
            pnTargets.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.Targets")));
            pnMain.add((Component)pnTargets, "North");
            this.tbTarget = new JTable(new TargetTableModel());
            this.tbTarget.setPreferredScrollableViewportSize(new Dimension(325, 120));
            SelectionListener listener = new SelectionListener(this.tbTarget);
            this.tbTarget.getSelectionModel().addListSelectionListener(listener);
            TableColumn column = null;
            block6: for (int i = 0; i < 3; ++i) {
                column = this.tbTarget.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        column.setPreferredWidth(100);
                        continue block6;
                    }
                    case 1: {
                        column.setPreferredWidth(50);
                        continue block6;
                    }
                    case 2: {
                        column.setPreferredWidth(75);
                        continue block6;
                    }
                    case 3: {
                        column.setPreferredWidth(100);
                    }
                }
            }
            this.cbTransformationTypes = new JComboBox<String>(Transformation.TRANSFORMATION_TYPES_DISPLAY);
            this.tbTarget.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.cbTransformationTypes));
            JScrollPane scrollPane = new JScrollPane(this.tbTarget);
            pnTargets.add(scrollPane);
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ProcessPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && ProcessPropertiesDialogEx.this.sList.size() > 0 && row < ProcessPropertiesDialogEx.this.sList.size()) {
                        DesignObject object = (DesignObject)ProcessPropertiesDialogEx.this.sList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            this.enableButtons(false);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 130));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ProcessPropertiesDialogEx.Sources")));
            jPanel.add((Component)buttonGeneral, "North");
            jPanel.add(scrollpane);
            pnMain.add(jPanel);
            this.pnSourceTargetMapping.add(pnMain);
        }
        return this.pnSourceTargetMapping;
    }

    private void enableButtons(boolean enable) {
        if (this.isEditable()) {
            this.btnProperties.setEnabled(enable);
            this.btnAdd.setEnabled(enable);
            this.btnRemove.setEnabled(enable);
        }
    }

    private void initSourceTargetMapping() {
        this.process.updateTargetElements();
        List targetElements = this.process.getTargetElements();
        for (TargetElement target : targetElements) {
            TargetElement tempElm = new TargetElement(target);
            this.targets.add(tempElm);
        }
        for (TargetElement target : this.targets) {
            ((DefaultTableModel)this.tbTarget.getModel()).addRow(new Object[]{target.getTarget().getLongName(), target.getTarget().getObjectTypeName(), this.translate(target.getTransformationType(), Transformation.TRANSFORMATION_TYPES, Transformation.TRANSFORMATION_TYPES_DISPLAY), target.getDescription()});
        }
    }

    private void updateSourceElements(TargetElement target) {
        this.sList.clear();
        Iterator it = target.getSources().iterator();
        while (it.hasNext()) {
            this.sList.add(it.next());
        }
        this.sTable.updateUI();
    }

    private void setSourceTargetInfo() {
        for (int i = 0; i < this.tbTarget.getRowCount(); ++i) {
            String transformationType = (String)this.tbTarget.getModel().getValueAt(i, 2);
            String description = (String)this.tbTarget.getModel().getValueAt(i, 3);
            TargetElement target = (TargetElement)this.targets.get(i);
            target.setTransformationType(this.translate(transformationType, Transformation.TRANSFORMATION_TYPES_DISPLAY, Transformation.TRANSFORMATION_TYPES));
            target.setDescription(description);
        }
        this.process.getTargetElements().clear();
        this.process.getTargetElements().addAll(this.targets);
    }

    @Override
    protected int getMinimumHeight() {
        return 460;
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 180;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    class TargetTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("ProcessPropertiesDialogEx.TargetElement"), Messages.getString("ProcessPropertiesDialogEx.Type"), Messages.getString("ProcessPropertiesDialogEx.Transformation"), Messages.getString("ProcessPropertiesDialogEx.Description")};

        TargetTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!ProcessPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return col > 1;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = this.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = ((ListSelectionModel)e.getSource()).getAnchorSelectionIndex();
            if (row != -1) {
                TargetElement target = (TargetElement)ProcessPropertiesDialogEx.this.targets.get(row);
                ProcessPropertiesDialogEx.this.updateSourceElements(target);
                ProcessPropertiesDialogEx.this.enableButtons(true);
            } else {
                ProcessPropertiesDialogEx.this.enableButtons(false);
            }
        }
    }

    private class SourceElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.SourceElements");
            }
            if (column == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)ProcessPropertiesDialogEx.this.sList.get(row);
            if (col == 0) {
                return object.getLongName();
            }
            if (col == 1) {
                return object.getObjectTypeName();
            }
            return new Integer(row * col);
        }
    }

    private class EntityModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.entList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.Entity");
            }
            if (column == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Create");
            }
            if (column == 2) {
                return Messages.getString("ProcessPropertiesDialogEx.Read");
            }
            if (column == 3) {
                return Messages.getString("ProcessPropertiesDialogEx.Update");
            }
            if (column == 4) {
                return Messages.getString("ProcessPropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Process.ProcessedObject po = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.entList.get(row);
            if (col == 0) {
                return po.getObject().getName();
            }
            if (col == 1) {
                return po.isOpCreate();
            }
            if (col == 2) {
                return po.isOpRead();
            }
            if (col == 3) {
                return po.isOpUpdate();
            }
            if (col == 4) {
                return po.isOpDelete();
            }
            return new Integer(row * col);
        }
    }

    private class AttributesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.attrList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.Attribute");
            }
            if (column == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Create");
            }
            if (column == 2) {
                return Messages.getString("ProcessPropertiesDialogEx.Read");
            }
            if (column == 3) {
                return Messages.getString("ProcessPropertiesDialogEx.Update");
            }
            if (column == 4) {
                return Messages.getString("ProcessPropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Process.ProcessedObject po = (Process.ProcessedObject)ProcessPropertiesDialogEx.this.attrList.get(row);
            if (col == 0) {
                return po.getObject().getName();
            }
            if (col == 1) {
                return po.isOpCreate();
            }
            if (col == 2) {
                return po.isOpRead();
            }
            if (col == 3) {
                return po.isOpUpdate();
            }
            if (col == 4) {
                return po.isOpDelete();
            }
            return new Integer(row * col);
        }
    }

    private class OutgoingFlowsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.ofList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.OutgoingFlows");
            }
            if (column == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Flow flow = (Flow)ProcessPropertiesDialogEx.this.ofList.get(row);
            if (col == 0) {
                return flow.getName();
            }
            if (col == 1) {
                return flow.getSynonym();
            }
            return new Integer(row * col);
        }
    }

    private class IncomingFlowsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.ifList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.IncomingFlows");
            }
            if (column == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Flow flow = (Flow)ProcessPropertiesDialogEx.this.ifList.get(row);
            if (col == 0) {
                return flow.getName();
            }
            if (col == 1) {
                return flow.getSynonym();
            }
            return new Integer(row * col);
        }
    }

    private class FlowEventModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.feList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.Event");
            }
            if (column == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            if (column == 2) {
                return Messages.getString("ProcessPropertiesDialogEx.Flow");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Event event = (Event)ProcessPropertiesDialogEx.this.feList.get(row);
            if (col == 0) {
                return event.getName();
            }
            if (col == 1) {
                return event.getSynonym();
            }
            if (col == 2) {
                return event.getFlow().getName();
            }
            return new Integer(row * col);
        }
    }

    private class EventModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.eList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.Events");
            }
            if (column == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            if (column == 2) {
                return Messages.getString("ProcessPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Event event = (Event)ProcessPropertiesDialogEx.this.eList.get(row);
            if (col == 0) {
                return event.getName();
            }
            if (col == 1) {
                return event.getSynonym();
            }
            if (col == 2) {
                return event.getEventTypeName();
            }
            return new Integer(row * col);
        }
    }

    private class InfoStructuresModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.isList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.InformationStructures");
            }
            if (column == 1) {
                return Messages.getString("ProcessPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            InfoStructure structure = (InfoStructure)ProcessPropertiesDialogEx.this.isList.get(row);
            if (col == 0) {
                return structure.getName();
            }
            if (col == 1) {
                return structure.getSynonym();
            }
            return new Integer(row * col);
        }
    }

    private class CheckboxListener
    implements ItemListener {
        private CheckboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ProcessPropertiesDialogEx.this.setNoPeaks();
        }
    }

    private class InputParamsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ProcessPropertiesDialogEx.this.paramsWrappers.size();
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ProcessPropertiesDialogEx.TaskInputParameters");
            }
            return Messages.getString("ProcessPropertiesDialogEx.Sources");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!ProcessPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Process.ParamWrapper wrapper = (Process.ParamWrapper)ProcessPropertiesDialogEx.this.paramsWrappers.get(row);
            if (col == 0) {
                return wrapper.getParam().getName();
            }
            return ((Process.ParamWrapper)ProcessPropertiesDialogEx.this.paramsWrappers.get(row)).getMappedObject();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                Process.ParamWrapper wrap = (Process.ParamWrapper)ProcessPropertiesDialogEx.this.paramsWrappers.get(row);
                wrap.setMappedObject((DesignObject)value);
                this.fireTableCellUpdated(row, col);
            }
        }
    }
}

