/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.editor.process.SelectProcessesDialog;

public class RolePropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private JTextField tfDescription;
    private Role role;
    private List pList;
    private JPanel pnProcess;
    private JTable pTable;
    private List eList;
    private JTable eTable;
    private JPanel pnEntity;

    public RolePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RolePropertiesDialogEx.RoleProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Role) {
            this.role = (Role)object;
            this.initDefaults(false);
            this.pList.addAll(this.role.getProcesses());
            this.updateEntityList();
            this.tfSynonym.setText(this.role.getSynonym());
            this.tfDescription.setText(this.role.getDescription());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator it = this.role.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.role.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.role.setName(this.tfName.getText());
        this.role.setNotes(this.taNotes.getText());
        this.role.setComment(this.taComments.getText());
        this.role.setSynonym(this.tfSynonym.getText());
        this.role.setDescription(this.tfDescription.getText());
        this.role.setAllProcesses(this.pList);
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        RolePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.role.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.role.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getProcessPanel());
        this.addToTree(root, this.getEntityPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "ROLE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbDescription = new JLabel(LB_DESCRIPTION);
        lbDescription.setPreferredSize(this.getDefaultSize());
        this.tfDescription = new JTextField();
        this.tfDescription.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDescription, this.tfDescription));
    }

    private JPanel getProcessPanel() {
        if (this.pnProcess == null) {
            this.pnProcess = this.createPage(Messages.getString("RolePropertiesDialogEx.Processes"));
            this.pList = new ArrayList();
            this.pTable = new JTable(new ProcessTableModel());
            this.pTable.setSelectionMode(0);
            this.pTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = RolePropertiesDialogEx.this.pTable.getSelectedRow()) != -1 && RolePropertiesDialogEx.this.pList.size() > 0 && row < RolePropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)RolePropertiesDialogEx.this.pList.get(row);
                        process.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.pTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = RolePropertiesDialogEx.this.pTable.getSelectedRow();
                    if (row != -1 && RolePropertiesDialogEx.this.pList.size() > 0 && row < RolePropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)RolePropertiesDialogEx.this.pList.get(row);
                        process.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectProcessesDialog dialog = new SelectProcessesDialog(RolePropertiesDialogEx.this.getAppView(), RolePropertiesDialogEx.this.pList);
                        dialog.show();
                        RolePropertiesDialogEx.this.pTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = RolePropertiesDialogEx.this.pTable.getSelectedRow();
                        if (objectNumber != -1 && RolePropertiesDialogEx.this.pList.size() > 0 && objectNumber < RolePropertiesDialogEx.this.pList.size()) {
                            RolePropertiesDialogEx.this.pList.remove(objectNumber);
                            RolePropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 175));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnProcess.add(pPanel);
        }
        return this.pnProcess;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("RolePropertiesDialogEx.Entities"));
            this.eList = new ArrayList();
            this.eTable = new JTable(new EntityModel());
            this.eTable.setSelectionMode(0);
            TableColumn column = this.eTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(200);
            this.eTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = RolePropertiesDialogEx.this.eTable.getSelectedRow()) != -1 && RolePropertiesDialogEx.this.eList.size() > 0 && row < RolePropertiesDialogEx.this.eList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)RolePropertiesDialogEx.this.eList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.eTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("RolePropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = RolePropertiesDialogEx.this.eTable.getSelectedRow();
                    if (row != -1 && RolePropertiesDialogEx.this.eList.size() > 0 && row < RolePropertiesDialogEx.this.eList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)RolePropertiesDialogEx.this.eList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 175));
            JPanel ePanel = new JPanel(new BorderLayout());
            ePanel.add((Component)buttonGeneral, "North");
            ePanel.add(scrollpane);
            this.pnEntity.add(ePanel);
        }
        return this.pnEntity;
    }

    private void updateEntityList() {
        this.eList.clear();
        for (Process process : this.pList) {
            process.addProcessedEntitiesToList(this.eList, true);
        }
        this.eTable.updateUI();
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class EntityModel
    extends AbstractTableModel {
        private EntityModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return RolePropertiesDialogEx.this.eList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("RolePropertiesDialogEx.Entity");
            }
            if (column == 1) {
                return Messages.getString("RolePropertiesDialogEx.Create");
            }
            if (column == 2) {
                return Messages.getString("RolePropertiesDialogEx.Read");
            }
            if (column == 3) {
                return Messages.getString("RolePropertiesDialogEx.Update");
            }
            if (column == 4) {
                return Messages.getString("RolePropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Process.ProcessedObject po = (Process.ProcessedObject)RolePropertiesDialogEx.this.eList.get(row);
            if (col == 0) {
                return po.getObject().getName();
            }
            if (col == 1) {
                return po.isOpCreate();
            }
            if (col == 2) {
                return po.isOpRead();
            }
            if (col == 3) {
                return po.isOpUpdate();
            }
            if (col == 4) {
                return po.isOpDelete();
            }
            return new Integer(row * col);
        }
    }

    private class ProcessTableModel
    extends AbstractTableModel {
        private ProcessTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return RolePropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("RolePropertiesDialogEx.Processes");
            }
            if (column == 1) {
                return Messages.getString("RolePropertiesDialogEx.Synonym");
            }
            if (column == 2) {
                return Messages.getString("RolePropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Process process = (Process)RolePropertiesDialogEx.this.pList.get(row);
            if (col == 0) {
                DataFlowDesign topdfd = ((DataFlowDesign)process.getDesignPart()).getTopLevelDataFlowDesign();
                if (topdfd == null) {
                    return process.getProcessNumber() + " - " + process.getName();
                }
                return process.getProcessNumber() + " - " + process.getName() + "  @" + topdfd.getName();
            }
            if (col == 1) {
                return process.getSynonym();
            }
            if (col == 2) {
                return process.getProcessTypeName();
            }
            return new Integer(row * col);
        }
    }
}

