/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectProcessesDialog
extends JDialog
implements AbstractEditorConstants {
    private ApplicationView view;
    private List pList;
    private JList selectedProcessesList;
    private JList allProcessesList;
    private DefaultListModel allProcessesModel;
    private DefaultListModel selectedProcessesModel;
    private JButton btnAddProcesses;
    private JButton btnRemoveProcesseses;
    protected JPanel generalPanel;

    public SelectProcessesDialog(ApplicationView view, List pList) {
        super(view.getFrame());
        this.setModal(true);
        this.view = view;
        this.pList = pList;
        this.setTitle(Messages.getString("SelectProcessesDialog.SelectProcessesConnectedToInfoStore"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectProcessesDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allProcessesModel = new DefaultListModel();
        this.selectedProcessesModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setPreferredSize(bnCancel.getPreferredSize());
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init() {
        this.initAllProcessesList();
        this.initProcessesButtons();
        this.initSelectedProcessesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = this.pList.iterator();
        while (it.hasNext()) {
            this.selectedProcessesModel.addElement(it.next());
        }
        it = this.view.getCurrentDesign().getProcessModel().getDataFlowDesign().getProcessSet().iterator();
        while (it.hasNext()) {
            Process next = (Process)it.next();
            if (this.pList.contains(next) || next.isComposite() || !next.isConnectedToStore()) continue;
            this.allProcessesModel.addElement(next);
        }
    }

    private void initAllProcessesList() {
        JPanel attributesList = new JPanel();
        this.allProcessesList = new JList(this.allProcessesModel);
        ListSelectionModel listSelectionModel = this.allProcessesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllProcessListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allProcessesList);
        sp.setPreferredSize(new Dimension(220, 300));
        attributesList.add(sp);
        this.generalPanel.add((Component)attributesList, "West");
    }

    private void initSelectedProcessesList() {
        JPanel selectedList = new JPanel();
        this.selectedProcessesList = new JList(this.selectedProcessesModel);
        ListSelectionModel listSelectionModel = this.selectedProcessesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedProcessListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedProcessesList);
        sp.setPreferredSize(new Dimension(220, 300));
        selectedList.add(sp);
        this.generalPanel.add((Component)selectedList, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initProcessesButtons() {
        JPanel buttonsPanel = new JPanel();
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddProcesses = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddProcesses.addActionListener(new AddProcessesActionListener());
        this.btnAddProcesses.setEnabled(false);
        this.btnAddProcesses.setToolTipText(Messages.getString("SelectProcessesDialog.Add"));
        this.btnRemoveProcesseses = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveProcesseses.setEnabled(false);
        this.btnRemoveProcesseses.addActionListener(new RemoveProcessesActionListener());
        this.btnRemoveProcesseses.setToolTipText(Messages.getString("SelectProcessesDialog.Remove"));
        toolBar.add(this.btnAddProcesses);
        toolBar.add(this.btnRemoveProcesseses);
        buttonsPanel.add(toolBar);
        buttonsPanel.setPreferredSize(new Dimension(32, 300));
        this.generalPanel.add((Component)buttonsPanel, "Center");
    }

    private class SelectedProcessListSelectionHandler
    implements ListSelectionListener {
        private SelectedProcessListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectProcessesDialog.this.selectedProcessesList.getSelectedIndex() == -1) {
                    SelectProcessesDialog.this.btnRemoveProcesseses.setEnabled(false);
                } else {
                    SelectProcessesDialog.this.btnRemoveProcesseses.setEnabled(true);
                }
            }
        }
    }

    private class AllProcessListSelectionHandler
    implements ListSelectionListener {
        private AllProcessListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectProcessesDialog.this.allProcessesList.getSelectedIndex() == -1) {
                    SelectProcessesDialog.this.btnAddProcesses.setEnabled(false);
                } else {
                    SelectProcessesDialog.this.btnAddProcesses.setEnabled(true);
                }
            }
        }
    }

    private class RemoveProcessesActionListener
    implements ActionListener {
        private RemoveProcessesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectProcessesDialog.this.selectedProcessesModel.isEmpty()) {
                Object[] selectedObjects = SelectProcessesDialog.this.selectedProcessesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectProcessesDialog.this.allProcessesModel.contains(ob)) continue;
                    SelectProcessesDialog.this.allProcessesModel.addElement(ob);
                    SelectProcessesDialog.this.selectedProcessesModel.removeElement(ob);
                }
            }
        }
    }

    private class AddProcessesActionListener
    implements ActionListener {
        private AddProcessesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectProcessesDialog.this.allProcessesModel.isEmpty()) {
                Object[] selectedObjects = SelectProcessesDialog.this.allProcessesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectProcessesDialog.this.selectedProcessesModel.contains(ob)) continue;
                    SelectProcessesDialog.this.selectedProcessesModel.addElement(ob);
                    SelectProcessesDialog.this.allProcessesModel.removeElement(ob);
                }
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectProcessesDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectProcessesDialog.this.pList.clear();
            for (int i = 0; i < SelectProcessesDialog.this.selectedProcessesModel.size(); ++i) {
                Process process = (Process)SelectProcessesDialog.this.selectedProcessesModel.getElementAt(i);
                SelectProcessesDialog.this.pList.add(process);
            }
            SelectProcessesDialog.this.dispose();
        }
    }
}

