/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectTransformationTaskDialog
extends JDialog
implements AbstractEditorConstants {
    private JList allProcessesList;
    private DefaultListModel allProcessesModel;
    protected JPanel generalPanel;
    TransformationTask transformationTask;
    Process process;

    public SelectTransformationTaskDialog(ApplicationView view, TransformationTask task, Process process) {
        super(view.getFrame());
        this.setModal(true);
        this.transformationTask = task;
        this.process = process;
        this.setTitle(Messages.getString("SelectTransformationTaskDialog.SelectTransformationTask"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectTransformationTaskDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allProcessesModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setPreferredSize(bnCancel.getPreferredSize());
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init() {
        this.initAllProcessesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = ((DataFlowDesign)this.process.getDesignPart()).getProcessModel().getAllTransformationTasks().iterator();
        while (it.hasNext()) {
            this.allProcessesModel.addElement(it.next());
        }
    }

    private void initAllProcessesList() {
        JPanel attributesList = new JPanel();
        this.allProcessesList = new JList(this.allProcessesModel);
        this.allProcessesList.setCellRenderer(new LongNameCellRenderer());
        JScrollPane sp = new JScrollPane(this.allProcessesList);
        sp.setPreferredSize(new Dimension(420, 300));
        attributesList.add(sp);
        this.generalPanel.add((Component)attributesList, "West");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    public TransformationTask getTransformationTask() {
        return this.transformationTask;
    }

    class LongNameCellRenderer
    extends JLabel
    implements ListCellRenderer {
        LongNameCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            TransformationTask task = (TransformationTask)value;
            String s = task.getTransformationPackage().getName() + "." + task.getName();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectTransformationTaskDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SelectTransformationTaskDialog.this.allProcessesList.getSelectedValue() != null) {
                SelectTransformationTaskDialog.this.transformationTask = (TransformationTask)SelectTransformationTaskDialog.this.allProcessesList.getSelectedValue();
            }
            SelectTransformationTaskDialog.this.dispose();
        }
    }
}

