/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.editor.process.SelectSourceElementsDialog;

public class TransformationPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private JTextField tfFilterCondition;
    private JTextField tfJoinCondition;
    private JCheckBox chbPrimary;
    private Transformation process;
    private JPanel pnInfoStructures;
    private ArrayList isList;
    private JTable istable;
    private JPanel pnAttributes;
    private ArrayList attrList;
    private JTable attrTable;
    private JPanel pnEntity;
    private ArrayList entList;
    private JTable entTable;
    private JPanel pnSourceTargetMapping;
    private JTable tbTarget;
    private JTable sTable;
    private JButton btnProperties;
    private List sList;
    private JButton btnAdd;
    private List targets = new ArrayList();
    private JButton btnRemove;
    private JComboBox cbTransformationTypes;

    public TransformationPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbFilterCondition = new JLabel(Messages.getString("TransformationPropertiesDialogEx.SourcesFilterCondition"));
        lbFilterCondition.setPreferredSize(this.getDefaultSize());
        this.tfFilterCondition = new JTextField();
        this.tfFilterCondition.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbFilterCondition, this.tfFilterCondition));
        JLabel lbJoinCondition = new JLabel(Messages.getString("TransformationPropertiesDialogEx.SourcesJoinCondition"));
        lbJoinCondition.setPreferredSize(this.getDefaultSize());
        this.tfJoinCondition = new JTextField();
        this.tfJoinCondition.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbJoinCondition, this.tfJoinCondition));
        JLabel lbPrimary = new JLabel(Messages.getString("TransformationPropertiesDialogEx.Primary"));
        lbPrimary.setPreferredSize(this.getDefaultSize());
        this.chbPrimary = new JCheckBox();
        this.chbPrimary.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbPrimary, this.chbPrimary));
    }

    @Override
    public String getCaption() {
        return Messages.getString("TransformationPropertiesDialogEx.TransformationProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Transformation) {
            this.process = (Transformation)object;
            this.initDefaults(false);
            this.tfSynonym.setText(this.process.getSynonym());
            this.tfFilterCondition.setText(this.process.getFilterCondition());
            this.tfJoinCondition.setText(this.process.getJoinCondition());
            this.chbPrimary.setSelected(this.process.isPrimary());
            this.isList.addAll(this.process.getInfoStructures());
            this.attrList.addAll(this.process.getProcessedAttributes(false));
            this.entList.addAll(this.process.getProcessedEntities(false));
            this.initSourceTargetMapping();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator it = this.process.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.process.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.process.setName(this.tfName.getText());
        this.process.setNotes(this.taNotes.getText());
        this.process.setComment(this.taComments.getText());
        this.process.setSynonym(this.tfSynonym.getText());
        this.process.setFilterCondition(this.tfFilterCondition.getText());
        this.process.setJoinCondition(this.tfJoinCondition.getText());
        this.process.setPrimary(this.chbPrimary.isSelected());
        this.setSourceTargetInfo();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        TransformationPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.process.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.process.setProperty(dp.getName(), dp.getValue());
        }
    }

    private void setSourceTargetInfo() {
        for (int i = 0; i < this.tbTarget.getRowCount(); ++i) {
            String transformationType = (String)this.tbTarget.getModel().getValueAt(i, 2);
            String description = (String)this.tbTarget.getModel().getValueAt(i, 3);
            TargetElement target = (TargetElement)this.targets.get(i);
            target.setTransformationType(this.translate(transformationType, Transformation.TRANSFORMATION_TYPES_DISPLAY, Transformation.TRANSFORMATION_TYPES));
            target.setDescription(description);
        }
        this.process.getTargetElements().clear();
        this.process.getTargetElements().addAll(this.targets);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getInfoStructuresPanel());
        this.addToTree(root, this.getAttributesPanel());
        this.addToTree(root, this.getEntityPanel());
        this.addToTree(root, this.getSourceTargetMappingPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "TRANSFORMATION_PROPERTIES_DIALOG";
    }

    private JPanel getInfoStructuresPanel() {
        if (this.pnInfoStructures == null) {
            this.pnInfoStructures = this.createPage(Messages.getString("TransformationPropertiesDialogEx.InformationStructures"));
            this.isList = new ArrayList();
            this.istable = new JTable(new InfoStructuresModel());
            this.istable.setSelectionMode(0);
            this.istable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = TransformationPropertiesDialogEx.this.istable.getSelectedRow()) != -1 && TransformationPropertiesDialogEx.this.isList.size() > 0 && row < TransformationPropertiesDialogEx.this.isList.size()) {
                        InfoStructure structure = (InfoStructure)TransformationPropertiesDialogEx.this.isList.get(row);
                        structure.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.istable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("TransformationPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = TransformationPropertiesDialogEx.this.istable.getSelectedRow();
                    if (row != -1 && TransformationPropertiesDialogEx.this.isList.size() > 0 && row < TransformationPropertiesDialogEx.this.isList.size()) {
                        InfoStructure structure = (InfoStructure)TransformationPropertiesDialogEx.this.isList.get(row);
                        structure.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)buttonGeneral, "North");
            jPanel.add(scrollpane);
            this.pnInfoStructures.add(jPanel);
        }
        return this.pnInfoStructures;
    }

    private JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("TransformationPropertiesDialogEx.ProcessedAttributes"));
            this.attrList = new ArrayList();
            this.attrTable = new JTable(new AttributesModel());
            this.attrTable.setSelectionMode(0);
            TableColumn column = this.attrTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(200);
            this.attrTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = TransformationPropertiesDialogEx.this.attrTable.getSelectedRow()) != -1 && TransformationPropertiesDialogEx.this.attrList.size() > 0 && row < TransformationPropertiesDialogEx.this.attrList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)TransformationPropertiesDialogEx.this.attrList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.attrTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("TransformationPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = TransformationPropertiesDialogEx.this.attrTable.getSelectedRow();
                    if (row != -1 && TransformationPropertiesDialogEx.this.attrList.size() > 0 && row < TransformationPropertiesDialogEx.this.attrList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)TransformationPropertiesDialogEx.this.attrList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 320));
            JPanel jpanel = new JPanel(new BorderLayout());
            jpanel.add((Component)buttonGeneral, "North");
            jpanel.add(scrollpane);
            this.pnAttributes.add(jpanel);
        }
        return this.pnAttributes;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("TransformationPropertiesDialogEx.ProcessedEntities"));
            this.entList = new ArrayList();
            this.entTable = new JTable(new EntityModel());
            this.entTable.setSelectionMode(0);
            TableColumn column = this.entTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(200);
            this.entTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = TransformationPropertiesDialogEx.this.entTable.getSelectedRow()) != -1 && TransformationPropertiesDialogEx.this.entList.size() > 0 && row < TransformationPropertiesDialogEx.this.entList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)TransformationPropertiesDialogEx.this.entList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.entTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("TransformationPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = TransformationPropertiesDialogEx.this.entTable.getSelectedRow();
                    if (row != -1 && TransformationPropertiesDialogEx.this.entList.size() > 0 && row < TransformationPropertiesDialogEx.this.entList.size()) {
                        Process.ProcessedObject po = (Process.ProcessedObject)TransformationPropertiesDialogEx.this.entList.get(row);
                        po.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 320));
            JPanel jpanel = new JPanel(new BorderLayout());
            jpanel.add((Component)buttonGeneral, "North");
            jpanel.add(scrollpane);
            this.pnEntity.add(jpanel);
        }
        return this.pnEntity;
    }

    private JPanel getSourceTargetMappingPanel() {
        if (this.pnSourceTargetMapping == null) {
            this.pnSourceTargetMapping = this.createPage(Messages.getString("TransformationPropertiesDialogEx.SourceTargetMapping"));
            this.sList = new ArrayList();
            JPanel pnMain = new JPanel(new BorderLayout());
            this.sTable = new JTable(new SourceElementsModel());
            JScrollPane scrollpane = new JScrollPane(this.sTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = TransformationPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (row != -1 && TransformationPropertiesDialogEx.this.sList.size() > 0 && row < TransformationPropertiesDialogEx.this.sList.size()) {
                        DesignObject object = (DesignObject)TransformationPropertiesDialogEx.this.sList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectSourceElementsDialog dialog = new SelectSourceElementsDialog(TransformationPropertiesDialogEx.this.getAppView(), TransformationPropertiesDialogEx.this.process, TransformationPropertiesDialogEx.this.sList);
                        dialog.show();
                        TransformationPropertiesDialogEx.this.sTable.updateUI();
                        int row = TransformationPropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (row != -1 && !dialog.cancel && row != -1) {
                            TargetElement target = (TargetElement)TransformationPropertiesDialogEx.this.targets.get(row);
                            target.getSources().clear();
                            for (DesignObject object : TransformationPropertiesDialogEx.this.sList) {
                                target.addSource(object);
                            }
                        }
                    }
                });
                this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = TransformationPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (objectNumber != -1 && TransformationPropertiesDialogEx.this.sList.size() > 0 && objectNumber < TransformationPropertiesDialogEx.this.sList.size()) {
                            TransformationPropertiesDialogEx.this.sList.remove(objectNumber);
                            TransformationPropertiesDialogEx.this.sTable.updateUI();
                            int row = TransformationPropertiesDialogEx.this.tbTarget.getSelectedRow();
                            if (row != -1) {
                                TargetElement target = (TargetElement)TransformationPropertiesDialogEx.this.targets.get(row);
                                target.getSources().clear();
                                for (DesignObject object : TransformationPropertiesDialogEx.this.sList) {
                                    target.addSource(object);
                                }
                            }
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAdd);
                toolBar.add(this.btnRemove);
            }
            JPanel pnTargets = new JPanel(new BorderLayout());
            pnTargets.setBorder(BorderFactory.createTitledBorder(Messages.getString("TransformationPropertiesDialogEx.Targets")));
            pnMain.add((Component)pnTargets, "North");
            this.tbTarget = new JTable(new TargetTableModel());
            this.tbTarget.setPreferredScrollableViewportSize(new Dimension(325, 120));
            SelectionListener listener = new SelectionListener(this.tbTarget);
            this.tbTarget.getSelectionModel().addListSelectionListener(listener);
            TableColumn column = null;
            block6: for (int i = 0; i < 3; ++i) {
                column = this.tbTarget.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        column.setPreferredWidth(100);
                        continue block6;
                    }
                    case 1: {
                        column.setPreferredWidth(50);
                        continue block6;
                    }
                    case 2: {
                        column.setPreferredWidth(75);
                        continue block6;
                    }
                    case 3: {
                        column.setPreferredWidth(100);
                    }
                }
            }
            this.cbTransformationTypes = new JComboBox<String>(Transformation.TRANSFORMATION_TYPES_DISPLAY);
            this.tbTarget.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.cbTransformationTypes));
            JScrollPane scrollPane = new JScrollPane(this.tbTarget);
            pnTargets.add(scrollPane);
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = TransformationPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && TransformationPropertiesDialogEx.this.sList.size() > 0 && row < TransformationPropertiesDialogEx.this.sList.size()) {
                        DesignObject object = (DesignObject)TransformationPropertiesDialogEx.this.sList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            this.enableButtons(false);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 130));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TransformationPropertiesDialogEx.Sources")));
            jPanel.add((Component)buttonGeneral, "North");
            jPanel.add(scrollpane);
            pnMain.add(jPanel);
            this.pnSourceTargetMapping.add(pnMain);
        }
        return this.pnSourceTargetMapping;
    }

    private void updateSourceElements(TargetElement target) {
        this.sList.clear();
        Iterator it = target.getSources().iterator();
        while (it.hasNext()) {
            this.sList.add(it.next());
        }
        this.sTable.updateUI();
    }

    private void enableButtons(boolean enable) {
        if (this.isEditable()) {
            this.btnProperties.setEnabled(enable);
            this.btnAdd.setEnabled(enable);
            this.btnRemove.setEnabled(enable);
        }
    }

    private void initSourceTargetMapping() {
        this.process.updateTargetElements();
        List targetElements = this.process.getTargetElements();
        for (TargetElement target : targetElements) {
            TargetElement tempElm = new TargetElement(target);
            this.targets.add(tempElm);
        }
        for (TargetElement target : this.targets) {
            ((DefaultTableModel)this.tbTarget.getModel()).addRow(new Object[]{target.getTarget().getLongName(), target.getTarget().getObjectTypeName(), this.translate(target.getTransformationType(), Transformation.TRANSFORMATION_TYPES, Transformation.TRANSFORMATION_TYPES_DISPLAY), target.getDescription()});
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = ((ListSelectionModel)e.getSource()).getAnchorSelectionIndex();
            if (row != -1) {
                TargetElement target = (TargetElement)TransformationPropertiesDialogEx.this.targets.get(row);
                TransformationPropertiesDialogEx.this.updateSourceElements(target);
                TransformationPropertiesDialogEx.this.enableButtons(true);
            } else {
                TransformationPropertiesDialogEx.this.enableButtons(false);
            }
        }
    }

    private class SourceElementsModel
    extends AbstractTableModel {
        private SourceElementsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TransformationPropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TransformationPropertiesDialogEx.SourceElements");
            }
            if (column == 1) {
                return Messages.getString("TransformationPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)TransformationPropertiesDialogEx.this.sList.get(row);
            if (col == 0) {
                return object.getLongName();
            }
            if (col == 1) {
                return object.getObjectTypeName();
            }
            return new Integer(row * col);
        }
    }

    class TargetTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("TransformationPropertiesDialogEx.TargetElement"), Messages.getString("TransformationPropertiesDialogEx.Type"), Messages.getString("TransformationPropertiesDialogEx.Transformation"), Messages.getString("TransformationPropertiesDialogEx.Description")};

        TargetTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!TransformationPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return col > 1;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = this.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }
    }

    private class EntityModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return TransformationPropertiesDialogEx.this.entList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TransformationPropertiesDialogEx.Entity");
            }
            if (column == 1) {
                return Messages.getString("TransformationPropertiesDialogEx.Create");
            }
            if (column == 2) {
                return Messages.getString("TransformationPropertiesDialogEx.Read");
            }
            if (column == 3) {
                return Messages.getString("TransformationPropertiesDialogEx.Update");
            }
            if (column == 4) {
                return Messages.getString("TransformationPropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Transformation.ProcessedObject po = (Transformation.ProcessedObject)TransformationPropertiesDialogEx.this.entList.get(row);
            if (col == 0) {
                return po.getObject().getName();
            }
            if (col == 1) {
                return po.isOpCreate();
            }
            if (col == 2) {
                return po.isOpRead();
            }
            if (col == 3) {
                return po.isOpUpdate();
            }
            if (col == 4) {
                return po.isOpDelete();
            }
            return new Integer(row * col);
        }
    }

    private class AttributesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return TransformationPropertiesDialogEx.this.attrList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TransformationPropertiesDialogEx.Attribute");
            }
            if (column == 1) {
                return Messages.getString("TransformationPropertiesDialogEx.Create");
            }
            if (column == 2) {
                return Messages.getString("TransformationPropertiesDialogEx.Read");
            }
            if (column == 3) {
                return Messages.getString("TransformationPropertiesDialogEx.Update");
            }
            if (column == 4) {
                return Messages.getString("TransformationPropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Transformation.ProcessedObject po = (Transformation.ProcessedObject)TransformationPropertiesDialogEx.this.attrList.get(row);
            if (col == 0) {
                return po.getObject().getName();
            }
            if (col == 1) {
                return po.isOpCreate();
            }
            if (col == 2) {
                return po.isOpRead();
            }
            if (col == 3) {
                return po.isOpUpdate();
            }
            if (col == 4) {
                return po.isOpDelete();
            }
            return new Integer(row * col);
        }
    }

    private class InfoStructuresModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TransformationPropertiesDialogEx.this.isList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TransformationPropertiesDialogEx.InformationStructures");
            }
            if (column == 1) {
                return Messages.getString("TransformationPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            InfoStructure structure = (InfoStructure)TransformationPropertiesDialogEx.this.isList.get(row);
            if (col == 0) {
                return structure.getName();
            }
            if (col == 1) {
                return structure.getSynonym();
            }
            return new Integer(row * col);
        }
    }
}

