/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_Column;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.relational.DRColumnCaseType;
import oracle.dbtools.crest.model.designrules.relational.DRColumnMaxNameLength;
import oracle.dbtools.crest.model.designrules.relational.DRColumnValidCharacters;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.domains.AVTEditor;
import oracle.dbtools.crest.swingui.admin.domains.CECheckConstraint;
import oracle.dbtools.crest.swingui.admin.domains.ValueListEditorEx;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DatatypeDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.LogicalTypeDialog;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;

public class ColumnPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final int MAX_DIGITS = 28;
    private static final int SEQ_VALUE_MAX_DIGITS = 28;
    private static final String EMPTY_VALUE = "";
    private static final String VIEW_EDIT = Messages.getString("ColumnPropertiesDialogEx.ViewEdit");
    private static final String VIEW_ONLY = Messages.getString("ColumnPropertiesDialogEx.View");
    private static final String FORM_MAXIMUM_WIDTH = Messages.getString("ColumnPropertiesDialogEx.FormMaximumWidth");
    private static final String FORM_DISPLAY_WIDTH = Messages.getString("ColumnPropertiesDialogEx.FormDisplayWidth");
    private static final String FORM_HEIGHT = Messages.getString("ColumnPropertiesDialogEx.FormHeight");
    private static final String HELP_TEXT = Messages.getString("ColumnPropertiesDialogEx.HelpText");
    private static final String READ_ONLY = Messages.getString("ColumnPropertiesDialogEx.ReadOnly");
    private static final String DISPLAYED_ON_REPORTS = Messages.getString("ColumnPropertiesDialogEx.DisplayedOnReports");
    private static final String DISPLAYED_ON_FORMS = Messages.getString("ColumnPropertiesDialogEx.DisplayedOnForms");
    private static final String DISPLAY_AS = Messages.getString("ColumnPropertiesDialogEx.DisplayAs");
    private static final String FORMAT_MASK = Messages.getString("ColumnPropertiesDialogEx.FormatMask");
    private static final String LABEL = Messages.getString("ColumnPropertiesDialogEx.Label");
    public static final String SECURITY = Messages.getString("ColumnPropertiesDialogEx.Security");
    public static final String MASK_DATA = Messages.getString("ColumnPropertiesDialogEx.MaskData");
    public static final String MASK_DATA_SHORT = Messages.getString("ColumnPropertiesDialogEx.MaskData_short");
    public static final String MASKING_TYPE = Messages.getString("ColumnPropertiesDialogEx.MaskingType");
    public static final String MASK_TEMPLATE = Messages.getString("ColumnPropertiesDialogEx.MaskTemplate");
    public static final String EXPRESSION = Messages.getString("ColumnPropertiesDialogEx.Expression");
    public static final String CONTAINS_SENSITIVE_INFORMATION = Messages.getString("ColumnPropertiesDialogEx.ContainsSensitiveInformation");
    public static final String CONTAINS_SENSITIVE_INFORMATION_SHORT = Messages.getString("ColumnPropertiesDialogEx.ContainsSensitiveInformation_short");
    public static final String CONTAINS_SENSITIVE_INFORMATION_MINIMAL = Messages.getString("ColumnPropertiesDialogEx.ContainsSensitiveInformation_minimal");
    public static final String CONTAINS_PII = Messages.getString("ColumnPropertiesDialogEx.ContainsPII");
    public static final String CONTAINS_PII_SHORT = Messages.getString("ColumnPropertiesDialogEx.ContainsPII_short");
    private static final String AUTO_INCREMENT_PANEL_CAPTION = Messages.getString("ColumnPropertiesDialogEx.AutoIncrement");
    private static final String AUTO_INCREMENT_GENERATE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementGenerate");
    private static final String AUTO_INCREMENT_START_WITH = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementStartWith");
    private static final String AUTO_INCREMENT_INCREMENT_BY = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementIncrementBy");
    private static final String AUTO_INCREMENT_MIN_VALUE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementMinValue");
    private static final String AUTO_INCREMENT_MAX_VALUE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementMaxValue");
    private static final String AUTO_INCREMENT_CYCLE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementCycle");
    private static final String AUTO_INCREMENT_DISABLE_CACHE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementDisableCache");
    private static final String AUTO_INCREMENT_CACHE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementCache");
    private static final String AUTO_INCREMENT_ORDER = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementOrder");
    private static final String AUTO_INCREMENT_SEQUENCE_NAME = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementSequenceName");
    private static final String AUTO_INCREMENT_TRIGGER_NAME = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementTriggerName");
    private static final String AUTO_INCREMENT_GENERATE_TRIGGER = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementGenerateTrigger");
    private static final String AUTO_INCREMENT_GENERATE_ALWAYS = Messages.getString("ColumnPropertiesDialogEx.ALWAYS");
    private static final String AUTO_INCREMENT_GENERATE_WHEN_NULL = Messages.getString("ColumnPropertiesDialogEx.WHEN_NULL");
    private static final String[] AUTO_INCREMENT_GENERATE_OPTIONS = new String[]{AUTO_INCREMENT_GENERATE_ALWAYS, AUTO_INCREMENT_GENERATE_WHEN_NULL};
    private Column column;
    private JTextField tfAbbreviation;
    private JCheckBox chEngineer;
    private JCheckBox chAllowNulls;
    private JTextField tfTable;
    private JButton bnDataType;
    private JComboBox cbSourceType;
    private JCheckBox chComputed;
    private JCheckBox chDependAsMandatory;
    private JTextField tfFormulaDesc;
    private JComboBox cbScope;
    private JComboBox cbTypeSubstitution;
    private JComboBox cbDependOnFK;
    private DatatypeDialog datatypeDialog = null;
    private JPanel pnConstraint;
    private JCheckBox chUsesDefault;
    private JTextField tfConstraintName;
    private JTextField tfNotNullConstraintName;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultValue;
    private JCheckBox chUseDomainConstraints;
    private JCheckBox chGenerateConstraintInDDL;
    private JButton btnConstraint;
    private JButton btnAVT;
    private JButton btnValueList;
    private CECheckConstraint checkEditor = null;
    private ValueListEditorEx valuesEditor = null;
    private List permittedTypes;
    private StructuredType currentST = null;
    private List subTypes;
    private JPanel pnLevels;
    private JTable lTable;
    private JTree tree;
    private JPanel pnUIDefaults;
    private JTextField tfDefaultLabel;
    private JTextField tfDefaultFormatMask;
    private JIntegerField tfDefaultFormDisplayWidth;
    private JIntegerField tfDefaultFormMaximumWidth;
    private JIntegerField tfDefaultFormHeight;
    private JTextArea taDefaultHelpText;
    private JCheckBox chDefaultReadOnly;
    private JCheckBox chDefaultDisplayedOnReports;
    private JCheckBox chDefaultDisplayedOnForms;
    private JComboBox cbDefaultDisplayAs;
    private JPanel pnSecurity;
    private JComboBox cbContainsPII;
    private JComboBox cbContainsSensitiveInformation;
    private JComboBox cbMaskData;
    private JComboBox cbMaskTemplate;
    private boolean oldUseDomainConstraint;
    private boolean oldGenerateConstraintInDDL;
    private boolean usePreferredList = false;
    private JButton btnProperties;
    private JCheckBox chAutoIncrementColumn;
    private JCheckBox chIdentityColumn;
    private JPanel pnAutoIncrement;
    private JComboBox cbAutoIncrementGenerate;
    private JIntegerField ifAutoIncrementStartWith;
    private JIntegerField ifAutoIncrementIncrementBy;
    private JIntegerField ifAutoIncrementMinValue;
    private JIntegerField ifAutoIncrementMaxValue;
    private JComboBox cbAutoIncrementCycle;
    private JComboBox cbAutoIncrementDisableCache;
    private JIntegerField ifAutoIncrementCache;
    private JComboBox cbAutoIncrementOrder;
    private JTextField tfAutoIncrementSequenceName;
    private JTextField tfAutoIncrementTriggerName;
    private JCheckBox chAutoIncrementGenerateTrigger;
    private boolean initializing = true;
    private JComboBox cbSensitiveTypes;
    private JTextField tfSensitiveTypeDesc;
    private JCheckBox chbDeprecated;
    private Dimension labelSize = null;

    public ColumnPropertiesDialogEx(ApplicationView view, DesignObject object, boolean usePreferred) {
        super(view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    public ColumnPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object, boolean usePreferred) {
        super(owner, view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ColumnPropertiesDialogEx.ColumnProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return OSEnvironment.isMacOS() ? 680 : 630;
    }

    @Override
    protected int getMinimumHeight() {
        return OSEnvironment.isMacOS() ? 720 : 660;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Column) {
            this.initializing = true;
            try {
                Boolean containsSensitiveInformation;
                Boolean containsPII;
                Integer formHeight;
                Integer formMaximumWidth;
                this.column = (Column)object;
                this.oldUseDomainConstraint = this.column.getUseDomainConstraints();
                this.oldGenerateConstraintInDDL = this.column.isGenerateConstraintInDDL();
                this.initDefaults();
                this.tfAbbreviation.setText(this.column.getAbbreviation());
                this.chEngineer.setSelected(this.column.getShouldEngineer());
                this.chAllowNulls.setSelected(this.column.getNullsAllowed());
                if (this.column.isPKElement() || this.column.isFKColumn()) {
                    this.chAllowNulls.setEnabled(false);
                }
                this.tfTable.setText(this.column.getContainer().getLongName());
                boolean updatable = this.isEditable() && !this.column.getContainer().isBST() && !this.column.isNested();
                this.tfName.setEnabled(updatable && !this.column.isNameFixed());
                this.bnDataType.setEnabled(updatable);
                this.bnDataType.setText(this.column.getDatatypeText());
                this.fillComboItems(ContainedObject.SOURCE_TYPE_STATES_DISPLAY, this.cbSourceType, false);
                String sourceType = this.translate(this.column.getSourceType(), ContainedObject.SOURCE_TYPE_STATES_INTERNAL, ContainedObject.SOURCE_TYPE_STATES_DISPLAY);
                this.cbSourceType.setSelectedItem(sourceType);
                this.chComputed.setSelected(this.column.isComputed());
                if (this.column.isComputed().booleanValue() || sourceType != null && (sourceType.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || sourceType.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE))) {
                    this.tfFormulaDesc.setEnabled(true);
                    this.tfFormulaDesc.setText(this.column.getFormulaDesc());
                } else {
                    this.tfFormulaDesc.setEnabled(false);
                    this.tfFormulaDesc.setText(EMPTY_VALUE);
                }
                this.initScope();
                if (this.column.isAllowSubtypeSubstitution()) {
                    if (this.column.isRestrictedTypeSubstitution()) {
                        this.cbTypeSubstitution.setSelectedItem("RESTRICTED");
                    } else {
                        this.cbTypeSubstitution.setSelectedItem("ALL");
                    }
                } else {
                    this.cbTypeSubstitution.setSelectedItem("NONE");
                }
                Table table = this.column.getTable();
                if (table.isBackup() && (table = (Table)table.getDesign().getDesignObject(table.getObjectID())) == null) {
                    table = this.column.getTable();
                }
                this.fillComboItems(table.getFKAssociationsList().toArray(), this.cbDependOnFK, true);
                this.cbDependOnFK.setSelectedItem(this.column.getDependOnForeignKey());
                this.chDependAsMandatory.setSelected(this.column.isDependOnFK_AsMandatory());
                if (this.column.getDataType() instanceof StructuredType) {
                    this.cbTypeSubstitution.setEnabled(true);
                    this.currentST = (StructuredType)this.column.getDataType();
                    this.permittedTypes.addAll(this.column.getPermittedSubTypes());
                    this.subTypes = this.currentST.getAllInstantiableSubTypes(true);
                } else {
                    this.cbTypeSubstitution.setEnabled(false);
                }
                this.tfConstraintName.setText(this.column.getConstraintName());
                this.tfNotNullConstraintName.setText(this.column.getNotNullConstraintName());
                this.chUsesDefault.setSelected(this.column.getUsesDefaultValue());
                this.setDefaultValueUI();
                this.chUseDomainConstraints.setSelected(this.column.getUseDomainConstraints());
                this.chGenerateConstraintInDDL.setSelected(this.column.isGenerateConstraintInDDL());
                String checkName = "NONE";
                if (this.column.getCheck() != null) {
                    checkName = this.isEditable() ? VIEW_EDIT : VIEW_ONLY;
                }
                this.btnConstraint.setText(checkName);
                this.btnConstraint.setEnabled(!this.chUseDomainConstraints.isSelected());
                checkName = LB_VALUES;
                if (!this.column.getAVTs().isEmpty()) {
                    checkName = this.isEditable() ? VIEW_EDIT : VIEW_ONLY;
                }
                this.btnAVT.setText(checkName);
                this.btnAVT.setEnabled(!this.chUseDomainConstraints.isSelected());
                checkName = LB_VALUES;
                if (this.column.getOwnValueList() != null) {
                    checkName = this.isEditable() ? VIEW_EDIT : VIEW_ONLY;
                }
                this.btnValueList.setText(checkName);
                this.btnValueList.setEnabled(!this.chUseDomainConstraints.isSelected());
                this.cbSensitiveTypes.addItem(null);
                Iterator it = this.getAppView().getSensitiveTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbSensitiveTypes.addItem(it.next());
                }
                this.cbSensitiveTypes.setSelectedItem(this.column.getSensitiveType());
                this.tfSensitiveTypeDesc.setText(this.column.getSensitiveTypeDescription());
                this.chbDeprecated.setSelected(this.column.isDeprecated());
                this.initMeasurements();
                this.initChangeRequests();
                this.initResponsibleParties();
                this.initDocuments();
                if (this.column.isFKColumn()) {
                    this.bnDataType.setEnabled(false);
                }
                if (this.column.isInFKinArc()) {
                    this.chAllowNulls.setEnabled(false);
                    this.chAllowNulls.setToolTipText(Messages.getString("ColumnPropertiesDialogEx.ColumnBelongsToFKInArc"));
                }
                if (this.column.isPKElement()) {
                    this.chAllowNulls.setEnabled(false);
                    this.chAllowNulls.setToolTipText(Messages.getString("ColumnPropertiesDialogEx.ColumnBelongsToPK"));
                }
                this.tfDefaultLabel.setText(this.column.getDefaultLabel());
                this.tfDefaultFormatMask.setText(this.column.getDefaultFormatMask());
                Integer formDisplayWidth = this.column.getDefaultFormDisplayWidth();
                if (formDisplayWidth != null) {
                    this.tfDefaultFormDisplayWidth.setText(String.valueOf(formDisplayWidth));
                }
                if ((formMaximumWidth = this.column.getDefaultFormMaximumWidth()) != null) {
                    this.tfDefaultFormMaximumWidth.setText(String.valueOf(formMaximumWidth));
                }
                if ((formHeight = this.column.getDefaultFormHeight()) != null) {
                    this.tfDefaultFormHeight.setText(String.valueOf(formHeight));
                }
                this.taDefaultHelpText.setText(this.column.getDefaultHelpText());
                this.chDefaultReadOnly.setSelected(this.column.isDefaultReadOnly());
                this.chDefaultDisplayedOnReports.setSelected(this.column.isDefaultDisplayedOnReports());
                this.chDefaultDisplayedOnForms.setSelected(this.column.isDefaultDisplayedOnForms());
                String displayAs = this.column.getDefaultDisplayAs();
                if (displayAs != null) {
                    this.cbDefaultDisplayAs.setSelectedItem(this.translate(displayAs, Column.DISPLAY_AS_INTERNAL, Column.DISPLAY_AS_DISPLAY));
                }
                if ((containsPII = this.column.isContainsPII()) != null) {
                    this.cbContainsPII.setSelectedItem(containsPII != false ? YES : NO);
                }
                if ((containsSensitiveInformation = this.column.isContainsSensitiveInformation()) != null) {
                    this.cbContainsSensitiveInformation.setSelectedItem(containsSensitiveInformation != false ? YES : NO);
                }
                this.updateMaskingTypes();
                this.cbMaskData.setSelectedItem(this.column.getMaskingType());
                this.cbMaskTemplate.setSelectedItem(this.column.getMaskTemplate());
                this.initAutoIncrementProperties();
                this.dynamicPropertiesList.clear();
                it = this.column.getPropertyNames();
                while (it.hasNext()) {
                    String propName = (String)it.next();
                    String value = this.column.getProperty(propName);
                    DynamicProperty dp = new DynamicProperty(propName, value);
                    this.dynamicPropertiesList.add(dp);
                }
                this.dynamicPropertiesTable.updateUI();
            }
            finally {
                this.initializing = false;
            }
        }
    }

    private void initAutoIncrementProperties() {
        this.chAutoIncrementColumn.setSelected(this.column.isAutoIncrementColumn());
        this.updateIdentityColumnState();
        this.chIdentityColumn.setSelected(this.column.isIdentityColumn());
        this.cbAutoIncrementGenerate.setSelectedItem(this.column.isAutoIncrementGenerateAlways() ? AUTO_INCREMENT_GENERATE_ALWAYS : AUTO_INCREMENT_GENERATE_WHEN_NULL);
        try {
            this.ifAutoIncrementStartWith.setText(this.column.getAutoIncrementStartWith());
        }
        catch (NumberFormatException nfe) {
            this.ifAutoIncrementStartWith.setValue(1L);
        }
        this.ifAutoIncrementIncrementBy.setValue(this.column.getAutoIncrementIncrementBy());
        try {
            this.ifAutoIncrementMinValue.setText(this.column.getAutoIncrementMinValue());
        }
        catch (NumberFormatException nfe) {
            this.ifAutoIncrementMinValue.setValue(null);
        }
        try {
            this.ifAutoIncrementMaxValue.setText(this.column.getAutoIncrementMaxValue());
        }
        catch (NumberFormatException nfe) {
            this.ifAutoIncrementMaxValue.setValue(null);
        }
        this.cbAutoIncrementCycle.setSelectedItem(this.column.isAutoIncrementCycle() ? YES : NO);
        this.cbAutoIncrementDisableCache.setSelectedItem(this.column.isAutoIncrementDisableCache() ? YES : NO);
        this.ifAutoIncrementCache.setEnabled(!this.column.isAutoIncrementDisableCache());
        this.ifAutoIncrementCache.setValue(this.column.getAutoIncrementCache());
        this.cbAutoIncrementOrder.setSelectedItem(this.column.isAutoIncrementOrder() ? YES : NO);
        this.tfAutoIncrementSequenceName.setText(this.column.getAutoIncrementSequenceName());
        this.tfAutoIncrementTriggerName.setText(this.column.getAutoIncrementTriggerName());
        this.chAutoIncrementGenerateTrigger.setSelected(this.column.isAutoIncrementGenerateTrigger());
    }

    @Override
    protected void setProperties() {
        this.column.setName(this.tfName.getText());
        this.column.setAbbreviation(this.tfAbbreviation.getText());
        this.column.setComment(this.taComments.getText());
        this.column.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.column.setNotes(this.taNotes.getText());
        if (this.cbDefaultValue.isVisible()) {
            this.column.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
        } else {
            this.column.setDefaultValue(this.tfDefaultValue.getText());
        }
        this.column.setShouldEngineer(this.chEngineer.isSelected());
        boolean mandatory = !this.chAllowNulls.isSelected();
        boolean old = this.column.getNullsAllowed();
        this.column.setNullsAllowed(!mandatory);
        ColumnPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.column.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.column.setProperty(dp.getName(), dp.getValue());
        }
        if (old && mandatory) {
            List list = ((Table)this.column.getContainerWithKeyObject()).getFKeysOnColumn(this.column);
            ArrayList<FKIndexAssociation> newlist = new ArrayList<FKIndexAssociation>();
            for (FKIndexAssociation fk : list) {
                if (!"SET NULL".equals(fk.getDeleteRule()) || fk.hasColumnWithAllowNulls()) continue;
                newlist.add(fk);
            }
            if (newlist.size() > 0) {
                String text = Messages.getString("ColumnPropertiesDialogEx.DeleteRleWillChange");
                for (FKIndexAssociation fk : newlist) {
                    text = text + "\n" + fk.getName();
                }
                int res = JOptionPane.showConfirmDialog(null, text, Messages.getString("ColumnPropertiesDialogEx.FKDeleteRuleChange"), 2);
                if (res != 0) {
                    this.column.setNullsAllowed(true);
                    this.chAllowNulls.setSelected(true);
                } else {
                    for (FKIndexAssociation fk : newlist) {
                        fk.setDeleteRule("RESTRICT");
                    }
                }
            }
            for (FKIndexAssociation fk : this.column.getAllFKs()) {
                if (fk.isMandatory()) continue;
                fk.setMandatory(true);
                fk.resetEdgeParams();
            }
        }
        this.column.setConstraintName(this.tfConstraintName.getText());
        this.column.setNotNullConstraintName(this.tfNotNullConstraintName.getText());
        this.column.setUsesDefaultValue(this.chUsesDefault.isSelected());
        this.column.setUseDomainConstraints(this.chUseDomainConstraints.isSelected());
        this.column.setGenerateConstraintInDDL(this.chGenerateConstraintInDDL.isSelected());
        this.column.setSourceType(this.translate((String)this.cbSourceType.getSelectedItem(), ContainedObject.SOURCE_TYPE_STATES_DISPLAY, ContainedObject.SOURCE_TYPE_STATES_INTERNAL));
        this.column.setComputed(this.chComputed.isSelected());
        this.column.setFormulaDesc(this.tfFormulaDesc.getText());
        if (this.cbScope.getSelectedItem() == null) {
            this.column.setScopeId(null);
        } else {
            this.column.setScopeId(((ContainerObject)this.cbScope.getSelectedItem()).getObjectID());
        }
        String typs = (String)this.cbTypeSubstitution.getSelectedItem();
        if ("NONE".equals(typs)) {
            this.column.setAllowSubtypeSubstitution(false);
            this.column.setRestrictedTypeSubstitution(false);
        } else if ("ALL".equals(typs)) {
            this.column.setRestrictedTypeSubstitution(false);
            this.column.setAllowSubtypeSubstitution(true);
        } else {
            this.column.setRestrictedTypeSubstitution(true);
            this.column.setAllowSubtypeSubstitution(true);
        }
        if (this.column.getCheck() != null && this.column.getCheck().isEmpty()) {
            this.column.setCheck(null);
        }
        if (this.column.getOwnValueList() != null && this.column.getOwnValueList().isEmpty()) {
            this.column.setOwnValueList(null);
        }
        if (this.column.getCheck() != null) {
            this.btnConstraint.setText(VIEW_EDIT);
        }
        if (!this.column.getAVTs().isEmpty()) {
            this.btnAVT.setText(VIEW_EDIT);
        }
        if (this.column.getOwnValueList() != null) {
            this.btnValueList.setText(VIEW_EDIT);
        }
        this.column.setDependOnForeignKeyID(EMPTY_VALUE);
        this.column.setDependOnForeignKey((FKIndexAssociation)this.cbDependOnFK.getSelectedItem());
        this.column.setDependOnFK_AsMandatory(this.chDependAsMandatory.isSelected());
        List list = this.column.getPermittedSubTypes();
        list.clear();
        list.addAll(this.permittedTypes);
        this.column.setSensitiveType((SensitiveType)this.cbSensitiveTypes.getSelectedItem());
        this.column.setSensitiveTypeDescription(this.tfSensitiveTypeDesc.getText());
        this.column.setDeprecated(this.chbDeprecated.isSelected());
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.column.setDefaultLabel(this.tfDefaultLabel.getText());
        this.column.setDefaultFormatMask(this.tfDefaultFormatMask.getText());
        String formDisplayWidth = this.tfDefaultFormDisplayWidth.getText();
        this.column.setDefaultFormDisplayWidth(StringUtilities.isNotEmpty(formDisplayWidth) ? Integer.valueOf(Integer.parseInt(formDisplayWidth)) : null);
        String formMaximumWidth = this.tfDefaultFormMaximumWidth.getText();
        this.column.setDefaultFormMaximumWidth(StringUtilities.isNotEmpty(formMaximumWidth) ? Integer.valueOf(Integer.parseInt(formMaximumWidth)) : null);
        String formHeight = this.tfDefaultFormHeight.getText();
        this.column.setDefaultFormHeight(StringUtilities.isNotEmpty(formHeight) ? Integer.valueOf(Integer.parseInt(formHeight)) : null);
        this.column.setDefaultHelpText(this.taDefaultHelpText.getText());
        this.column.setDefaultReadOnly(this.chDefaultReadOnly.isSelected());
        this.column.setDefaultDisplayedOnReports(this.chDefaultDisplayedOnReports.isSelected());
        this.column.setDefaultDisplayedOnForms(this.chDefaultDisplayedOnForms.isSelected());
        this.column.setDefaultDisplayAs(this.translate((String)this.cbDefaultDisplayAs.getSelectedItem(), Column.DISPLAY_AS_DISPLAY, Column.DISPLAY_AS_INTERNAL));
        String containsPIIValue = (String)this.cbContainsPII.getSelectedItem();
        this.column.setContainsPII(YES.equals(containsPIIValue) ? Boolean.TRUE : (NO.equals(containsPIIValue) ? Boolean.FALSE : null));
        String containsSensitiveInformationValue = (String)this.cbContainsSensitiveInformation.getSelectedItem();
        this.column.setContainsSensitiveInformation(YES.equals(containsSensitiveInformationValue) ? Boolean.TRUE : (NO.equals(containsSensitiveInformationValue) ? Boolean.FALSE : null));
        String maskDataValue = (String)this.cbMaskData.getSelectedItem();
        this.column.setMaskingType(maskDataValue);
        this.column.setMaskTemplate((MaskTemplate)this.cbMaskTemplate.getSelectedItem());
        this.setAutoIncrementProperties();
        this.oldUseDomainConstraint = this.column.getUseDomainConstraints();
        this.oldGenerateConstraintInDDL = this.column.isGenerateConstraintInDDL();
        this.checkNamingOptions();
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    private void setAutoIncrementProperties() {
        this.column.setAutoIncrementColumn(this.chAutoIncrementColumn.isSelected());
        this.column.setIdentityColumn(this.chIdentityColumn.isSelected());
        this.column.setAutoIncrementGenerateAlways(AUTO_INCREMENT_GENERATE_ALWAYS.equals(this.cbAutoIncrementGenerate.getSelectedItem()));
        try {
            String autoIncStartWith = this.ifAutoIncrementStartWith.getText();
            Double.parseDouble(autoIncStartWith);
            this.column.setAutoIncrementStartWith(autoIncStartWith);
        }
        catch (NumberFormatException nfe) {
            this.column.setAutoIncrementStartWith("1");
        }
        try {
            this.column.setAutoIncrementIncrementBy(Integer.parseInt(this.ifAutoIncrementIncrementBy.getText()));
        }
        catch (NumberFormatException nfe) {
            this.column.setAutoIncrementIncrementBy(1);
        }
        try {
            String autoIncMinValue = this.ifAutoIncrementMinValue.getText();
            if (autoIncMinValue != null) {
                Double.parseDouble(autoIncMinValue);
            }
            this.column.setAutoIncrementMinValue(autoIncMinValue);
        }
        catch (NumberFormatException nfe) {
            this.column.setAutoIncrementMinValue(null);
        }
        try {
            String autoIncMaxValue = this.ifAutoIncrementMaxValue.getText();
            if (autoIncMaxValue != null) {
                Double.parseDouble(autoIncMaxValue);
            }
            this.column.setAutoIncrementMaxValue(autoIncMaxValue);
        }
        catch (NumberFormatException nfe) {
            this.column.setAutoIncrementMaxValue(null);
        }
        this.column.setAutoIncrementCycle(YES.equals(this.cbAutoIncrementCycle.getSelectedItem()));
        this.column.setAutoIncrementDisableCache(YES.equals(this.cbAutoIncrementDisableCache.getSelectedItem()));
        try {
            this.column.setAutoIncrementCache(Integer.parseInt(this.ifAutoIncrementCache.getText()));
        }
        catch (NumberFormatException nfe) {
            this.column.setAutoIncrementCache(null);
        }
        this.column.setAutoIncrementOrder(YES.equals(this.cbAutoIncrementOrder.getSelectedItem()));
        this.column.setAutoIncrementSequenceName(this.tfAutoIncrementSequenceName.getText());
        this.column.setAutoIncrementTriggerName(this.tfAutoIncrementTriggerName.getText());
        this.column.setAutoIncrementGenerateTrigger(this.chAutoIncrementGenerateTrigger.isSelected());
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRColumnMaxNameLength(), this.column);
        this.checkDesignRule(new DRColumnCaseType(), this.column);
        this.checkDesignRule(new DRColumnValidCharacters(), this.column);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getConstraintPanel());
        this.addToTree(root, this.getAutoIncrementPanel());
        this.addToTree(root, this.getSecurityPanel());
        this.addToTree(root, this.getUIDefaultsPanel());
        this.addToTree(root, this.getPermittedSubtypesPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "COLUMN_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbTable = new JLabel(LB_TABLE);
        lbTable.setPreferredSize(this.getDefaultSize());
        this.tfTable = new JTextField();
        this.tfTable.setPreferredSize(this.getDefaultSize());
        this.tfTable.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbTable, this.tfTable));
        JLabel lbAbbreviation = new JLabel(ABBREVIATION);
        lbAbbreviation.setPreferredSize(this.getDefaultSize());
        this.tfAbbreviation = new JTextField();
        this.tfAbbreviation.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAbbreviation, this.tfAbbreviation));
        JLabel lbEngineer = new JLabel(LB_ENGINEER);
        lbEngineer.setPreferredSize(this.getDefaultSize());
        this.chEngineer = new JCheckBox();
        this.chEngineer.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbEngineer, this.chEngineer));
        JLabel lbAllowNulls = new JLabel(LB_ALLOW_NULLS);
        lbAllowNulls.setPreferredSize(this.getDefaultSize());
        this.chAllowNulls = new JCheckBox();
        this.chAllowNulls.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAllowNulls, this.chAllowNulls));
        JLabel lbDataType = new JLabel(LB_DATA_TYPE);
        lbDataType.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(new Dimension(FIELD_WIDTH + 80, 20));
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.setToolTipText(Messages.getString("ColumnPropertiesDialogEx.ClickToEditDataType"));
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColumnPropertiesDialogEx.this.datatypeDialog == null) {
                    ColumnPropertiesDialogEx.this.datatypeDialog = new DatatypeDialog(ColumnPropertiesDialogEx.this, ColumnPropertiesDialogEx.this.getAppView(), ColumnPropertiesDialogEx.this.column, ColumnPropertiesDialogEx.this.bnDataType);
                }
                ColumnPropertiesDialogEx.this.datatypeDialog.initProperties(ColumnPropertiesDialogEx.this.usePreferredList);
                ColumnPropertiesDialogEx.this.datatypeDialog.showDialog();
                if (ColumnPropertiesDialogEx.this.column.getDataType() instanceof StructuredType && !ColumnPropertiesDialogEx.this.column.isReference() && ColumnPropertiesDialogEx.this.column.getDataType() != ColumnPropertiesDialogEx.this.currentST) {
                    ColumnPropertiesDialogEx.this.currentST = (StructuredType)ColumnPropertiesDialogEx.this.column.getDataType();
                    ColumnPropertiesDialogEx.this.subTypes = ColumnPropertiesDialogEx.this.currentST.getAllInstantiableSubTypes(true);
                }
                ColumnPropertiesDialogEx.this.bnDataType.setText(ColumnPropertiesDialogEx.this.column.getDatatypeText());
            }
        });
        this.bnDataType.addChangeListener(new DatatypeListener());
        JPanel jpDatatype = this.createRow(lbDataType, this.bnDataType);
        JButton bnProps = new JButton("...");
        bnProps.setToolTipText(Messages.getString("ColumnPropertiesDialogEx.DatatypeProperties"));
        bnProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignObject sel = null;
                if (ColumnPropertiesDialogEx.this.column.getUse() == 0) {
                    sel = ColumnPropertiesDialogEx.this.column.getDomain();
                } else if (ColumnPropertiesDialogEx.this.column.getUse() == 2) {
                    sel = ColumnPropertiesDialogEx.this.column.getDistinctType();
                } else if (ColumnPropertiesDialogEx.this.column.getUse() == 3) {
                    sel = ColumnPropertiesDialogEx.this.column.getStructuredType();
                } else if (ColumnPropertiesDialogEx.this.column.getUse() == 4) {
                    sel = ColumnPropertiesDialogEx.this.column.getCollectionType();
                }
                if (sel != null) {
                    sel.showModal = ((ColumnPropertiesDialogEx)ColumnPropertiesDialogEx.this).column.showModal;
                    sel.showPropertyDialog();
                } else if (ColumnPropertiesDialogEx.this.column.getUse() == 1) {
                    LogicalTypeDialog logicalDialog = !ColumnPropertiesDialogEx.this.isEditable() || ColumnPropertiesDialogEx.this.column.getContainer().isBST() || ColumnPropertiesDialogEx.this.column.isNested() ? new LogicalTypeDialog(ColumnPropertiesDialogEx.this.getAppView(), ColumnPropertiesDialogEx.this.column, ColumnPropertiesDialogEx.this.column.getSelectedRDBMSType().getName(), ColumnPropertiesDialogEx.this.usePreferredList) : new LogicalTypeDialog(ColumnPropertiesDialogEx.this.getAppView(), ColumnPropertiesDialogEx.this.column, ColumnPropertiesDialogEx.this.bnDataType, ColumnPropertiesDialogEx.this.column.getSelectedRDBMSType().getName(), ColumnPropertiesDialogEx.this.usePreferredList);
                    logicalDialog.setVisible(true);
                }
                ColumnPropertiesDialogEx.this.bnDataType.setText(ColumnPropertiesDialogEx.this.column.getDatatypeText());
            }
        });
        this.addRowToGeneralPanel(this.createRow(jpDatatype, bnProps, true));
        JLabel lbSourceType = new JLabel(LB_TYPE);
        lbSourceType.setPreferredSize(this.getDefaultSize());
        this.cbSourceType = new JComboBox();
        this.cbSourceType.setPreferredSize(this.getDefaultSize());
        this.cbSourceType.setMaximumRowCount(8);
        this.cbSourceType.addActionListener(new ExpressionEnableListener());
        this.addRowToGeneralPanel(this.createRow(lbSourceType, this.cbSourceType));
        JLabel lbComputed = new JLabel(LB_COMPUTED);
        lbComputed.setPreferredSize(this.getDefaultSize());
        this.chComputed = new JCheckBox();
        this.chComputed.setPreferredSize(this.getDefaultSize());
        this.chComputed.addActionListener(new ExpressionEnableListener());
        this.addRowToGeneralPanel(this.createRow(lbComputed, this.chComputed));
        JLabel lbColumnExpr = new JLabel(LB_COLUMN_EXPRESSION);
        lbColumnExpr.setPreferredSize(this.getDefaultSize());
        this.tfFormulaDesc = new JTextField();
        this.tfFormulaDesc.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbColumnExpr, this.tfFormulaDesc));
        JLabel lbAutoIncrement = new JLabel(LB_AUTO_INCREMENT);
        lbAutoIncrement.setPreferredSize(this.getDefaultSize());
        this.chAutoIncrementColumn = new JCheckBox();
        this.chIdentityColumn = new JCheckBox(LB_IDENTITY_COLUMN);
        this.chIdentityColumn.setHorizontalTextPosition(10);
        this.chIdentityColumn.setEnabled(false);
        this.chAutoIncrementColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnPropertiesDialogEx.this.updateIdentityColumnState();
            }
        });
        JPanel autoIncrementPanel = new JPanel(new BorderLayout(20, 0));
        autoIncrementPanel.add((Component)this.chAutoIncrementColumn, "West");
        autoIncrementPanel.add(this.chIdentityColumn);
        this.addRowToGeneralPanel(this.createRow(lbAutoIncrement, autoIncrementPanel));
        JLabel lbScope = new JLabel(LB_SCOPE);
        lbScope.setPreferredSize(this.getDefaultSize());
        this.cbScope = new JComboBox();
        this.cbScope.setPreferredSize(this.getDefaultSize());
        this.cbScope.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbScope, this.cbScope));
        JLabel lbAllowSubtypeSubstitution = new JLabel(LB_SUBTYPE_SUBSTITUTION);
        lbAllowSubtypeSubstitution.setPreferredSize(this.getDefaultSize());
        this.cbTypeSubstitution = new JComboBox<String>(ContainedObjectWithDomain.SUBST_OPTIONS);
        this.cbTypeSubstitution.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAllowSubtypeSubstitution, this.cbTypeSubstitution));
        JLabel lbDependOnFK = new JLabel(LB_DEPEND_ON_FK);
        lbDependOnFK.setPreferredSize(this.getDefaultSize());
        this.cbDependOnFK = new JComboBox();
        this.cbDependOnFK.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDependOnFK, this.cbDependOnFK));
        JLabel lbDependOnFKAsMandatory = new JLabel(LB_DEPEND_ON_FK_AS_MANDATORY);
        lbDependOnFKAsMandatory.setPreferredSize(this.getDefaultSize());
        this.chDependAsMandatory = new JCheckBox();
        this.chDependAsMandatory.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDependOnFKAsMandatory, this.chDependAsMandatory));
        JLabel lbSensitiveType = new JLabel(LB_SENSITIVE_TYPE);
        lbSensitiveType.setPreferredSize(this.getDefaultSize());
        this.cbSensitiveTypes = new JComboBox();
        this.cbSensitiveTypes.setPreferredSize(this.tfName.getPreferredSize());
        this.addRowToGeneralPanel(this.createRow(lbSensitiveType, this.cbSensitiveTypes));
        JLabel lbSensitiveTypeDesc = new JLabel(LB_SENSITIVE_TYPE_DESC);
        lbSensitiveTypeDesc.setPreferredSize(this.getDefaultSize());
        this.tfSensitiveTypeDesc = new JTextField();
        this.tfSensitiveTypeDesc.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSensitiveTypeDesc, this.tfSensitiveTypeDesc));
        JLabel lbDeprecated = new JLabel(LB_DEPRECATED);
        lbDeprecated.setPreferredSize(this.getDefaultSize());
        this.chbDeprecated = new JCheckBox();
        this.chbDeprecated.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDeprecated, this.chbDeprecated));
    }

    private void updateIdentityColumnState() {
        boolean autoIncrementSelected = this.chAutoIncrementColumn.isSelected();
        if (!autoIncrementSelected) {
            this.chIdentityColumn.setSelected(false);
        }
        this.chIdentityColumn.setEnabled(autoIncrementSelected);
        this.enableAutoIncrement(autoIncrementSelected);
    }

    private void initScope() {
        if (this.column.isReference() && this.column.getUse() == 3) {
            this.cbScope.removeAllItems();
            this.cbScope.addItem(null);
            StructuredType col_st = this.column.getStructuredType();
            Iterator it = ((RelationalDesign)this.column.getDesignPart()).getTableSet().iterator();
            while (it.hasNext()) {
                Table t = (Table)it.next();
                if (!t.isBST() || !col_st.isParentOf(t.getBasedOnStructuredType())) continue;
                this.cbScope.addItem(t);
            }
            this.cbScope.setSelectedItem(this.column.getScope());
            this.cbScope.setEnabled(true);
        } else {
            this.cbScope.setEnabled(false);
        }
    }

    private Dimension getLabelDefaultSize() {
        if (this.labelSize == null) {
            this.labelSize = new Dimension(200, 20);
        }
        return this.labelSize;
    }

    protected JPanel getConstraintPanel() {
        if (this.pnConstraint == null) {
            this.pnConstraint = this.createPage(Messages.getString("ColumnPropertiesDialogEx.DefaultAndConstraint"));
            JPanel pnMain = new JPanel(new BorderLayout());
            JPanel jpanel = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbConstrName = new JLabel(Messages.getString("ColumnPropertiesDialogEx.ConstraintName"));
            lbConstrName.setPreferredSize(this.getLabelDefaultSize());
            this.tfConstraintName = new JTextField();
            this.tfConstraintName.setPreferredSize(this.getDefaultSize());
            jpanel.add(this.createRow(lbConstrName, this.tfConstraintName));
            JLabel lbNotNullConstraintName = new JLabel(Messages.getString("ColumnPropertiesDialogEx.NotNullConstraintName"));
            lbNotNullConstraintName.setPreferredSize(this.getLabelDefaultSize());
            this.tfNotNullConstraintName = new JTextField();
            this.tfNotNullConstraintName.setPreferredSize(this.getDefaultSize());
            jpanel.add(this.createRow(lbNotNullConstraintName, this.tfNotNullConstraintName));
            JLabel lbUsesDefault = new JLabel(LB_USES_DEFAULT);
            lbUsesDefault.setPreferredSize(this.getLabelDefaultSize());
            this.chUsesDefault = new JCheckBox();
            this.chUsesDefault.setPreferredSize(this.getDefaultSize());
            jpanel.add(this.createRow(lbUsesDefault, this.chUsesDefault));
            JLabel lbDefaultValue = new JLabel(LB_DEFAULT_VALUE);
            lbDefaultValue.setPreferredSize(this.getLabelDefaultSize());
            JPanel pnDefaultValue = new JPanel();
            OverlayLayout overlay = new OverlayLayout(pnDefaultValue);
            pnDefaultValue.setLayout(overlay);
            this.cbDefaultValue = new JComboBox();
            this.cbDefaultValue.setPreferredSize(this.getDefaultSize());
            this.cbDefaultValue.setVisible(false);
            pnDefaultValue.add(this.cbDefaultValue);
            this.tfDefaultValue = new JTextField();
            this.tfDefaultValue.setPreferredSize(this.getDefaultSize());
            this.tfDefaultValue.setVisible(true);
            pnDefaultValue.add(this.tfDefaultValue);
            jpanel.add(this.createRow(lbDefaultValue, pnDefaultValue));
            JLabel lbUseDomainConstraints = new JLabel(LB_USE_DOMAIN_CONSTRAINTS);
            lbUseDomainConstraints.setPreferredSize(this.getLabelDefaultSize());
            this.chUseDomainConstraints = new JCheckBox();
            this.chUseDomainConstraints.setPreferredSize(this.getDefaultSize());
            this.chUseDomainConstraints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnPropertiesDialogEx.this.btnConstraint.setEnabled(!ColumnPropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    ColumnPropertiesDialogEx.this.btnAVT.setEnabled(!ColumnPropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    ColumnPropertiesDialogEx.this.btnValueList.setEnabled(!ColumnPropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    if (ColumnPropertiesDialogEx.this.chUseDomainConstraints.isSelected()) {
                        ColumnPropertiesDialogEx.this.column.setCheck(null);
                    }
                }
            });
            jpanel.add(this.createRow(lbUseDomainConstraints, this.chUseDomainConstraints));
            JLabel lbConstraint = new JLabel(LB_CONSTRAINT);
            lbConstraint.setPreferredSize(this.getLabelDefaultSize());
            this.btnConstraint = new JButton();
            this.btnConstraint.setHorizontalAlignment(0);
            this.btnConstraint.setPreferredSize(this.getDefaultSize());
            this.btnConstraint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnPropertiesDialogEx.this.column.setUseDomainConstraints(false);
                    if (ColumnPropertiesDialogEx.this.column.getCheck() == null) {
                        CheckConstraint check = new CheckConstraint();
                        ColumnPropertiesDialogEx.this.column.setCheck(check);
                    }
                    if (ColumnPropertiesDialogEx.this.column.getCheck().getDesign() == null) {
                        ColumnPropertiesDialogEx.this.column.getCheck().setDesign(ColumnPropertiesDialogEx.this.column.getDesign());
                    }
                    if (ColumnPropertiesDialogEx.this.checkEditor == null) {
                        ColumnPropertiesDialogEx.this.checkEditor = new CECheckConstraint((Dialog)ColumnPropertiesDialogEx.this, ColumnPropertiesDialogEx.this.getAppView(), !ColumnPropertiesDialogEx.this.isEditable());
                    }
                    ColumnPropertiesDialogEx.this.checkEditor.configureEditComponentFor(ColumnPropertiesDialogEx.this.column.getCheck());
                    ColumnPropertiesDialogEx.this.checkEditor.doEditing(ColumnPropertiesDialogEx.this.column.getCheck());
                }
            });
            jpanel.add(this.createRow(lbConstraint, this.btnConstraint));
            JLabel lbAVT = new JLabel(LB_RANGES);
            lbAVT.setPreferredSize(this.getLabelDefaultSize());
            this.btnAVT = new JButton();
            this.btnAVT.setPreferredSize(this.getDefaultSize());
            this.btnAVT.setHorizontalAlignment(0);
            this.btnAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnPropertiesDialogEx.this.column.setUseDomainConstraints(false);
                    AVTEditor avtEditor = new AVTEditor((Dialog)ColumnPropertiesDialogEx.this, !ColumnPropertiesDialogEx.this.isEditable());
                    avtEditor.configureEditComponentFor(ColumnPropertiesDialogEx.this.column, ColumnPropertiesDialogEx.this.column.getLogicalDatatype());
                    avtEditor.doEditing(ColumnPropertiesDialogEx.this.column);
                }
            });
            jpanel.add(this.createRow(lbAVT, this.btnAVT));
            JLabel lbValueList = new JLabel(LB_VALUE_LIST);
            lbValueList.setPreferredSize(this.getLabelDefaultSize());
            this.btnValueList = new JButton();
            this.btnValueList.setPreferredSize(this.getDefaultSize());
            this.btnValueList.setHorizontalAlignment(0);
            this.btnValueList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnPropertiesDialogEx.this.column.setUseDomainConstraints(false);
                    if (ColumnPropertiesDialogEx.this.column.getOwnValueList() == null) {
                        ConstraintEnumeration valueList = new ConstraintEnumeration();
                        ColumnPropertiesDialogEx.this.column.setValueList(valueList);
                    }
                    if (ColumnPropertiesDialogEx.this.valuesEditor == null) {
                        ColumnPropertiesDialogEx.this.valuesEditor = new ValueListEditorEx((Dialog)ColumnPropertiesDialogEx.this, !ColumnPropertiesDialogEx.this.isEditable());
                    }
                    ColumnPropertiesDialogEx.this.valuesEditor.configureEditComponentFor(ColumnPropertiesDialogEx.this.column.getOwnValueList());
                    ColumnPropertiesDialogEx.this.valuesEditor.doEditing(ColumnPropertiesDialogEx.this.column);
                }
            });
            jpanel.add(this.createRow(lbValueList, this.btnValueList));
            JLabel lbGenerateConstraintInDDL = new JLabel(LB_GEN_CONSTRAINT_IN_DDL);
            lbGenerateConstraintInDDL.setPreferredSize(this.getLabelDefaultSize());
            this.chGenerateConstraintInDDL = new JCheckBox();
            this.chGenerateConstraintInDDL.setPreferredSize(this.getDefaultSize());
            jpanel.add(this.createRow(lbGenerateConstraintInDDL, this.chGenerateConstraintInDDL));
            pnMain.add((Component)jpanel, "North");
            this.pnConstraint.add(pnMain);
        }
        return this.pnConstraint;
    }

    @Override
    protected void onApply() {
        super.onApply();
        this.setDefaultValueUI();
    }

    private void setDefaultValueUI() {
        Object[] vals = this.column.getValues().toArray();
        if (vals != null && vals.length > 0) {
            Object[] defs = new Object[vals.length + 1];
            defs[0] = EMPTY_VALUE;
            int sel = 0;
            String def = this.column.getDefaultValue();
            for (int i = 0; i < vals.length; ++i) {
                defs[i + 1] = vals[i];
                if (def == null || !def.equals(vals[i].toString())) continue;
                sel = i + 1;
            }
            this.cbDefaultValue.setModel(new DefaultComboBoxModel<Object>(defs));
            this.cbDefaultValue.setSelectedIndex(sel);
            this.cbDefaultValue.setVisible(true);
            this.tfDefaultValue.setVisible(false);
        } else {
            this.tfDefaultValue.setText(this.column.getDefaultValue());
            this.tfDefaultValue.setVisible(true);
            this.cbDefaultValue.setVisible(false);
        }
    }

    protected JPanel getAutoIncrementPanel() {
        if (this.pnAutoIncrement == null) {
            this.pnAutoIncrement = this.createPage(AUTO_INCREMENT_PANEL_CAPTION);
            JPanel pnInnerGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            this.cbAutoIncrementGenerate = new JComboBox<String>(AUTO_INCREMENT_GENERATE_OPTIONS);
            this.cbAutoIncrementGenerate.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_GENERATE, this.cbAutoIncrementGenerate);
            this.ifAutoIncrementStartWith = new JIntegerField();
            this.ifAutoIncrementStartWith.setColumns(28);
            this.ifAutoIncrementStartWith.setLargeIntegerDocument(28);
            this.ifAutoIncrementStartWith.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_START_WITH, this.ifAutoIncrementStartWith);
            this.ifAutoIncrementIncrementBy = new JIntegerField();
            this.ifAutoIncrementIncrementBy.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_INCREMENT_BY, this.ifAutoIncrementIncrementBy);
            this.ifAutoIncrementMinValue = new JIntegerField();
            this.ifAutoIncrementMinValue.setColumns(28);
            this.ifAutoIncrementMinValue.setLargeIntegerDocument(28);
            this.ifAutoIncrementMinValue.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_MIN_VALUE, this.ifAutoIncrementMinValue);
            this.ifAutoIncrementMaxValue = new JIntegerField();
            this.ifAutoIncrementMaxValue.setColumns(28);
            this.ifAutoIncrementMaxValue.setLargeIntegerDocument(28);
            this.ifAutoIncrementMaxValue.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_MAX_VALUE, this.ifAutoIncrementMaxValue);
            this.cbAutoIncrementCycle = new JComboBox<String>(YES_NO);
            this.cbAutoIncrementCycle.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_CYCLE, this.cbAutoIncrementCycle);
            this.cbAutoIncrementDisableCache = new JComboBox<String>(YES_NO);
            this.cbAutoIncrementDisableCache.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_DISABLE_CACHE, this.cbAutoIncrementDisableCache);
            this.ifAutoIncrementCache = new JIntegerField();
            this.ifAutoIncrementCache.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_CACHE, this.ifAutoIncrementCache);
            this.cbAutoIncrementDisableCache.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean disableCache = AbstractPropertiesDialog.YES.equals(ColumnPropertiesDialogEx.this.cbAutoIncrementDisableCache.getSelectedItem());
                    if (disableCache) {
                        ColumnPropertiesDialogEx.this.ifAutoIncrementCache.setValue(null);
                    } else {
                        ColumnPropertiesDialogEx.this.ifAutoIncrementCache.setValue(ColumnPropertiesDialogEx.this.column.getAutoIncrementCache());
                    }
                    ColumnPropertiesDialogEx.this.ifAutoIncrementCache.setEnabled(!disableCache);
                }
            });
            this.cbAutoIncrementOrder = new JComboBox<String>(YES_NO);
            this.cbAutoIncrementOrder.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_ORDER, this.cbAutoIncrementOrder);
            this.tfAutoIncrementSequenceName = new JTextField();
            this.tfAutoIncrementSequenceName.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_SEQUENCE_NAME, this.tfAutoIncrementSequenceName);
            this.tfAutoIncrementTriggerName = new JTextField();
            this.tfAutoIncrementTriggerName.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_TRIGGER_NAME, this.tfAutoIncrementTriggerName);
            this.chAutoIncrementGenerateTrigger = new JCheckBox();
            this.chAutoIncrementGenerateTrigger.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnInnerGrid, AUTO_INCREMENT_GENERATE_TRIGGER, this.chAutoIncrementGenerateTrigger);
            JPanel pnMain = new JPanel(new BorderLayout(10, 10));
            pnMain.add((Component)pnInnerGrid, "North");
            this.pnAutoIncrement.add((Component)pnMain, "Center");
            this.enableAutoIncrement(false);
        }
        return this.pnAutoIncrement;
    }

    protected void enableAutoIncrement(boolean enabled) {
        this.cbAutoIncrementGenerate.setEnabled(enabled);
        this.ifAutoIncrementStartWith.setEnabled(enabled);
        this.ifAutoIncrementIncrementBy.setEnabled(enabled);
        this.ifAutoIncrementMinValue.setEnabled(enabled);
        this.ifAutoIncrementMaxValue.setEnabled(enabled);
        this.cbAutoIncrementCycle.setEnabled(enabled);
        this.cbAutoIncrementDisableCache.setEnabled(enabled);
        this.ifAutoIncrementCache.setEnabled(enabled);
        this.cbAutoIncrementOrder.setEnabled(enabled);
        this.tfAutoIncrementSequenceName.setEnabled(enabled);
        this.tfAutoIncrementTriggerName.setEnabled(enabled);
        this.chAutoIncrementGenerateTrigger.setEnabled(enabled);
    }

    @Override
    protected void onCancel() {
        if (this.column.getCheck() != null && this.column.getCheck().isEmpty()) {
            this.column.setCheck(null);
        }
        if (this.column.getOwnValueList() != null && this.column.getOwnValueList().isEmpty()) {
            this.column.setOwnValueList(null);
        }
        this.column.setUseDomainConstraints(this.oldUseDomainConstraint);
        this.column.setGenerateConstraintInDDL(this.oldGenerateConstraintInDDL);
        super.onCancel();
    }

    protected JPanel getPermittedSubtypesPanel() {
        if (this.pnLevels == null) {
            this.pnLevels = this.createPage(Messages.getString("ColumnPropertiesDialogEx.PermittedSubtypes"));
            this.permittedTypes = new ArrayList();
            this.subTypes = new ArrayList();
            this.lTable = new JTable(new DataModel());
            this.lTable.setSelectionMode(0);
            this.lTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selRow = ColumnPropertiesDialogEx.this.lTable.getSelectedRow();
                    if (selRow == -1) {
                        ColumnPropertiesDialogEx.this.btnProperties.setEnabled(false);
                    } else {
                        ColumnPropertiesDialogEx.this.btnProperties.setEnabled(true);
                    }
                }
            });
            this.lTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ColumnPropertiesDialogEx.this.lTable.getSelectedRow()) != -1 && ColumnPropertiesDialogEx.this.subTypes.size() > 0 && row < ColumnPropertiesDialogEx.this.subTypes.size()) {
                        DesignObject dobj = (DesignObject)ColumnPropertiesDialogEx.this.subTypes.get(row);
                        dobj.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.lTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setEnabled(false);
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ColumnPropertiesDialogEx.this.lTable.getSelectedRow();
                    if (row != -1 && ColumnPropertiesDialogEx.this.subTypes.size() > 0 && row < ColumnPropertiesDialogEx.this.subTypes.size()) {
                        DesignObject dobj = (DesignObject)ColumnPropertiesDialogEx.this.subTypes.get(row);
                        dobj.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProperties);
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnLevels.add(pPanel);
        }
        return this.pnLevels;
    }

    protected JPanel getUIDefaultsPanel() {
        if (this.pnUIDefaults == null) {
            this.pnUIDefaults = this.createPage(Messages.getString("ColumnPropertiesDialogEx.UIDefaults"));
            JPanel pnUIDefaultsGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            this.tfDefaultLabel = new JTextField();
            this.tfDefaultLabel.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnUIDefaultsGrid, LABEL, this.tfDefaultLabel);
            this.tfDefaultFormatMask = new JTextField();
            this.tfDefaultFormatMask.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnUIDefaultsGrid, FORMAT_MASK, this.tfDefaultFormatMask);
            this.tfDefaultFormDisplayWidth = new JIntegerField();
            this.tfDefaultFormDisplayWidth.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnUIDefaultsGrid, FORM_DISPLAY_WIDTH, this.tfDefaultFormDisplayWidth);
            this.tfDefaultFormMaximumWidth = new JIntegerField();
            this.tfDefaultFormMaximumWidth.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnUIDefaultsGrid, FORM_MAXIMUM_WIDTH, this.tfDefaultFormMaximumWidth);
            this.cbDefaultDisplayAs = new JComboBox<String>(Column.DISPLAY_AS_DISPLAY);
            this.cbDefaultDisplayAs.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnUIDefaultsGrid, DISPLAY_AS, this.cbDefaultDisplayAs);
            this.tfDefaultFormHeight = new JIntegerField();
            this.tfDefaultFormHeight.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnUIDefaultsGrid, FORM_HEIGHT, this.tfDefaultFormHeight);
            this.chDefaultDisplayedOnForms = new JCheckBox();
            this.chDefaultDisplayedOnForms.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnUIDefaultsGrid, DISPLAYED_ON_FORMS, this.chDefaultDisplayedOnForms);
            this.chDefaultDisplayedOnReports = new JCheckBox();
            this.chDefaultDisplayedOnReports.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnUIDefaultsGrid, DISPLAYED_ON_REPORTS, this.chDefaultDisplayedOnReports);
            this.chDefaultReadOnly = new JCheckBox();
            this.chDefaultReadOnly.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnUIDefaultsGrid, READ_ONLY, this.chDefaultReadOnly);
            JPanel pnHelpText = new JPanel(new GridLayout(0, 1, 10, 10));
            this.taDefaultHelpText = new JTextArea();
            this.taDefaultHelpText.setEditable(this.isEditable());
            this.addRowToPanel(pnHelpText, HELP_TEXT, new JScrollPane(this.taDefaultHelpText));
            JPanel pnMain = new JPanel(new BorderLayout(10, 10));
            pnMain.add((Component)pnUIDefaultsGrid, "North");
            pnMain.add((Component)pnHelpText, "Center");
            this.pnUIDefaults.add((Component)pnMain, "Center");
        }
        return this.pnUIDefaults;
    }

    protected JPanel getSecurityPanel() {
        if (this.pnSecurity == null) {
            this.pnSecurity = this.createPage(SECURITY);
            JPanel pnSecurityGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            this.cbContainsPII = new JComboBox<String>(EMPTY_STRING_YES_NO);
            this.cbContainsPII.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnSecurityGrid, CONTAINS_PII_SHORT, this.cbContainsPII, CONTAINS_PII);
            this.cbContainsSensitiveInformation = new JComboBox<String>(EMPTY_STRING_YES_NO);
            this.cbContainsSensitiveInformation.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnSecurityGrid, CONTAINS_SENSITIVE_INFORMATION_SHORT, this.cbContainsSensitiveInformation, CONTAINS_SENSITIVE_INFORMATION);
            this.cbMaskData = new JComboBox();
            this.cbMaskData.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnSecurityGrid, MASKING_TYPE, this.cbMaskData, MASKING_TYPE);
            this.cbMaskData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnPropertiesDialogEx.this.updateMaskTemplates();
                }
            });
            this.cbMaskTemplate = new JComboBox();
            this.cbMaskTemplate.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(pnSecurityGrid, MASK_TEMPLATE, this.cbMaskTemplate, MASK_TEMPLATE);
            JPanel pnMain = new JPanel(new BorderLayout(10, 10));
            pnMain.add((Component)pnSecurityGrid, "North");
            this.pnSecurity.add((Component)pnMain, "Center");
        }
        return this.pnSecurity;
    }

    private void updateMaskingTypes() {
        this.cbMaskData.removeAllItems();
        Iterator it = this.getMTComboBoxItems().iterator();
        while (it.hasNext()) {
            this.cbMaskData.addItem(it.next());
        }
    }

    private List getMTComboBoxItems() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.column.isRedactionPolicyCompatible()) {
            result.addAll(Arrays.asList(Column.MASKING_TYPES));
        }
        return result;
    }

    private void updateMaskTemplates() {
        this.cbMaskTemplate.removeAllItems();
        this.cbMaskTemplate.addItem(null);
        List list = this.getComboBoxItems();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.cbMaskTemplate.addItem(it.next());
        }
        if (!this.initializing && this.column.getMaskTemplate() != null) {
            if (!list.contains(this.column.getMaskTemplate())) {
                this.column.setMaskTemplate(null);
            } else {
                this.cbMaskTemplate.setSelectedItem(this.column.getMaskTemplate());
            }
        }
    }

    private List getComboBoxItems() {
        ArrayList<MaskTemplate> result;
        block5: {
            String maskingType;
            block6: {
                String datatype;
                block8: {
                    block7: {
                        result = new ArrayList<MaskTemplate>();
                        maskingType = (String)this.cbMaskData.getSelectedItem();
                        if (maskingType == null) break block5;
                        if (!"PARTIAL".equalsIgnoreCase(maskingType)) break block6;
                        datatype = this.column.getDataTypeName();
                        if (datatype.indexOf("CHAR") <= -1) break block7;
                        Iterator it = this.getAppView().getMaskTemplateSet().iterator();
                        while (it.hasNext()) {
                            MaskTemplate mt = (MaskTemplate)it.next();
                            if (0 != mt.getFunctionType() || 0 != mt.getDataType()) continue;
                            result.add(mt);
                        }
                        break block5;
                    }
                    if (!"NUMBER".equalsIgnoreCase(datatype) && !"INTEGER".equalsIgnoreCase(datatype) && !"SMALLINT".equalsIgnoreCase(datatype) && !"FLOAT".equalsIgnoreCase(datatype) && !"BINARY_FLOAT".equalsIgnoreCase(datatype) && !"BINARY_DOUBLE".equalsIgnoreCase(datatype) && !"REAL".equalsIgnoreCase(datatype)) break block8;
                    Iterator it = this.getAppView().getMaskTemplateSet().iterator();
                    while (it.hasNext()) {
                        MaskTemplate mt = (MaskTemplate)it.next();
                        if (0 != mt.getFunctionType() || 1 != mt.getDataType()) continue;
                        result.add(mt);
                    }
                    break block5;
                }
                if (!"DATE".equalsIgnoreCase(datatype) && !datatype.startsWith("TIMESTAMP")) break block5;
                Iterator it = this.getAppView().getMaskTemplateSet().iterator();
                while (it.hasNext()) {
                    MaskTemplate mt = (MaskTemplate)it.next();
                    if (0 != mt.getFunctionType() || 2 != mt.getDataType()) continue;
                    result.add(mt);
                }
                break block5;
            }
            if ("REGEXP".equalsIgnoreCase(maskingType)) {
                Iterator it = this.getAppView().getMaskTemplateSet().iterator();
                while (it.hasNext()) {
                    MaskTemplate mt = (MaskTemplate)it.next();
                    if (1 != mt.getFunctionType()) continue;
                    result.add(mt);
                }
            }
        }
        return result;
    }

    @Override
    protected void addRowToPanel(JPanel panel, String labelResourceKey, JComponent rightComp) {
        this.addRowToPanel(panel, labelResourceKey, rightComp, null);
    }

    @Override
    protected void addRowToPanel(JPanel panel, String labelText, JComponent rightComp, String toolTipText) {
        JLabel label = new JLabel(labelText);
        label.setPreferredSize(this.getDefaultSize());
        if (toolTipText != null) {
            label.setToolTipText(toolTipText);
            rightComp.setToolTipText(toolTipText);
        }
        panel.add((Component)this.createRow(label, rightComp), "North");
    }

    private JPanel getImpactAnalysisPanel() {
        final ColumnPropertiesDialogEx owner = this;
        JPanel pnImpact = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = ColumnPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        if (obj instanceof AbstractMDObject) {
                            ((AbstractMDObject)obj).showPropertyDialog(owner);
                        } else {
                            obj.showPropertyDialog();
                        }
                    } else {
                        if (ColumnPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            ColumnPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            ColumnPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_Column(this.getColumn_forIA(), null, true), false);
        ImpactTreeRenderer renderer = new ImpactTreeRenderer();
        this.tree.setModel(treeDesign);
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    @Override
    protected boolean canExit() {
        int result;
        if (this.column.isInOptionalFK() && !this.chAllowNulls.isSelected() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("ColumnPropertiesDialogEx.TheColumnBelongsToPptionalFK"), Messages.getString("ColumnPropertiesDialogEx.ColumnInOptionalFK"), 0)) != 0) {
            return false;
        }
        return this.containsInteger(this.tfDefaultFormDisplayWidth, FORM_DISPLAY_WIDTH) && this.containsInteger(this.tfDefaultFormMaximumWidth, FORM_MAXIMUM_WIDTH) && this.containsInteger(this.tfDefaultFormHeight, FORM_HEIGHT) && super.canExit();
    }

    protected boolean containsInteger(JTextField textField, String fieldLabel) {
        String text = textField.getText();
        if (StringUtilities.isNotEmpty(text) && !text.matches("\\d+")) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("ColumnPropertiesDialogEx.InvalidInteger"), fieldLabel));
            textField.requestFocus();
            return false;
        }
        return true;
    }

    private Column getColumn_forIA() {
        Column col = (Column)((RelationalDesign)this.column.getDesignPart()).getColumnSet().getObjectByID(this.column.getObjectID());
        if (col != null) {
            return col;
        }
        return this.column;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ColumnPropertiesDialogEx.this.subTypes.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ColumnPropertiesDialogEx.Permitted");
            }
            if (column == 1) {
                return Messages.getString("ColumnPropertiesDialogEx.Name");
            }
            return ColumnPropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!ColumnPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StructuredType st = (StructuredType)ColumnPropertiesDialogEx.this.subTypes.get(row);
            if (col == 1) {
                return st.getName();
            }
            if (col == 0) {
                return ColumnPropertiesDialogEx.this.permittedTypes.contains(st);
            }
            return ColumnPropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            StructuredType st = (StructuredType)ColumnPropertiesDialogEx.this.subTypes.get(row);
            if (col == 0) {
                if (((Boolean)aValue).booleanValue()) {
                    if (!ColumnPropertiesDialogEx.this.permittedTypes.contains(st)) {
                        ColumnPropertiesDialogEx.this.permittedTypes.add(st);
                    }
                } else {
                    ColumnPropertiesDialogEx.this.permittedTypes.remove(st);
                }
            }
        }
    }

    private class DatatypeListener
    implements ChangeListener {
        private DatatypeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            ColumnPropertiesDialogEx.this.initScope();
            ColumnPropertiesDialogEx.this.cbTypeSubstitution.setEnabled(ColumnPropertiesDialogEx.this.column.getDataType() instanceof StructuredType || ColumnPropertiesDialogEx.this.column.getDataType() instanceof CollectionType);
        }
    }

    private class ExpressionEnableListener
    implements ActionListener {
        private ExpressionEnableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String type = (String)ColumnPropertiesDialogEx.this.cbSourceType.getSelectedItem();
            if (ColumnPropertiesDialogEx.this.chComputed.isSelected() || type != null && (type.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || type.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE))) {
                ColumnPropertiesDialogEx.this.tfFormulaDesc.setEnabled(true);
            } else {
                ColumnPropertiesDialogEx.this.tfFormulaDesc.setEnabled(false);
                ColumnPropertiesDialogEx.this.tfFormulaDesc.setText(ColumnPropertiesDialogEx.EMPTY_VALUE);
            }
        }
    }
}

