/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class FKColumnsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3606942481591565508L;
    final String[] COL_NAMES = new String[]{Messages.getString("FKColumnsTableModel.ReferencedColumn"), Messages.getString("FKColumnsTableModel.Column")};
    private Column[] fkColumns;
    private KeyObject currentKey;

    public FKColumnsTableModel() {
        this(null, null);
    }

    public Column[] getFkColumns() {
        return this.fkColumns;
    }

    public FKColumnsTableModel(Column[] fkColumns, KeyObject currentKey) {
        this.fkColumns = fkColumns;
        this.currentKey = currentKey;
    }

    public void init(KeyObject currentKey) {
        this.currentKey = currentKey;
    }

    public void init(Column[] fkColumns, KeyObject currentKey) {
        this.fkColumns = fkColumns;
        this.currentKey = currentKey;
    }

    @Override
    public int getColumnCount() {
        return this.COL_NAMES.length;
    }

    @Override
    public int getRowCount() {
        if (this.currentKey != null && this.currentKey.getElements() != null) {
            return this.currentKey.getElements().length;
        }
        return 0;
    }

    public void dataChanged() {
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return this.COL_NAMES[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.currentKey.getElements()[row];
        }
        if (this.fkColumns != null && this.fkColumns.length > 0 && row < this.fkColumns.length) {
            return this.fkColumns[row];
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            this.fkColumns[row] = (Column)value;
        }
    }
}

