/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class FKUtilities {
    public static String generateFKName(FKIndexAssociation fk, int fkNumber) {
        Table parentTable = (Table)fk.getSourceObject();
        Table table = (Table)fk.getTargetObject();
        String childName = table.getName();
        NamingStandardRule namingStandardRule = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
        String relModelName = table.getDesignPart().getName();
        String abbreviation = table.getAbbreviation();
        Relation rel = fk.getEngRelation();
        String relName = null;
        if (rel != null) {
            relName = rel.getName();
            char logSep = namingStandardRule.getLogicalSeparatorChar();
            char relSep = namingStandardRule.getRelationalSeparatorChar();
            relName = AbstractEngineering.transformSeparatorFromLogical(relName, logSep, relSep);
        }
        return ApplyNamingStandards.createFK_Name(childName, parentTable, fkNumber, namingStandardRule, relModelName, abbreviation, relName);
    }

    public static String generateFKName(Table table, Table parentTable, List<FKIndexAssociation.FKMemento> fkList) {
        String childName = table.getName();
        NamingStandardRule namingStandardRule = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
        String relModelName = table.getDesignPart().getName();
        String abbreviation = table.getAbbreviation();
        String indexName = "";
        String lastGeneratedIndexName = null;
        int count = fkList.size();
        while (!(indexName = ApplyNamingStandards.createFK_Name(childName, parentTable, count, namingStandardRule, relModelName, abbreviation, null)).equals(lastGeneratedIndexName)) {
            lastGeneratedIndexName = indexName;
            ++count;
            if (FKUtilities.hasFK_Name(fkList, indexName)) continue;
        }
        return indexName;
    }

    public static boolean hasFK_Name(List<FKIndexAssociation.FKMemento> fkList, String name) {
        for (FKIndexAssociation.FKMemento fkMemento : fkList) {
            if (!fkMemento.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String generateFKName(Table table, Table parentTable, KeyObject parentKey) {
        FKIndexAssociation[] fkeys = table.getFKAssociations();
        int count = fkeys.length - 1;
        String childName = table.getName();
        NamingStandardRule namingStandardRule = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
        String relModelName = table.getDesignPart().getName();
        String abbreviation = table.getAbbreviation();
        String indexName = "";
        String lastGeneratedIndexName = null;
        while (!(indexName = ApplyNamingStandards.createFK_Name(childName, parentTable, parentKey, count, namingStandardRule, relModelName, abbreviation, null)).equals(lastGeneratedIndexName)) {
            lastGeneratedIndexName = indexName;
            ++count;
            if (FKUtilities.hasFK_Name(fkeys, indexName)) continue;
        }
        return indexName;
    }

    public static boolean hasFK_Name(FKIndexAssociation[] fkeys, String name) {
        for (int i = 0; i < fkeys.length; ++i) {
            if (!fkeys[i].getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean compatibleColumns(Column col1, Column col2) {
        if (col1.isOid() && col1.getContainerWithKeyObject().getBasedOnStructuredType() != null) {
            return col2.isRefToStructuredType(col1.getContainerWithKeyObject().getBasedOnStructuredType());
        }
        return col1.getDataType().getName().equalsIgnoreCase(col2.getDataType().getName());
    }

    public static boolean hasPKColumns(FKIndexAssociation fk) {
        KeyObject pk = fk.getContainerWithKeyObject().getPK();
        if (pk != null && fk.getLocalFKIndex() != null) {
            for (ContainedObject co : fk.getLocalFKIndex().getElementsCollection()) {
                if (!pk.contains(co)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPKColumnsOnly(FKIndexAssociation fk) {
        KeyObject pk = fk.getContainerWithKeyObject().getPK();
        if (pk == null) {
            return false;
        }
        if (pk != null && fk.getLocalFKIndex() != null) {
            for (ContainedObject co : fk.getLocalFKIndex().getElementsCollection()) {
                if (pk.contains(co)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasPKColumnsOnly(FKIndexAssociation fk, Column[] fkColumns) {
        KeyObject pk = fk.getContainerWithKeyObject().getPK();
        if (pk == null) {
            return false;
        }
        if (pk != null && fk.getLocalFKIndex() != null) {
            for (Column co : fkColumns) {
                if (pk.contains(co)) continue;
                return false;
            }
        }
        return true;
    }

    public static Column[] getCompatibleColumns(ContainerWithKeyObject container, Column column) {
        ArrayList columns = container.getElementsCollection();
        List nestedColumns = container.getNestedElements();
        if (nestedColumns.size() > 0) {
            columns = new ArrayList(columns);
            columns.addAll(nestedColumns);
        }
        return FKUtilities.getCompatibleColumns(columns, column);
    }

    public static Column[] getCompatibleColumns(Collection<Column> columns, Column column) {
        ArrayList<Column> col = new ArrayList<Column>();
        for (Column currentColumn : columns) {
            if (!FKUtilities.compatibleColumns(column, currentColumn)) continue;
            col.add(currentColumn);
        }
        return col.toArray(new Column[0]);
    }

    public static boolean hasMandatoryColumns(Column[] fkColumns) {
        for (int i = 0; i < fkColumns.length; ++i) {
            if (fkColumns[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRequiredProperties(Component messageDialogParent, Column[] fkColumns, FKIndexAssociation fkIndexAssociation, boolean mandatory, boolean transferable) {
        int i;
        if (fkColumns == null || fkColumns.length == 0) {
            JOptionPane.showMessageDialog(messageDialogParent, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.IncompleteFKdefinition", fkIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnsAssignment"), 0);
            return false;
        }
        for (i = 0; i < fkColumns.length; ++i) {
            if (fkColumns[i] != null) continue;
            JOptionPane.showMessageDialog(messageDialogParent, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.IncompleteFKdefinition", fkIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnsAssignment"), 0);
            return false;
        }
        if (FKUtilities.hasPKColumnsOnly(fkIndexAssociation, fkColumns) && !mandatory) {
            JOptionPane.showMessageDialog(messageDialogParent, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.FKCannotBeOptional", fkIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnsInPK"), 0);
            return false;
        }
        if (FKUtilities.hasMandatoryColumns(fkColumns) && !mandatory) {
            int result = JOptionPane.showConfirmDialog(messageDialogParent, FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.FKIsOptional", fkIndexAssociation.getName()), Messages.getString("ForeignKeyPropertiesDialogEx.MandatoryFKColumns"), 0);
            return result == 0;
        }
        for (i = 0; i < fkColumns.length; ++i) {
            for (FKIndexAssociation fk : fkColumns[i].getAllFKs()) {
                if (fk == fkIndexAssociation || fk.isTransferable() == transferable) continue;
                JOptionPane.showMessageDialog(messageDialogParent, MessageFormat.format(FKUtilities.formatMessage("ForeignKeyPropertiesDialogEx.Column", fkIndexAssociation.getName()), fkColumns[i].getName()), Messages.getString("ForeignKeyPropertiesDialogEx.FKColumnCollisionalUsage"), 0);
                return false;
            }
        }
        return true;
    }

    public static String formatMessage(String messageKey, String fkName) {
        return MessageFormat.format(Messages.getString(messageKey), fkName);
    }

    public static Column[] getFKColumns(FKIndexAssociation.FKMemento fkMemento) {
        return FKUtilities.getFKColumns(fkMemento, null);
    }

    public static Column[] getFKColumns(FKIndexAssociation.FKMemento fkMemento, List<Column> newColumns) {
        Column[] fkColumns = new Column[fkMemento.columns.size()];
        for (int i = 0; i < fkMemento.columns.size(); ++i) {
            String columnID = fkMemento.columns.get(i);
            Column column = null;
            if (columnID != null && (column = (Column)fkMemento.table.getElementByID(columnID)) == null && newColumns != null) {
                column = FKUtilities.getColumn(columnID, newColumns);
            }
            fkColumns[i] = column;
        }
        return fkColumns;
    }

    public static Column[] getFKColumnsFromTable(FKIndexAssociation.FKMemento fkMemento, Table table) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (int i = 0; i < fkMemento.columns.size(); ++i) {
            String columnID = fkMemento.columns.get(i);
            Column column = null;
            if (columnID == null || (column = (Column)table.getElementByID(columnID)) == null) continue;
            list.add(column);
        }
        return list.toArray(new Column[0]);
    }

    public static Column getColumn(String columnID, List<Column> columns) {
        for (Column column : columns) {
            if (!columnID.equals(column.getObjectID())) continue;
            return column;
        }
        return null;
    }

    public static boolean containsEmptyColumns(FKIndexAssociation.FKMemento fkMemento) {
        if (fkMemento.columns.isEmpty()) {
            return true;
        }
        for (String columnID : fkMemento.columns) {
            if (columnID != null && !columnID.equals("")) continue;
            return true;
        }
        return false;
    }
}

