/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.impact.ImpA_FKAssociation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.undo.relational.FKUpdateEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.FKColumnsCellEditor;
import oracle.dbtools.crest.swingui.editor.relational.FKColumnsTableModel;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ForeignKeyPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final long serialVersionUID = 6498069064076573019L;
    private FKIndexAssociation newFKIass;
    private FKIndexAssociation oldFKIass;
    private KeyObject oldKey;
    private JTextField tfLongName;
    private JTextField tfDiscrValue;
    private JComboBox cbIndexPkUk;
    private JComboBox cbDeleteRule;
    private JComboBox cbDiscrimanatorCiolumn;
    private JComboBox cbSourceTableSynonym;
    private JComboBox cbTargetTableSynonym;
    private JCheckBox chMarkGenerate;
    private JCheckBox chMandatory;
    private JCheckBox chTransferable;
    private JCheckBox chInArc;
    private Column[] fkColumns;
    private JTable columnsTable;
    private JTable columnsDependencyConstraintTable;
    private JPanel pnColumns;
    private JPanel pnColumnsDependencyConstraint;
    private JTree tree;
    private FKIndexAssociation.FKMemento mem;
    private FKIndexAssociation.FKMemento memBackup;
    private static final Dimension defaultSize = new Dimension(200, 20);
    private List dependantColumnsList;
    private DesignObject obj;
    private JTextField txtCDCName;
    private JCheckBox chCDCGenerateInDDL;
    private JCheckBox chbDeprecated;
    private static final Logger LOGGER = new Logger(ForeignKeyPropertiesDialogEx.class);
    private KeyObject currentKey = null;
    private Action statusChanged = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            StorageDesign sd = ((RelationalDesign)ForeignKeyPropertiesDialogEx.this.oldFKIass.getDesignPart()).getStorageDesign();
            Object object = ForeignKeyPropertiesDialogEx.this.cbDeleteRule.getSelectedItem();
            ForeignKeyPropertiesDialogEx.this.cbDeleteRule.removeAllItems();
            if (!ForeignKeyPropertiesDialogEx.this.chTransferable.isSelected()) {
                ForeignKeyPropertiesDialogEx.this.fillComboItems(sd.getFKDeleteRulesNonTransferable(), ForeignKeyPropertiesDialogEx.this.cbDeleteRule, false);
                if ("CASCADE".equalsIgnoreCase((String)object)) {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem("CASCADE");
                } else {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem("RESTRICT");
                }
            } else if (ForeignKeyPropertiesDialogEx.this.chMandatory.isSelected()) {
                ForeignKeyPropertiesDialogEx.this.fillComboItems(sd.getFKDeleteRulesMandatory(), ForeignKeyPropertiesDialogEx.this.cbDeleteRule, false);
                if ("SET NULL".equalsIgnoreCase((String)object)) {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem("RESTRICT");
                } else if ("SET DEFAULT".equalsIgnoreCase((String)object)) {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem(sd.getValidFKRule("SET DEFAULT"));
                } else {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem(sd.getValidFKRule((String)object));
                }
            } else {
                ForeignKeyPropertiesDialogEx.this.fillComboItems(sd.getFKDeleteRules(), ForeignKeyPropertiesDialogEx.this.cbDeleteRule, false);
                ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem(sd.getValidFKRule((String)object));
            }
        }
    };

    public ForeignKeyPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
        this.obj = object;
    }

    public ForeignKeyPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object, FKIndexAssociation.FKMemento mem) {
        super(owner, view, mem.fk);
        this.initGeneral();
        this.obj = object;
        this.mem = mem;
    }

    @Override
    public String getCaption() {
        return Messages.getString("ForeignKeyPropertiesDialogEx.ForeignKeyProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof FKIndexAssociation) {
            this.oldFKIass = (FKIndexAssociation)object;
            this.oldKey = this.oldFKIass.getKeyObject();
            this.memBackup = this.oldFKIass.getFKMemento(this.oldFKIass.getTopView().getDesignPartView());
            this.obj.setShowForFirstTime(true);
            this.initDefaults(false);
            this.initSummaryExtras();
            this.tfLongName.setText(this.oldFKIass.getContainerWithKeyObject().getLongName());
            Object[] keys = ((RelationalDesign)this.oldFKIass.getDesignPart()).getGlobalIndexSet().getPKUK();
            Arrays.sort(keys, ModelObjectSet.LONG_NAME_COMPARATOR);
            this.fillComboItems(keys, this.cbIndexPkUk, false);
            this.cbIndexPkUk.setSelectedItem(this.oldFKIass.getKeyObject());
            this.currentKey = this.oldFKIass.getKeyObject();
            this.cbIndexPkUk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyObject key = (KeyObject)ForeignKeyPropertiesDialogEx.this.cbIndexPkUk.getSelectedItem();
                    if (ForeignKeyPropertiesDialogEx.this.currentKey != key) {
                        ForeignKeyPropertiesDialogEx.this.newFKIass = ForeignKeyPropertiesDialogEx.this.replaceFK(ForeignKeyPropertiesDialogEx.this.obj, key);
                        ForeignKeyPropertiesDialogEx.this.obj = ForeignKeyPropertiesDialogEx.this.newFKIass;
                        ForeignKeyPropertiesDialogEx.this.currentKey = key;
                        ForeignKeyPropertiesDialogEx.this.initParentChildColumns(ForeignKeyPropertiesDialogEx.this.newFKIass, key);
                        ForeignKeyPropertiesDialogEx.this.columnsTable.updateUI();
                        TopView tv = (TopView)ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.getSelectedItem();
                        TopViewCollection col = key.getContainerWithKeyObject().getViewsForDPV(tv.getDesignPartView());
                        ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setModel(new DefaultComboBoxModel<Object>(col.toArray()));
                        if (col.size() > 0) {
                            ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setSelectedItem(col.get(0));
                        }
                    }
                }
            });
            StorageDesign sd = ((RelationalDesign)this.oldFKIass.getDesignPart()).getStorageDesign();
            if (!this.oldFKIass.isTransferable()) {
                this.fillComboItems(sd.getFKDeleteRulesNonTransferable(), this.cbDeleteRule, false);
            } else if (this.oldFKIass.isMandatory()) {
                this.fillComboItems(sd.getFKDeleteRulesMandatory(), this.cbDeleteRule, false);
            } else {
                this.fillComboItems(sd.getFKDeleteRules(), this.cbDeleteRule, false);
            }
            this.cbDeleteRule.setSelectedItem(sd.getValidFKRule(this.oldFKIass.getDeleteRule()));
            DesignPartView dpv = this.getAppView().getCurrentDPV();
            if (this.oldFKIass.getRemoteTable().getDesignPart() != dpv.getDesignPart()) {
                dpv = this.oldFKIass.getRemoteTable().getDesignPart().getMainView();
            }
            this.fillComboItems(this.oldFKIass.getRemoteTable().getViewsForDPV(dpv).toArray(), this.cbSourceTableSynonym, false);
            this.cbSourceTableSynonym.setSelectedItem(this.oldFKIass.getSourceTV(dpv));
            dpv = this.getAppView().getCurrentDPV();
            if (this.oldFKIass.getContainerWithKeyObject().getDesignPart() != dpv.getDesignPart()) {
                dpv = this.oldFKIass.getContainerWithKeyObject().getDesignPart().getMainView();
            }
            this.fillComboItems(this.oldFKIass.getContainerWithKeyObject().getViewsForDPV(dpv).toArray(), this.cbTargetTableSynonym, false);
            this.cbTargetTableSynonym.setSelectedItem(this.oldFKIass.getTargetTV(dpv));
            this.chMarkGenerate.setSelected(this.oldFKIass.getLocalFKIndex().isMarkedGenerate());
            this.chMandatory.setSelected(this.oldFKIass.isMandatory());
            this.chTransferable.setSelected(this.oldFKIass.isTransferable());
            this.chbDeprecated.setSelected(this.oldFKIass.isDeprecated());
            this.chInArc.setSelected(this.oldFKIass.isInArc());
            this.initParentChildColumns();
            if (this.oldFKIass.isInArc() || FKUtilities.hasPKColumnsOnly(this.oldFKIass)) {
                this.chMandatory.setEnabled(false);
            }
            this.chMandatory.addActionListener(this.statusChanged);
            this.chTransferable.addActionListener(this.statusChanged);
            this.fillComboItems(this.oldFKIass.getRemoteTable().getElements(), this.cbDiscrimanatorCiolumn, true);
            this.cbDiscrimanatorCiolumn.setSelectedItem(this.oldFKIass.getDiscriminatorColumn());
            this.dynamicPropertiesList.clear();
            Iterator it = this.oldFKIass.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.oldFKIass.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
            this.txtCDCName.setText(this.oldFKIass.getColumnDependencyConstraintGenerateName());
            this.chCDCGenerateInDDL.setSelected(this.oldFKIass.isColumnDependencyConstraintGenerateInDDL());
        }
    }

    private void initDefaults(FKIndexAssociation.FKMemento mem) {
        this.tfName.setText(mem.name);
        if (mem.name_fixed) {
            this.tfName.setEnabled(false);
            this.tfName.setToolTipText(NAME_IS_FROZEN);
        }
        this.taComments.setText(mem.comments);
        this.taNotes.setText(mem.notes);
        this.tfObjectID.setText(mem.id);
        this.tfCreationTime.setText(this.oldFKIass.getCreationTime());
        this.tfCreator.setText(this.oldFKIass.getCreator().getName());
        this.tfDesign.setText(this.oldFKIass.getOwnerDesignName());
        if (this.oldFKIass.getGenerator() != null) {
            this.tfGeneratorName.setText(this.oldFKIass.getGeneratorLongName());
        } else {
            this.tfGeneratorName.setText(NONE);
        }
        this.tfLastChangedBy.setText(this.oldFKIass.getChanger().getName());
        this.tfLastChangedTime.setText(this.oldFKIass.getChangeTime());
    }

    public void initProperties(FKIndexAssociation.FKMemento mem) {
        this.oldFKIass = mem.fk;
        this.oldKey = this.oldFKIass.getKeyObject();
        this.mem = mem;
        FKIndexAssociation fKIndexAssociation = mem.fk;
        fKIndexAssociation.getClass();
        this.memBackup = fKIndexAssociation.new FKIndexAssociation.FKMemento(mem.fk);
        mem.copyTo(this.memBackup);
        this.obj.setShowForFirstTime(false);
        this.initDefaults(mem);
        this.initSummaryExtras();
        this.tfLongName.setText(this.oldFKIass.getContainerWithKeyObject().getLongName());
        Object[] keys = ((RelationalDesign)this.oldFKIass.getDesignPart()).getGlobalIndexSet().getPKUK();
        Arrays.sort(keys, ModelObjectSet.LONG_NAME_COMPARATOR);
        this.fillComboItems(keys, this.cbIndexPkUk, false);
        this.cbIndexPkUk.setSelectedItem(mem.remoteKey);
        this.currentKey = mem.remoteKey;
        this.cbIndexPkUk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyObject key = (KeyObject)ForeignKeyPropertiesDialogEx.this.cbIndexPkUk.getSelectedItem();
                if (ForeignKeyPropertiesDialogEx.this.currentKey != key) {
                    ForeignKeyPropertiesDialogEx.this.newFKIass = ForeignKeyPropertiesDialogEx.this.replaceFK(ForeignKeyPropertiesDialogEx.this.obj, key);
                    ForeignKeyPropertiesDialogEx.this.obj = ForeignKeyPropertiesDialogEx.this.newFKIass;
                    ForeignKeyPropertiesDialogEx.this.currentKey = key;
                    ForeignKeyPropertiesDialogEx.this.initParentChildColumns(ForeignKeyPropertiesDialogEx.this.newFKIass, key);
                    ForeignKeyPropertiesDialogEx.this.columnsTable.updateUI();
                    TopView tv = (TopView)ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.getSelectedItem();
                    TopViewCollection col = key.getContainerWithKeyObject().getViewsForDPV(tv.getDesignPartView());
                    ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setModel(new DefaultComboBoxModel<Object>(col.toArray()));
                    if (col.size() > 0) {
                        ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setSelectedItem(col.get(0));
                    }
                }
            }
        });
        StorageDesign sd = ((RelationalDesign)this.oldFKIass.getDesignPart()).getStorageDesign();
        if (!mem.transferable) {
            this.fillComboItems(sd.getFKDeleteRulesNonTransferable(), this.cbDeleteRule, false);
        } else if (this.oldFKIass.isMandatory()) {
            this.fillComboItems(sd.getFKDeleteRulesMandatory(), this.cbDeleteRule, false);
        } else {
            this.fillComboItems(sd.getFKDeleteRules(), this.cbDeleteRule, false);
        }
        this.cbDeleteRule.setSelectedItem(sd.getValidFKRule(mem.deleteRule));
        DesignPartView dpv = this.getAppView().getCurrentDPV();
        Table oldRemoteTable = this.oldFKIass.getRemoteTable();
        if (dpv != null && oldRemoteTable != null && this.oldFKIass.getRemoteTable().getDesignPart() != dpv.getDesignPart() || dpv == null) {
            dpv = this.oldFKIass.getRemoteTable().getDesignPart().getMainView();
        }
        if (mem.remoteTable != null) {
            this.fillComboItems(mem.remoteTable.getViewsForDPV(dpv).toArray(), this.cbSourceTableSynonym, false);
        }
        this.cbSourceTableSynonym.setSelectedItem(mem.sourceTV);
        this.fillComboItems(this.oldFKIass.getContainerWithKeyObject().getViewsForDPV(dpv).toArray(), this.cbTargetTableSynonym, false);
        this.cbTargetTableSynonym.setSelectedItem(mem.targetTV);
        this.chMarkGenerate.setSelected(mem.generate_in_DDL);
        this.chMandatory.setSelected(mem.mandatory);
        this.chTransferable.setSelected(mem.transferable);
        this.chInArc.setSelected(mem.arc != null);
        this.chbDeprecated.setSelected(mem.cdcDeprecated);
        this.initParentChildColumns();
        if (this.oldFKIass.isInArc() || FKUtilities.hasPKColumnsOnly(this.oldFKIass)) {
            this.chMandatory.setEnabled(false);
        }
        this.chMandatory.addActionListener(this.statusChanged);
        this.chTransferable.addActionListener(this.statusChanged);
        if (this.oldFKIass.getRemoteTable() != null) {
            this.fillComboItems(this.oldFKIass.getRemoteTable().getElements(), this.cbDiscrimanatorCiolumn, true);
        }
        this.cbDiscrimanatorCiolumn.setSelectedItem(mem.discrColumn);
        this.tfDiscrValue.setText(mem.discrValue);
        this.dynamicPropertiesList.clear();
        Iterator it = this.oldFKIass.getPropertyNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            String value = this.oldFKIass.getProperty(propName);
            DynamicProperty dynamicProperty = new DynamicProperty(propName, value);
            this.dynamicPropertiesList.add(dynamicProperty);
        }
        this.dynamicPropertiesTable.updateUI();
        Table table = (Table)this.oldFKIass.getContainerWithKeyObject();
        for (Column column : Arrays.asList(table.getElements())) {
            if (Arrays.asList(this.fkColumns).contains(column)) continue;
            this.dependantColumnsList.add(column);
        }
        CDCTableModel cDCTableModel = new CDCTableModel((FKIndexAssociation)this.obj);
        this.columnsDependencyConstraintTable.setModel(cDCTableModel);
        TableColumn col1 = this.columnsDependencyConstraintTable.getColumnModel().getColumn(1);
        col1.setMinWidth(90);
        col1.setMaxWidth(90);
        col1.setPreferredWidth(90);
        TableColumn col2 = this.columnsDependencyConstraintTable.getColumnModel().getColumn(2);
        col2.setMinWidth(90);
        col2.setMaxWidth(90);
        col2.setPreferredWidth(90);
        this.txtCDCName.setText(mem.cdcName);
        this.chCDCGenerateInDDL.setSelected(mem.cdcGenerateInDDL);
    }

    private void initParentChildColumns() {
        if (this.mem != null) {
            this.fkColumns = FKUtilities.getFKColumns(this.mem);
            Index ind = this.mem.fk.getRemoteIndex();
            if (ind != null && ind.getElementsCollection().size() != this.fkColumns.length) {
                Column[] oldFKColumns = this.fkColumns;
                this.fkColumns = new Column[ind.getElementsCollection().size()];
                for (int i = 0; i < oldFKColumns.length && i < this.fkColumns.length; ++i) {
                    this.fkColumns[i] = oldFKColumns[i];
                }
            }
        } else {
            Column[] cols = (Column[])this.oldFKIass.getLocalFKIndex().getElements();
            Index remoteIndex = this.oldFKIass.getRemoteIndex();
            int noOfCols = remoteIndex != null ? remoteIndex.size() : cols.length;
            this.fkColumns = new Column[noOfCols];
            for (int i = 0; i < noOfCols && i < cols.length; ++i) {
                this.fkColumns[i] = cols[i];
            }
        }
        this.refreshColumnsPanel();
    }

    private void initParentChildColumns(FKIndexAssociation newFK, KeyObject newKey) {
        Column[] cols = (Column[])newFK.getLocalFKIndex().getElements();
        Index remoteIndex = newFK.getRemoteIndex();
        int noOfCols = remoteIndex != null ? remoteIndex.size() : cols.length;
        this.fkColumns = new Column[noOfCols];
        for (int i = 0; i < noOfCols && i < cols.length; ++i) {
            this.fkColumns[i] = cols[i];
        }
        this.refreshColumnsPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FKIndexAssociation replaceFK(DesignObject oldObj, KeyObject newKey) {
        if (oldObj instanceof FKIndexAssociation) {
            FKIndexAssociation oldFK = (FKIndexAssociation)oldObj;
            Table childTable = (Table)oldFK.getContainerWithKeyObject();
            try {
                if (oldObj.showForFirstTime()) {
                    oldFK.setSilentRemove(true);
                }
                oldFK.getLocalFKIndex().remove();
            }
            finally {
                if (oldObj.showForFirstTime()) {
                    oldFK.setSilentRemove(false);
                }
            }
            FKIndexAssociation newFK = childTable.addFK(newKey);
            newFK.setShowForFirstTime(oldObj.showForFirstTime());
            return newFK;
        }
        return null;
    }

    public boolean changed() {
        return this.mem != null && !this.mem.equals(this.memBackup);
    }

    @Override
    protected void setProperties() {
        try {
            ForeignKeyPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
            if (this.mem != null) {
                this.mem.fk = (FKIndexAssociation)this.obj;
                this.mem.name = this.tfName.getText();
                this.mem.comments = this.taComments.getText();
                this.mem.notes = this.taNotes.getText();
                this.mem.remoteKey = (Index)this.cbIndexPkUk.getSelectedItem();
                this.mem.deleteRule = (String)this.cbDeleteRule.getSelectedItem();
                this.mem.sourceTV = (TVTable)this.cbSourceTableSynonym.getSelectedItem();
                this.mem.targetTV = (TVTable)this.cbTargetTableSynonym.getSelectedItem();
                this.mem.generate_in_DDL = this.chMarkGenerate.isSelected();
                this.mem.mandatory = this.chMandatory.isSelected();
                this.mem.transferable = this.chTransferable.isSelected();
                this.mem.columns.clear();
                for (int i = 0; i < this.fkColumns.length; ++i) {
                    this.mem.columns.add(this.fkColumns[i].getObjectID());
                }
                this.tfLongName.setText(this.oldFKIass.getContainerWithKeyObject().getName());
                this.mem.discrColumn = (Column)this.cbDiscrimanatorCiolumn.getSelectedItem();
                this.mem.discrValue = this.tfDiscrValue.getText();
                this.mem.cdcName = this.txtCDCName.getText();
                this.mem.cdcGenerateInDDL = this.chCDCGenerateInDDL.isSelected();
                this.mem.cdcDeprecated = this.chbDeprecated.isSelected();
                this.mem.fk.clearProperties();
                for (DynamicProperty dp : this.dynamicPropertiesList) {
                    this.mem.fk.setProperty(dp.getName(), dp.getValue());
                }
                FKUpdateEdit edit = new FKUpdateEdit(this.mem.fk, this.mem);
                edit.applyUpdates();
                this.mem.fk.getDesignPart().postUndoableEdit(edit);
                this.mem.fk.updateRemoteObjectListeners();
            } else {
                FKIndexAssociation newFK = (FKIndexAssociation)this.obj;
                newFK.setName(this.tfName.getText());
                newFK.setComment(this.taComments.getText());
                newFK.setNotes(this.taNotes.getText());
                newFK.setKeyObject((Index)this.cbIndexPkUk.getSelectedItem());
                newFK.setDeleteRule((String)this.cbDeleteRule.getSelectedItem());
                newFK.setSourceTopView((TVTable)this.cbSourceTableSynonym.getSelectedItem());
                newFK.setTargetTopView((TVTable)this.cbTargetTableSynonym.getSelectedItem());
                newFK.setMarkedGenerate(this.chMarkGenerate.isSelected());
                newFK.setDeprecated(this.chbDeprecated.isSelected());
                newFK.setMandatory(this.chMandatory.isSelected());
                newFK.setTransferable(this.chTransferable.isSelected());
                newFK.changeKeyObject((KeyObject)this.cbIndexPkUk.getSelectedItem(), this.fkColumns);
                newFK.setDiscriminatorColumn((Column)this.cbDiscrimanatorCiolumn.getSelectedItem());
                newFK.setDiscriminatorValue(this.tfDiscrValue.getText());
                newFK.setColumnDependencyConstraintGenerateName(this.txtCDCName.getText());
                newFK.setColumnDependencyConstraintGenerateInDDL(this.chCDCGenerateInDDL.isSelected());
                newFK.clearProperties();
                for (DynamicProperty dp : this.dynamicPropertiesList) {
                    newFK.setProperty(dp.getName(), dp.getValue());
                }
                FKUpdateEdit edit = new FKUpdateEdit(newFK, this.mem);
                edit.apply();
                newFK.getDesignPart().postUndoableEdit(edit);
                newFK.updateRemoteObjectListeners();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error setting FK's properties!", e);
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getColumnsPanel());
        this.addToTree(root, this.getColumnsDependencyConstraintPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "FOREIGN_KEY_PROPERTIES_DIALOG";
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    private void initGeneral() {
        this.lbName.setPreferredSize(defaultSize);
        JLabel lbLongName = new JLabel(LB_TABLE);
        lbLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbLongName, this.tfLongName));
        JLabel lbIndexPkUk = new JLabel(LB_INDEX_PK_UK);
        lbIndexPkUk.setPreferredSize(this.getDefaultSize());
        this.cbIndexPkUk = new JComboBox();
        this.cbIndexPkUk.setPreferredSize(this.getDefaultSize());
        this.cbIndexPkUk.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbIndexPkUk, this.cbIndexPkUk));
        JLabel lbDeleteRule = new JLabel(LB_DELETE_RULE);
        lbDeleteRule.setPreferredSize(this.getDefaultSize());
        this.cbDeleteRule = new JComboBox();
        this.cbDeleteRule.setPreferredSize(this.getDefaultSize());
        this.cbDeleteRule.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbDeleteRule, this.cbDeleteRule));
        JLabel lbSourceTableSynonym = new JLabel(LB_SOURCE_TABLE_SYNONYM);
        lbSourceTableSynonym.setPreferredSize(this.getDefaultSize());
        this.cbSourceTableSynonym = new JComboBox();
        this.cbSourceTableSynonym.setPreferredSize(this.getDefaultSize());
        this.cbSourceTableSynonym.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbSourceTableSynonym, this.cbSourceTableSynonym));
        JLabel lbTargetTableSynonym = new JLabel(LB_TARGET_TABLE_SYNONYM);
        lbTargetTableSynonym.setPreferredSize(this.getDefaultSize());
        this.cbTargetTableSynonym = new JComboBox();
        this.cbTargetTableSynonym.setPreferredSize(this.getDefaultSize());
        this.cbTargetTableSynonym.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbTargetTableSynonym, this.cbTargetTableSynonym));
        JLabel lbMandatory = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.Mandatory"));
        lbMandatory.setPreferredSize(this.getDefaultSize());
        this.chMandatory = new JCheckBox();
        this.chMandatory.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbMandatory, this.chMandatory));
        JLabel lbTransferable = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.TransferableUpdatable"));
        lbTransferable.setPreferredSize(this.getDefaultSize());
        this.chTransferable = new JCheckBox();
        this.chTransferable.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbTransferable, this.chTransferable));
        JLabel lbMarkGenerate = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.GenerateInDDL"));
        lbMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.chMarkGenerate = new JCheckBox();
        this.chMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbMarkGenerate, this.chMarkGenerate));
        JLabel lbInArc = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.InArc"));
        lbInArc.setPreferredSize(this.getDefaultSize());
        this.chInArc = new JCheckBox();
        this.chInArc.setPreferredSize(this.getDefaultSize());
        this.chInArc.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(lbInArc, this.chInArc));
        JLabel lbDeprecated = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.Deprecated"));
        lbDeprecated.setPreferredSize(this.getDefaultSize());
        this.chbDeprecated = new JCheckBox();
        this.chbDeprecated.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDeprecated, this.chbDeprecated));
        JLabel lbDiscrimanatorCiolumn = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.DiscriminatorColumn"));
        lbDiscrimanatorCiolumn.setPreferredSize(this.getDefaultSize());
        this.cbDiscrimanatorCiolumn = new JComboBox();
        this.cbDiscrimanatorCiolumn.setPreferredSize(this.getDefaultSize());
        this.cbDiscrimanatorCiolumn.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbDiscrimanatorCiolumn, this.cbDiscrimanatorCiolumn));
        JLabel lbDiscriminatorValue = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.DiscriminatorValue"));
        lbDiscriminatorValue.setPreferredSize(this.getDefaultSize());
        this.tfDiscrValue = new JTextField();
        this.tfDiscrValue.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDiscriminatorValue, this.tfDiscrValue));
    }

    protected JTable getColumnsTable() {
        FKColumnsTableModel fkColumnsTableModel = new FKColumnsTableModel();
        fkColumnsTableModel.init(this.fkColumns, this.currentKey);
        this.columnsTable = new JTable(fkColumnsTableModel);
        FKColumnsCellEditor fkColumnsCellEditor = new FKColumnsCellEditor();
        if (this.oldFKIass != null) {
            fkColumnsCellEditor.init(this.fkColumns, this.currentKey, this.oldFKIass.getContainerWithKeyObject().getElementsCollection());
        } else {
            fkColumnsCellEditor.init(this.fkColumns, this.currentKey, null);
        }
        this.columnsTable.getColumnModel().getColumn(1).setCellEditor(fkColumnsCellEditor);
        this.columnsTable.setEnabled(this.isEditable());
        return this.columnsTable;
    }

    protected JPanel getColumnsPanel() {
        if (this.pnColumns == null) {
            this.pnColumns = this.createPage(Messages.getString("ForeignKeyPropertiesDialogEx.AssociatedColumns"));
            this.pnColumns.add(new JScrollPane(this.getColumnsTable()));
        }
        return this.pnColumns;
    }

    private void refreshColumnsPanel() {
        this.columnsTable = this.getColumnsTable();
        this.pnColumns.remove(this.pnColumns.getComponentCount() - 1);
        this.pnColumns.add(new JScrollPane(this.columnsTable));
        this.pnColumns.validate();
    }

    protected JPanel getColumnsDependencyConstraintPanel() {
        if (this.pnColumnsDependencyConstraint == null) {
            this.pnColumnsDependencyConstraint = this.createPage(Messages.getString("ForeignKeyPropertiesDialogEx.DependantColumnsConstraint"));
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel pnGrid = new JPanel(new GridLayout(2, 2, 10, 10));
            JLabel lblCName = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.ConstraintName"));
            lblCName.setPreferredSize(this.getDefaultSize());
            this.txtCDCName = new JTextField();
            this.txtCDCName.setPreferredSize(this.getDefaultSize());
            JLabel lbGenerateInDDL = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.GenerateInDDL"));
            lbGenerateInDDL.setPreferredSize(this.getDefaultSize());
            this.chCDCGenerateInDDL = new JCheckBox();
            this.chCDCGenerateInDDL.setPreferredSize(this.getDefaultSize());
            pnGrid.add(this.createRow(lblCName, this.txtCDCName));
            pnGrid.add(this.createRow(lbGenerateInDDL, this.chCDCGenerateInDDL));
            jpanel.add((Component)pnGrid, "North");
            JScrollPane jsp = new JScrollPane(this.getColumnsDependencyConstraintTable());
            jsp.setBorder(BorderFactory.createTitledBorder(Messages.getString("ForeignKeyPropertiesDialogEx.Columns")));
            jpanel.add((Component)jsp, "Center");
            this.pnColumnsDependencyConstraint.add(jpanel);
        }
        return this.pnColumnsDependencyConstraint;
    }

    protected JTable getColumnsDependencyConstraintTable() {
        if (this.columnsDependencyConstraintTable == null) {
            this.dependantColumnsList = new ArrayList();
            this.columnsDependencyConstraintTable = new JTable();
        }
        return this.columnsDependencyConstraintTable;
    }

    public boolean hasColumnWithAllowNulls() {
        for (int i = 0; i < this.fkColumns.length; ++i) {
            if (this.fkColumns[i] == null || !this.fkColumns[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExit() {
        if (super.canExit()) {
            return FKUtilities.checkRequiredProperties((Component)Ide.getMainWindow(), this.fkColumns, this.oldFKIass, this.chMandatory.isSelected(), this.chTransferable.isSelected());
        }
        return false;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel pnImpact = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = ForeignKeyPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        obj.showPropertyDialog();
                    } else {
                        if (ForeignKeyPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            ForeignKeyPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            ForeignKeyPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_FKAssociation(this.getFK_ForIA(), null, true), false);
        ImpactTreeRenderer renderer = new ImpactTreeRenderer();
        this.tree.setModel(treeDesign);
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    private FKIndexAssociation getFK_ForIA() {
        String id = this.oldFKIass.getObjectID();
        FKIndexAssociation fk = (FKIndexAssociation)((RelationalDesign)this.oldFKIass.getDesignPart()).getFKIndexAssociationSet().getObjectByID(id);
        if (fk == null) {
            fk = this.oldFKIass;
        }
        return fk;
    }

    @Override
    protected int getMinimumHeight() {
        return 530;
    }

    public FKIndexAssociation.FKMemento getFKMemento() {
        return this.mem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCancel() {
        if (this.obj.showForFirstTime()) {
            try {
                if (this.obj instanceof FKIndexAssociation) {
                    ((FKIndexAssociation)this.obj).setSilentRemove(true);
                }
                this.obj.remove();
            }
            finally {
                if (this.obj instanceof FKIndexAssociation) {
                    ((FKIndexAssociation)this.obj).setSilentRemove(false);
                }
            }
        }
        if (this.newFKIass != null && !this.newFKIass.getName().equals(this.oldFKIass.getName()) && this.obj instanceof FKIndexAssociation && this.memBackup != null) {
            try {
                ((FKIndexAssociation)this.obj).setSilentRemove(true);
                ((FKIndexAssociation)this.obj).getLocalFKIndex().remove();
            }
            finally {
                ((FKIndexAssociation)this.obj).setSilentRemove(false);
            }
            Table childTable = (Table)this.oldFKIass.getContainerWithKeyObject();
            FKIndexAssociation fKIndexAssociation = childTable.addFK(this.oldKey);
        }
        this.mem = this.memBackup;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    class CDCTableModel
    extends AbstractTableModel {
        private FKIndexAssociation fk;
        final String[] COL_NAMES = new String[]{Messages.getString("ForeignKeyPropertiesDialogEx.ColumnCol"), Messages.getString("ForeignKeyPropertiesDialogEx.Depend"), Messages.getString("ForeignKeyPropertiesDialogEx.AsMandatory")};

        CDCTableModel(FKIndexAssociation fk) {
            this.fk = fk;
        }

        @Override
        public int getRowCount() {
            return ForeignKeyPropertiesDialogEx.this.dependantColumnsList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.COL_NAMES[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Column column = (Column)ForeignKeyPropertiesDialogEx.this.dependantColumnsList.get(rowIndex);
            if (columnIndex == 0) {
                return column.getName();
            }
            if (columnIndex == 1) {
                return column.getDependOnForeignKey() != null;
            }
            if (columnIndex == 2) {
                return column.isDependOnFK_AsMandatory();
            }
            return Messages.getString("ForeignKeyPropertiesDialogEx.8");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Column column = (Column)ForeignKeyPropertiesDialogEx.this.dependantColumnsList.get(row);
            if (col == 1) {
                if (((Boolean)value).booleanValue()) {
                    column.setDependOnForeignKey(this.fk);
                } else {
                    column.setDependOnForeignKeyID("");
                    column.setDependOnForeignKey(null);
                }
            } else if (col == 2) {
                column.setDependOnFK_AsMandatory((Boolean)value);
            }
        }
    }
}

