/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.swingui.editor.relational.AbstractIndexPanel;
import oracle.dbtools.crest.swingui.editor.relational.IndexColumnsPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.editor.relational.PKColumnsPanel;
import oracle.dbtools.crest.swingui.editor.relational.UKColumnsPanel;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexExpressionPanel
extends AbstractIndexPanel {
    private static final long serialVersionUID = -6412036690921122010L;
    private static final String EXPRESSION = Messages.getString("IndexPropertiesDialogEx.Expression");
    private IndexColumnsPanel indexColumnsPanel;
    private JTextArea taIndexExpression;
    private JPanel pnFunctional;
    private JPanel mainPanel;
    private CardLayout cardLayout;

    public IndexExpressionPanel(Index index, boolean editable, int buttonsSize, boolean showDesc) {
        super(index, editable, buttonsSize, showDesc);
    }

    public String getIndexExpressionText() {
        return this.taIndexExpression.getText();
    }

    public IndexColumnsPanel getIndexColumnsPanel() {
        return this.indexColumnsPanel;
    }

    public List<Column> getSelectedColumns() {
        return this.indexColumnsPanel.getSelectedColumns();
    }

    @Override
    public void init(Collection<Column> tableColumns) {
        super.init(tableColumns);
        this.indexColumnsPanel.init(tableColumns);
    }

    @Override
    public void init(Index index, Collection<Column> tableColumns) {
        super.init(index, tableColumns);
        this.indexColumnsPanel.init(index, tableColumns);
        if (index != null) {
            this.showExpressionPanel(StringUtilities.isNotEmpty(index.getIndexMemento().expression));
        }
    }

    @Override
    protected void createUIComponents() {
        this.setLayout(new BorderLayout());
        this.cardLayout = new CardLayout();
        this.mainPanel = new JPanel(this.cardLayout);
        this.indexColumnsPanel = this.index != null && this.index.isPK() ? new PKColumnsPanel(this.index, this.editable, this.buttonsSize, this.showDesc) : (this.index != null && this.index.isUnique() ? new UKColumnsPanel(this.index, this.editable, this.buttonsSize, this.showDesc) : new IndexColumnsPanel(this.index, this.editable, this.buttonsSize, this.showDesc));
        this.mainPanel.add((Component)this.indexColumnsPanel, this.indexColumnsPanel.getName());
        this.pnFunctional = new JPanel(new BorderLayout(0, 10));
        this.pnFunctional.setName(EXPRESSION);
        this.pnFunctional.setBorder(BorderFactory.createTitledBorder(EXPRESSION));
        this.taIndexExpression = new JTextArea();
        this.taIndexExpression.setAutoscrolls(true);
        this.pnFunctional.add(new JScrollPane(this.taIndexExpression));
        this.mainPanel.add((Component)this.pnFunctional, this.pnFunctional.getName());
        this.add(this.mainPanel);
    }

    @Override
    protected void initUIComponents() {
    }

    public void showExpressionPanel(boolean show) {
        if (show) {
            String indexExpression = this.index.getIndexMemento().expression;
            this.taIndexExpression.setText(indexExpression);
            this.cardLayout.show(this.mainPanel, this.pnFunctional.getName());
        } else {
            this.cardLayout.show(this.mainPanel, this.indexColumnsPanel.getName());
        }
    }
}

