/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.impact.ImpA_PK_UK;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.IndexUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.IndexExpressionPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;

public class IndexPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final long serialVersionUID = 7429391886536213361L;
    private Index index;
    private JTextField tfLongName;
    private JCheckBox chbEngineer;
    private JTextField tfTable;
    private JComboBox cbSchemaObject;
    private JComboBox cbState;
    private JCheckBox chIndexExpression;
    private List<Column> columnsList;
    private JCheckBox chSpatialIndex;
    private JPanel pnSpatialProp;
    private JComboBox cbLayerType;
    private JComboBox cbGeodetic;
    private JIntegerField ifDimensions;
    private int dimensionsSize = 0;
    private JCheckBox chMarkGenerate;
    private JTree tree;
    private IndexMemento mem;
    private IndexExpressionPanel indexExpressionPanel;
    private JCheckBox chbDeprecated;
    String[] STATES_DISPLAY = new String[]{UNIQUE_KEY, PRIMARY_KEY, PLAIN_INDEX, UNIQUE_PLAIN_INDEX};
    String[] STATES_INTERNAL = new String[]{"Unique Key", "Primary Key", "Plain Index", "Unique Plain Index"};

    public IndexPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public IndexPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        Index index = (Index)this.getDesignObject();
        if (index.isPK()) {
            return MessageFormat.format(Messages.getString("IndexPropertiesDialogEx.Properties"), PRIMARY_KEY);
        }
        if (index.isUnique()) {
            return MessageFormat.format(Messages.getString("IndexPropertiesDialogEx.Properties"), UNIQUE_KEY);
        }
        return MessageFormat.format(Messages.getString("IndexPropertiesDialogEx.Properties"), PLAIN_INDEX);
    }

    @Override
    protected int getMinimumWidth() {
        return 630;
    }

    @Override
    protected int getMinimumHeight() {
        return 530;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Index) {
            this.index = (Index)object;
            this.initDefaults(false);
            Table table = this.index.getTable();
            ArrayList<Column> expandedColumns = new ArrayList<Column>(table.getElementsCollection());
            expandedColumns.addAll(table.getNestedElements());
            this.indexExpressionPanel.init(this.index, expandedColumns);
            if (this.index.isSpatialIndex() && this.index.getSpatialColumnDefiniton() != null) {
                this.dimensionsSize = this.index.getSpatialColumnDefiniton().getTableDimensions().size();
            }
            this.tfLongName.setText(this.index.getLongName());
            this.chbEngineer.setSelected(this.index.getShouldEngineer());
            this.tfTable.setText(this.index.getContainerObject().getLongName());
            this.cbState.setSelectedItem(this.translate(this.index.getIndexState(), this.STATES_INTERNAL, this.STATES_DISPLAY));
            if (this.chIndexExpression != null && this.index.hasIndexExpression()) {
                this.chIndexExpression.setSelected(true);
                this.chIndexExpression.setText(this.index.getIndexExpression());
            }
            if (!this.index.isPK() && !this.index.isUnique()) {
                this.chSpatialIndex.setSelected(this.index.isSpatialIndex());
            }
            this.chMarkGenerate.setSelected(this.index.isMarkedGenerate());
            this.chbDeprecated.setSelected(this.index.isDeprecated());
            this.cbLayerType.setSelectedItem(this.index.getLayerType());
            this.cbGeodetic.setSelectedItem(this.index.getGeodetic());
            this.ifDimensions.setValue((long)this.index.getDimensionsNumber());
            this.cbSchemaObject.setSelectedItem(this.index.getSchemaObject());
            this.enableComponents(this.index.isSpatialIndex());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator it = this.index.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.index.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    public void initProperties(IndexMemento mem) {
        this.index = mem.index;
        this.mem = mem;
        this.initDefaults(false);
        this.indexExpressionPanel.init(this.index, this.columnsList);
        if (this.index.isSpatialIndex() && this.index.getSpatialColumnDefiniton() != null) {
            this.dimensionsSize = this.index.getSpatialColumnDefiniton().getTableDimensions().size();
        }
        this.tfName.setText(mem.name);
        this.taComments.setText(mem.comments);
        this.taCommentsInRDBMS.setText(mem.comments_in_rdbms);
        this.taNotes.setText(mem.notes);
        this.tfLongName.setText(mem.table.getName() + "." + mem.name);
        this.chbEngineer.setSelected(mem.engineer);
        this.tfTable.setText(mem.table.getLongName());
        this.cbState.setSelectedItem(this.translate(mem.index_state, this.STATES_INTERNAL, this.STATES_DISPLAY));
        if (this.chIndexExpression != null && mem.expression.length() > 0) {
            this.chIndexExpression.setSelected(true);
        }
        if (!this.index.isPK() && !this.index.isUnique()) {
            this.chSpatialIndex.setSelected(mem.spatial);
            this.cbLayerType.setSelectedItem(mem.layer_type);
            this.cbGeodetic.setSelectedItem(mem.is_geodetic);
            this.ifDimensions.setValue((long)mem.dimensionsNumber);
        }
        this.chMarkGenerate.setSelected(mem.generate_in_DDL);
        this.chbDeprecated.setSelected(mem.deprecated);
        this.cbSchemaObject.setSelectedItem(mem.schemaObject);
        this.enableComponents(mem.spatial);
        this.fillComboItems(((RelationalDesign)this.index.getDesignPart()).getSchemaObjectSet().toArray(), this.cbSchemaObject, true);
        this.cbSchemaObject.setSelectedItem(mem.schemaObject);
        this.initMeasurements();
        this.initChangeRequests();
        this.initResponsibleParties();
        this.initDocuments();
        this.dynamicPropertiesList.clear();
        Iterator it = mem.index.getPropertyNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            String value = mem.index.getProperty(propName);
            DynamicProperty dp = new DynamicProperty(propName, value);
            this.dynamicPropertiesList.add(dp);
        }
        this.dynamicPropertiesTable.updateUI();
    }

    private void enableComponents(boolean enable) {
        this.chbEngineer.setEnabled(!enable);
        if (!this.index.isPK() && !this.index.isUnique()) {
            this.cbState.setEnabled(!enable);
            this.cbLayerType.setEnabled(enable);
            this.cbGeodetic.setEnabled(enable);
            this.ifDimensions.setEnabled(enable);
        }
    }

    @Override
    protected boolean canExit() {
        if (super.canExit()) {
            String indexState = this.translate((String)this.cbState.getSelectedItem(), this.STATES_DISPLAY, this.STATES_INTERNAL);
            if (!("Primary Constraint".equalsIgnoreCase(indexState) || "Unique Constraint".equalsIgnoreCase(indexState) || this.index.isPK() || this.index.isUnique() || !this.index.hasFKAssociations())) {
                JOptionPane.showMessageDialog(this, Messages.getString("IndexPropertiesDialogEx.ForeignKeyOnThisKey"), Messages.getString("IndexPropertiesDialogEx.PKUKStatusChange"), 0);
                return false;
            }
            if (!this.index.isPK() && "Primary Constraint".equalsIgnoreCase(indexState)) {
                int result;
                List<Column> selectedColumns = this.indexExpressionPanel.getIndexColumnsPanel().getSelectedColumns();
                if (this.hasColumnInFKinArc(selectedColumns)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("IndexPropertiesDialogEx.TheIndexHasColumnBelongingToFKInARC"), Messages.getString("IndexPropertiesDialogEx.ColumnInFKInArc"), 0);
                    return false;
                }
                if (this.hasColumnInOptionalFK(selectedColumns) && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("IndexPropertiesDialogEx.TheIndexHasColumnBelongingToOptionalFK"), Messages.getString("IndexPropertiesDialogEx.ColumnInOptionalFK"), 0)) != 0) {
                    return false;
                }
            }
            return this.checkRequiredProperties();
        }
        return false;
    }

    protected boolean checkRequiredProperties() {
        boolean result = false;
        if (this.chIndexExpression != null && this.chIndexExpression.isSelected()) {
            if (StringUtilities.isNotEmpty(this.indexExpressionPanel.getIndexExpressionText())) {
                result = true;
            }
        } else if (!this.indexExpressionPanel.getSelectedColumns().isEmpty()) {
            result = true;
        }
        if (!result) {
            String message = Messages.getString("IndexPropertiesDialogEx.IncompleteIxDefinition");
            String title = Messages.getString("IndexPropertiesDialogEx.IxColumnsAssignment");
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(message, this.index.getName()), title, 0);
        }
        return result;
    }

    public boolean hasColumnInOptionalFK(List<Column> columns) {
        for (Column column : columns) {
            if (!column.isInOptionalFK()) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumnInFKinArc(List<Column> columns) {
        for (Column column : columns) {
            if (!column.isInFKinArc()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setProperties() {
        this.mem.name = this.tfName.getText();
        this.mem.comments = this.taComments.getText();
        this.mem.comments_in_rdbms = this.taCommentsInRDBMS.getText();
        this.mem.notes = this.taNotes.getText();
        this.mem.engineer = this.chbEngineer.isSelected();
        if (this.chIndexExpression != null && this.chIndexExpression.isSelected()) {
            this.mem.columns.clear();
            this.mem.expression = this.indexExpressionPanel.getIndexExpressionText();
        } else {
            this.mem.columns.clear();
            for (Column column : this.indexExpressionPanel.getSelectedColumns()) {
                String sortord = this.index.getColumnSortOrder(column);
                IndexMemento.ColWr wr = this.mem.new IndexMemento.ColWr();
                wr.col_id = column.getObjectID();
                wr.sort_order = sortord;
                this.mem.columns.add(wr);
            }
            this.mem.expression = "";
        }
        this.mem.index_state = this.translate((String)this.cbState.getSelectedItem(), this.STATES_DISPLAY, this.STATES_INTERNAL);
        this.mem.generate_in_DDL = this.chMarkGenerate.isSelected();
        this.mem.deprecated = this.chbDeprecated.isSelected();
        if (this.cbLayerType != null) {
            this.mem.layer_type = (String)this.cbLayerType.getSelectedItem();
            this.mem.is_geodetic = (String)this.cbGeodetic.getSelectedItem();
            this.mem.dimensionsNumber = this.ifDimensions.getIntValue();
        }
        this.mem.schemaObject = (SchemaObject)this.cbSchemaObject.getSelectedItem();
        this.setMeasurements(this.mem.index);
        this.setChangeRequests(this.mem.index);
        this.setResponsibleParties(this.mem.index);
        this.setDocuments(this.mem.index);
        IndexUpdateEdit edit = new IndexUpdateEdit(this.mem.index, this.mem);
        edit.end();
        edit.applyUpdates();
        String id = this.mem.index.getObjectID();
        if (id != null && this.mem.index.getContainerWithKeyObject().getKeySet().getObjectByID(id) != null) {
            this.mem.index.getDesignPart().postUndoableEdit(edit);
        }
        this.tfLongName.setText(this.mem.table.getName() + "." + this.mem.name);
        IndexPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.mem.index.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.mem.index.setProperty(dp.getName(), dp.getValue());
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        boolean pkUK = ((Index)this.getDesignObject()).isPK() || ((Index)this.getDesignObject()).isUnique();
        this.addToTree(root, this.getGeneralPanel());
        if (!pkUK) {
            this.addToTree(root, this.getSpatialPanel());
        }
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        if (pkUK) {
            this.addToTree(root, this.getImpactAnalysisPanel());
        }
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "INDEX_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        this.index = (Index)this.getDesignObject();
        boolean pkUK = this.index.isPK() || this.index.isUnique();
        this.indexExpressionPanel = new IndexExpressionPanel(this.index, this.isEditable(), this.getPreferredIconSize(), !pkUK);
        JLabel lbLongName = new JLabel(LB_LONG_NAME);
        lbLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbLongName, this.tfLongName));
        JLabel lbEngineer = new JLabel(LB_ENGINEER);
        lbEngineer.setPreferredSize(this.getDefaultSize());
        this.chbEngineer = new JCheckBox();
        this.addRowToGeneralPanel(this.createRow(lbEngineer, this.chbEngineer));
        JLabel lbTable = new JLabel(LB_TABLE);
        lbTable.setPreferredSize(this.getDefaultSize());
        this.tfTable = new JTextField();
        this.tfTable.setPreferredSize(this.getDefaultSize());
        this.tfTable.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbTable, this.tfTable));
        JLabel lbState = new JLabel(LB_STATE);
        lbState.setPreferredSize(this.getDefaultSize());
        this.cbSchemaObject = new JComboBox();
        if (this.index.isPK()) {
            this.cbState = new JComboBox<String>(new String[]{PRIMARY_KEY});
            this.cbState.setEnabled(false);
            this.cbSchemaObject.setEnabled(false);
        } else if (this.index.isUnique()) {
            this.cbState = new JComboBox<String>(new String[]{UNIQUE_KEY});
            this.cbState.setEnabled(false);
            this.cbSchemaObject.setEnabled(false);
        } else {
            this.cbState = new JComboBox<String>(INDEX_STATES_NOPK_NOUK_DISPLAY);
            this.cbSchemaObject.setEnabled(true);
        }
        this.cbState.setPreferredSize(this.getDefaultSize());
        this.cbState.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbState, this.cbState));
        JLabel lbSchemaObject = new JLabel(SCHEMA);
        lbSchemaObject.setPreferredSize(this.getDefaultSize());
        this.cbSchemaObject.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSchemaObject, this.cbSchemaObject));
        if (!pkUK) {
            JLabel lbindexExpression = new JLabel(LB_INDEX_EXPRESSION);
            lbindexExpression.setPreferredSize(this.getDefaultSize());
            this.chIndexExpression = new JCheckBox();
            this.chIndexExpression.setPreferredSize(this.getDefaultSize());
            this.chIndexExpression.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IndexPropertiesDialogEx.this.indexExpressionPanel.showExpressionPanel(IndexPropertiesDialogEx.this.chIndexExpression.isSelected());
                }
            });
            this.addRowToGeneralPanel(this.createRow(lbindexExpression, this.chIndexExpression));
            JLabel lbSpatialIndex = new JLabel(Messages.getString("IndexPropertiesDialogEx.SpatialIndex"));
            lbSpatialIndex.setPreferredSize(this.getDefaultSize());
            this.chSpatialIndex = new JCheckBox();
            this.chSpatialIndex.setSelected(false);
            this.chSpatialIndex.setEnabled(false);
            this.chSpatialIndex.setPreferredSize(this.getDefaultSize());
            this.addRowToGeneralPanel(this.createRow(lbSpatialIndex, this.chSpatialIndex));
        }
        JLabel lbMarkGenerate = new JLabel(Messages.getString("IndexPropertiesDialogEx.GenerateInDDL"));
        lbMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.chMarkGenerate = new JCheckBox();
        this.chMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbMarkGenerate, this.chMarkGenerate));
        JLabel lbDeprecated = new JLabel(Messages.getString("IndexPropertiesDialogEx.Deprecated"));
        lbDeprecated.setPreferredSize(this.getDefaultSize());
        this.chbDeprecated = new JCheckBox();
        this.chbDeprecated.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDeprecated, this.chbDeprecated));
        this.pnAdditionalPanel.add(this.indexExpressionPanel);
    }

    public List getColumnsList() {
        return this.columnsList;
    }

    public void setColumnsList(List<Column> columnsList) {
        this.columnsList = columnsList;
    }

    private JPanel getSpatialPanel() {
        if (this.pnSpatialProp == null) {
            this.pnSpatialProp = this.createPage(Messages.getString("IndexPropertiesDialogEx.SpatialProperties"));
            JPanel panel = new JPanel(new BorderLayout(10, 10));
            JPanel gridPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbLayerType = new JLabel(Messages.getString("IndexPropertiesDialogEx.ConstrainToLayerType"));
            lbLayerType.setPreferredSize(this.getDefaultSize());
            this.cbLayerType = new JComboBox<String>(Index.getConstrainLayerTypeChoices());
            this.cbLayerType.setPreferredSize(this.getDefaultSize());
            gridPanel.add(this.createRow(lbLayerType, this.cbLayerType));
            JLabel lbGeodetic = new JLabel(Messages.getString("IndexPropertiesDialogEx.GeodeticIndex"));
            lbGeodetic.setPreferredSize(this.getDefaultSize());
            this.cbGeodetic = new JComboBox<String>(Index.getGeodeticChoices());
            this.cbGeodetic.setPreferredSize(this.getDefaultSize());
            gridPanel.add(this.createRow(lbGeodetic, this.cbGeodetic));
            JLabel lbDimensions = new JLabel(Messages.getString("IndexPropertiesDialogEx.NumberOfDimensions"));
            lbDimensions.setPreferredSize(this.getDefaultSize());
            this.ifDimensions = new JIntegerField();
            this.ifDimensions.setDocument(new IntegerSizeDocument());
            this.ifDimensions.setToolTipText(Messages.getString("IndexPropertiesDialogEx.ShouldBeLessOrEqual"));
            this.ifDimensions.setPreferredSize(this.getDefaultSize());
            gridPanel.add(this.createRow(lbDimensions, this.ifDimensions));
            panel.add((Component)gridPanel, "North");
            this.pnSpatialProp.add(panel);
        }
        return this.pnSpatialProp;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel pnImpact = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = IndexPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        obj.showPropertyDialog();
                    } else {
                        if (IndexPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            IndexPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            IndexPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        if (this.index.isPK() || this.index.isUnique()) {
            this.tree.addTreeWillExpandListener(this);
            CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_PK_UK(this.getIndexForIA(), null, true), false);
            ImpactTreeRenderer renderer = new ImpactTreeRenderer();
            this.tree.setModel(treeDesign);
            this.tree.setCellRenderer(renderer);
        }
        return this.tree;
    }

    private Index getIndexForIA() {
        Index ind;
        String tableid = this.index.getContainerWithKeyObject().getObjectID();
        Table tbl = (Table)((RelationalDesign)this.index.getDesignPart()).getTableSet().getObjectByID(tableid);
        if (tbl == null) {
            tbl = (Table)this.index.getContainerWithKeyObject();
        }
        if ((ind = (Index)tbl.getKeySet().getObjectByID(this.index.getObjectID())) != null) {
            return ind;
        }
        return this.index;
    }

    public IndexMemento getIndexMemento() {
        return this.mem;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    class IntegerSizeDocument
    extends PlainDocument {
        private static final long serialVersionUID = 3211590025851616007L;

        IntegerSizeDocument() {
        }

        @Override
        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            String newValue;
            if (string == null) {
                return;
            }
            int length = this.getLength();
            if (length == 0) {
                newValue = string;
            } else {
                String currentContent = this.getText(0, length);
                StringBuffer currentBuffer = new StringBuffer(currentContent);
                currentBuffer.insert(offset, string);
                newValue = currentBuffer.toString();
            }
            if (length == 0 && ("-".equals(string) || "+".equals(string))) {
                super.insertString(offset, string, attributes);
            } else {
                try {
                    if (Integer.parseInt(newValue) == 2 || Integer.parseInt(newValue) <= IndexPropertiesDialogEx.this.dimensionsSize) {
                        super.insertString(offset, string, attributes);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (NumberFormatException exception) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

