/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class IndexesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 9153673050664757933L;
    protected static final String[] COLUMN_NAMES = new String[]{" ", Messages.getString("IndexesTable.Name"), Messages.getString("IndexesTable.Unique"), Messages.getString("IndexesTable.Generate"), Messages.getString("IndexesTable.Engineer"), Messages.getString("IndexesTable.Spatial"), Messages.getString("IndexesTable.Deprecated")};
    protected List<Index> indexesList;
    protected Component parent;

    public IndexesTableModel(List<Index> indexesList, Component parent) {
        this.indexesList = indexesList;
        this.parent = parent;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return this.indexesList.size();
    }

    public String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumnNames()[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Index index = this.indexesList.get(rowIndex);
        return !index.isDialogVisible() && (columnIndex == 1 && !index.isNameFixed() || columnIndex == 2 || columnIndex == 3 || columnIndex == 4 || columnIndex == 6);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        IndexMemento indexMemento = this.indexesList.get(row).getIndexMemento();
        if (col == 0) {
            return new Integer(row + 1);
        }
        if (col == 1) {
            return indexMemento.name;
        }
        if (col == 2) {
            return "Unique Plain Index".equals(indexMemento.index_state);
        }
        if (col == 3) {
            return indexMemento.generate_in_DDL;
        }
        if (col == 4) {
            return indexMemento.engineer;
        }
        if (col == 5) {
            return indexMemento.spatial;
        }
        if (col == 6) {
            return indexMemento.deprecated;
        }
        return new Integer(row * col);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        IndexMemento indexMemento = this.indexesList.get(rowIndex).getIndexMemento();
        if (columnIndex == 1) {
            indexMemento.name = (String)aValue;
        } else if (columnIndex == 2) {
            Boolean uniquePlainIndex = (Boolean)aValue;
            indexMemento.index_state = uniquePlainIndex != false ? "Unique Plain Index" : "Plain Index";
        } else if (columnIndex == 3) {
            indexMemento.generate_in_DDL = (Boolean)aValue;
        } else if (columnIndex == 4) {
            indexMemento.engineer = (Boolean)aValue;
        } else if (columnIndex == 6) {
            indexMemento.deprecated = (Boolean)aValue;
        }
    }
}

