/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractNamingStandards;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class KeysNamingStandards
extends AbstractNamingStandards {
    protected JCheckBox chbPK;
    protected JCheckBox chbPK_SK;
    protected JCheckBox chbFK;
    protected JCheckBox chbCHC;
    protected JCheckBox chbNNConstr;
    protected JCheckBox chbUC;
    protected JCheckBox chbIndex;
    protected JCheckBox chbColumnCHC;
    protected JCheckBox chbColumnSK;
    protected JCheckBox chbColumnFK;
    protected RelationalDesign relational;
    protected ApplyNamingStandards applyNS;

    public KeysNamingStandards(ApplicationView appView, RelationalDesign relational) {
        super(appView);
        this.relational = relational;
    }

    @Override
    protected JPanel initGeneralPanel() {
        JPanel generalPanel = super.initGeneralPanel();
        this.chbPK = new JCheckBox(Messages.getString("KeysNamingStandards.PrimaryKeys"), ApplyNamingStandards.applyToPK);
        this.chbFK = new JCheckBox(Messages.getString("KeysNamingStandards.ForeignKeys"), ApplyNamingStandards.applyToFK);
        this.chbCHC = new JCheckBox(Messages.getString("KeysNamingStandards.CheckConstraints"), ApplyNamingStandards.applyToTableCHC);
        this.chbUC = new JCheckBox(Messages.getString("KeysNamingStandards.UniqueConstraints"), ApplyNamingStandards.applyToUC);
        this.chbIndex = new JCheckBox(Messages.getString("KeysNamingStandards.Indexes"), ApplyNamingStandards.applyToIndex);
        this.chbColumnCHC = new JCheckBox(oracle.dbtools.crest.swingui.editor.Messages.getString("DesignPropertiesDialog.ColumnCheckConstraint"), ApplyNamingStandards.applyToColumnCHC);
        this.chbNNConstr = new JCheckBox(oracle.dbtools.crest.swingui.editor.Messages.getString("DesignPropertiesDialog.ColumnNotNullConstraint"), ApplyNamingStandards.applyToColumnNNC);
        this.chbColumnFK = new JCheckBox(Messages.getString("KeysNamingStandards.ColumnForeignKeys"), ApplyNamingStandards.applyToFKColumn);
        this.chbColumnSK = new JCheckBox("Surogate Key Column", ApplyNamingStandards.applyToColumnSK);
        this.generalPanelContents.add(this.chbPK);
        this.generalPanelContents.add(this.chbFK);
        this.generalPanelContents.add(this.chbCHC);
        this.generalPanelContents.add(this.chbUC);
        this.generalPanelContents.add(this.chbIndex);
        this.generalPanelContents.add(this.chbColumnSK);
        this.generalPanelContents.add(this.chbColumnCHC);
        this.generalPanelContents.add(this.chbNNConstr);
        this.generalPanelContents.add(this.chbColumnFK);
        return generalPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() {
        try {
            ApplicationView.canLogging = false;
            ApplyNamingStandards.applyToPK = this.chbPK.isSelected();
            ApplyNamingStandards.applyToIndex = this.chbIndex.isSelected();
            ApplyNamingStandards.applyToFK = this.chbFK.isSelected();
            ApplyNamingStandards.applyToColumnCHC = this.chbColumnCHC.isSelected();
            ApplyNamingStandards.applyToTableCHC = this.chbCHC.isSelected();
            ApplyNamingStandards.applyToUC = this.chbUC.isSelected();
            ApplyNamingStandards.applyToFKColumn = this.chbColumnFK.isSelected();
            ApplyNamingStandards.applyToColumnNNC = this.chbNNConstr.isSelected();
            ApplyNamingStandards.applyToColumnSK = this.chbColumnSK.isSelected();
            this.applyNS = new ApplyNamingStandards(this.getDesign().getDesignLevelSettings().getNamingStandardRule(), ApplyNamingStandards.applyToColumnCHC, ApplyNamingStandards.applyToFK, ApplyNamingStandards.applyToIndex, ApplyNamingStandards.applyToPK, ApplyNamingStandards.applyToTableCHC, ApplyNamingStandards.applyToUC, this.chbColumnFK.isSelected(), ApplyNamingStandards.applyToColumnNNC, ApplyNamingStandards.applyToColumnSK);
            Set<Column> firstReferencingColumns = this.getFirstLevelColumns();
            for (Column firstReferencingColumn : firstReferencingColumns) {
                this.applyColumnsNamingStandards(firstReferencingColumn);
            }
            Iterator it = this.relational.getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                this.applyNS.apply(table);
            }
        }
        finally {
            ApplicationView.canLogging = true;
            if (this.relational != null) {
                this.relational.sortCollections();
            }
        }
    }

    private Set<Column> getFirstLevelColumns() {
        HashSet<Column> result = new HashSet<Column>();
        Iterator iterator = this.relational.getColumnSet().iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!column.isFKColumn() || column.getDelegate().isFKColumn()) continue;
            result.add(column);
        }
        return result;
    }

    protected void applyColumnsNamingStandards(Column column) {
        Table table = (Table)column.getParent();
        this.applyNS.apply(table);
        for (Column referencingColumn : this.getReferencingColumns(column)) {
            this.applyColumnsNamingStandards(referencingColumn);
        }
    }

    protected Set<Column> getReferencingColumns(Column column) {
        HashSet<Column> result = new HashSet<Column>();
        Iterator iterator = this.relational.getColumnSet().iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            if (col.getDelegate() != column) continue;
            result.add(col);
        }
        return result;
    }

    @Override
    protected String getDialogTitle() {
        return Messages.getString("KeysNamingStandards.ApplyNamingStandardsToKeysAndConstraints");
    }

    @Override
    protected Dimension getDialogPreferredSize() {
        return new Dimension(300, 200);
    }
}

