/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class SchemaObjectPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final long serialVersionUID = -3640605097703231194L;
    private static final String INDEXES_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.Indexes");
    private static final String TABLES_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.Tables");
    private static final String VIEWS_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.Views");
    private SchemaObject schemaObject;
    private JPanel pnTables;
    private JPanel pnViews;
    private JPanel pnIndexes;
    private JButton buttonTableAdd;
    private JButton buttonTableRemove;
    private JButton buttonIndexAdd;
    private JButton buttonIndexRemove;
    private JButton buttonViewAdd;
    private JButton buttonViewRemove;
    private DefaultListModel selectedTablesModel;
    private DefaultListModel allTablesModel;
    private JList allTablesList;
    private JList selectedTablesList;
    private DefaultListModel selectedViewsModel;
    private DefaultListModel allViewsModel;
    private JList allViewsList;
    private JList selectedViewsList;
    private DefaultListModel selectedIndexesModel;
    private DefaultListModel allIndexesModel;
    private JList allIndexesList;
    private JList selectedIndexesList;
    private RelationalDesign rd = (RelationalDesign)this.getDesignObject().getDesignPart();
    private TableSet allTablesSet;
    private TableViewSet allViewsSet;
    private GlobalIndexSet allIndexesSet;

    public SchemaObjectPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    @Override
    public String getCaption() {
        return Messages.getString("SchemaPropertiesDialogEx.SchemaProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "SCHEMA_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof SchemaObject) {
            this.schemaObject = (SchemaObject)object;
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.taCommentsInRDBMS.setText(this.schemaObject.getCommentInRDBMS());
            this.taComments.setText(this.schemaObject.getComment());
            this.taNotes.setText(this.schemaObject.getNotes());
            this.tfName.setText(this.schemaObject.getName());
            this.allTablesSet = this.rd.getTableSet();
            Iterator it1 = this.allTablesSet.iterator();
            while (it1.hasNext()) {
                Table t = (Table)it1.next();
                if (object == t.getSchemaObject()) {
                    this.selectedTablesModel.addElement(t);
                    continue;
                }
                this.allTablesModel.addElement(t);
            }
            this.sort(this.selectedTablesModel);
            this.sort(this.allTablesModel);
            this.allViewsSet = this.rd.getTableViewSet();
            Iterator it2 = this.allViewsSet.iterator();
            while (it2.hasNext()) {
                TableView tv = (TableView)it2.next();
                if (object == tv.getSchemaObject()) {
                    this.selectedViewsModel.addElement(tv);
                    continue;
                }
                this.allViewsModel.addElement(tv);
            }
            this.sort(this.selectedViewsModel);
            this.sort(this.allViewsModel);
            this.allIndexesSet = this.rd.getGlobalIndexSet();
            Iterator it3 = this.allIndexesSet.iterator();
            while (it3.hasNext()) {
                Index i = (Index)it3.next();
                if (object == i.getSchemaObject()) {
                    this.selectedIndexesModel.addElement(i);
                    continue;
                }
                if (i.isUnique() || i.isFK() || i.isPK()) continue;
                this.allIndexesModel.addElement(i);
            }
            this.sort(this.selectedIndexesModel);
            this.sort(this.allIndexesModel);
            this.dynamicPropertiesList.clear();
            Iterator it = this.schemaObject.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.schemaObject.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getTablesPanel());
        this.addToTree(root, this.getViewsPanel());
        this.addToTree(root, this.getIndexesPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
    }

    protected JPanel getTablesPanel() {
        if (this.pnTables == null) {
            this.pnTables = this.createPage(TABLES_TAB_NAME);
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel allTablesPanel = new JPanel(new GridBagLayout());
        allTablesPanel.setPreferredSize(new Dimension(100, 100));
        allTablesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.AllTables")));
        this.allTablesModel = new DefaultListModel();
        this.allTablesList = new JList(this.allTablesModel);
        this.allTablesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.allTablesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonTableAdd.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonTableAdd.setEnabled(true);
                }
            }
        });
        JScrollPane allTablesScrollPane = new JScrollPane(this.allTablesList);
        allTablesPanel.add((Component)allTablesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel selectedTablesPanel = new JPanel(new GridBagLayout());
        selectedTablesPanel.setPreferredSize(new Dimension(100, 100));
        selectedTablesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.SelectedTables")));
        this.selectedTablesModel = new DefaultListModel();
        this.selectedTablesList = new JList(this.selectedTablesModel);
        this.selectedTablesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.selectedTablesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonTableRemove.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonTableRemove.setEnabled(true);
                }
            }
        });
        JScrollPane selectedTablesScrollPane = new JScrollPane(this.selectedTablesList);
        selectedTablesPanel.add((Component)selectedTablesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)allTablesPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)selectedTablesPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.initTablesPanelAddRemoveButtons(mainPanel);
        this.pnTables.add(mainPanel);
        return this.pnTables;
    }

    private void initTablesPanelAddRemoveButtons(JPanel main) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonTableAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON"));
        this.buttonTableAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonTableAdd.addActionListener(new AddTable());
        this.buttonTableAdd.setEnabled(false);
        this.buttonTableAdd.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Add"));
        this.buttonTableRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON"));
        this.buttonTableRemove.setPreferredSize(new Dimension(32, 32));
        this.buttonTableRemove.setEnabled(false);
        this.buttonTableRemove.addActionListener(new RemoveTable());
        this.buttonTableRemove.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonTableAdd);
        verticalBox.add(this.buttonTableRemove);
        verticalBox.add(Box.createVerticalGlue());
        main.add((Component)verticalBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getIndexesPanel() {
        if (this.pnIndexes == null) {
            this.pnIndexes = this.createPage(INDEXES_TAB_NAME);
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel allIndexesPanel = new JPanel(new GridBagLayout());
        allIndexesPanel.setPreferredSize(new Dimension(100, 100));
        allIndexesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.AllIndexes")));
        this.allIndexesModel = new DefaultListModel();
        this.allIndexesList = new JList(this.allIndexesModel);
        this.allIndexesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.allIndexesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexAdd.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexAdd.setEnabled(true);
                }
            }
        });
        JScrollPane allIndexesScrollPane = new JScrollPane(this.allIndexesList);
        allIndexesPanel.add((Component)allIndexesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel selectedIndexesPanel = new JPanel(new GridBagLayout());
        selectedIndexesPanel.setPreferredSize(new Dimension(100, 100));
        selectedIndexesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.SelectedIndexes")));
        this.selectedIndexesModel = new DefaultListModel();
        this.selectedIndexesList = new JList(this.selectedIndexesModel);
        this.selectedIndexesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.selectedIndexesList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexRemove.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonIndexRemove.setEnabled(true);
                }
            }
        });
        JScrollPane selectedIndexesScrollPane = new JScrollPane(this.selectedIndexesList);
        selectedIndexesPanel.add((Component)selectedIndexesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)allIndexesPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)selectedIndexesPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.initIndexesPanelAddRemoveButtons(mainPanel);
        this.pnIndexes.add(mainPanel);
        return this.pnIndexes;
    }

    private void initIndexesPanelAddRemoveButtons(JPanel main) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonIndexAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonIndexAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonIndexAdd.addActionListener(new AddIndex());
        this.buttonIndexAdd.setEnabled(false);
        this.buttonIndexAdd.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Add"));
        this.buttonIndexRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonIndexRemove.setPreferredSize(new Dimension(32, 32));
        this.buttonIndexRemove.setEnabled(false);
        this.buttonIndexRemove.addActionListener(new RemoveIndex());
        this.buttonIndexRemove.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonIndexAdd);
        verticalBox.add(this.buttonIndexRemove);
        verticalBox.add(Box.createVerticalGlue());
        main.add((Component)verticalBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getViewsPanel() {
        if (this.pnViews == null) {
            this.pnViews = this.createPage(VIEWS_TAB_NAME);
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel allViewsPanel = new JPanel(new GridBagLayout());
        allViewsPanel.setPreferredSize(new Dimension(100, 100));
        allViewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.AllViews")));
        this.allViewsModel = new DefaultListModel();
        this.allViewsList = new JList(this.allViewsModel);
        this.allViewsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.allViewsList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonViewAdd.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonViewAdd.setEnabled(true);
                }
            }
        });
        JScrollPane allIndexesScrollPane = new JScrollPane(this.allViewsList);
        allViewsPanel.add((Component)allIndexesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel selectedViewsPanel = new JPanel(new GridBagLayout());
        selectedViewsPanel.setPreferredSize(new Dimension(100, 100));
        selectedViewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SchemaPropertiesDialogEx.SelectedViews")));
        this.selectedViewsModel = new DefaultListModel();
        this.selectedViewsList = new JList(this.selectedViewsModel);
        this.selectedViewsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SchemaObjectPropertiesDialogEx.this.selectedViewsList.getSelectedIndex() == -1) {
                    SchemaObjectPropertiesDialogEx.this.buttonViewRemove.setEnabled(false);
                } else {
                    SchemaObjectPropertiesDialogEx.this.buttonViewRemove.setEnabled(true);
                }
            }
        });
        JScrollPane selectedViewsScrollPane = new JScrollPane(this.selectedViewsList);
        selectedViewsPanel.add((Component)selectedViewsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)allViewsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)selectedViewsPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.initViewsPanelAddRemoveButtons(mainPanel);
        this.pnViews.add(mainPanel);
        return this.pnViews;
    }

    private void initViewsPanelAddRemoveButtons(JPanel main) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonViewAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON"));
        this.buttonViewAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonViewAdd.addActionListener(new AddView());
        this.buttonViewAdd.setEnabled(false);
        this.buttonViewAdd.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Add"));
        this.buttonViewRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON"));
        this.buttonViewRemove.setPreferredSize(new Dimension(32, 32));
        this.buttonViewRemove.setEnabled(false);
        this.buttonViewRemove.addActionListener(new RemoveView());
        this.buttonViewRemove.setToolTipText(Messages.getString("SchemaPropertiesDialogEx.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonViewAdd);
        verticalBox.add(this.buttonViewRemove);
        verticalBox.add(Box.createVerticalGlue());
        main.add((Component)verticalBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void setProperties() {
        ContainerObject item;
        int i;
        String oldName = this.schemaObject.getName();
        this.schemaObject.setName(this.tfName.getText());
        this.schemaObject.setComment(this.taComments.getText());
        this.schemaObject.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.schemaObject.setNotes(this.taNotes.getText());
        for (i = 0; i < this.selectedTablesList.getModel().getSize(); ++i) {
            item = (Table)this.selectedTablesList.getModel().getElementAt(i);
            item.setSchemaObject(this.schemaObject, oldName);
            item.fireNameChangedNoDirty();
        }
        for (i = 0; i < this.selectedViewsList.getModel().getSize(); ++i) {
            item = (TableView)this.selectedViewsList.getModel().getElementAt(i);
            item.setSchemaObject(this.schemaObject, oldName);
            item.fireNameChangedNoDirty();
        }
        for (i = 0; i < this.selectedIndexesList.getModel().getSize(); ++i) {
            item = (Index)this.selectedIndexesList.getModel().getElementAt(i);
            item.setSchemaObject(this.schemaObject, oldName);
        }
        for (i = 0; i < this.allTablesList.getModel().getSize(); ++i) {
            item = (Table)this.allTablesList.getModel().getElementAt(i);
            if (item.getSchemaObject() != this.schemaObject) continue;
            item.setSchemaObject(null);
            item.fireNameChangedNoDirty();
        }
        for (i = 0; i < this.allViewsList.getModel().getSize(); ++i) {
            item = (TableView)this.allViewsList.getModel().getElementAt(i);
            if (item.getSchemaObject() != this.schemaObject) continue;
            item.setSchemaObject(null);
            item.fireNameChangedNoDirty();
        }
        for (i = 0; i < this.allIndexesList.getModel().getSize(); ++i) {
            item = (Index)this.allIndexesList.getModel().getElementAt(i);
            if (item.getSchemaObject() != this.schemaObject) continue;
            item.setSchemaObject(null);
        }
        this.setMeasurements(this.schemaObject);
        this.setChangeRequests(this.schemaObject);
        this.setResponsibleParties(this.schemaObject);
        this.setDocuments(this.schemaObject);
        SchemaObjectPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.schemaObject.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.schemaObject.setProperty(dp.getName(), dp.getValue());
        }
        this.schemaObject.updateRemoteObjectListeners();
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (list.get(i).toString().compareTo(list.get(i - 1).toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class RemoveView
    implements ActionListener {
        private RemoveView() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.selectedViewsList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.allViewsModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedViewsModel.removeElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allViewsModel.addElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.allViewsModel);
        }
    }

    private class AddView
    implements ActionListener {
        private AddView() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.allViewsList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.selectedViewsModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedViewsModel.addElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allViewsModel.removeElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.selectedViewsModel);
        }
    }

    private class RemoveIndex
    implements ActionListener {
        private RemoveIndex() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.selectedIndexesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.allIndexesModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.allIndexesModel.addElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.selectedIndexesModel.removeElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.allIndexesModel);
        }
    }

    private class AddIndex
    implements ActionListener {
        private AddIndex() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.allIndexesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.selectedIndexesModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedIndexesModel.addElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allIndexesModel.removeElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.selectedIndexesModel);
        }
    }

    private class RemoveTable
    implements ActionListener {
        private RemoveTable() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.selectedTablesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.allTablesModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedTablesModel.removeElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allTablesModel.addElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.allTablesModel);
        }
    }

    private class AddTable
    implements ActionListener {
        private AddTable() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = SchemaObjectPropertiesDialogEx.this.allTablesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                if (SchemaObjectPropertiesDialogEx.this.selectedTablesModel.contains(selected[i])) continue;
                SchemaObjectPropertiesDialogEx.this.selectedTablesModel.addElement(selected[i]);
                SchemaObjectPropertiesDialogEx.this.allTablesModel.removeElement(selected[i]);
            }
            SchemaObjectPropertiesDialogEx.this.sort(SchemaObjectPropertiesDialogEx.this.selectedTablesModel);
        }
    }
}

