/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_TableView;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.designrules.DRViewCaseType;
import oracle.dbtools.crest.model.designrules.DRViewMaxNameLength;
import oracle.dbtools.crest.model.designrules.DRViewValidCharacters;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QueryBuilderPanel;
import oracle.dbtools.crest.swingui.editor.viewbuilder.ViewBuilder;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.DMSQLQueryTester;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.ResultTesterComponent;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.LNComboTableCellRenderer;

public class TableViewPropertiesDialogEx
extends AbstractPropertiesDialog {
    private TableView tableView;
    private JButton btnQueryBuilder;
    private JComboBox cbBaseOnStructuredType;
    private JDialog builder;
    private StructuredType st_type;
    protected JTextArea userDefinedSQL;
    private JPanel pnElementComments;
    private JTable tbElements;
    private List lsElements;
    private JCheckBox chTypeSubst;
    private JTextField tfOIDColumns;
    private JTree tree;
    private JComboBox cbSchemaObject;
    private JCheckBox chIncludeSchemaNameInQuery;
    private JCheckBox chAutoJoin;
    private JComboBox cbSubViews;
    private JButton btnTestQuery;
    private int currentElement;
    private JCheckBox chMarkGenerate;
    private JTextArea taColumnComments;
    private JTextArea taColumnNotes;
    private JTextArea taColumnCommentsInRDBMS;
    private JCheckBox chbDeprecated;

    public TableViewPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public TableViewPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    protected int getMinimumHeight() {
        return 500;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableViewPropertiesDialogEx.ViewProperties");
    }

    private List getStructuredTypes() {
        ArrayList<StructuredType> result = new ArrayList<StructuredType>();
        Iterator it = this.tableView.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (!st.isInstantiable()) continue;
            result.add(st);
        }
        return result;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof TableView) {
            object.updateFromRemoteObject(false);
            this.tableView = (TableView)object;
            this.initDefaults();
            this.fillComboItems(this.getStructuredTypes().toArray(), this.cbBaseOnStructuredType, true);
            this.cbBaseOnStructuredType.setSelectedItem(this.tableView.getBasedOnStructuredType());
            if (this.tableView.isBST()) {
                this.st_type = this.tableView.getBasedOnStructuredType();
                this.tfOIDColumns.setText(this.tableView.getOidText());
            }
            this.chTypeSubst.setSelected(this.tableView.isAllowTypeSubstitution());
            if (!this.tableView.isBST() || this.tableView.isBST() && this.tableView.getSubTypeSubstitutions().size() > 0) {
                this.chTypeSubst.setEnabled(false);
            }
            if (this.btnQueryBuilder != null) {
                this.btnQueryBuilder.setEnabled(this.isEditable());
            }
            this.enablePanels(this.st_type != null);
            this.chIncludeSchemaNameInQuery.setSelected(this.tableView.includeSchemaNameInQuery());
            this.updateElementsList();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.taBeforeDrop.setText(this.tableView.getBeforeDrop());
            this.taBeforeCreate.setText(this.tableView.getBeforeCreate());
            this.taAfterCreate.setText(this.tableView.getAfterCreate());
            this.taEndOfScript.setText(this.tableView.getEndOfScript());
            this.chGenerateScript.setSelected(this.tableView.getShouldGenerateScript());
            this.taBeforeDrop.setCaretPosition(0);
            this.taBeforeCreate.setCaretPosition(0);
            this.taAfterCreate.setCaretPosition(0);
            this.taEndOfScript.setCaretPosition(0);
            this.fillComboItems(((RelationalDesign)this.tableView.getDesignPart()).getSchemaObjectSet().toArray(), this.cbSchemaObject, true);
            this.cbSchemaObject.setSelectedItem(this.tableView.getSchemaObject());
            String useObjectsFrom = this.tableView.getUseObjectsOnlyFrom();
            DesignPartView usedDPV = null;
            this.cbSubViews.addItem(this.tableView.getDesignPart().getMainView());
            Iterator svit = this.tableView.getDesignPart().getDesignSubviews().iterator();
            while (svit.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)svit.next();
                DesignPartView dpv = ph.getDesignPartView();
                this.cbSubViews.addItem(dpv);
                if (useObjectsFrom.length() <= 0 || !dpv.getDPVId().equalsIgnoreCase(useObjectsFrom)) continue;
                usedDPV = dpv;
            }
            if (usedDPV != null) {
                this.cbSubViews.setSelectedItem(usedDPV);
            }
            CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_TableView(this.tableView, null));
            ImpactTreeRenderer renderer = new ImpactTreeRenderer();
            this.tree.setModel(treeDesign);
            this.tree.setCellRenderer(renderer);
            this.dynamicPropertiesList.clear();
            Iterator it = this.tableView.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.tableView.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
            this.chMarkGenerate.setSelected(this.tableView.isMarkedGenerate());
            this.chbDeprecated.setSelected(this.tableView.isDeprecated());
        }
    }

    private void updateElementsList() {
        this.currentElement = -1;
        this.taColumnComments.setText("");
        this.taColumnComments.setEnabled(false);
        this.taColumnCommentsInRDBMS.setText("");
        this.taColumnCommentsInRDBMS.setEnabled(false);
        this.taColumnNotes.setText("");
        this.taColumnNotes.setEnabled(false);
        ContainedObject[] elements = this.tableView.getElements();
        List<ContainedObject> tempList = Arrays.asList(elements);
        for (int i = this.lsElements.size() - 1; i >= 0; --i) {
            ElementHelper elementHelper = (ElementHelper)this.lsElements.get(i);
            if (tempList.contains(elementHelper.getElement())) continue;
            this.lsElements.remove(i);
        }
        for (AbstractViewElement abstractViewElement : tempList) {
            if (this.listContainsElement(abstractViewElement)) continue;
            ElementHelper helper = new ElementHelper(abstractViewElement);
            this.lsElements.add(helper);
        }
        this.tbElements.updateUI();
        this.tbElements.clearSelection();
    }

    @Override
    protected void showComponent(Component component) {
        this.setPreviousSelectedElement();
        super.showComponent(component);
    }

    private boolean listContainsElement(AbstractViewElement element) {
        for (ElementHelper helper : this.lsElements) {
            if (helper.getElement() != element) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setProperties() {
        TableViewPropertiesDialogEx.stopCellEditing(this.tbElements);
        this.tableView.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
        this.tableView.setName(this.tfName.getText());
        this.tableView.setComment(this.taComments.getText());
        this.tableView.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.tableView.setNotes(this.taNotes.getText());
        this.tableView.setBasedOnStructuredType((StructuredType)this.cbBaseOnStructuredType.getSelectedItem());
        if (this.tableView.isBST()) {
            this.tableView.setOidText(this.tfOIDColumns.getText().trim());
        }
        this.tableView.setAllowTypeSubstitution(this.chTypeSubst.isSelected());
        this.tableView.setIncludeSchemaNameInQuery(this.chIncludeSchemaNameInQuery.isSelected());
        if (this.cbSubViews.getSelectedIndex() > 0) {
            this.tableView.setUseObjectsOnlyFrom(((DesignPartView)this.cbSubViews.getSelectedItem()).getDPVId());
        } else {
            this.tableView.setUseObjectsOnlyFrom("");
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.tableView.setBeforeDrop(this.taBeforeDrop.getText());
        this.tableView.setBeforeCreate(this.taBeforeCreate.getText());
        this.tableView.setAfterCreate(this.taAfterCreate.getText());
        this.tableView.setEndOfScript(this.taEndOfScript.getText());
        this.tableView.setShouldGenerateScript(this.chGenerateScript.isSelected());
        for (ColumnView cv : this.tableView.getElementsCollection()) {
            String name = cv.getPresentationName(false);
            if (name.equals(cv.getName())) continue;
            cv.setName(name);
        }
        this.checkNamingOptions();
        TableViewPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.tableView.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.tableView.setProperty(dp.getName(), dp.getValue());
        }
        this.tableView.setMarkedGenerate(this.chMarkGenerate.isSelected());
        this.tableView.setDeprecated(this.chbDeprecated.isSelected());
        this.applyElementsComments();
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRViewMaxNameLength(), this.tableView);
        this.checkDesignRule(new DRViewCaseType(), this.tableView);
        this.checkDesignRule(new DRViewValidCharacters(), this.tableView);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getElementCommentsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getScriptPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "VIEW_PROPERTIES_DIALOG";
    }

    public JDialog getBuilder() {
        if (this.builder == null) {
            this.builder = new ViewBuilder(this.tableView).getDialog(this.getAppView());
            return this.builder;
        }
        return this.builder;
    }

    private void enablePanels(boolean enable) {
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 210;
    }

    private void initGeneral() {
        JLabel lbQueryBuilder = new JLabel(Messages.getString("TableViewPropertiesDialogEx.QueryBuilder"));
        lbQueryBuilder.setPreferredSize(this.getDefaultSize());
        this.btnQueryBuilder = new JButton(BTN_QUERY);
        this.btnQueryBuilder.setHorizontalAlignment(2);
        this.btnQueryBuilder.setPreferredSize(this.getDefaultSize());
        this.btnQueryBuilder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryBuilderPanel qb = new QueryBuilderPanel(TableViewPropertiesDialogEx.this.tableView);
                DesignPartView useDPV = null;
                if (TableViewPropertiesDialogEx.this.cbSubViews.getSelectedIndex() > 0) {
                    useDPV = (DesignPartView)TableViewPropertiesDialogEx.this.cbSubViews.getSelectedItem();
                }
                qb.getDialog(TableViewPropertiesDialogEx.this.getAppView(), TableViewPropertiesDialogEx.this.chIncludeSchemaNameInQuery.isSelected() && TableViewPropertiesDialogEx.this.tableView.getSchemaObject() != null, useDPV, TableViewPropertiesDialogEx.this.chAutoJoin.isSelected()).setVisible(true);
                TableViewPropertiesDialogEx.this.updateElementsList();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbQueryBuilder, this.btnQueryBuilder));
        JLabel lbBaseOnStructuredType = new JLabel(LB_BASED_ON_STRUCTURED_TYPE);
        lbBaseOnStructuredType.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType = new JComboBox();
        this.cbBaseOnStructuredType.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType.setMaximumRowCount(8);
        this.cbBaseOnStructuredType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = TableViewPropertiesDialogEx.this.cbBaseOnStructuredType.getSelectedItem();
                TableViewPropertiesDialogEx.this.st_type = (StructuredType)obj;
                if (TableViewPropertiesDialogEx.this.btnQueryBuilder != null) {
                    TableViewPropertiesDialogEx.this.btnQueryBuilder.setEnabled(TableViewPropertiesDialogEx.this.isEditable());
                }
                TableViewPropertiesDialogEx.this.enablePanels(TableViewPropertiesDialogEx.this.st_type != null);
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbBaseOnStructuredType, this.cbBaseOnStructuredType));
        JLabel lbIdentValue = new JLabel(LB_OID_COLUMNS);
        lbIdentValue.setPreferredSize(this.getDefaultSize());
        this.tfOIDColumns = new JTextField();
        this.tfOIDColumns.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbIdentValue, this.tfOIDColumns));
        JLabel lbSchemaObject = new JLabel(SCHEMA);
        lbSchemaObject.setPreferredSize(this.getDefaultSize());
        this.cbSchemaObject = new JComboBox();
        this.cbSchemaObject.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSchemaObject, this.cbSchemaObject));
        JLabel lbIncludeSchemaNameInQuery = new JLabel(Messages.getString("TableViewPropertiesDialogEx.IncludeSchemaNameInQuery"));
        lbIncludeSchemaNameInQuery.setPreferredSize(this.getDefaultSize());
        this.chIncludeSchemaNameInQuery = new JCheckBox();
        this.chIncludeSchemaNameInQuery.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbIncludeSchemaNameInQuery, this.chIncludeSchemaNameInQuery));
        this.cbSchemaObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.chIncludeSchemaNameInQuery.setEnabled(TableViewPropertiesDialogEx.this.cbSchemaObject.getSelectedItem() != null);
            }
        });
        JLabel lbAutoJoin = new JLabel(Messages.getString("TableViewPropertiesDialogEx.AutoJoinOnFKs"));
        lbAutoJoin.setPreferredSize(this.getDefaultSize());
        this.chAutoJoin = new JCheckBox();
        this.chAutoJoin.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAutoJoin, this.chAutoJoin));
        this.chAutoJoin.setSelected(ApplicationView.getInstance().getSettings().isAutoJoinOnFK());
        this.chAutoJoin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.tableView.getAppView().getSettings().setAutoJoinOnFK(TableViewPropertiesDialogEx.this.chAutoJoin.isSelected());
            }
        });
        JLabel lbUseObjectsFrom = new JLabel(Messages.getString("TableViewPropertiesDialogEx.UseObjectsFrom"));
        lbUseObjectsFrom.setPreferredSize(this.getDefaultSize());
        this.cbSubViews = new JComboBox();
        this.cbSubViews.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbUseObjectsFrom, this.cbSubViews));
        JLabel lbTypeSubst = new JLabel(Messages.getString("TableViewPropertiesDialogEx.AllowTypeSubstitution"));
        lbTypeSubst.setPreferredSize(this.getDefaultSize());
        this.chTypeSubst = new JCheckBox();
        this.chTypeSubst.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbTypeSubst, this.chTypeSubst));
        JLabel lbMarkGenerate = new JLabel(Messages.getString("TablePropertiesDialogEx.GenerateInDDL"));
        lbMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.chMarkGenerate = new JCheckBox();
        this.chMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbMarkGenerate, this.chMarkGenerate));
        JLabel lbDeprecated = new JLabel(Messages.getString("TablePropertiesDialogEx.Deprecated"));
        lbDeprecated.setPreferredSize(this.getDefaultSize());
        this.chbDeprecated = new JCheckBox();
        this.chbDeprecated.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDeprecated, this.chbDeprecated));
        JLabel lbTestQuery = new JLabel("");
        lbTestQuery.setPreferredSize(this.getDefaultSize());
        this.btnTestQuery = new JButton(Messages.getString("TableViewPropertiesDialogEx.TestQuery"));
        this.btnTestQuery.setHorizontalAlignment(2);
        this.btnTestQuery.setPreferredSize(this.getDefaultSize());
        this.btnTestQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMSQLQueryTester.registerComponent(ResultTesterComponent.class);
                DMSQLQueryTester qt = new DMSQLQueryTester(null);
                qt.showDialog(TableViewPropertiesDialogEx.this, QBUtils.getSQL(TableViewPropertiesDialogEx.this.tableView.getUserDefinedSQL()));
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbTestQuery, this.btnTestQuery));
    }

    private void setElementSelected() {
        int row;
        if (this.currentElement > -1) {
            this.setPreviousSelectedElement();
        }
        if ((row = this.tbElements.getSelectedRow()) != -1 && this.lsElements.size() > 0 && row < this.lsElements.size()) {
            this.currentElement = row;
            ElementHelper helper = (ElementHelper)this.lsElements.get(row);
            this.taColumnComments.setText(helper.getComments());
            this.taColumnComments.setEnabled(true);
            this.taColumnCommentsInRDBMS.setText(helper.getCommentsInRDBMS());
            this.taColumnCommentsInRDBMS.setEnabled(true);
            this.taColumnNotes.setText(helper.getNotes());
            this.taColumnNotes.setEnabled(true);
        }
    }

    protected JPanel getElementCommentsPanel() {
        if (this.pnElementComments == null) {
            this.currentElement = -1;
            this.pnElementComments = this.createPage(PANEL_COLUMN_COMMENTS);
            this.tbElements = new JTable(new ElementsModel());
            this.tbElements.setSelectionMode(0);
            this.tbElements.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TableViewPropertiesDialogEx.this.setElementSelected();
                }
            });
            this.tbElements.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (TableViewPropertiesDialogEx.this.lsElements.isEmpty()) {
                        TableViewPropertiesDialogEx.this.taColumnComments.setText("");
                        TableViewPropertiesDialogEx.this.taColumnComments.setEnabled(false);
                        TableViewPropertiesDialogEx.this.taColumnCommentsInRDBMS.setText("");
                        TableViewPropertiesDialogEx.this.taColumnCommentsInRDBMS.setEnabled(false);
                        TableViewPropertiesDialogEx.this.taColumnNotes.setText("");
                        TableViewPropertiesDialogEx.this.taColumnNotes.setEnabled(false);
                    } else {
                        TableViewPropertiesDialogEx.this.taColumnComments.setEnabled(true);
                        TableViewPropertiesDialogEx.this.taColumnCommentsInRDBMS.setEnabled(true);
                        TableViewPropertiesDialogEx.this.taColumnNotes.setEnabled(true);
                        TableViewPropertiesDialogEx.this.setElementSelected();
                    }
                }
            });
            this.lsElements = new ArrayList();
            JScrollPane sp = new JScrollPane(this.tbElements);
            sp.setPreferredSize(new Dimension(200, 200));
            this.pnElementComments.add((Component)sp, "North");
            JTabbedPane tpComments = new JTabbedPane();
            this.taColumnComments = new JTextArea();
            this.taColumnComments.setLineWrap(true);
            this.taColumnComments.setWrapStyleWord(true);
            this.taColumnNotes = new JTextArea();
            this.taColumnNotes.setLineWrap(true);
            this.taColumnNotes.setWrapStyleWord(true);
            this.taColumnCommentsInRDBMS = new JTextArea();
            this.taColumnCommentsInRDBMS.setLineWrap(true);
            this.taColumnCommentsInRDBMS.setWrapStyleWord(true);
            tpComments.addTab(Messages.getString("TableViewPropertiesDialogEx.Comments"), new JScrollPane(this.taColumnComments));
            tpComments.addTab(Messages.getString("TableViewPropertiesDialogEx.CommentsInRDBMS"), new JScrollPane(this.taColumnCommentsInRDBMS));
            tpComments.addTab(Messages.getString("TableViewPropertiesDialogEx.Notes"), new JScrollPane(this.taColumnNotes));
            this.pnElementComments.add((Component)tpComments, "Center");
        }
        return this.pnElementComments;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel pnImpact = this.createPage(Messages.getString("TableViewPropertiesDialogEx.ImpactAnalysis"));
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = TableViewPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        obj.showPropertyDialog();
                    } else {
                        if (TableViewPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            TableViewPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            TableViewPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void setPreviousSelectedElement() {
        if (this.currentElement > -1) {
            ElementHelper helper = (ElementHelper)this.lsElements.get(this.currentElement);
            helper.setComments(this.taColumnComments.getText());
            helper.setCommentsInRDBMS(this.taColumnCommentsInRDBMS.getText());
            helper.setNotes(this.taColumnNotes.getText());
        }
    }

    private void applyElementsComments() {
        this.setPreviousSelectedElement();
        for (ElementHelper helper : this.lsElements) {
            helper.applyComments();
            helper.applyCommentsInRDBMS();
            helper.applyNotes();
        }
    }

    public class ElementHelper {
        AbstractViewElement element;
        String comments;
        String commentsInRDBMS;
        String notes;

        public ElementHelper(AbstractViewElement element) {
            this.element = element;
            this.comments = element.getComment();
            this.commentsInRDBMS = element.getCommentInRDBMS();
            this.notes = element.getNotes();
        }

        public AbstractViewElement getElement() {
            return this.element;
        }

        public String getName() {
            if (!"".equals(this.element.getAlias())) {
                return this.element.getAlias();
            }
            return this.element.getName();
        }

        public String getRefContainerName() {
            if (this.element.getReferencedContainer() != null) {
                return this.element.getReferencedContainer().getName();
            }
            return "";
        }

        public String getHeaderAlias() {
            return this.element.getHeaderAlias();
        }

        public void setHeaderAlias(String headerAlias) {
            this.element.setHeaderAlias(headerAlias);
        }

        public void applyComments() {
            this.element.setComment(this.comments);
        }

        public void applyCommentsInRDBMS() {
            this.element.setCommentInRDBMS(this.commentsInRDBMS);
        }

        public void applyNotes() {
            this.element.setNotes(this.notes);
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String getCommentsInRDBMS() {
            return this.commentsInRDBMS;
        }

        public void setCommentsInRDBMS(String commentsInRDBMS) {
            this.commentsInRDBMS = commentsInRDBMS;
        }

        public String getNotes() {
            return this.notes;
        }

        public void setNotes(String notes) {
            this.notes = notes;
        }
    }

    public class ComboModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TableViewPropertiesDialogEx.Column");
            }
            if (column == 1) {
                return Messages.getString("TableViewPropertiesDialogEx.Table");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!TableViewPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return columnIndex != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ComboTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox combo;

        ComboTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.combo = (JComboBox)value;
            this.combo.setOpaque(true);
            return this.combo;
        }
    }

    public class ElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return TableViewPropertiesDialogEx.this.lsElements.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TableViewPropertiesDialogEx.Column");
            }
            if (column == 1) {
                return Messages.getString("TableViewPropertiesDialogEx.HeaderAlias");
            }
            if (column == 2) {
                return Messages.getString("TableViewPropertiesDialogEx.ReferencedContainer");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ElementHelper helper = (ElementHelper)TableViewPropertiesDialogEx.this.lsElements.get(row);
            if (col == 0) {
                return helper.getName();
            }
            if (col == 1) {
                return helper.getHeaderAlias();
            }
            if (col == 2) {
                return helper.getRefContainerName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                ElementHelper helper = (ElementHelper)TableViewPropertiesDialogEx.this.lsElements.get(rowIndex);
                helper.setHeaderAlias(obj.toString());
            }
        }
    }

    class ColumnTable
    extends JTable {
        ComboModel dataModel;

        public ColumnTable() {
            this.dataModel = new ComboModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return super.getCellRenderer(row, col);
            }
            return new LNComboTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ComboTableCellEditor();
        }
    }
}

