/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.PermissionsPropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ColumnsPermissionsDialogDB2
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = Messages.getString("ColumnsPermissionsDialogDB2.1");
    protected static final String EDIT = Messages.getString("ColumnsPermissionsDialogDB2.Edit");
    private StorageObject storageObject;
    private Object[] columnsSet;
    private StorageObject user;
    private AbstractStorageDesignDB2 storageDesign;
    private JButton bnCancel;
    private JPanel jpanel;
    private PermissionsPropertyDialogDB2 permDialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogDB2.this.bnCancel.doClick();
        }
    };
    private ColumnsTable columnsTable;

    public ColumnsPermissionsDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object, StorageObject user, PermissionsPropertyDialogDB2 permDialog) {
        super(view.getFrame());
        this.storageDesign = (AbstractStorageDesignDB2)storageDesign;
        this.storageObject = object;
        this.user = user;
        this.storageObject.setDialogVisible(true, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ColumnsPermissionsDialogDB2.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(Messages.getString("ColumnsPermissionsDialogDB2.OK"));
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        bottomPanel.add(bnOK);
        this.getRootPane().setDefaultButton(bnOK);
        JButton bnApply = new JButton(Messages.getString("ColumnsPermissionsDialogDB2.Apply"));
        bnApply.addActionListener(new ApplyAction());
        bnApply.setCursor(Cursor.getPredefinedCursor(12));
        bnApply.setMnemonic(65);
        bottomPanel.add(bnApply);
        this.bnCancel = new JButton(Messages.getString("ColumnsPermissionsDialogDB2.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        AbstractPropertyDialog.equalizeButtonSizes(bnApply, this.bnCancel);
        AbstractPropertyDialog.equalizeButtonSizes(bnOK, this.bnCancel);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escape);
        bottomPanel.add(this.bnCancel);
        this.jpanel.add((Component)bottomPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.initColumnsTable();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        this.setModal(true);
        this.setResizable(false);
        this.permDialog = permDialog;
    }

    public void initProperties() {
        for (int i = 0; i < this.columnsTable.getRowCount(); ++i) {
            ColumnProxyDB2 column = (ColumnProxyDB2)this.columnsTable.getValueAt(i, 0);
            for (int k = 0; k < this.columnsTable.getColumnCount(); ++k) {
                if (!(this.columnsTable.getValueAt(i, k) instanceof JButton)) continue;
                JButton button = (JButton)this.columnsTable.getValueAt(i, k);
                if (this.getPermission(this.user, this.storageObject, column) != null) {
                    if (this.getPermission(this.user, this.storageObject, column).getPrivs(column).indexOf(this.columnsTable.getColumnName(k)) > -1) {
                        button.setText(CHECKED);
                        button.setBackground(Color.WHITE);
                        button.updateUI();
                        continue;
                    }
                    button.setText(EMPTY_VALUE);
                    button.setBackground(Color.WHITE);
                    button.updateUI();
                    continue;
                }
                button.setText(EMPTY_VALUE);
                button.setBackground(Color.WHITE);
                button.updateUI();
            }
        }
    }

    private void initColumnsTable() {
        this.columnsSet = ((TableProxyDB2)this.storageObject).getColumnProxies();
        this.columnsTable = new ColumnsTable();
        JScrollPane scrollpane = new JScrollPane(this.columnsTable);
        scrollpane.setPreferredSize(new Dimension(440, 180));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.jpanel.add(scrollpane);
        this.columnsTable.updateUI();
        ColumnsModel tableModel = (ColumnsModel)this.columnsTable.getModel();
        for (int i = 0; i < this.columnsSet.length; ++i) {
            ColumnProxyDB2 column = (ColumnProxyDB2)this.columnsSet[i];
            String[] list = (String[])PermissionsDB2.getColumnPermissionsValues().toArray();
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(column);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    private boolean hasSelectedColumnsPrivileges(int row) {
        for (int k = 1; k < this.columnsTable.getColumnCount(); ++k) {
            JButton button;
            if (!(this.columnsTable.getValueAt(row, k) instanceof JButton) || !(button = (JButton)this.columnsTable.getValueAt(row, k)).getText().equals(CHECKED)) continue;
            return true;
        }
        return false;
    }

    protected void setProperties() {
        int i;
        PermissionsDB2 perm = this.getPermission(this.user, this.storageObject);
        if (perm != null) {
            perm.clearColPermissions();
        }
        for (i = 0; i < this.columnsTable.getRowCount(); ++i) {
            ColumnProxyDB2 column = (ColumnProxyDB2)this.columnsTable.getValueAt(i, 0);
            if (this.hasSelectedColumnsPrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    if (this.user instanceof Owner) {
                        perm.setUser((Owner)this.user);
                    }
                    perm.setTable((TableProxyDB2)this.storageObject);
                }
                String columnPrivileges = "";
                columnPrivileges = columnPrivileges.concat(column.getName());
                for (int k = 0; k < this.columnsTable.getColumnCount(); ++k) {
                    JButton button;
                    if (!(this.columnsTable.getValueAt(i, k) instanceof JButton) || !(button = (JButton)this.columnsTable.getValueAt(i, k)).getText().equals(CHECKED)) continue;
                    columnPrivileges = columnPrivileges.concat(", ").concat(this.columnsTable.getColumnName(k));
                    this.permDialog.setColumnPermissions(this.user, this.columnsTable.getColumnName(k));
                }
                perm.setColumnList(columnPrivileges);
                continue;
            }
            if (perm == null || !perm.getColumns().isEmpty()) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
            for (int k = 0; k < this.columnsTable.getColumnCount(); ++k) {
                if (!(this.columnsTable.getValueAt(i, k) instanceof JButton)) continue;
                this.permDialog.clearColumnPermissions(this.user, this.columnsTable.getColumnName(k));
            }
        }
        for (i = 1; i < this.columnsTable.getColumnCount(); ++i) {
            boolean marked = false;
            for (int j = 0; j < this.columnsTable.getRowCount(); ++j) {
                if (!((JButton)this.columnsTable.getValueAt(j, i)).getText().equalsIgnoreCase(CHECKED)) continue;
                marked = true;
                break;
            }
            if (marked) continue;
            this.permDialog.clearColumnPermissions(this.user, this.columnsTable.getColumnName(i));
        }
    }

    public String getCaption() {
        return Messages.getString("ColumnsPermissionsDialogDB2.Permissions");
    }

    private PermissionsDB2 getPermission(StorageObject user, StorageObject proxy, StorageObject column) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        while (it.hasNext()) {
            PermissionsDB2 perm = (PermissionsDB2)it.next();
            if (perm.getUser() != user || perm.getTable() != proxy && perm.getView() != proxy || !perm.getColumns().contains(column.getName())) continue;
            return perm;
        }
        return null;
    }

    private PermissionsDB2 getPermission(StorageObject user, StorageObject proxy) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        while (it.hasNext()) {
            PermissionsDB2 perm = (PermissionsDB2)it.next();
            if (perm.getUser() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
            return perm;
        }
        return null;
    }

    public StorageObject getUser() {
        return this.user;
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            if (value != null) {
                this.button.setOpaque(true);
                this.button.setBackground(table.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(false);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            try {
                this.setText(value == null ? "" : "  " + ((JButton)value).getText());
            }
            catch (Exception e) {
                // empty catch block
            }
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            if (value == null) {
                this.setText("");
            } else if (value instanceof ColumnProxyDB2) {
                this.setText(" " + ((ColumnProxyDB2)value).getName());
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogDB2.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogDB2.this.setProperties();
            ColumnsPermissionsDialogDB2.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogDB2.this.setProperties();
            ColumnsPermissionsDialogDB2.this.storageObject.setDirty(true);
            ColumnsPermissionsDialogDB2.this.dispose();
        }
    }

    class ColumnsTable
    extends JTable {
        ColumnsModel dataModel;

        public ColumnsTable() {
            this.dataModel = new ColumnsModel();
            this.setModel(this.dataModel);
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 3; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(220);
                    continue;
                }
                column.setPreferredWidth(80);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class ColumnsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] perms = PermissionsDB2.getColumnPermissionsValues().toArray();
            return perms.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            Object[] perms = PermissionsDB2.getColumnPermissionsValues().toArray();
            if (column == 0) {
                return Messages.getString("ColumnsPermissionsDialogDB2.Column");
            }
            for (int i = 1; i < this.getColumnCount(); ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

