/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2.v80;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnIdentityDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnProxyDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.ColumnPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ColumnPropertyDialogDB2v80
extends ColumnPropertyDialogDB2 {
    protected JComboBox cbOrder;
    private String comment;
    private String commentInRDBMS;
    private boolean order;

    public ColumnPropertyDialogDB2v80(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
    }

    @Override
    protected void initColumnIdentity() {
        this.initUseIdentity();
        this.initGenerate();
        this.initStartWith();
        this.initIncremetBy();
        this.initMinValue();
        this.initMaxValue();
        this.initCycle();
        this.initCache();
        this.initOrder();
        this.setIdentityUse(false);
    }

    protected void initOrder() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogDB2v80.Order"));
        this.columnIdentity.add(label);
        this.cbOrder = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOrder);
        this.cbOrder.setPreferredSize(this.tfName.getPreferredSize());
        this.columnIdentity.add(this.cbOrder);
        this.setLabelConstraints(this.getColumnIdentityLayout(), label, 260);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.cbOrder, 260);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.column.getName());
        this.tfName.setText(this.column.getName());
        this.tfDataType.setText(this.column.getDatatypeString());
        this.cbNullsAllowed.setSelectedItem(this.column.getColumn().getNullsAllowed() ? YES_NO[0] : YES_NO[1]);
        this.ifColNo.setValue((long)this.column.getColno());
        this.ifKeySeq.setValue((long)this.column.getKeyseq());
        this.cbDataFormat.setSelectedItem(this.column.getBitData());
        this.cbDataFormat.setEnabled(this.dataTypeIsCharacter(this.column));
        this.cbDefault.setSelectedItem(this.column.getDefault() ? YES_NO[0] : YES_NO[1]);
        this.cbDefaultValue.setSelectedItem(this.column.getDefaultValue());
        this.tfDefaultConstant.setText(this.column.getDefaultValueConstant());
        this.tfLabel.setText(this.column.getLabel());
        this.dfUpdateRatePercent.setValue(this.column.getUpdateRatePercent());
        this.dfAverageLength.setValue(this.column.getAverageLength());
        this.dfGrowthPercent.setValue(this.column.getGrowthPercent());
        this.ifInitial.setValue(this.column.getInitial());
        this.ifFrequencyCount.setValue(this.column.getFrequencyCount());
        this.dfFrequencyPercent.setValue(this.column.getFrequencyPercent());
        this.tfProgram.setText(this.column.getProgram());
        this.tfConstant.setText(this.column.getConstant());
        this.initColumnIdentityProperties();
        this.comment = this.column.getObject().getComment();
        this.commentInRDBMS = this.column.getObject().getCommentInRDBMS();
        if (this.column.isCommentChanged()) {
            this.getCommentsList().insert(this.column.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.column.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.column.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.enableFieldProc(this.column);
    }

    @Override
    protected void initColumnIdentityAdditionalProperties(ColumnIdentityDB2 identity) {
        Column columnObject = (Column)this.column.getObject();
        this.order = columnObject.isAutoIncrementOrder();
        if (((ColumnProxyDB2v80)this.column).isOrderChanged()) {
            if (identity != null) {
                this.cbOrder.setSelectedItem(ColumnPropertyDialogDB2v80.translateYesNoForDisplay(((ColumnIdentityDB2v80)identity).getOrder()));
            } else {
                this.cbOrder.setSelectedItem(YES_NO[1]);
            }
        } else if (identity != null) {
            this.cbOrder.setSelectedItem(this.order ? YES_NO[0] : YES_NO[1]);
        } else {
            this.cbOrder.setSelectedItem(YES_NO[1]);
        }
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            this.column.setName(this.tfName.getText());
            this.column.setBitData((String)this.cbDataFormat.getSelectedItem());
            Object selected = this.cbDefault.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.column.setDefault(result);
            this.column.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
            this.column.setDefaultValueConstant(this.tfDefaultConstant.getText());
            this.column.setLabel(this.tfLabel.getText());
            this.column.setUpdateRatePercent(this.dfUpdateRatePercent.getFloatValue());
            this.column.setAverageLength(this.dfAverageLength.getFloatValue());
            this.column.setGrowthPercent(this.dfGrowthPercent.getFloatValue());
            this.column.setInitial(this.ifInitial.getIntValue());
            this.column.setFrequencyCount(this.ifFrequencyCount.getIntValue());
            this.column.setFrequencyPercent(this.dfFrequencyPercent.getFloatValue());
            this.column.setProgram(this.tfProgram.getText());
            this.column.setConstant(this.tfConstant.getText());
            this.setColumnIdentityProperties();
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.column.setComment(commentText);
                this.column.setCommentChanged(true);
            } else {
                this.column.setComment("");
                this.column.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.column.setCommentInRDBMS(commentInRDBMSText);
                this.column.setCommentInRDBMSChanged(true);
            } else {
                this.column.setCommentInRDBMS("");
                this.column.setCommentInRDBMSChanged(false);
            }
        }
    }

    @Override
    protected void setColumnIdentityAdditionalProperties(ColumnIdentityDB2 identity) {
        if (this.notEquals(this.order, this.cbOrder, YES, NO)) {
            ((ColumnIdentityDB2v80)identity).setOrder(ColumnPropertyDialogDB2v80.translateYesNoForStorage((String)this.cbOrder.getSelectedItem()));
            ((ColumnProxyDB2v80)this.column).setOrderChanged(true);
        } else {
            ((ColumnProxyDB2v80)this.column).setOrderChanged(false);
        }
    }

    @Override
    protected void setIdentityUse(boolean use) {
        super.setIdentityUse(use);
        this.cbOrder.setEnabled(use);
    }
}

