/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class LevelPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private LevelOracle level;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JComboBox cbTables;
    private TableProxy current;
    private DimensionAttributeOracle attribute;
    private DefaultListModel allAttrColumnsModel;
    private DefaultListModel selectedAttrColumnsModel;
    private JList allAttrColumnsList;
    private JList selectedAttrColumnsList;
    private JButton bnAttrAdd;
    private JButton bnAttrRemove;
    private JPanel attrPanel;
    private JTextField tfAttrName;
    private boolean first = true;

    public LevelPropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.level = (LevelOracle)object;
        this.attribute = this.getAttributeForLevel(this.level, (StorageDesignOracle)storageDesign);
        if (this.attribute == null) {
            this.attribute = this.createAttribute(this.level, (StorageDesignOracle)storageDesign);
        }
        this.setHeight(310);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("LevelPropertyDialogOracle.LevelProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    @Override
    protected void addTabs() {
        this.initAttributesView();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("LevelPropertyDialogOracle.AllColumns"));
        this.general.add(label);
        JLabel tlabel = new JLabel(Messages.getString("LevelPropertyDialogOracle.Table"));
        this.general.add(tlabel);
        this.cbTables = new JComboBox();
        this.setBG(this.cbTables);
        this.general.add(this.cbTables);
        this.cbTables.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TableProxy tp = (TableProxy)LevelPropertyDialogOracle.this.cbTables.getSelectedItem();
                if (tp != null && LevelPropertyDialogOracle.this.first || tp != LevelPropertyDialogOracle.this.current) {
                    LevelPropertyDialogOracle.this.first = false;
                    LevelPropertyDialogOracle.this.selectedColumnsModel.clear();
                    LevelPropertyDialogOracle.this.allColumnsModel.clear();
                    LevelPropertyDialogOracle.this.selectedAttrColumnsModel.clear();
                    LevelPropertyDialogOracle.this.allAttrColumnsModel.clear();
                    if (tp != null) {
                        ColumnProxy[] cps = tp.getColumnProxies();
                        for (int i = 0; i < cps.length; ++i) {
                            LevelPropertyDialogOracle.this.allColumnsModel.addElement(cps[i]);
                            LevelPropertyDialogOracle.this.allAttrColumnsModel.addElement(cps[i]);
                        }
                    }
                    LevelPropertyDialogOracle.this.current = tp;
                }
            }
        });
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 180));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), tlabel, 10, 48);
        this.setObjectConstraints(this.cbTables, 48);
        this.setLabelConstraints(this.getColumnsLayout(), label, 12, 74);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 92);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("LevelPropertyDialogOracle.LevelKey"));
        this.general.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 180));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 292, 74);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 290, 92);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("LevelPropertyDialogOracle.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.general.add(this.bnAdd);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAdd, 175, 145);
        this.bnRemove = new JButton(Messages.getString("LevelPropertyDialogOracle.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.general.add(this.bnRemove);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemove, 175, 175);
        LevelPropertyDialogOracle.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.level.getName());
        this.cbTables.addItem(null);
        Iterator it = this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            this.cbTables.addItem(it.next());
        }
        this.current = this.level.getLevelTable();
        if (this.current != null) {
            this.cbTables.setSelectedItem(this.current);
            this.selectedColumnsModel.clear();
            this.allColumnsModel.clear();
            this.selectedAttrColumnsModel.clear();
            this.allAttrColumnsModel.clear();
            ColumnProxy[] cps = this.current.getColumnProxies();
            for (int i = 0; i < cps.length; ++i) {
                this.allColumnsModel.addElement(cps[i]);
                this.allAttrColumnsModel.addElement(cps[i]);
            }
            block2: for (String colId : this.level.getColumnSet()) {
                for (int i = 0; i < cps.length; ++i) {
                    ColumnProxy col = cps[i];
                    if (!col.getObjectID().equals(colId)) continue;
                    this.selectedColumnsModel.addElement(col);
                    this.allColumnsModel.removeElement(col);
                    continue block2;
                }
            }
            this.initAttrProperties();
        }
        this.tfName.setText(this.level.getName());
        this.getCommentsList().insert(this.level.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.level != null) {
            this.level.setName(this.tfName.getText());
            Object[] colSet = this.selectedColumnsModel.toArray();
            this.level.clear();
            for (int i = 0; i < colSet.length; ++i) {
                Object ob = colSet[i];
                if (!(ob instanceof ColumnProxyOracle)) continue;
                this.level.setColumns(((ColumnProxyOracle)ob).getObjectID());
            }
            this.level.setComment(this.getCommentsList().getText());
            this.level.setLevelTable(this.current);
            this.setAttrProperties();
        }
    }

    private void initAttributesView() {
        this.attrPanel = new JPanel(new SpringLayout());
        JLabel lbName = new JLabel(Messages.getString("LevelPropertyDialogOracle.AttributeName"));
        this.attrPanel.add(lbName);
        this.tfAttrName = new JTextField("", 26);
        this.attrPanel.add(this.tfAttrName);
        this.setLabelConstraints(this.getAttrColumnsLayout(), lbName, 12, 20);
        this.setObjectConstraints(this.getAttrColumnsLayout(), this.tfAttrName, 20);
        this.initAttrAllColumnsList();
        this.initAttrSelectedColumnsList();
        this.initAttrButtons();
        this.tpane.add(Messages.getString("LevelPropertyDialogOracle.LevelAttributes"), this.attrPanel);
    }

    private void initAttrAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("LevelPropertyDialogOracle.AllColumns"));
        this.attrPanel.add(label);
        this.allAttrColumnsModel = new DefaultListModel();
        this.allAttrColumnsList = new JList(this.allAttrColumnsModel);
        ListSelectionModel listSelectionModel = this.allAttrColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AttrAllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allAttrColumnsList);
        sp.setPreferredSize(new Dimension(144, 202));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.attrPanel.add(sp);
        this.setLabelConstraints(this.getAttrColumnsLayout(), label, 12, 50);
        this.setObjectConstraints(this.getAttrColumnsLayout(), sp, 10, 70);
    }

    private void initAttrSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("LevelPropertyDialogOracle.DeterminedColumns"));
        this.attrPanel.add(label);
        this.selectedAttrColumnsModel = new DefaultListModel();
        this.selectedAttrColumnsList = new JList(this.selectedAttrColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedAttrColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AttrSelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedAttrColumnsList);
        sp.setPreferredSize(new Dimension(145, 202));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.attrPanel.add(sp);
        this.setLabelConstraints(this.getAttrColumnsLayout(), label, 292, 50);
        this.setObjectConstraints(this.getAttrColumnsLayout(), sp, 290, 70);
    }

    private void initAttrButtons() {
        this.bnAttrAdd = new JButton(Messages.getString("LevelPropertyDialogOracle.Add"));
        this.bnAttrAdd.addActionListener(new AttrAddColumnsActionListener());
        this.bnAttrAdd.setEnabled(false);
        this.attrPanel.add(this.bnAttrAdd);
        this.setObjectConstraints(this.getAttrColumnsLayout(), this.bnAttrAdd, 175, 145);
        this.bnAttrRemove = new JButton(Messages.getString("LevelPropertyDialogOracle.Remove"));
        this.bnAttrRemove.setEnabled(false);
        this.bnAttrRemove.addActionListener(new AttrRemoveColumnsActionListener());
        this.attrPanel.add(this.bnAttrRemove);
        this.setObjectConstraints(this.getAttrColumnsLayout(), this.bnAttrRemove, 175, 175);
        LevelPropertyDialogOracle.equalizeButtonSizes(this.bnAttrAdd, this.bnAttrRemove);
    }

    private SpringLayout getAttrColumnsLayout() {
        return (SpringLayout)this.attrPanel.getLayout();
    }

    public void initAttrProperties() {
        ColumnProxy[] colSet = this.current.getColumnProxies();
        block0: for (String colId : this.attribute.getColumnSet()) {
            for (int i = 0; i < colSet.length; ++i) {
                ColumnProxy col = colSet[i];
                if (!col.getObjectID().equals(colId)) continue;
                this.selectedAttrColumnsModel.addElement(col);
                this.allAttrColumnsModel.removeElement(col);
                continue block0;
            }
        }
        this.tfAttrName.setText(this.attribute.getName());
    }

    protected void setAttrProperties() {
        if (this.attribute != null) {
            this.attribute.setName(this.tfAttrName.getText());
            Object[] colSet = this.selectedAttrColumnsModel.toArray();
            this.attribute.clearColumns();
            for (int i = 0; i < colSet.length; ++i) {
                Object ob = colSet[i];
                if (!(ob instanceof ColumnProxyOracle)) continue;
                this.attribute.setColumns(((ColumnProxyOracle)ob).getObjectID());
            }
            this.attribute.setComment(this.getCommentsList().getText());
        }
    }

    private DimensionAttributeOracle getAttributeForLevel(LevelOracle level, StorageDesignOracle stdes) {
        Iterator it = stdes.getDimensionAttributeSet().iterator();
        while (it.hasNext()) {
            DimensionAttributeOracle attr = (DimensionAttributeOracle)it.next();
            if (attr.getLevel() != level) continue;
            return attr;
        }
        return null;
    }

    private DimensionAttributeOracle createAttribute(LevelOracle level, StorageDesignOracle stdes) {
        DimensionAttributeOracle attr = stdes.getDimensionAttributeSet().createDimensionAttribute();
        attr.setLevel(level);
        return attr;
    }

    private class AttrSelectedListSelectionHandler
    implements ListSelectionListener {
        private AttrSelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (LevelPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (LevelPropertyDialogOracle.this.selectedAttrColumnsList.getSelectedIndex() == -1) {
                    LevelPropertyDialogOracle.this.bnAttrRemove.setEnabled(false);
                } else {
                    LevelPropertyDialogOracle.this.bnAttrRemove.setEnabled(true);
                }
            }
        }
    }

    private class AttrAllListSelectionHandler
    implements ListSelectionListener {
        private AttrAllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (LevelPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (LevelPropertyDialogOracle.this.allAttrColumnsList.getSelectedIndex() == -1) {
                    LevelPropertyDialogOracle.this.bnAttrAdd.setEnabled(false);
                } else {
                    LevelPropertyDialogOracle.this.bnAttrAdd.setEnabled(true);
                }
            }
        }
    }

    private class AttrRemoveColumnsActionListener
    implements ActionListener {
        private AttrRemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!LevelPropertyDialogOracle.this.selectedAttrColumnsModel.isEmpty()) {
                Object[] selectedObjects = LevelPropertyDialogOracle.this.selectedAttrColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (LevelPropertyDialogOracle.this.allAttrColumnsModel.contains(ob)) continue;
                    LevelPropertyDialogOracle.this.allAttrColumnsModel.addElement(ob);
                    LevelPropertyDialogOracle.this.selectedAttrColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AttrAddColumnsActionListener
    implements ActionListener {
        private AttrAddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!LevelPropertyDialogOracle.this.allAttrColumnsModel.isEmpty()) {
                Object[] selectedObjects = LevelPropertyDialogOracle.this.allAttrColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (LevelPropertyDialogOracle.this.selectedAttrColumnsModel.contains(ob)) continue;
                    LevelPropertyDialogOracle.this.selectedAttrColumnsModel.addElement(ob);
                    LevelPropertyDialogOracle.this.allAttrColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (LevelPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (LevelPropertyDialogOracle.this.selectedColumnsList.getSelectedIndex() == -1) {
                    LevelPropertyDialogOracle.this.bnRemove.setEnabled(false);
                } else {
                    LevelPropertyDialogOracle.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (LevelPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (LevelPropertyDialogOracle.this.allColumnsList.getSelectedIndex() == -1) {
                    LevelPropertyDialogOracle.this.bnAdd.setEnabled(false);
                } else {
                    LevelPropertyDialogOracle.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!LevelPropertyDialogOracle.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = LevelPropertyDialogOracle.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (LevelPropertyDialogOracle.this.allColumnsModel.contains(ob)) continue;
                    LevelPropertyDialogOracle.this.allColumnsModel.addElement(ob);
                    LevelPropertyDialogOracle.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!LevelPropertyDialogOracle.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = LevelPropertyDialogOracle.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (LevelPropertyDialogOracle.this.selectedColumnsModel.contains(ob)) continue;
                    LevelPropertyDialogOracle.this.selectedColumnsModel.addElement(ob);
                    LevelPropertyDialogOracle.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }
}

