/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RoleOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.UserAndRolePermissionsDialogOracle;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class RolePropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private static final long serialVersionUID = 6223251914507648749L;
    private RoleOraclev9i role;
    private JComboBox cbIdentified;
    private JComboBox cbIdentType;
    private JPasswordField tfPassword;
    private JTextField tfSchema;
    private JTextField tfPackage;
    private JPanel panelRoles;
    private JPanel panelSystemPrivileges;
    private JList allPrivilegesList;
    private DefaultListModel allPrivilegesModel;
    private JButton bnAddPrivileges;
    private JButton bnRemovePrivileges;
    private JList allRolesList;
    private JTable selectedRolesTable;
    private JTable selectedSystemPrivilegesTable;
    private List<Role> selectedRolesList;
    private List<SystemPrivilege> selectedSystemPrivilegesList;
    private DefaultListModel allRolesModel;
    private JButton bnAddRoles;
    private JButton bnRemoveRoles;
    private JButton bnPermissions;
    private UserAndRolePermissionsDialogOracle dialog;
    private JButton btnSelectAllPrivileges;
    private JButton btnDeselectAllPrivileges;
    private JButton btnSelectAllRoles;
    private JButton btnDeselectAllRoles;
    private TableRowSorter<SelectedSystemPrivilegesModel> spSorter;
    private TableRowSorter<SelectedRolesModel> rSorter;

    public RolePropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.role = (RoleOraclev9i)object;
        this.setHeight(410);
        this.initCommentsView();
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RolePropertyDialogOracle.RoleProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initIdentified();
        this.initIdentType();
        this.initPassword();
        this.initSchema();
        this.initPackage();
        if (this.isEditable()) {
            this.initPropagatePropsButton(350);
        }
        this.initPermissionsButton();
    }

    private void initIdentified() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogOracle.Identified"));
        this.general.add(label);
        this.cbIdentified = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIdentified);
        this.cbIdentified.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIdentified);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbIdentified, 50);
    }

    private void initIdentType() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogOracle.IdentificationType"));
        this.general.add(label);
        this.cbIdentType = new JComboBox<String>(RoleOraclev9i.getAuthTypes());
        this.setBG(this.cbIdentType);
        this.cbIdentType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbIdentType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RolePropertyDialogOracle.this.cbIdentType.getSelectedItem() != null) {
                    if (((String)RolePropertyDialogOracle.this.cbIdentType.getSelectedItem()).equalsIgnoreCase("BY_PASSWORD")) {
                        RolePropertyDialogOracle.this.tfPassword.setEditable(true);
                        RolePropertyDialogOracle.this.tfPassword.setText(RolePropertyDialogOracle.this.role.decodePassword());
                    } else {
                        RolePropertyDialogOracle.this.tfPassword.setEditable(false);
                        RolePropertyDialogOracle.this.tfPassword.setText("");
                    }
                }
            }
        });
        this.general.add(this.cbIdentType);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbIdentType, 80);
    }

    private void initPassword() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogOracle.Password"));
        this.general.add(label);
        this.tfPassword = new JPasswordField("", 26);
        this.general.add(this.tfPassword);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfPassword, 110);
    }

    private void initSchema() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogOracle.Schema"));
        this.general.add(label);
        this.tfSchema = new JTextField("", 26);
        this.general.add(this.tfSchema);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfSchema, 140);
    }

    private void initPackage() {
        JLabel label = new JLabel(Messages.getString("RolePropertyDialogOracle.Package"));
        this.general.add(label);
        this.tfPackage = new JTextField("", 26);
        this.general.add(this.tfPackage);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfPackage, 170);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("RolePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 350);
    }

    @Override
    protected void addTabs() {
        this.initRolesView();
        this.initSystemPrivilegesView();
    }

    private void initRolesView() {
        this.panelRoles = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("RolePropertyDialogOracle.Roles"), this.panelRoles);
        this.initRoles();
    }

    private void initSystemPrivilegesView() {
        this.panelSystemPrivileges = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("RolePropertyDialogOracle.SystemPrivileges"), this.panelSystemPrivileges);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivilegesList();
        this.initSelectedPrivilegesList();
    }

    private void initAllPrivilegesList() {
        this.allPrivilegesModel = new DefaultListModel();
        this.allPrivilegesList = new JList(this.allPrivilegesModel);
        ListSelectionModel listSelectionModel = this.allPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllPrivilegesListSelectionHandler());
        JPanel jp = new JPanel(new BorderLayout());
        jp.setPreferredSize(new Dimension(425, 190));
        JPanel jpSP = new JPanel(new BorderLayout());
        jpSP.setBorder(BorderFactory.createTitledBorder(Messages.getString("RolePropertyDialogOracle.Available")));
        JScrollPane sp = new JScrollPane(this.allPrivilegesList);
        sp.setPreferredSize(new Dimension(415, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        jpSP.add(sp);
        jp.add((Component)jpSP, "Center");
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), jp, 10, 10);
        this.initPrivilegesButtons(jp);
        this.panelSystemPrivileges.add(jp);
    }

    private void initSelectedPrivilegesList() {
        JPanel jp = new JPanel(new BorderLayout());
        jp.setPreferredSize(new Dimension(425, 193));
        jp.setBorder(BorderFactory.createTitledBorder(Messages.getString("RolePropertyDialogOracle.Selected")));
        JPanel selectButtonsPanel = new JPanel(new SpringLayout());
        selectButtonsPanel.setPreferredSize(new Dimension(425, 25));
        this.btnSelectAllPrivileges = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        this.btnSelectAllPrivileges.setToolTipText(Messages.getString("RolePropertyDialogOracle.GrantAllPrivilegesWithAdminOption"));
        this.btnSelectAllPrivileges.setEnabled(false);
        this.btnSelectAllPrivileges.setMnemonic(83);
        this.btnSelectAllPrivileges.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllPrivileges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RolePropertyDialogOracle.this.checkAllSysPrivs(RolePropertyDialogOracle.this.selectedSystemPrivilegesTable, RolePropertyDialogOracle.this.selectedSystemPrivilegesList, true);
                RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.updateUI();
            }
        });
        this.btnDeselectAllPrivileges = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        this.btnDeselectAllPrivileges.setToolTipText(Messages.getString("RolePropertyDialogOracle.RevokeAllPrivilegesWithAdminOption"));
        this.btnDeselectAllPrivileges.setEnabled(false);
        this.btnDeselectAllPrivileges.setMnemonic(68);
        this.btnDeselectAllPrivileges.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAllPrivileges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RolePropertyDialogOracle.this.checkAllSysPrivs(RolePropertyDialogOracle.this.selectedSystemPrivilegesTable, RolePropertyDialogOracle.this.selectedSystemPrivilegesList, false);
                RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.updateUI();
            }
        });
        selectButtonsPanel.add(this.btnSelectAllPrivileges);
        selectButtonsPanel.add(this.btnDeselectAllPrivileges);
        CommonUtil.setObjectConstraints((SpringLayout)selectButtonsPanel.getLayout(), this.btnSelectAllPrivileges, 355, 0);
        CommonUtil.setObjectConstraints((SpringLayout)selectButtonsPanel.getLayout(), this.btnDeselectAllPrivileges, 385, 0);
        this.selectedSystemPrivilegesList = new ArrayList<SystemPrivilege>();
        SelectedSystemPrivilegesModel pModel = new SelectedSystemPrivilegesModel();
        this.selectedSystemPrivilegesTable = new JTable(pModel);
        this.spSorter = new TableRowSorter<SelectedSystemPrivilegesModel>(pModel);
        this.spSorter.setSortsOnUpdates(true);
        ColumnAdminRenderer columnAdminRenderer = new ColumnAdminRenderer();
        TableColumn col0 = this.selectedSystemPrivilegesTable.getColumnModel().getColumn(0);
        col0.setWidth(375);
        col0.setMaxWidth(375);
        TableColumn col1 = this.selectedSystemPrivilegesTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        col1.setCellRenderer(columnAdminRenderer);
        this.selectedSystemPrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getSelectedRow() == -1) {
                    RolePropertyDialogOracle.this.bnRemovePrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogOracle.this.bnRemovePrivileges.setEnabled(true);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.selectedSystemPrivilegesTable);
        sp.setPreferredSize(new Dimension(425, 165));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        jp.add((Component)selectButtonsPanel, "North");
        jp.add((Component)sp, "Center");
        this.panelSystemPrivileges.add(jp);
        this.setObjectConstraints(this.getSystemPrivilegesLayout(), jp, 10, 197);
    }

    private void initRoles() {
        this.initAllRolesList();
        this.initSelectedRolesList();
    }

    private void initAllRolesList() {
        this.allRolesModel = new DefaultListModel();
        this.allRolesList = new JList(this.allRolesModel);
        ListSelectionModel listSelectionModel = this.allRolesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllRolesListSelectionHandler());
        JPanel jp = new JPanel(new BorderLayout());
        jp.setPreferredSize(new Dimension(425, 190));
        JPanel jpSP = new JPanel(new BorderLayout());
        jpSP.setBorder(BorderFactory.createTitledBorder(Messages.getString("RolePropertyDialogOracle.Available")));
        JScrollPane sp = new JScrollPane(this.allRolesList);
        sp.setPreferredSize(new Dimension(415, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        jpSP.add(sp);
        jp.add((Component)jpSP, "Center");
        this.setObjectConstraints(this.getRolesLayout(), jp, 10, 10);
        this.initRolesButtons(jp);
        this.panelRoles.add(jp);
    }

    private void initSelectedRolesList() {
        JPanel jp = new JPanel(new BorderLayout());
        jp.setPreferredSize(new Dimension(425, 193));
        jp.setBorder(BorderFactory.createTitledBorder(Messages.getString("RolePropertyDialogOracle.Selected")));
        JPanel selectButtonsPanel = new JPanel(new SpringLayout());
        selectButtonsPanel.setPreferredSize(new Dimension(425, 25));
        this.btnSelectAllRoles = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        this.btnSelectAllRoles.setToolTipText(Messages.getString("RolePropertyDialogOracle.GrantAllRolesWithAdminOption"));
        this.btnSelectAllRoles.setEnabled(false);
        this.btnSelectAllRoles.setMnemonic(83);
        this.btnSelectAllRoles.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllRoles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RolePropertyDialogOracle.this.checkAllRoles(RolePropertyDialogOracle.this.selectedRolesTable, RolePropertyDialogOracle.this.selectedRolesList, true);
                RolePropertyDialogOracle.this.selectedRolesTable.updateUI();
            }
        });
        this.btnDeselectAllRoles = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        this.btnDeselectAllRoles.setToolTipText(Messages.getString("RolePropertyDialogOracle.RevokeAllRolesWithAdminOption"));
        this.btnDeselectAllRoles.setEnabled(false);
        this.btnDeselectAllRoles.setMnemonic(68);
        this.btnDeselectAllRoles.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAllRoles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RolePropertyDialogOracle.this.checkAllRoles(RolePropertyDialogOracle.this.selectedRolesTable, RolePropertyDialogOracle.this.selectedRolesList, false);
                RolePropertyDialogOracle.this.selectedRolesTable.updateUI();
            }
        });
        selectButtonsPanel.add(this.btnSelectAllRoles);
        selectButtonsPanel.add(this.btnDeselectAllRoles);
        CommonUtil.setObjectConstraints((SpringLayout)selectButtonsPanel.getLayout(), this.btnSelectAllRoles, 355, 0);
        CommonUtil.setObjectConstraints((SpringLayout)selectButtonsPanel.getLayout(), this.btnDeselectAllRoles, 385, 0);
        this.selectedRolesList = new ArrayList<Role>();
        SelectedRolesModel rModel = new SelectedRolesModel();
        this.selectedRolesTable = new JTable(rModel);
        this.rSorter = new TableRowSorter<SelectedRolesModel>(rModel);
        this.rSorter.setSortsOnUpdates(true);
        ColumnAdminRenderer columnAdminRenderer = new ColumnAdminRenderer();
        TableColumn col0 = this.selectedRolesTable.getColumnModel().getColumn(0);
        col0.setWidth(375);
        col0.setMaxWidth(375);
        TableColumn col1 = this.selectedRolesTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        col1.setCellRenderer(columnAdminRenderer);
        this.selectedRolesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RolePropertyDialogOracle.this.selectedRolesTable.getSelectedRow() == -1) {
                    RolePropertyDialogOracle.this.bnRemoveRoles.setEnabled(false);
                } else {
                    RolePropertyDialogOracle.this.bnRemoveRoles.setEnabled(true);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.selectedRolesTable);
        sp.setPreferredSize(new Dimension(425, 165));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        jp.add((Component)selectButtonsPanel, "North");
        jp.add((Component)sp, "Center");
        this.panelRoles.add(jp);
        this.setObjectConstraints(this.getRolesLayout(), jp, 10, 197);
    }

    private void initRolesButtons(JPanel jp) {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.bnAddRoles = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_DOWN_ICON"));
        this.bnAddRoles.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.bnAddRoles.addActionListener(new AddRolesActionListener());
        this.bnAddRoles.setEnabled(false);
        this.bnRemoveRoles = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_UP_ICON"));
        this.bnRemoveRoles.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.bnRemoveRoles.setEnabled(false);
        this.bnRemoveRoles.addActionListener(new RemoveRolesActionListener());
        buttonsPanel.add(this.bnAddRoles);
        buttonsPanel.add(this.bnRemoveRoles);
        jp.add((Component)buttonsPanel, "South");
    }

    protected SpringLayout getSystemPrivilegesLayout() {
        return (SpringLayout)this.panelSystemPrivileges.getLayout();
    }

    protected SpringLayout getRolesLayout() {
        return (SpringLayout)this.panelRoles.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.role.getName());
        this.tfName.setText(this.role.getName());
        this.cbIdentified.setSelectedItem(RolePropertyDialogOracle.translateYesNoForDisplay(this.role.getIdentified()));
        this.cbIdentType.setSelectedItem(this.role.getAuthType());
        this.tfPassword.setText(this.role.decodePassword());
        this.tfSchema.setText(this.role.getSchema());
        this.tfPackage.setText(this.role.getPack());
        Object[] allRolesSet = this.getStorageDesign().getRoleSet().toArray();
        for (int i = 0; i < allRolesSet.length; ++i) {
            StringTokenizer st = new StringTokenizer(this.role.getRoles(), ",");
            StringTokenizer st1 = new StringTokenizer(this.role.getRolesWithAdminOption(), ",");
            Role roleOracle = new Role(allRolesSet[i]);
            roleOracle.setObjectID(((RoleOracle)allRolesSet[i]).getObjectID());
            boolean treated = false;
            while (st.hasMoreTokens()) {
                String item = st.nextToken().trim();
                if (!roleOracle.getObjectID().equalsIgnoreCase(item)) continue;
                this.selectedRolesList.add(roleOracle);
                treated = true;
                break;
            }
            while (st1.hasMoreTokens()) {
                String item1 = st1.nextToken().trim();
                if (!roleOracle.getObjectID().equalsIgnoreCase(item1)) continue;
                roleOracle.setAdminOption(true);
                this.selectedRolesList.add(roleOracle);
                treated = true;
                break;
            }
            if (treated || this.role.getObjectID().equalsIgnoreCase(((RoleOracle)roleOracle.getObject()).getObjectID())) continue;
            this.allRolesModel.addElement(roleOracle.getObject());
        }
        this.sort(this.allRolesModel);
        if (this.allRolesModel.getSize() > 0) {
            this.allRolesList.getSelectionModel().setSelectionInterval(0, 0);
        } else if (this.selectedRolesList.size() > 0) {
            this.selectedRolesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.selectedRolesList.size() > 0) {
            this.selectedRolesTable.setRowSorter(this.rSorter);
            this.selectedRolesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.selectedRolesTable, 0);
            this.btnSelectAllRoles.setEnabled(true);
            this.btnDeselectAllRoles.setEnabled(true);
        }
        String[] allPrivilegesSet = this.role.getPrivilegesValues();
        for (int i = 0; i < allPrivilegesSet.length; ++i) {
            StringTokenizer st = new StringTokenizer(this.role.getPrivileges(), ",");
            StringTokenizer st1 = new StringTokenizer(this.role.getPrivilegesWithAdminOption(), ",");
            String privilege = allPrivilegesSet[i];
            SystemPrivilege p = null;
            boolean treated = false;
            while (st.hasMoreTokens()) {
                String item = st.nextToken().trim();
                if (!privilege.equalsIgnoreCase(item)) continue;
                p = new SystemPrivilege(item.trim());
                p.setName(item);
                this.selectedSystemPrivilegesList.add(p);
                treated = true;
                break;
            }
            while (st1.hasMoreTokens()) {
                String item1 = st1.nextToken().trim();
                if (!privilege.equalsIgnoreCase(item1)) continue;
                p = new SystemPrivilege(item1.trim());
                p.setName(item1);
                p.setAdminOption(true);
                this.selectedSystemPrivilegesList.add(p);
                treated = true;
                break;
            }
            if (treated) continue;
            this.allPrivilegesModel.addElement(privilege);
        }
        this.sort(this.allPrivilegesModel);
        if (this.allPrivilegesModel.getSize() > 0) {
            this.allPrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
        } else if (this.selectedSystemPrivilegesList.size() > 0) {
            this.selectedSystemPrivilegesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.selectedSystemPrivilegesList.size() > 0) {
            this.selectedSystemPrivilegesTable.setRowSorter(this.spSorter);
            this.selectedSystemPrivilegesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.selectedSystemPrivilegesTable, 0);
            this.btnSelectAllPrivileges.setEnabled(true);
            this.btnDeselectAllPrivileges.setEnabled(true);
        }
        this.getCommentsList().insert(this.role.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.role != null) {
            this.role.clear();
            this.role.setName(this.tfName.getText());
            this.role.setIdentified(RolePropertyDialogOracle.translateYesNoForStorage((String)this.cbIdentified.getSelectedItem()));
            this.role.setAuthType((String)this.cbIdentType.getSelectedItem());
            this.role.encodePassword(String.valueOf(this.tfPassword.getPassword()));
            this.role.setSchema(this.tfSchema.getText());
            this.role.setPack(this.tfPackage.getText());
            Object[] roleSet = this.selectedRolesList.toArray();
            for (int i = 0; i < roleSet.length; ++i) {
                Role ro = (Role)roleSet[i];
                boolean admin = ro.getAdminOption();
                if (admin) {
                    this.role.setRolesWithAdminOption(ro.getObjectID());
                    continue;
                }
                this.role.setRoles(ro.getObjectID());
            }
            Object[] privSet = this.selectedSystemPrivilegesList.toArray();
            for (int i = 0; i < privSet.length; ++i) {
                Object pr = privSet[i];
                if (!(pr instanceof SystemPrivilege)) continue;
                SystemPrivilege sp = (SystemPrivilege)pr;
                if (sp.getAdminOption()) {
                    this.role.setPrivilegesWithAdminOption(sp.getObject().toString());
                    continue;
                }
                this.role.setPrivileges(sp.getObject().toString());
            }
            this.role.setComment(this.getCommentsList().getText());
        }
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (list.get(i).toString().compareTo(list.get(i - 1).toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private void checkAllSysPrivs(JTable table, List objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                SystemPrivilege obj = this.selectedSystemPrivilegesList.get(table.convertRowIndexToModel(selected[i]));
                obj.setAdminOption(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void checkAllRoles(JTable table, List objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                Role obj = this.selectedRolesList.get(table.convertRowIndexToModel(selected[i]));
                obj.setAdminOption(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void selectAll(JTable table, List objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), true);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), true);
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), false);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), false);
            }
        }
    }

    private void setSelected(Object obj, boolean selected) {
        if (obj != null) {
            if (obj instanceof SystemPrivilege) {
                ((SystemPrivilege)obj).setAdminOption(selected);
            } else if (obj instanceof Role) {
                ((Role)obj).setAdminOption(selected);
            }
        }
    }

    private void initPrivilegesButtons(JPanel jp) {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.bnAddPrivileges = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_DOWN_ICON"));
        this.bnAddPrivileges.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.bnAddPrivileges.addActionListener(new AddPrivilegesActionListener());
        this.bnAddPrivileges.setEnabled(false);
        this.bnRemovePrivileges = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_UP_ICON"));
        this.bnRemovePrivileges.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.bnRemovePrivileges.setEnabled(false);
        this.bnRemovePrivileges.addActionListener(new RemovePrivilegesActionListener());
        buttonsPanel.add(this.bnAddPrivileges);
        buttonsPanel.add(this.bnRemovePrivileges);
        jp.add((Component)buttonsPanel, "South");
    }

    private void initPropagatePropsButton(int yCoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                RolePropertyDialogOracle.this.getStorageDesign().getRoleSet().addAllElementsTo(list);
                list.remove(RolePropertyDialogOracle.this.role);
                new PropertiesPropagationDialog(RolePropertyDialogOracle.this.getAppView(), RolePropertyDialogOracle.this.role, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, yCoord);
    }

    private class SelectedRolesModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("RolePropertyDialogOracle.Role"), Messages.getString("RolePropertyDialogOracle.Admin")};

        private SelectedRolesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return RolePropertyDialogOracle.this.selectedRolesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Role ro = (Role)RolePropertyDialogOracle.this.selectedRolesList.get(row);
            if (value instanceof Boolean && col == 1) {
                ro.setAdminOption((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            Role ro = (Role)RolePropertyDialogOracle.this.selectedRolesList.get(row);
            if (col == 0) {
                return ro.getObject();
            }
            if (col == 1) {
                return ro.getAdminOption();
            }
            return "";
        }
    }

    public class ColumnAdminRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -215127161678321822L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(val);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class SelectedRolessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1999134389475107666L;
        final String[] COL_NAMES = new String[]{Messages.getString("RolePropertyDialogOracle.Role"), Messages.getString("RolePropertyDialogOracle.Admin")};

        private SelectedRolessModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return RolePropertyDialogOracle.this.selectedRolesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Role ro = (Role)RolePropertyDialogOracle.this.selectedRolesList.get(row);
            if (value instanceof Boolean && col == 1) {
                ro.setAdminOption((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            Role ro = (Role)RolePropertyDialogOracle.this.selectedRolesList.get(row);
            if (col == 0) {
                return ro.getObject();
            }
            if (col == 1) {
                return ro.getAdminOption();
            }
            return "";
        }
    }

    private class SelectedSystemPrivilegesModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 7290076584038675384L;
        final String[] COL_NAMES = new String[]{Messages.getString("RolePropertyDialogOracle.Privilege"), Messages.getString("RolePropertyDialogOracle.Admin")};

        private SelectedSystemPrivilegesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return RolePropertyDialogOracle.this.selectedSystemPrivilegesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            SystemPrivilege sp = (SystemPrivilege)RolePropertyDialogOracle.this.selectedSystemPrivilegesList.get(row);
            if (value instanceof Boolean && col == 1) {
                sp.setAdminOption((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            SystemPrivilege sp = (SystemPrivilege)RolePropertyDialogOracle.this.selectedSystemPrivilegesList.get(row);
            if (col == 0) {
                return sp.getObject();
            }
            if (col == 1) {
                return sp.getAdminOption();
            }
            return "";
        }
    }

    private class RemoveRolesActionListener
    implements ActionListener {
        private RemoveRolesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Role> removalList = new ArrayList<Role>();
            int[] selectedObjects = RolePropertyDialogOracle.this.selectedRolesTable.getSelectedRows();
            Object ob1 = null;
            for (int i = 0; i < selectedObjects.length; ++i) {
                Role ob = (Role)RolePropertyDialogOracle.this.selectedRolesList.get(RolePropertyDialogOracle.this.selectedRolesTable.convertRowIndexToModel(selectedObjects[i]));
                ob1 = ob.getObject();
                if (RolePropertyDialogOracle.this.allRolesModel.contains(ob1)) continue;
                RolePropertyDialogOracle.this.allRolesModel.addElement(ob1);
                removalList.add(ob);
            }
            RolePropertyDialogOracle.this.selectedRolesTable.setRowSorter(null);
            RolePropertyDialogOracle.this.selectedRolesTable.setAutoCreateRowSorter(false);
            RolePropertyDialogOracle.this.selectedRolesList.removeAll(removalList);
            RolePropertyDialogOracle.this.selectedRolesTable.updateUI();
            RolePropertyDialogOracle.this.selectedRolesTable.clearSelection();
            if (RolePropertyDialogOracle.this.selectedRolesList.size() > 0) {
                RolePropertyDialogOracle.this.selectedRolesTable.setRowSorter(RolePropertyDialogOracle.this.rSorter);
                RolePropertyDialogOracle.this.selectedRolesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(RolePropertyDialogOracle.this.selectedRolesTable, 0);
            }
            RolePropertyDialogOracle.this.sort(RolePropertyDialogOracle.this.allRolesModel);
            RolePropertyDialogOracle.this.allRolesList.setSelectedValue(ob1, true);
            RolePropertyDialogOracle.this.btnSelectAllRoles.setEnabled(RolePropertyDialogOracle.this.selectedRolesList.size() > 0);
            RolePropertyDialogOracle.this.btnDeselectAllRoles.setEnabled(RolePropertyDialogOracle.this.selectedRolesList.size() > 0);
        }
    }

    private class AddRolesActionListener
    implements ActionListener {
        private AddRolesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object ob = null;
            if (!RolePropertyDialogOracle.this.allRolesModel.isEmpty()) {
                Object[] selectedObjects = RolePropertyDialogOracle.this.allRolesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ob = selectedObjects[i];
                    if (RolePropertyDialogOracle.this.selectedRolesList.contains(ob)) continue;
                    Role ro = new Role(ob);
                    ro.setName(ob.toString());
                    ro.setObjectID(((RoleOracle)selectedObjects[i]).getObjectID());
                    RolePropertyDialogOracle.this.selectedRolesList.add(ro);
                    RolePropertyDialogOracle.this.allRolesModel.removeElement(selectedObjects[i]);
                }
                ((AbstractTableModel)RolePropertyDialogOracle.this.selectedRolesTable.getModel()).fireTableDataChanged();
                if (RolePropertyDialogOracle.this.selectedRolesTable.getRowSorter() == null) {
                    RolePropertyDialogOracle.this.selectedRolesTable.setRowSorter(RolePropertyDialogOracle.this.rSorter);
                    RolePropertyDialogOracle.this.selectedRolesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(RolePropertyDialogOracle.this.selectedRolesTable, 0);
                }
                RolePropertyDialogOracle.this.btnSelectAllRoles.setEnabled(true);
                RolePropertyDialogOracle.this.btnDeselectAllRoles.setEnabled(true);
            }
            RolePropertyDialogOracle.this.selectedRolesTable.updateUI();
            RolePropertyDialogOracle.this.selectedRolesTable.getSelectionModel().setSelectionInterval(RolePropertyDialogOracle.this.selectedRolesTable.getRowCount() - 1, RolePropertyDialogOracle.this.selectedRolesTable.getRowCount() - 1);
        }
    }

    private class AllRolesListSelectionHandler
    implements ListSelectionListener {
        private AllRolesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RolePropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RolePropertyDialogOracle.this.allRolesList.getSelectedIndex() == -1) {
                    RolePropertyDialogOracle.this.bnAddRoles.setEnabled(false);
                } else {
                    RolePropertyDialogOracle.this.bnAddRoles.setEnabled(true);
                }
            }
        }
    }

    private class AllPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private AllPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RolePropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RolePropertyDialogOracle.this.allPrivilegesList.getSelectedIndex() == -1) {
                    RolePropertyDialogOracle.this.bnAddPrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogOracle.this.bnAddPrivileges.setEnabled(true);
                }
            }
        }
    }

    private class RemovePrivilegesActionListener
    implements ActionListener {
        private RemovePrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<SystemPrivilege> removalList = new ArrayList<SystemPrivilege>();
            int[] selectedObjects = RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getSelectedRows();
            Object currentObject = null;
            for (int i = 0; i < selectedObjects.length; ++i) {
                SystemPrivilege selectedObject = (SystemPrivilege)RolePropertyDialogOracle.this.selectedSystemPrivilegesList.get(RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.convertRowIndexToModel(selectedObjects[i]));
                currentObject = selectedObject.getObject();
                if (RolePropertyDialogOracle.this.allPrivilegesModel.contains(currentObject)) continue;
                RolePropertyDialogOracle.this.allPrivilegesModel.addElement(currentObject);
                removalList.add(selectedObject);
            }
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.setRowSorter(null);
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.setAutoCreateRowSorter(false);
            RolePropertyDialogOracle.this.selectedSystemPrivilegesList.removeAll(removalList);
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.updateUI();
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.clearSelection();
            if (RolePropertyDialogOracle.this.selectedSystemPrivilegesList.size() > 0) {
                RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.setRowSorter(RolePropertyDialogOracle.this.spSorter);
                RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(RolePropertyDialogOracle.this.selectedSystemPrivilegesTable, 0);
            }
            RolePropertyDialogOracle.this.sort(RolePropertyDialogOracle.this.allPrivilegesModel);
            RolePropertyDialogOracle.this.allPrivilegesList.setSelectedValue(currentObject, true);
            RolePropertyDialogOracle.this.btnSelectAllPrivileges.setEnabled(RolePropertyDialogOracle.this.selectedSystemPrivilegesList.size() > 0);
            RolePropertyDialogOracle.this.btnDeselectAllPrivileges.setEnabled(RolePropertyDialogOracle.this.selectedSystemPrivilegesList.size() > 0);
        }
    }

    private class AddPrivilegesActionListener
    implements ActionListener {
        private AddPrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object ob = null;
            if (!RolePropertyDialogOracle.this.allPrivilegesModel.isEmpty()) {
                Object[] selectedObjects = RolePropertyDialogOracle.this.allPrivilegesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ob = selectedObjects[i];
                    if (RolePropertyDialogOracle.this.selectedSystemPrivilegesList.contains(ob)) continue;
                    SystemPrivilege sp = new SystemPrivilege(ob);
                    sp.setName(ob.toString());
                    RolePropertyDialogOracle.this.selectedSystemPrivilegesList.add(sp);
                    RolePropertyDialogOracle.this.allPrivilegesModel.removeElement(ob);
                }
                ((AbstractTableModel)RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getModel()).fireTableDataChanged();
                if (RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getRowSorter() == null) {
                    RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.setRowSorter(RolePropertyDialogOracle.this.spSorter);
                    RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(RolePropertyDialogOracle.this.selectedSystemPrivilegesTable, 0);
                }
                RolePropertyDialogOracle.this.btnSelectAllPrivileges.setEnabled(true);
                RolePropertyDialogOracle.this.btnDeselectAllPrivileges.setEnabled(true);
            }
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.updateUI();
            RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getSelectionModel().setSelectionInterval(RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getRowCount() - 1, RolePropertyDialogOracle.this.selectedSystemPrivilegesTable.getRowCount() - 1);
        }
    }

    class Role {
        Object obj = null;
        String name = "";
        String objectID = "";
        boolean adminOption = false;

        Role(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void setObjectID(String objectID) {
            this.objectID = objectID;
        }

        String getObjectID() {
            return this.objectID;
        }

        void setAdminOption(boolean adminOption) {
            this.adminOption = adminOption;
        }

        boolean getAdminOption() {
            return this.adminOption;
        }
    }

    class SystemPrivilege {
        Object obj = null;
        String name = "";
        boolean adminOption = false;

        SystemPrivilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void setAdminOption(boolean adminOption) {
            this.adminOption = adminOption;
        }

        boolean getAdminOption() {
            return this.adminOption;
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RolePropertyDialogOracle.this.dialog == null) {
                RolePropertyDialogOracle.this.dialog = new UserAndRolePermissionsDialogOracle(RolePropertyDialogOracle.this.getAppView(), RolePropertyDialogOracle.this.getStorageDesign(), RolePropertyDialogOracle.this.role);
            }
            RolePropertyDialogOracle.this.dialog.showDialog();
        }
    }
}

