/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;

public class BitmapJoinIndexPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private BitmapJoinIndexOraclev10g index;
    protected JTextField tfTablespace;
    protected JComboBox cbUser;
    protected JComboBox cbLocalPartitioning;
    protected JComboBox cbLogging;
    protected JComboBox cbSegment;
    protected JComboBox cbParallel;
    private JPositiveIntegerField ifDegree;
    protected JComboBox cbComputeStatistics;
    protected JComboBox cbOnline;
    protected JPositiveIntegerField ifCompress;
    private JPanel columnsPanel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAddColumns;
    private JButton bnRemoveColumns;
    private JPanel sortOrderPanel;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JPanel dimensionKeysPanel;
    private JTable dimensionKeysTable;
    private KeysTableModel keysModel;
    private JPanel dimensionColumnsPanel;
    private JTable dimensionColumnsTable;
    private KeysTableModel columnsModel;
    private JPanel hashSubPartTS;
    private JList allHashSubPartTSList;
    private JList selectedHashSubPartTSList;
    private DefaultListModel allHashSubPartTSModel;
    private DefaultListModel selectedHashSubPartTSModel;
    private JButton bnAddHashSubPartTS;
    private JButton bnRemoveHashSubPartTS;

    public BitmapJoinIndexPropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.index = (BitmapJoinIndexOraclev10g)object;
        this.setHeight(420);
        this.initCommentsView(this.getPane().getPreferredSize().height - 90);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("BitmapJoinIndexPropertyDialogOracle.BitmapJoinIndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initLocalPartitioning();
        this.initTablespace();
        this.initLogging();
        this.initSegment();
        this.initCompress();
        this.initParallel();
        this.initDegree();
        this.initComputeStatistics();
        this.initOnline();
    }

    private void initUser() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.User"));
        this.general.add(label);
        this.cbUser = new JComboBox();
        if (this.storageDesign != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.setBG(this.cbUser);
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initLocalPartitioning() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.LocalPartitioning"));
        this.general.add(label);
        this.cbLocalPartitioning = new JComboBox<String>(YES_NO);
        this.setBG(this.cbLocalPartitioning);
        this.cbLocalPartitioning.addActionListener(new LocalPartitionListener());
        this.cbLocalPartitioning.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLocalPartitioning);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbLocalPartitioning, 80);
    }

    private void initTablespace() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Tablespace"));
        this.general.add(label);
        this.tfTablespace = new JTextField("", 26);
        this.general.add(this.tfTablespace);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfTablespace, 110);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        if (this.storageDesign != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.setBG(this.cbSegment);
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    private void initCompress() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Compress"));
        this.general.add(label);
        this.ifCompress = new JPositiveIntegerField(0, 26);
        this.general.add(this.ifCompress);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifCompress, 200);
    }

    private void initParallel() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Parallel"));
        this.general.add(label);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.addActionListener(new ParallelListener());
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbParallel, 230);
    }

    private void initDegree() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Degree"));
        this.general.add(label);
        this.ifDegree = new JPositiveIntegerField(0, 26);
        this.general.add(this.ifDegree);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.ifDegree, 260);
    }

    private void initComputeStatistics() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.ComputeStatistics"));
        this.general.add(label);
        this.cbComputeStatistics = new JComboBox<String>(YES_NO);
        this.setBG(this.cbComputeStatistics);
        this.cbComputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbComputeStatistics);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbComputeStatistics, 290);
    }

    private void initOnline() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.Online"));
        this.general.add(label);
        this.cbOnline = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOnline);
        this.cbOnline.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnline);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbOnline, 320);
    }

    @Override
    protected void addTabs() {
        this.initIndexColumnsView();
        this.initSortOrderView(this.getPane().getPreferredSize().height - 90);
        this.initDimensionKeysView();
        this.initDimensionColumnsView();
        this.initHashPartTSView();
    }

    private void initDimensionColumnsView() {
        this.dimensionColumnsPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.DimensionTablesColumns"), this.dimensionColumnsPanel);
        this.dimensionColumnsTable = new DimensionColumnsTable();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        JScrollPane pane = new JScrollPane(this.dimensionColumnsTable);
        pane.setPreferredSize(new Dimension(417, 355));
        this.columnsModel = (KeysTableModel)this.dimensionColumnsTable.getModel();
        this.dimensionColumnsPanel.add(pane);
    }

    private void initDimensionKeysView() {
        this.dimensionKeysPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.DimensionTablesKeys"), this.dimensionKeysPanel);
        this.dimensionKeysTable = new OptionsTable();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        JScrollPane pane = new JScrollPane(this.dimensionKeysTable);
        pane.setPreferredSize(new Dimension(417, 355));
        this.keysModel = (KeysTableModel)this.dimensionKeysTable.getModel();
        this.dimensionKeysPanel.add(pane);
    }

    private void initIndexColumnsView() {
        this.columnsPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.IndexColumns"), this.columnsPanel);
        this.initColumns();
    }

    protected SpringLayout getIndexColumnsLayout() {
        return (SpringLayout)this.columnsPanel.getLayout();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.AllColumns"));
        this.columnsPanel.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setCellRenderer(new LongNameCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 310));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsPanel.add(sp);
        this.setLabelConstraints(this.getIndexColumnsLayout(), label, 12, 14);
        this.setObjectConstraints(this.getIndexColumnsLayout(), sp, 10, 34);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.SelectedColumns"));
        this.columnsPanel.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        this.selectedColumnsList.setCellRenderer(new LongNameCellRenderer());
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 310));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsPanel.add(sp);
        this.setLabelConstraints(this.getIndexColumnsLayout(), label, 292, 14);
        this.setObjectConstraints(this.getIndexColumnsLayout(), sp, 290, 34);
    }

    private void initColumnsButtons() {
        this.bnAddColumns = new JButton(ADD_CAPTION);
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setEnabled(false);
        this.columnsPanel.add(this.bnAddColumns);
        this.setObjectConstraints(this.getIndexColumnsLayout(), this.bnAddColumns, 175, 145);
        this.bnRemoveColumns = new JButton(REMOVE_CAPTION);
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.columnsPanel.add(this.bnRemoveColumns);
        this.setObjectConstraints(this.getIndexColumnsLayout(), this.bnRemoveColumns, 175, 175);
        BitmapJoinIndexPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddColumns, this.bnRemoveColumns);
    }

    protected void initSortOrderView(int height) {
        this.sortOrderPanel = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.ColumnsSortOrder"), this.sortOrderPanel);
        this.columnsTable = new JTable();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        JScrollPane sp = new JScrollPane(this.columnsTable);
        sp.setPreferredSize(new Dimension(395, height));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.sortOrderPanel.add(sp);
    }

    private void initColumnsSortOrderAndDimensionKeys() {
        ColumnProxyOraclev10g[] selected = new ColumnProxyOraclev10g[this.selectedColumnsModel.size()];
        for (int i = 0; i < this.selectedColumnsModel.size(); ++i) {
            selected[i] = (ColumnProxyOraclev10g)this.selectedColumnsModel.elementAt(i);
        }
        this.initColumnsSortOrder(selected);
        this.initDimensionKeys(selected);
    }

    protected void initColumnsSortOrder(ColumnProxyOraclev10g[] selectedCols) {
        this.sortModel = new ColumnsSortOrderModel(this.index, selectedCols);
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void initDimensionKeys(ColumnProxyOraclev10g[] selected) {
        int rows = this.keysModel.getRowCount();
        for (int j = 0; j < rows; ++j) {
            this.keysModel.removeRow(0);
        }
        ArrayList<TableProxyOracle> dimTables = new ArrayList<TableProxyOracle>();
        for (int i = 0; i < selected.length; ++i) {
            TableProxyOracle proxy = selected[i].getTableProxy();
            if (dimTables.contains(proxy)) continue;
            dimTables.add(proxy);
            ModelObject key = this.index.getDimensionKey(proxy);
            if (key == null) {
                key = proxy.getPrimaryKeys().size() > 0 ? proxy.getPrimaryKeys().getElement(0) : proxy.getUniqueKeys().getElement(0);
            }
            this.keysModel.addRow(new Object[]{proxy, key});
        }
    }

    private void initDimensionColumns() {
        Object[] selectedKeys = new Object[this.keysModel.getRowCount()];
        for (int i = 0; i < this.keysModel.getRowCount(); ++i) {
            if (!(this.keysModel.getValueAt(i, 1) instanceof IndexProxy)) continue;
            selectedKeys[i] = this.keysModel.getValueAt(i, 1);
        }
        int rows = this.columnsModel.getRowCount();
        for (int j = 0; j < rows; ++j) {
            this.columnsModel.removeRow(0);
        }
        if (this.index.getTable().getColumnProxies().length > 0) {
            ArrayList<ColumnProxy> dimColumns = new ArrayList<ColumnProxy>();
            for (int i = 0; i < selectedKeys.length; ++i) {
                ColumnProxy[] indexCols = ((IndexProxy)selectedKeys[i]).getColumnProxies();
                for (int j = 0; j < indexCols.length; ++j) {
                    if (dimColumns.contains(indexCols[j])) continue;
                    dimColumns.add(indexCols[j]);
                    ColumnProxyOraclev10g col = (ColumnProxyOraclev10g)this.index.getJoinColumn((ColumnProxyOraclev10g)indexCols[j]);
                    if (col == null) {
                        col = (ColumnProxyOraclev10g)this.index.getTable().getColumnProxies()[0];
                    }
                    this.columnsModel.addRow(new Object[]{indexCols[j], col});
                }
            }
        }
    }

    protected void applyColumnsSortOrder() {
        Object[] propSet = this.sortModel.getRows();
        this.index.clearIndexColumns();
        if (propSet.length > 0) {
            String col = null;
            String sortOrder = null;
            for (int i = 0; i < propSet.length; ++i) {
                Object pr = propSet[i];
                if (!(pr instanceof String)) continue;
                StringTokenizer st = new StringTokenizer(pr.toString(), ",");
                if (st.hasMoreTokens()) {
                    col = st.nextToken().trim();
                }
                if (!st.hasMoreTokens()) continue;
                sortOrder = st.nextToken().trim();
                this.index.setIndexColumns(col);
                this.index.setIndexColumns(sortOrder);
            }
        } else {
            Object[] selected = this.selectedColumnsModel.toArray();
            for (int i = 0; i < selected.length; ++i) {
                this.index.setIndexColumns(((ColumnProxyOraclev10g)selected[i]).getObjectID());
                this.index.setIndexColumns("ASC");
            }
        }
    }

    protected void setDimensionKeys() {
        this.index.clearDimensionKeys();
        for (int i = 0; i < this.keysModel.getRowCount(); ++i) {
            TableProxyOracle dimTable = (TableProxyOracle)this.keysModel.getValueAt(i, 0);
            IndexProxy dimIndex = (IndexProxy)this.keysModel.getValueAt(i, 1);
            this.index.setDimensionKeys(dimTable.getObjectID());
            this.index.setDimensionKeys(dimIndex.getObjectID());
        }
    }

    protected void setJoinColumns() {
        this.index.clearJoinColumns();
        for (int i = 0; i < this.columnsModel.getRowCount(); ++i) {
            ColumnProxyOraclev10g dimColumn = (ColumnProxyOraclev10g)this.columnsModel.getValueAt(i, 0);
            ColumnProxyOraclev10g baseColumn = (ColumnProxyOraclev10g)this.columnsModel.getValueAt(i, 1);
            this.index.setJoinColumns(dimColumn.getObjectID());
            this.index.setJoinColumns(baseColumn.getObjectID());
        }
    }

    private void initHashPartTSView() {
        this.hashSubPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BitmapJoinIndexPropertyDialogOracle.HashCompositeByHashTablespaces"), this.hashSubPartTS);
        this.initHashPartTablespaces();
    }

    private void initHashPartTablespaces() {
        this.initAllHashSubPartTSList();
        this.initSelectedHashSubPartTSList();
        this.initHashSubPartTSButtons();
    }

    private void initAllHashSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.AllTableSpaces"));
        this.hashSubPartTS.add(label);
        this.allHashSubPartTSModel = new DefaultListModel();
        this.allHashSubPartTSList = new JList(this.allHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allHashSubPartTSList);
        sp.setPreferredSize(new Dimension(144, 310));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartTS.add(sp);
        this.setLabelConstraints(this.getHashSubPartTSLayout(), label, 12, 14);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), sp, 10, 34);
    }

    private void initSelectedHashSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("BitmapJoinIndexPropertyDialogOracle.SelectedTableSpaces"));
        this.hashSubPartTS.add(label);
        this.selectedHashSubPartTSModel = new DefaultListModel();
        this.selectedHashSubPartTSList = new JList(this.selectedHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedHashSubPartTSList);
        sp.setPreferredSize(new Dimension(145, 310));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartTS.add(sp);
        this.setLabelConstraints(this.getHashSubPartTSLayout(), label, 292, 14);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), sp, 290, 34);
    }

    private void initHashSubPartTSButtons() {
        this.bnAddHashSubPartTS = new JButton(ADD_CAPTION);
        this.bnAddHashSubPartTS.addActionListener(new AddHashSubPartTSActionListener());
        this.bnAddHashSubPartTS.setEnabled(false);
        this.hashSubPartTS.add(this.bnAddHashSubPartTS);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), this.bnAddHashSubPartTS, 175, 145);
        this.bnRemoveHashSubPartTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashSubPartTS.setEnabled(false);
        this.bnRemoveHashSubPartTS.addActionListener(new RemoveHashSubPartTSActionListener());
        this.hashSubPartTS.add(this.bnRemoveHashSubPartTS);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), this.bnRemoveHashSubPartTS, 175, 175);
        BitmapJoinIndexPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddHashSubPartTS, this.bnRemoveHashSubPartTS);
    }

    protected SpringLayout getHashSubPartTSLayout() {
        return (SpringLayout)this.hashSubPartTS.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        this.cbUser.setSelectedItem(this.index.getUser());
        this.cbLocalPartitioning.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getLocalPartitioning()));
        this.tfTablespace.setText(this.index.getTablespace());
        this.cbLogging.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getLogging()));
        this.cbSegment.setSelectedItem(this.index.getSegment());
        this.ifCompress.setValue((long)this.index.getCompress());
        this.cbParallel.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getParallel()));
        this.ifDegree.setText(this.index.getDegree());
        this.cbComputeStatistics.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getComputeStatistics()));
        this.cbOnline.setSelectedItem(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.index.getOnline()));
        TableProxySet tableProxySet = this.getStorageDesign().getTableProxySet();
        tableProxySet.sort();
        for (TableProxyOracle tableProxy : tableProxySet.getElements()) {
            if (this.index.getTable() == tableProxy || tableProxy.getPrimaryKeys().size() <= 0 && tableProxy.getUniqueKeys().size() <= 0) continue;
            StorageObjectCollection columnProxies = tableProxy.getColumns();
            columnProxies.sortByName();
            for (int j = 0; j < columnProxies.size(); ++j) {
                this.allColumnsModel.addElement(columnProxies.getElement(j));
            }
        }
        for (String indexColumnElement : this.index.getIndexColumnSet()) {
            StorageObject storageObject = this.storageDesign.getStorageObject(indexColumnElement);
            if (!(storageObject instanceof ColumnProxyOracle)) continue;
            this.allColumnsModel.removeElement(storageObject);
            this.selectedColumnsModel.addElement(storageObject);
        }
        this.initColumnsSortOrderAndDimensionKeys();
        this.initDimensionColumns();
        Iterator tsIt = this.index.getHashPartitionsTableSpacesSet().iterator();
        while (tsIt.hasNext()) {
            ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
            if (!(ts instanceof TableSpaceOracle)) continue;
            this.selectedHashSubPartTSModel.addElement(ts);
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedHashSubPartTSModel.contains(ts)) continue;
            this.allHashSubPartTSModel.addElement(ts);
        }
        PartitionListOracle partList = this.index.getTable().getPartitionList();
        String partType = null;
        String subpartType = "";
        if (partList != null) {
            partType = partList.getPartitionType();
            subpartType = partList.getSubpartitionType();
        }
        if (this.index.getLocalPartitioning().equalsIgnoreCase("YES") && partType != null && (partType.equalsIgnoreCase("HASH BY QUANTITY") || partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || subpartType.equalsIgnoreCase("HASH"))) {
            this.allHashSubPartTSList.setEnabled(true);
            this.selectedHashSubPartTSList.setEnabled(true);
            this.bnAddHashSubPartTS.setEnabled(this.allHashSubPartTSList.getSelectedIndex() != -1);
            this.bnRemoveHashSubPartTS.setEnabled(this.selectedHashSubPartTSList.getSelectedIndex() != -1);
        } else {
            this.allHashSubPartTSList.setEnabled(false);
            this.selectedHashSubPartTSList.setEnabled(false);
            this.bnAddHashSubPartTS.setEnabled(false);
            this.bnRemoveHashSubPartTS.setEnabled(false);
        }
        this.getCommentsList().insert(this.index.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            this.index.setUser((UserOracle)this.cbUser.getSelectedItem());
            this.index.setName(this.tfName.getText());
            this.index.setLocalPartitioning(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLocalPartitioning.getSelectedItem()));
            this.index.setTablespace(this.tfTablespace.getText());
            this.index.setLogging(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            this.index.setSegment((SegmentOracle)this.cbSegment.getSelectedItem());
            this.index.setCompress(this.ifCompress.getIntValue());
            this.index.setParallel(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.index.setDegree(this.ifDegree.getText());
            this.index.setComputeStatistics(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbComputeStatistics.getSelectedItem()));
            this.index.setOnline(BitmapJoinIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbOnline.getSelectedItem()));
            this.applyColumnsSortOrder();
            this.setDimensionKeys();
            this.setJoinColumns();
            this.index.getHashPartitionsTableSpacesSet().clear();
            Object[] set = this.selectedHashSubPartTSModel.toArray();
            for (int i = 0; i < set.length; ++i) {
                Object ts = set[i];
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.index.setHashSubPartitionsTableSpaces(((TableSpaceOracle)ts).getObjectID());
            }
            this.index.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedUser = this.cbUser.getSelectedItem();
        if (selectedUser instanceof UserOracle) {
            newName = ((UserOracle)selectedUser).getName() + '.' + newName;
        }
        return this.getStorageObject().allowName(newName, true);
    }

    private class RemoveHashSubPartTSActionListener
    implements ActionListener {
        private RemoveHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSModel.contains(ob)) continue;
                    BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSModel.addElement(ob);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AddHashSubPartTSActionListener
    implements ActionListener {
        private AddHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSModel.contains(ob)) continue;
                    BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSModel.addElement(ob);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.getSelectedIndex() == -1) {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveHashSubPartTS.setEnabled(false);
                } else {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveHashSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.getSelectedIndex() == -1) {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddHashSubPartTS.setEnabled(false);
                } else {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddHashSubPartTS.setEnabled(true);
                }
            }
        }
    }

    protected class ColumnsSortOrderModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("BitmapJoinIndexPropertyDialogOracle.ColumnName"), Messages.getString("BitmapJoinIndexPropertyDialogOracle.SortOrder")};
        private ArrayList columns = new ArrayList();

        public ColumnsSortOrderModel(BitmapJoinIndexOraclev10g index, ColumnProxyOraclev10g[] cols) {
            for (int i = 0; i < cols.length; ++i) {
                this.columns.add(new ColumnNode(index, cols[i]));
            }
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return this.columns.size();
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            return this.COL_NAMES[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            ColumnNode cn = (ColumnNode)this.columns.get(row);
            if (col == 0) {
                return cn;
            }
            return cn.sortOrder;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable()) {
                return false;
            }
            return col != 0;
        }

        public Object[] getRows() {
            int rowCount = this.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = ((ColumnNode)this.getValueAt(i, 0)).getColumnId() + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ColumnNode cn = (ColumnNode)this.columns.get(row);
            if (col == 1) {
                cn.sortOrder = (String)value;
                this.fireTableCellUpdated(row, col);
            }
        }

        public void setUpSortOrderColumn(TableColumn sortColumn) {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("ASC");
            comboBox.addItem("DESC");
            sortColumn.setCellEditor(new DefaultCellEditor(comboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(Messages.getString("BitmapJoinIndexPropertyDialogOracle.ClickForComboBox"));
            sortColumn.setCellRenderer(renderer);
            TableCellRenderer headerRenderer = sortColumn.getHeaderRenderer();
            if (headerRenderer instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)headerRenderer).setToolTipText(Messages.getString("BitmapJoinIndexPropertyDialogOracle.ClickTheSort"));
            }
        }

        public class ColumnNode {
            public String name;
            public String objectId;
            public String sortOrder;

            ColumnNode(BitmapJoinIndexOraclev10g index, ColumnProxyOraclev10g column) {
                this.name = column.getLongName();
                this.objectId = column.getObjectID();
                this.sortOrder = index.getColumnSortOrder(column.getObjectID());
            }

            public String toString() {
                return this.name;
            }

            public String getColumnId() {
                return this.objectId;
            }
        }
    }

    class LongNameCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public LongNameCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ColumnProxyOracle) {
                this.setText(((ColumnProxyOracle)value).getLongName());
            } else {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsModel.contains(ob)) continue;
                    BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsModel.addElement(ob);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsModel.removeElement(ob);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.initColumnsSortOrderAndDimensionKeys();
                    BitmapJoinIndexPropertyDialogOraclev10g.this.initDimensionColumns();
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsModel.contains(ob)) continue;
                    BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsModel.addElement(ob);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsModel.removeElement(ob);
                    BitmapJoinIndexPropertyDialogOraclev10g.this.initColumnsSortOrderAndDimensionKeys();
                    BitmapJoinIndexPropertyDialogOraclev10g.this.initDimensionColumns();
                }
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BitmapJoinIndexPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() == -1) {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveColumns.setEnabled(false);
                } else {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BitmapJoinIndexPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() == -1) {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddColumns.setEnabled(false);
                } else {
                    BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    class DimensionColumnsTable
    extends JTable {
        KeysTableModel dataModel;

        public DimensionColumnsTable() {
            String[] cNames = new String[]{Messages.getString("BitmapJoinIndexPropertyDialogOracle.DimensionTableColumns"), Messages.getString("BitmapJoinIndexPropertyDialogOracle.BaseTableColumns")};
            this.dataModel = new KeysTableModel(cNames);
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0 || col == 1) {
                return new LabelTableCellRenderer();
            }
            return super.getCellRenderer(row, col);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 1) {
                return new BaseTableColumnsCellEditor();
            }
            return super.getCellEditor();
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            return this;
        }
    }

    class BaseTableColumnsCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        BaseTableColumnsCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cbox.setModel(new DefaultComboBoxModel<ColumnProxy>(BitmapJoinIndexPropertyDialogOraclev10g.this.index.getTable().getColumnProxies()));
            this.cbox.setSelectedItem(value);
            return this.cbox;
        }
    }

    class ComboBoxCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        ComboBoxCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)table.getValueAt(row, 0);
            ArrayList keys = new ArrayList();
            keys.addAll(tableProxy.getPrimaryKeys().getElementsList());
            keys.addAll(tableProxy.getUniqueKeys().getElementsList());
            this.cbox.setModel(new DefaultComboBoxModel<Object>(keys.toArray()));
            this.cbox.setSelectedItem(value);
            return this.cbox;
        }
    }

    class OptionsTable
    extends JTable {
        KeysTableModel dataModel;

        public OptionsTable() {
            String[] cNames = new String[]{Messages.getString("BitmapJoinIndexPropertyDialogOracle.DimensionTable"), Messages.getString("BitmapJoinIndexPropertyDialogOracle.TableKey")};
            this.dataModel = new KeysTableModel(cNames);
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0 || col == 1) {
                return new LabelTableCellRenderer();
            }
            return super.getCellRenderer(row, col);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 1) {
                return new ComboBoxCellEditor();
            }
            return super.getCellEditor();
        }
    }

    class KeysTableModel
    extends DefaultTableModel {
        String[] cNames;

        public KeysTableModel(String[] cNames) {
            this.cNames = cNames;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!BitmapJoinIndexPropertyDialogOraclev10g.this.isEditable()) {
                return false;
            }
            return col == 0 || col == 1;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = this.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }
    }

    private class ParallelListener
    implements ActionListener {
        private ParallelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BitmapJoinIndexPropertyDialogOraclev10g.this.ifDegree.setEnabled(BitmapJoinIndexPropertyDialogOraclev10g.this.cbParallel.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }

    private class LocalPartitionListener
    implements ActionListener {
        private LocalPartitionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PartitionListOracle partList = BitmapJoinIndexPropertyDialogOraclev10g.this.index.getTable().getPartitionList();
            String partType = null;
            String subpartType = "";
            if (partList != null) {
                partType = partList.getPartitionType();
                subpartType = partList.getSubpartitionType();
            }
            if (((String)BitmapJoinIndexPropertyDialogOraclev10g.this.cbLocalPartitioning.getSelectedItem()).equalsIgnoreCase(AbstractPropertyDialog.YES) && partType != null && (partType.equalsIgnoreCase("HASH BY QUANTITY") || partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || subpartType.equalsIgnoreCase("HASH"))) {
                BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.setEnabled(true);
                BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.setEnabled(true);
                BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddHashSubPartTS.setEnabled(BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.getSelectedIndex() != -1);
                BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveHashSubPartTS.setEnabled(BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.getSelectedIndex() != -1);
            } else {
                BitmapJoinIndexPropertyDialogOraclev10g.this.allHashSubPartTSList.setEnabled(false);
                BitmapJoinIndexPropertyDialogOraclev10g.this.selectedHashSubPartTSList.setEnabled(false);
                BitmapJoinIndexPropertyDialogOraclev10g.this.bnAddHashSubPartTS.setEnabled(false);
                BitmapJoinIndexPropertyDialogOraclev10g.this.bnRemoveHashSubPartTS.setEnabled(false);
            }
        }
    }
}

