/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.LocalIndexPropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ListPartitionPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    protected ListPartitionOraclev10g listPartition;
    private JTextField tfValueList;
    private JComboBox cbCompression;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JPanel indexesButtonPanel;
    private JList list;
    private DefaultListModel listModel;
    private JButton edit;

    public ListPartitionPropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.listPartition = (ListPartitionOraclev10g)object;
        this.setHeight(280);
        this.initCommentsView(210);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ListPartitionPropertyDialogOracle.ListPartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initDataSegmentCompression();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
    }

    private void initValueList() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.ValueList"));
        this.general.add(label);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initDataSegmentCompression() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Compression"));
        this.general.add(label);
        this.cbCompression = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbCompression);
        this.cbCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompression);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbCompression, 80);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    @Override
    protected void addTabs() {
        this.initIndexesTab();
    }

    private void initIndexesTab() {
        JPanel constraintPanel = new JPanel();
        JScrollPane pane = new JScrollPane(this.getList());
        pane.setPreferredSize(new Dimension(390, 180));
        constraintPanel.add((Component)this.getIndexesButtonPanel(), "North");
        constraintPanel.add((Component)pane, "Center");
        this.getPane().addTab(Messages.getString("ListPartitionPropertyDialogOracle.LocalIndexes"), constraintPanel);
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.edit = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("ListPartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListPartitionPropertyDialogOraclev10g.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.edit);
            toolBar.addSeparator();
            this.indexesButtonPanel.add(toolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void editSelected() {
        Object selected = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev10g editor = new LocalIndexPropertyDialogOraclev10g(this.listPartition.getDesign().getAppView(), this.getStorageDesign(), this.listPartition, (StorageObject)selected);
        editor.show();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.listPartition.getName());
        this.tfName.setText(this.listPartition.getName());
        this.tfValueList.setText(this.listPartition.getColumns());
        this.cbCompression.setSelectedItem(ListPartitionPropertyDialogOraclev10g.translateYesNoForDisplay(this.listPartition.getDataSegmentCompression()));
        this.selectObject(this.cbTableSpace, this.listPartition.getTablespace());
        this.cbLogging.setSelectedItem(ListPartitionPropertyDialogOraclev10g.translateYesNoForDisplay(this.listPartition.getLogging()));
        this.selectObject(this.cbSegment, this.listPartition.getSegment());
        PartitionListOracle partitionList = this.listPartition.getPartitionList();
        if (partitionList != null) {
            SnapshotOracle snapshot;
            TableProxyOraclev10g table = (TableProxyOraclev10g)partitionList.getTable();
            if (table == null && (snapshot = partitionList.getSnapshot()) != null) {
                table = (TableProxyOraclev10g)snapshot.getImplementedTable();
            }
            if (table != null) {
                Iterator it = table.getIndexes().iterator();
                while (it.hasNext()) {
                    IndexProxyOraclev10g index = (IndexProxyOraclev10g)it.next();
                    if (!index.getIndexPartitioned().equalsIgnoreCase("local")) continue;
                    this.listModel.addElement(index);
                }
                Iterator bjiIt = table.getBjIndexes().iterator();
                while (bjiIt.hasNext()) {
                    BitmapJoinIndexOraclev10g bji = (BitmapJoinIndexOraclev10g)bjiIt.next();
                    if (!bji.getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                    this.listModel.addElement(bji);
                }
                Iterator uniqueIt = table.getUniqueKeys().iterator();
                while (uniqueIt.hasNext()) {
                    UniqueOraclev10g unique = (UniqueOraclev10g)uniqueIt.next();
                    if (!unique.getUsingIndex().equalsIgnoreCase("local")) continue;
                    this.listModel.addElement(unique);
                }
                Iterator pkIt = table.getPrimaryKeys().iterator();
                while (pkIt.hasNext()) {
                    PKProxyOraclev10g pk = (PKProxyOraclev10g)pkIt.next();
                    if (!pk.getUsingIndex().equalsIgnoreCase("local")) continue;
                    this.listModel.addElement(pk);
                }
            }
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            LocalIndexProperties lip;
            StorageObject index;
            if (this.listModel.get(i) instanceof IndexProxyOraclev10g) {
                index = (IndexProxyOraclev10g)this.listModel.get(i);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setPartition(this.listPartition);
                lip.setIndex(index);
                continue;
            }
            if (this.listModel.get(i) instanceof BitmapJoinIndexOraclev10g) {
                index = (BitmapJoinIndexOraclev10g)this.listModel.get(i);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setPartition(this.listPartition);
                lip.setIndex(index);
                continue;
            }
            if (this.listModel.get(i) instanceof UniqueOraclev10g) {
                index = (UniqueOraclev10g)this.listModel.get(i);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setPartition(this.listPartition);
                lip.setIndex(index);
                continue;
            }
            if (!(this.listModel.get(i) instanceof PKProxyOraclev10g)) continue;
            index = (PKProxyOraclev10g)this.listModel.get(i);
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, index);
            if (lip != null) continue;
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            lip.setPartition(this.listPartition);
            lip.setIndex(index);
        }
        this.getCommentsList().insert(this.listPartition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.listPartition != null) {
            this.listPartition.setName(this.tfName.getText());
            this.listPartition.setColumns(this.tfValueList.getText());
            this.listPartition.setDataSegmentCompression(ListPartitionPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbCompression.getSelectedItem()));
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOraclev10g) {
                this.listPartition.setTablespace((TableSpaceOraclev10g)selected);
            } else {
                this.listPartition.setTablespace(null);
            }
            this.listPartition.setLogging(ListPartitionPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOraclev10g) {
                this.listPartition.setSegment((SegmentOraclev10g)selected);
            } else {
                this.listPartition.setSegment(null);
            }
            this.listPartition.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ListPartitionPropertyDialogOraclev10g.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Index) {
                this.setText(((Index)value).getName());
            } else {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }
}

