/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.PartitionPropertyTabOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.TablePropertyDialogOraclev11g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    protected TableProxyOraclev10g table;
    protected PartitionPropertyTabOraclev10g partitionPropertyTab;
    private static final String YES_PRESERVE = Messages.getString("TablePropertyDialogOracle.YES_PRESERVE_ROWS");
    private static final String YES_DELETE = Messages.getString("TablePropertyDialogOracle.YES_DELETE_ROWS");
    private static final String[] NO_PRESERVE_DELETE = new String[]{NO, YES_PRESERVE, YES_DELETE};
    private JComboBox cbUser;
    private JComboBox cbTemporary;
    private JLabel lbTableSpace;
    private JLabel lbTemporaryTablespace;
    private JComboBox cbTableSpace;
    private JComboBox cbTemporaryTablespace;
    private JComboBox cbOrganization;
    private JComboBox cbCluster;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JComboBox cbCache;
    private JComboBox cbParallel;
    private JPositiveIntegerField ifDegree;
    private JComboBox cbRowDependency;
    private JComboBox cbPartitioned;
    private JComboBox cbPartRowMovement;
    protected JComboBox cbDataSegmentCompression;
    private JTextField tfBasedOnStructuredType;
    private JComboBox cbSnapshot;
    private JPositiveIntegerField ifIotCompress;
    private JPositiveIntegerField ifIotPctThreshold;
    private JComboBox cbIotIncluding;
    private JComboBox cbIotOverflowTablespace;
    private JComboBox cbIotOverflowLogging;
    private JComboBox cbIotOverflowSegment;
    private JComboBox cbIotMappingTable;
    private JPanel iotProperties;
    private JPanel partitioningTab;
    private JPanel supplementalLog;
    private JTextField tfSupplementalLogGroupName;
    private JComboBox cbSupplementalLogCondition;
    private JList allSupplementalColumnsList;
    private JList selectedSupplementalColumnsList;
    private DefaultListModel allSupplementalColumnsModel;
    private DefaultListModel selectedSupplementalColumnsModel;
    private JButton bnSupplementalAdd;
    private JButton bnSupplementalRemove;
    private JPanel clusterColumns;
    private JList allClusterColumnsList;
    private JList selectedClusterColumnsList;
    private DefaultListModel allClusterColumnsModel;
    private DefaultListModel selectedClusterColumnsModel;
    private JButton bnAddClusterColumn;
    private JButton bnRemoveClusterColumn;
    private String comment;
    private String commentInRDBMS;
    private JPanel oidProperties;
    private JTextField tfOidIndexName;
    private JComboBox cbOidIndexSegment;
    private JTextField tfOidType;
    protected JPanel xmlTypeProperties;
    protected JTextField tfXmlSchemaUrl;
    private JTextField tfXmlSchemaElement;
    private JComboBox cbStoreAs;
    protected JComboBox cbAllowAnySchema;
    protected JComboBox cbAllowNonSchema;
    protected JComboBox cbLobStorageType;
    private JTextField tfLobSegmentName;
    private JComboBox cbXmlTypeTableSpace;
    private JComboBox cbStorageInRow;
    private JComboBox cbXmlTypeLogging;
    private JComboBox cbXmlTypeCache;
    private JPositiveIntegerField ifChunk;
    private JComboBox cbOldVersions;
    private JPositiveIntegerField ifPctVersion;
    private JPositiveIntegerField ifFreePools;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public TablePropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.table = (TableProxyOraclev10g)object;
        this.setHeight(650);
        this.initCommentsView(260);
        this.initCommentsInRDBMS(265);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogOracle.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.setObjectConstraints(this.tfName, 20);
        this.initUser();
        this.initTemporary();
        this.initTableSpace();
        this.initOrganization();
        this.initCluster();
        this.initLogging();
        this.initSegment();
        this.initCache();
        this.initParallel();
        this.initDegree();
        this.initRowDependency();
        this.initPartitioned();
        this.initPartRowMovement();
        this.initDataSegmentCompression();
        int yCoord = this.initCompressionType(470);
        yCoord = this.initBasedOnStructuredType(yCoord);
        yCoord = this.initSnapshot(yCoord) + 10;
        if (this.isEditable()) {
            this.initPropagatePropsButton(yCoord);
        }
        this.initPermissionsButton(yCoord);
    }

    private void initUser() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.User"));
        this.general.add(label);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initTemporary() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Temporary"));
        this.general.add(label);
        this.cbTemporary = new JComboBox<String>(NO_PRESERVE_DELETE);
        this.setBG(this.cbTemporary);
        this.cbTemporary.addActionListener(new TemporaryListener());
        this.cbTemporary.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTemporary);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbTemporary, 80);
    }

    private void initTableSpace() {
        this.lbTableSpace = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.general.add(this.lbTableSpace);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(this.lbTableSpace, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.lbTemporaryTablespace = new JLabel(Messages.getString("TablePropertyDialogOracle.TemporaryTablespace"));
            this.general.add(this.lbTemporaryTablespace);
            this.cbTemporaryTablespace = new JComboBox();
            this.setBG(this.cbTemporaryTablespace);
            if (this.getStorageDesign() != null) {
                this.fillComboItems(this.getStorageDesign().getTemporaryTablespaceSet().toArray(), this.cbTemporaryTablespace);
            }
            this.cbTemporaryTablespace.setPreferredSize(this.tfName.getPreferredSize());
            this.general.add(this.cbTemporaryTablespace);
            this.setLabelConstraints(this.lbTemporaryTablespace, 110);
            this.setObjectConstraints(this.cbTemporaryTablespace, 110);
        }
    }

    private void initOrganization() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Organization"));
        this.general.add(label);
        this.cbOrganization = new JComboBox<String>(TableProxyOracle.getOrganizationChoices());
        this.setBG(this.cbOrganization);
        this.cbOrganization.setPreferredSize(this.tfName.getPreferredSize());
        this.cbOrganization.addActionListener(new OrganizationListener());
        this.general.add(this.cbOrganization);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbOrganization, 140);
    }

    private void initCluster() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Cluster"));
        this.general.add(label);
        this.cbCluster = new JComboBox();
        this.setBG(this.cbCluster);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getClusterSet().toArray(), this.cbCluster);
        }
        this.cbCluster.addActionListener(new ClusterListener());
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbLogging, 200);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbSegment, 230);
    }

    private void initCache() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.general.add(label);
        this.cbCache = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbCache, 260);
    }

    private void initParallel() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Parallel"));
        this.general.add(label);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.addActionListener(new ParallelListener());
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbParallel, 290);
    }

    private void initDegree() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Degree"));
        this.general.add(label);
        this.ifDegree = new JPositiveIntegerField(0, 26);
        this.general.add(this.ifDegree);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.ifDegree, 320);
    }

    private void initRowDependency() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.RowDependency"));
        this.general.add(label);
        this.cbRowDependency = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRowDependency);
        this.cbRowDependency.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRowDependency);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbRowDependency, 350);
    }

    private void initPartitioned() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Partitioned"));
        this.general.add(label);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitioned.addActionListener(new PartitionedAction());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbPartitioned, 380);
    }

    private void initPartRowMovement() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.RowMovement"));
        this.general.add(label);
        this.cbPartRowMovement = new JComboBox<String>(TableProxyOracle.getParttitionedRowMovementChoices());
        this.setBG(this.cbPartRowMovement);
        this.cbPartRowMovement.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartRowMovement);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.cbPartRowMovement, 410);
    }

    private void initDataSegmentCompression() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.DataCompression"));
        this.general.add(label);
        this.cbDataSegmentCompression = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDataSegmentCompression);
        this.cbDataSegmentCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataSegmentCompression);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.cbDataSegmentCompression, 440);
    }

    protected int initCompressionType(int yCoord) {
        return yCoord;
    }

    private List getSnapshots() {
        ArrayList<SnapshotOracle> result = new ArrayList<SnapshotOracle>();
        Iterator it = this.getStorageDesign().getSnapshotSet().iterator();
        while (it.hasNext()) {
            SnapshotOracle snapshot = (SnapshotOracle)it.next();
            TableProxyOracle snapshotTable = snapshot.getImplementedTable();
            if (snapshotTable != null && snapshotTable != this.getStorageObject()) continue;
            result.add(snapshot);
        }
        return result;
    }

    private int initBasedOnStructuredType(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.StructuredType"));
        this.general.add(label);
        this.tfBasedOnStructuredType = new JTextField();
        this.setBG(this.tfBasedOnStructuredType);
        this.tfBasedOnStructuredType.setEnabled(false);
        this.tfBasedOnStructuredType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfBasedOnStructuredType);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.tfBasedOnStructuredType, yCoord);
        return yCoord + 30;
    }

    private int initSnapshot(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.ImplementAsSnapshot"));
        this.general.add(label);
        this.cbSnapshot = new JComboBox();
        this.cbSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePropertyDialogOraclev10g.this.snapshotChanged();
            }
        });
        this.setBG(this.cbSnapshot);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getSnapshots().toArray(), this.cbSnapshot);
        }
        this.cbSnapshot.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSnapshot);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbSnapshot, yCoord);
        return yCoord + 30;
    }

    private void initPropagatePropsButton(int yCoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TablePropertyDialogOraclev10g.this.getStorageDesign().getTableProxySet().getElements());
                list.remove(TablePropertyDialogOraclev10g.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogOraclev10g.this.getAppView(), TablePropertyDialogOraclev10g.this.table, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, yCoord);
    }

    private void initPermissionsButton(int yCoord) {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 265, yCoord);
    }

    protected SpringLayout getIOTPropertiesLayout() {
        return (SpringLayout)this.iotProperties.getLayout();
    }

    protected SpringLayout getSupplementalLogLayout() {
        return (SpringLayout)this.supplementalLog.getLayout();
    }

    private void initIOTCompress() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTCompress"));
        this.iotProperties.add(label);
        this.ifIotCompress = new JPositiveIntegerField(0, 26);
        this.iotProperties.add(this.ifIotCompress);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 20);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotCompress, 20);
    }

    private void initIOTPCTThreshold() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTPCTThreshold"));
        this.iotProperties.add(label);
        this.ifIotPctThreshold = new JPositiveIntegerField(0, 26);
        this.iotProperties.add(this.ifIotPctThreshold);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 50);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotPctThreshold, 50);
    }

    private void initIOTIncluding() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTIncluding"));
        this.iotProperties.add(label);
        this.cbIotIncluding = new JComboBox();
        this.setBG(this.cbIotIncluding);
        this.cbIotIncluding.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotIncluding);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 80);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotIncluding, 80);
    }

    private void initIOTOverflowTablespace() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowTablespace"));
        this.iotProperties.add(label);
        this.cbIotOverflowTablespace = new JComboBox();
        this.setBG(this.cbIotOverflowTablespace);
        this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIotOverflowTablespace);
        this.cbIotOverflowTablespace.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowTablespace);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 110);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowTablespace, 110);
    }

    private void initIOTOverflowLogging() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowLogging"));
        this.iotProperties.add(label);
        this.cbIotOverflowLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbIotOverflowLogging);
        this.cbIotOverflowLogging.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowLogging);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 140);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowLogging, 140);
    }

    private void initIOTOverflowSegment() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowSegment"));
        this.iotProperties.add(label);
        this.cbIotOverflowSegment = new JComboBox();
        this.setBG(this.cbIotOverflowSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIotOverflowSegment);
        }
        this.cbIotOverflowSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowSegment);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 170);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowSegment, 170);
    }

    private void initIOTMappingTable() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.MappingTable"));
        this.iotProperties.add(label);
        this.cbIotMappingTable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIotMappingTable);
        this.cbIotMappingTable.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotMappingTable);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 200);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotMappingTable, 200);
    }

    @Override
    protected void addTabs() {
        this.initClusterColumnsView();
        this.partitioningTab = this.initPartitioningView();
        this.initIOTPropertiesView();
        this.initSupplementalLogView();
        this.initOIDView();
        this.initXMLTypeView();
    }

    private void initXMLTypeView() {
        this.xmlTypeProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.XMLTypeProperties"), this.xmlTypeProperties);
        this.initXMLTypeProperties();
    }

    private void initXMLTypeProperties() {
        this.initXMLSchemaURL(20);
        this.initXMLSchemaElement(50);
        int yCoord = this.initAllowAnySchema(80);
        yCoord = this.initAllowNonSchema(yCoord);
        this.initStoreAs(yCoord);
        yCoord += 30;
        yCoord = this.initLobStorageType(yCoord);
        this.initLobSegmentName(yCoord);
        this.initXmlTypeTableSpace(yCoord += 30);
        this.initStorageInRow(yCoord += 30);
        this.initXmlTypeLogging(yCoord += 30);
        this.initXmlTypeCache(yCoord += 30);
        this.initChunk(yCoord += 30);
        this.initOldVersions(yCoord += 30);
        this.initPctVersion(yCoord += 30);
        this.initFreePools(yCoord += 30);
    }

    private void initStoreAs(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.StoreAs"));
        this.xmlTypeProperties.add(label);
        this.cbStoreAs = this.getStorageDesign() instanceof StorageDesignOraclev11g ? new JComboBox<String>(TableProxyOraclev11g.getStoreAsValues11g()) : new JComboBox<String>(TableProxyOraclev10g.getStoreAsValues());
        this.cbStoreAs.addActionListener(new StoreAsListener());
        this.setBG(this.cbStoreAs);
        this.cbStoreAs.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStoreAs);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStoreAs, yCoord);
    }

    private void initXMLSchemaURL(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaURL"));
        this.xmlTypeProperties.add(label);
        this.tfXmlSchemaUrl = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaUrl);
        this.xmlTypeProperties.add(this.tfXmlSchemaUrl);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaUrl, yCoord);
    }

    private void initXMLSchemaElement(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaElem"));
        this.xmlTypeProperties.add(label);
        this.tfXmlSchemaElement = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaElement);
        this.xmlTypeProperties.add(this.tfXmlSchemaElement);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaElement, yCoord);
    }

    protected int initAllowAnySchema(int yCoord) {
        return yCoord;
    }

    protected int initAllowNonSchema(int yCoord) {
        return yCoord;
    }

    protected int initLobStorageType(int yCoord) {
        return yCoord;
    }

    private void initLobSegmentName(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.LobSegmentName"));
        this.xmlTypeProperties.add(label);
        this.tfLobSegmentName = new JTextField("", 26);
        this.xmlTypeProperties.add(this.tfLobSegmentName);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfLobSegmentName, yCoord);
    }

    private void initXmlTypeTableSpace(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.xmlTypeProperties.add(label);
        this.cbXmlTypeTableSpace = new JComboBox();
        this.setBG(this.cbXmlTypeTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbXmlTypeTableSpace);
        }
        this.cbXmlTypeTableSpace.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeTableSpace);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeTableSpace, yCoord);
    }

    private void initStorageInRow(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.StorageInRow"));
        this.xmlTypeProperties.add(label);
        this.cbStorageInRow = new JComboBox<String>(TableProxyOracle.getStorageInRowValues());
        this.setBG(this.cbStorageInRow);
        this.cbStorageInRow.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStorageInRow);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStorageInRow, yCoord);
    }

    private void initXmlTypeLogging(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.xmlTypeProperties.add(label);
        this.cbXmlTypeLogging = new JComboBox<String>(this instanceof TablePropertyDialogOraclev11g ? TableProxyOraclev11g.getXmlTypeLoggingChoices11g() : EMPTY_YES_NO);
        this.setBG(this.cbXmlTypeLogging);
        this.cbXmlTypeLogging.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeLogging);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeLogging, yCoord);
    }

    private void initXmlTypeCache(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.xmlTypeProperties.add(label);
        this.cbXmlTypeCache = new JComboBox<String>(TableProxyOracle.getXmlTypeCacheValues());
        this.setBG(this.cbXmlTypeCache);
        this.cbXmlTypeCache.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeCache);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeCache, yCoord);
    }

    private void initChunk(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Chunk"));
        this.xmlTypeProperties.add(label);
        this.ifChunk = new JPositiveIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifChunk);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifChunk, yCoord);
    }

    private void initOldVersions(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OldVersions"));
        this.xmlTypeProperties.add(label);
        this.cbOldVersions = new JComboBox<String>(TableProxyOraclev10g.getOldVersionChoices());
        this.cbOldVersions.addActionListener(new VersionListener());
        this.setBG(this.cbOldVersions);
        this.cbOldVersions.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbOldVersions);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbOldVersions, yCoord);
    }

    private void initPctVersion(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.PCTVersion"));
        this.xmlTypeProperties.add(label);
        this.ifPctVersion = new JPositiveIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifPctVersion);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifPctVersion, yCoord);
    }

    private void initFreePools(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.FreePools"));
        this.xmlTypeProperties.add(label);
        this.ifFreePools = new JPositiveIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifFreePools);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifFreePools, yCoord);
    }

    private void enableXMLTypeClobOptions(boolean enable) {
        if (this.getStorageDesign() instanceof StorageDesignOraclev11g) {
            this.cbLobStorageType.setEnabled(enable);
        }
        this.tfLobSegmentName.setEnabled(enable);
        this.cbXmlTypeTableSpace.setEnabled(enable);
        this.cbStorageInRow.setEnabled(enable);
        this.cbXmlTypeLogging.setEnabled(enable);
        this.cbXmlTypeCache.setEnabled(enable);
        this.ifChunk.setEnabled(enable);
        this.cbOldVersions.setEnabled(enable);
        this.ifPctVersion.setEnabled(enable);
        this.ifFreePools.setEnabled(enable);
    }

    protected SpringLayout getXMLTypePropertiesLayout() {
        return (SpringLayout)this.xmlTypeProperties.getLayout();
    }

    private void initOIDView() {
        this.oidProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.OIDProperties"), this.oidProperties);
        this.initOIDProperties();
    }

    private void initOIDProperties() {
        this.initOidType();
        this.initOidIndexName();
        this.initOidIndexSegment();
    }

    private void initOidType() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDType"));
        this.oidProperties.add(label);
        this.tfOidType = new JTextField();
        this.tfOidType.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.tfOidType.setEnabled(false);
        this.oidProperties.add(this.tfOidType);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), label, 20);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidType, 20);
    }

    private void initOidIndexName() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexName"));
        this.oidProperties.add(label);
        this.tfOidIndexName = new JTextField();
        this.tfOidIndexName.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.tfOidIndexName);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), label, 50);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidIndexName, 50);
    }

    private void initOidIndexSegment() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexSegment"));
        this.oidProperties.add(label);
        this.cbOidIndexSegment = new JComboBox();
        this.setBG(this.cbOidIndexSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbOidIndexSegment);
        }
        this.cbOidIndexSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.cbOidIndexSegment);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), label, 80);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.cbOidIndexSegment, 80);
    }

    protected SpringLayout getOIDPropertiesLayout() {
        return (SpringLayout)this.oidProperties.getLayout();
    }

    private void initSupplementalLogView() {
        this.supplementalLog = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.SupplementalLog"), this.supplementalLog);
        this.initSupplementalLog();
    }

    private void initSupplementalLog() {
        this.initSupplementalLogGroupName();
        this.initSupplementalLogCondition();
        this.initSupplementalLogColumns();
    }

    private void initSupplementalLogColumns() {
        this.initAllSupplementalColumnsList();
        this.initSelectedSupplementalColumnsList();
        this.initSupplementalButtons();
    }

    private void initAllSupplementalColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.supplementalLog.add(label);
        this.allSupplementalColumnsModel = new DefaultListModel();
        this.allSupplementalColumnsList = new JList(this.allSupplementalColumnsModel);
        ListSelectionModel listSelectionModel = this.allSupplementalColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSupplementalSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSupplementalColumnsList);
        sp.setPreferredSize(new Dimension(144, 450));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.supplementalLog.add(sp);
        this.setLabelConstraints(this.getSupplementalLogLayout(), label, 8, 84);
        this.setObjectConstraints(this.getSupplementalLogLayout(), sp, 6, 112);
    }

    private void initSelectedSupplementalColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.SupplementalColumns"));
        this.supplementalLog.add(label);
        this.selectedSupplementalColumnsModel = new DefaultListModel();
        this.selectedSupplementalColumnsList = new JList(this.selectedSupplementalColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedSupplementalColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSupplementalSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSupplementalColumnsList);
        sp.setPreferredSize(new Dimension(145, 450));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.supplementalLog.add(sp);
        this.setLabelConstraints(this.getSupplementalLogLayout(), label, 292, 84);
        this.setObjectConstraints(this.getSupplementalLogLayout(), sp, 290, 112);
    }

    private void initSupplementalButtons() {
        this.bnSupplementalAdd = new JButton(ADD_CAPTION);
        this.bnSupplementalAdd.addActionListener(new AddSupplementalColumnsActionListener());
        this.bnSupplementalAdd.setEnabled(false);
        this.supplementalLog.add(this.bnSupplementalAdd);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.bnSupplementalAdd, 175, 290);
        this.bnSupplementalRemove = new JButton(REMOVE_CAPTION);
        this.bnSupplementalRemove.setEnabled(false);
        this.bnSupplementalRemove.addActionListener(new RemoveSupplementalColumnsActionListener());
        this.supplementalLog.add(this.bnSupplementalRemove);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.bnSupplementalRemove, 175, 330);
        TablePropertyDialogOraclev10g.equalizeButtonSizes(this.bnSupplementalAdd, this.bnSupplementalRemove);
    }

    private void initSupplementalLogGroupName() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.GroupName"));
        this.supplementalLog.add(label);
        this.tfSupplementalLogGroupName = new JTextField("", 26);
        this.supplementalLog.add(this.tfSupplementalLogGroupName);
        this.setLabelConstraints(this.getSupplementalLogLayout(), label, 20);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.tfSupplementalLogGroupName, 20);
    }

    private void initSupplementalLogCondition() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Condition"));
        this.supplementalLog.add(label);
        this.cbSupplementalLogCondition = new JComboBox<String>(TableProxyOraclev10g.suplementalLogConditionChoices);
        this.setBG(this.cbSupplementalLogCondition);
        this.cbSupplementalLogCondition.setPreferredSize(this.tfSupplementalLogGroupName.getPreferredSize());
        this.supplementalLog.add(this.cbSupplementalLogCondition);
        this.setLabelConstraints(this.getSupplementalLogLayout(), label, 50);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.cbSupplementalLogCondition, 50);
    }

    private void initIOTPropertiesView() {
        this.iotProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.IOTProperties"), this.iotProperties);
        this.initIOTProperties();
    }

    private void initIOTProperties() {
        this.initIOTCompress();
        this.initIOTPCTThreshold();
        this.initIOTIncluding();
        this.initIOTOverflowTablespace();
        this.initIOTOverflowLogging();
        this.initIOTOverflowSegment();
        this.initIOTMappingTable();
    }

    private void initClusterColumnsView() {
        this.clusterColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.ClusterColumns"), this.clusterColumns);
        this.initClusterColumns();
    }

    protected SpringLayout getClusterColumnsLayout() {
        return (SpringLayout)this.clusterColumns.getLayout();
    }

    private void initClusterColumns() {
        this.initAllClusterColumnsList();
        this.initSelectedClusterColumnsList();
        this.initClusterColumnsButtons();
    }

    private void initAllClusterColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.clusterColumns.add(label);
        this.allClusterColumnsModel = new DefaultListModel();
        this.allClusterColumnsList = new JList(this.allClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.allClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllClusterColumnListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allClusterColumnsList);
        sp.setPreferredSize(new Dimension(144, 540));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(sp);
        this.setLabelConstraints(this.getClusterColumnsLayout(), label, 12, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), sp, 10, 22);
    }

    private void initSelectedClusterColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedColumns"));
        this.clusterColumns.add(label);
        this.selectedClusterColumnsModel = new DefaultListModel();
        this.selectedClusterColumnsList = new JList(this.selectedClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedClusterColumnListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedClusterColumnsList);
        sp.setPreferredSize(new Dimension(145, 540));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(sp);
        this.setLabelConstraints(this.getClusterColumnsLayout(), label, 292, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), sp, 290, 22);
    }

    private void initClusterColumnsButtons() {
        this.bnAddClusterColumn = new JButton(ADD_CAPTION);
        this.bnAddClusterColumn.addActionListener(new AddClusterColumnsActionListener());
        this.bnAddClusterColumn.setEnabled(false);
        this.clusterColumns.add(this.bnAddClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnAddClusterColumn, 175, 240);
        this.bnRemoveClusterColumn = new JButton(REMOVE_CAPTION);
        this.bnRemoveClusterColumn.setEnabled(false);
        this.bnRemoveClusterColumn.addActionListener(new RemoveClusterColumnsActionListener());
        this.clusterColumns.add(this.bnRemoveClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnRemoveClusterColumn, 175, 270);
        TablePropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddClusterColumn, this.bnRemoveClusterColumn);
    }

    protected JPanel initPartitioningView() {
        this.partitionPropertyTab = new PartitionPropertyTabOraclev10g(this.getAppView(), this.getStorageDesign(), this.getStorageObject(), this);
        return this.partitionPropertyTab.addTab(this.getPane());
    }

    @Override
    public void initProperties() {
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        String basedOnStructuredType = this.table.getBasedOnStructuredType();
        this.tfBasedOnStructuredType.setText(basedOnStructuredType);
        this.selectObject(this.cbUser, this.table.getUser());
        this.cbPartitioned.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getPartitioned()));
        this.cbPartRowMovement.setSelectedItem(this.table.getParttitionedRowMovement());
        this.cbOrganization.setSelectedItem(this.table.getOrganization());
        this.selectObject(this.cbCluster, this.table.getCluster());
        this.cbLogging.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getLogging()));
        this.selectObject(this.cbSegment, this.table.getSegment());
        this.cbCache.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getCache()));
        this.cbRowDependency.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getRowDependency()));
        this.cbDataSegmentCompression.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getDataSegmentCompression()));
        this.ifIotCompress.setValue((long)this.table.getIotCompress());
        this.ifIotPctThreshold.setValue((long)this.table.getIotPctThreshold());
        this.fillComboItems(this.table.getColumnProxies(), this.cbIotIncluding);
        this.cbIotIncluding.setSelectedItem(this.table.getIotIncluding());
        this.cbIotOverflowTablespace.setSelectedItem(this.table.getIotOverflowTablespace());
        this.cbIotOverflowLogging.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getIotOverflowLogging()));
        this.cbIotOverflowSegment.setSelectedItem(this.table.getIotOverflowSegment());
        this.cbIotMappingTable.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getIOTMappingTable()));
        this.cbSnapshot.setSelectedItem(this.table.getSnapshot());
        ColumnProxy[] columnSet = this.table.getColumnProxies();
        block0: for (String colId : this.table.getSuplementalLogColumnSet()) {
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy col = columnSet[i];
                if (!col.getObjectID().equals(colId)) continue;
                this.selectedSupplementalColumnsModel.addElement(col);
                continue block0;
            }
        }
        for (int i = 0; i < columnSet.length; ++i) {
            ColumnProxy col = columnSet[i];
            if (this.selectedSupplementalColumnsModel.contains(col)) continue;
            this.allSupplementalColumnsModel.addElement(col);
        }
        this.tfSupplementalLogGroupName.setText(this.table.getSuplementalLogGroupName());
        this.cbSupplementalLogCondition.setSelectedItem(this.table.getSuplementalLogConditions());
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.oidProperties), !basedOnStructuredType.equals(""));
        this.tfOidType.setText(this.table.getOidType());
        this.tfOidIndexName.setText(this.table.getOidIndexName());
        this.cbOidIndexSegment.setSelectedItem(this.table.getOidIndexSegment());
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.xmlTypeProperties), basedOnStructuredType.equalsIgnoreCase("XMLTYPE"));
        this.tfXmlSchemaUrl.setText(this.table.getXmlSchemaUrl());
        this.tfXmlSchemaElement.setText(this.table.getXmlSchemaElement());
        this.cbStoreAs.setSelectedItem(this.table.getStoreAs());
        this.tfLobSegmentName.setText(this.table.getLobSegmentName());
        this.selectObject(this.cbXmlTypeTableSpace, this.table.getXmlTypeTableSpace());
        this.cbStorageInRow.setSelectedItem(this.table.getStorageInRow());
        this.cbXmlTypeLogging.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getXmlTypeLogging()));
        this.cbXmlTypeCache.setSelectedItem(this.table.getXmlTypeCache());
        this.ifChunk.setValue((long)this.table.getChunk());
        this.cbOldVersions.setSelectedItem(this.table.getOldVersions());
        this.ifPctVersion.setValue((long)this.table.getPCTVersion());
        this.ifFreePools.setValue((long)this.table.getFreepools());
        block3: for (String colId : this.table.getClusterColumnsSet()) {
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy col = columnSet[i];
                if (!col.getObjectID().equals(colId)) continue;
                this.selectedClusterColumnsModel.addElement(col);
                continue block3;
            }
        }
        for (int i = 0; i < columnSet.length; ++i) {
            ColumnProxy col = columnSet[i];
            if (this.selectedClusterColumnsModel.contains(col)) continue;
            this.allClusterColumnsModel.addElement(col);
        }
        this.partitionPropertyTab.initProperties();
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        if (this.table.getTemporary().equals("NO")) {
            this.cbTemporary.setSelectedItem(NO);
        } else if (this.table.getTempPreserveRows().equals("YES")) {
            this.cbTemporary.setSelectedItem(YES_PRESERVE);
        } else {
            this.cbTemporary.setSelectedItem(YES_DELETE);
        }
        this.selectObject(this.cbTableSpace, this.table.getTableSpace());
        if (this.cbTemporaryTablespace != null) {
            this.selectObject(this.cbTemporaryTablespace, this.table.getTemporaryTablespace());
        }
        this.cbParallel.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getParallel()));
        this.ifDegree.setText(this.table.getDegree());
        if (this.cbSnapshot.getSelectedItem() != null) {
            this.snapshotChanged();
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            this.table.setName(this.tfName.getText());
            Object selected = this.cbUser.getSelectedItem();
            if (selected instanceof UserOraclev10g) {
                this.table.setUser((UserOraclev10g)selected);
            } else {
                this.table.setUser(null);
            }
            if (this.cbTemporary.getSelectedItem().equals(NO)) {
                this.table.setTemporary("NO");
                selected = this.cbTableSpace.getSelectedItem();
                if (selected instanceof TableSpaceOracle) {
                    this.table.setTableSpace((TableSpaceOracle)selected);
                } else {
                    this.table.setTableSpace(null);
                }
            } else {
                this.table.setTemporary("YES");
                if (this.cbTemporary.getSelectedItem().equals(YES_PRESERVE)) {
                    this.table.setTempPreserveRows("YES");
                } else {
                    this.table.setTempPreserveRows("NO");
                }
                if (this.cbTemporaryTablespace != null) {
                    selected = this.cbTemporaryTablespace.getSelectedItem();
                    if (selected instanceof TemporaryTablespaceOracle) {
                        this.table.setTemporaryTablespace((TemporaryTablespaceOracle)selected);
                    } else {
                        this.table.setTableSpace(null);
                    }
                }
            }
            this.table.setOrganization((String)this.cbOrganization.getSelectedItem());
            selected = this.cbCluster.getSelectedItem();
            if (selected instanceof ClusterOraclev10g) {
                this.table.setCluster((ClusterOraclev10g)selected);
            } else {
                this.table.setCluster(null);
            }
            this.table.setLogging(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOraclev10g) {
                this.table.setSegment((SegmentOraclev10g)selected);
            } else {
                this.table.setSegment(null);
            }
            this.table.setCache(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbCache.getSelectedItem()));
            this.table.setParallel(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.table.setDegree(this.ifDegree.getText());
            this.table.setRowDependency(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbRowDependency.getSelectedItem()));
            this.table.setPartitioned(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.table.setParttitionedRowMovement((String)this.cbPartRowMovement.getSelectedItem());
            this.table.setDataSegmentCompression(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbDataSegmentCompression.getSelectedItem()));
            this.table.setOidIndexName(this.tfOidIndexName.getText());
            this.table.setOidIndexSegment((SegmentOracle)this.cbOidIndexSegment.getSelectedItem());
            this.table.setXmlSchemaUrl(this.tfXmlSchemaUrl.getText());
            this.table.setXmlSchemaElement(this.tfXmlSchemaElement.getText());
            String storeAs = (String)this.cbStoreAs.getSelectedItem();
            this.table.setStoreAs(storeAs);
            if (!storeAs.equalsIgnoreCase("OBJECT RELATIONAL")) {
                this.table.setLobSegmentName(this.tfLobSegmentName.getText());
                selected = this.cbXmlTypeTableSpace.getSelectedItem();
                if (selected instanceof TableSpaceOraclev10g) {
                    this.table.setXmlTypeTableSpace((TableSpaceOraclev10g)selected);
                } else {
                    this.table.setXmlTypeTableSpace(null);
                }
                this.table.setStorageInRow((String)this.cbStorageInRow.getSelectedItem());
                this.table.setXmlTypeLogging(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbXmlTypeLogging.getSelectedItem()));
                this.table.setXmlTypeCache((String)this.cbXmlTypeCache.getSelectedItem());
                this.table.setChunk(this.ifChunk.getIntValue());
                this.table.setOldVersions((String)this.cbOldVersions.getSelectedItem());
                this.table.setFreepools(this.ifFreePools.getIntValue());
                this.table.setPCTVersion(this.ifPctVersion.getIntValue());
            }
            this.table.setIotCompress(this.ifIotCompress.getIntValue());
            this.table.setIotPctThreshold(this.ifIotPctThreshold.getIntValue());
            selected = this.cbIotIncluding.getSelectedItem();
            if (selected instanceof ColumnProxy) {
                this.table.setIotIncluding((ColumnProxy)selected);
            } else {
                this.table.setIotIncluding(null);
            }
            selected = this.cbIotOverflowTablespace.getSelectedItem();
            if (selected instanceof TableSpaceOraclev10g) {
                this.table.setIotOverflowTablespace((TableSpaceOraclev10g)selected);
            } else {
                this.table.setIotOverflowTablespace(null);
            }
            this.table.setIotOverflowLogging(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbIotOverflowLogging.getSelectedItem()));
            selected = this.cbIotOverflowSegment.getSelectedItem();
            if (selected instanceof SegmentOraclev10g) {
                this.table.setIotOverflowSegment((SegmentOraclev10g)selected);
            } else {
                this.table.setIotOverflowSegment(null);
            }
            this.table.setIOTMappingTable(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbIotMappingTable.getSelectedItem()));
            selected = this.cbSnapshot.getSelectedItem();
            if (selected instanceof SnapshotOracle) {
                this.table.setSnapshot((SnapshotOracle)selected);
            } else {
                this.table.setSnapshot(null);
            }
            Object[] supplementalColumnSet = this.selectedSupplementalColumnsModel.toArray();
            this.table.clearSuplementalLogColumns();
            for (int i = 0; i < supplementalColumnSet.length; ++i) {
                Object ob = supplementalColumnSet[i];
                if (!(ob instanceof ColumnProxy)) continue;
                this.table.setSuplementalLogColumns(((ColumnProxy)ob).getObjectID());
            }
            Object[] columnSet = this.selectedClusterColumnsModel.toArray();
            this.table.clear();
            for (int i = 0; i < columnSet.length; ++i) {
                Object ob = columnSet[i];
                if (!(ob instanceof ColumnProxy)) continue;
                this.table.setClusterColumns(((ColumnProxy)ob).getObjectID());
            }
            this.table.setSuplementalLogGroupName(this.tfSupplementalLogGroupName.getText());
            this.table.setSuplementalLogConditions((String)this.cbSupplementalLogCondition.getSelectedItem());
            this.partitionPropertyTab.setProperties(this.isPartitioned());
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equals(commentText)) {
                this.table.setComment(commentText);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            String taCommentsInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(taCommentsInRDBMSText) && !this.commentInRDBMS.equals(taCommentsInRDBMSText)) {
                this.table.setCommentInRDBMS(taCommentsInRDBMSText);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
        }
    }

    protected boolean isPartitioned() {
        return this.cbPartitioned.getSelectedItem().equals(YES);
    }

    protected boolean isIndexOrg() {
        return this.cbOrganization.getSelectedItem().equals("INDEX");
    }

    private void snapshotChanged() {
        boolean enable = this.cbSnapshot.getSelectedItem() == null;
        this.tfName.setEnabled(enable);
        this.cbUser.setEnabled(enable);
        this.cbTemporary.setEnabled(enable);
        this.cbTableSpace.setEnabled(enable);
        this.cbCluster.setEnabled(enable);
        this.cbLogging.setEnabled(enable);
        this.cbCache.setEnabled(enable);
        this.cbParallel.setEnabled(enable);
        this.ifDegree.setEnabled(enable);
        this.cbRowDependency.setEnabled(enable);
        this.cbPartRowMovement.setEnabled(enable);
        this.cbDataSegmentCompression.setEnabled(enable);
        this.bnPermissions.setEnabled(enable);
        try {
            this.getPane().setEnabledAt(1, enable);
            this.getPane().setEnabledAt(3, enable);
            this.getPane().setEnabledAt(4, enable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void postProcessingInApply() {
        if (this.partitionPropertyTab != null) {
            this.partitionPropertyTab.postProcessingInApply();
        }
    }

    @Override
    protected void clearOnDispose() {
        if (this.partitionPropertyTab != null) {
            this.partitionPropertyTab.clearOnDispose();
        }
    }

    private class RemoveSupplementalColumnsActionListener
    implements ActionListener {
        private RemoveSupplementalColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev10g.this.allSupplementalColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev10g.this.allSupplementalColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddSupplementalColumnsActionListener
    implements ActionListener {
        private AddSupplementalColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev10g.this.allSupplementalColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev10g.this.allSupplementalColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev10g.this.allSupplementalColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedListSupplementalSelectionHandler
    implements ListSelectionListener {
        private SelectedListSupplementalSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev10g.this.bnSupplementalRemove.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev10g.this.bnSupplementalRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSupplementalSelectionHandler
    implements ListSelectionListener {
        private AllListSupplementalSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev10g.this.allSupplementalColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev10g.this.bnSupplementalAdd.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev10g.this.bnSupplementalAdd.setEnabled(true);
                }
            }
        }
    }

    private class ParallelListener
    implements ActionListener {
        private ParallelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev10g.this.ifDegree.setEnabled(TablePropertyDialogOraclev10g.this.cbParallel.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }

    private class OrganizationListener
    implements ActionListener {
        private OrganizationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String organization = (String)TablePropertyDialogOraclev10g.this.cbOrganization.getSelectedItem();
            if (organization != null) {
                boolean indexOrg = organization.equalsIgnoreCase("INDEX");
                TablePropertyDialogOraclev10g.this.cbCache.setEnabled(!indexOrg);
                TablePropertyDialogOraclev10g.this.ifIotCompress.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.ifIotPctThreshold.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotIncluding.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotOverflowTablespace.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotOverflowLogging.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotOverflowSegment.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotMappingTable.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.partitionPropertyTab.enableRelevantPartitionFields(TablePropertyDialogOraclev10g.this.isPartitioned());
            }
        }
    }

    private class ClusterListener
    implements ActionListener {
        private ClusterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(true);
                TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(false);
                TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedIndex() != -1);
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class TemporaryListener
    implements ActionListener {
        private TemporaryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev10g.this.cbTemporary.getSelectedItem().equals(AbstractPropertyDialog.NO)) {
                TablePropertyDialogOraclev10g.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbCluster.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbPartitioned.setSelectedItem(AbstractPropertyDialog.NO);
                TablePropertyDialogOraclev10g.this.cbPartitioned.setEnabled(false);
                if (TablePropertyDialogOraclev10g.this.cbTemporaryTablespace != null) {
                    TablePropertyDialogOraclev10g.this.lbTableSpace.setVisible(false);
                    TablePropertyDialogOraclev10g.this.cbTableSpace.setVisible(false);
                    TablePropertyDialogOraclev10g.this.lbTemporaryTablespace.setVisible(true);
                    TablePropertyDialogOraclev10g.this.cbTemporaryTablespace.setVisible(true);
                } else {
                    TablePropertyDialogOraclev10g.this.cbTableSpace.setEnabled(false);
                }
                TablePropertyDialogOraclev10g.this.cbLogging.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(false);
                TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev10g.this.cbCluster.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbPartitioned.setEnabled(true);
                if (TablePropertyDialogOraclev10g.this.cbTemporaryTablespace != null) {
                    TablePropertyDialogOraclev10g.this.lbTemporaryTablespace.setVisible(false);
                    TablePropertyDialogOraclev10g.this.cbTemporaryTablespace.setVisible(false);
                    TablePropertyDialogOraclev10g.this.lbTableSpace.setVisible(true);
                    TablePropertyDialogOraclev10g.this.cbTableSpace.setVisible(true);
                }
                TablePropertyDialogOraclev10g.this.cbTableSpace.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbLogging.setEnabled(true);
                if (TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                    TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedIndex() != -1);
                    TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedIndex() != -1);
                }
            }
        }
    }

    private class RemoveClusterColumnsActionListener
    implements ActionListener {
        private RemoveClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev10g.this.allClusterColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev10g.this.allClusterColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddClusterColumnsActionListener
    implements ActionListener {
        private AddClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev10g.this.allClusterColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev10g.this.allClusterColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private SelectedClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class AllClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private AllClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class VersionListener
    implements ActionListener {
        private VersionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev10g.this.ifPctVersion.setEnabled(TablePropertyDialogOraclev10g.this.cbOldVersions.getSelectedItem().equals("PCT_VERSION"));
        }
    }

    private class StoreAsListener
    implements ActionListener {
        private StoreAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean objectRelational;
            if (TablePropertyDialogOraclev10g.this.cbAllowAnySchema != null && TablePropertyDialogOraclev10g.this.cbAllowNonSchema != null) {
                boolean binaryXml = TablePropertyDialogOraclev10g.this.cbStoreAs.getSelectedItem().equals("BINARY XML");
                TablePropertyDialogOraclev10g.this.cbAllowAnySchema.setEnabled(binaryXml);
                TablePropertyDialogOraclev10g.this.cbAllowNonSchema.setEnabled(binaryXml);
            }
            TablePropertyDialogOraclev10g.this.enableXMLTypeClobOptions(!(objectRelational = TablePropertyDialogOraclev10g.this.cbStoreAs.getSelectedItem().equals("OBJECT RELATIONAL")));
        }
    }

    private class PartitionedAction
    implements ActionListener {
        private PartitionedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean partitioned = TablePropertyDialogOraclev10g.this.isPartitioned();
            int partitionedTabIndex = TablePropertyDialogOraclev10g.this.getPane().indexOfComponent(TablePropertyDialogOraclev10g.this.partitioningTab);
            if (partitionedTabIndex > -1) {
                TablePropertyDialogOraclev10g.this.getPane().setEnabledAt(partitionedTabIndex, partitioned);
            }
            TablePropertyDialogOraclev10g.this.partitionPropertyTab.reinitPartitioning(partitioned);
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev10g.this.dialog = new ObjectPermissionsDialogOracle(TablePropertyDialogOraclev10g.this.getAppView(), TablePropertyDialogOraclev10g.this.getStorageDesign(), TablePropertyDialogOraclev10g.this.table);
            TablePropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }
}

