/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v11g;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.PartitionPropertyTabOraclev10g;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;

public class PartitionPropertyTabOraclev11g
extends PartitionPropertyTabOraclev10g {
    private JComboBox cbSubpartType;
    private JComboBox cbRefConstraint;
    private JPositiveIntegerField ifSystemPartitions;
    private JPanel intervalPanel;
    private int intervalTabIndex;
    private JTextArea taInterval;
    private JScrollPane spInterval;
    private JList allIntervalTSList;
    private JList selectedIntervalTSList;
    private DefaultListModel allIntervalTSModel;
    private DefaultListModel selectedIntervalTSModel;
    private JButton bnAddIntervalTS;
    private JButton bnRemoveIntervalTS;

    public PartitionPropertyTabOraclev11g(ApplicationView view, StorageDesign storageDesign, StorageObject ownerStorageObject, AbstractOraclePropertyDialog parentDialog) {
        super(view, storageDesign, ownerStorageObject, parentDialog);
    }

    @Override
    protected String[] getPartitionTypes() {
        return PartitionListOraclev11g.getPartitionTypes();
    }

    @Override
    protected void initGeneralPartitioning() {
        this.initPartType();
        this.initSubpartType(50);
        this.initUseSubpartitionsStorageTemplate(80);
        this.initHashPQuantity(110);
        this.initSubPartQuantity(140);
        this.initRefConstraint(170);
        this.initSystemPartitions(200);
        if (this.useColumnProxies) {
            this.initAllColumnsList(234, 290);
            this.initSelectedColumnsList(234, 290);
            this.initButtons();
        } else {
            this.initColumnsTextArea(230, 295);
        }
    }

    protected void initSubpartType(int yCoord) {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.SubpartitionType"));
        this.pnPartGeneral.add(label);
        this.cbSubpartType = new JComboBox<String>(PartitionListOraclev11g.getSubpartitionTypes());
        this.setBG(this.cbSubpartType);
        this.cbSubpartType.setPreferredSize(this.cbPartType.getPreferredSize());
        this.cbSubpartType.addActionListener(new SubpartitionTypeListener());
        this.pnPartGeneral.add(this.cbSubpartType);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, yCoord);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbSubpartType, yCoord);
    }

    private void initRefConstraint(int yCoord) {
        FKProxyOracle fkProxy;
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.ReferenceConstraint"));
        this.pnPartGeneral.add(label);
        Vector<FKProxyOracle> comboItems = new Vector<FKProxyOracle>();
        comboItems.add(null);
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            Iterator it = ((TableProxyOracle)this.ownerStorageObject).getFKeys().iterator();
            while (it.hasNext()) {
                TableProxyOracle remoteTableProxy;
                FKProxyOracle fKey = (FKProxyOracle)it.next();
                Table remoteTable = fKey.getFKTable();
                if (remoteTable == null || (remoteTableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(remoteTable.getObjectID())) == null || remoteTableProxy == this.ownerStorageObject || !remoteTableProxy.getPartitioned().equalsIgnoreCase(YES)) continue;
                comboItems.add(fKey);
            }
        }
        if (this.partList != null && (fkProxy = ((PartitionListOraclev11g)this.partList).getRefConstraint()) != null && !comboItems.contains(fkProxy)) {
            comboItems.add(fkProxy);
        }
        this.cbRefConstraint = new JComboBox(comboItems);
        this.setBG(this.cbRefConstraint);
        this.cbRefConstraint.setPreferredSize(this.cbPartType.getPreferredSize());
        this.pnPartGeneral.add(this.cbRefConstraint);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, yCoord);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbRefConstraint, yCoord);
    }

    private void initSystemPartitions(int yCoord) {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.SystemPartitions"));
        this.pnPartGeneral.add(label);
        this.ifSystemPartitions = new JPositiveIntegerField();
        this.ifSystemPartitions.setPreferredSize(this.cbPartType.getPreferredSize());
        this.pnPartGeneral.add(this.ifSystemPartitions);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, yCoord);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifSystemPartitions, yCoord);
    }

    @Override
    protected void addIntervalTab() {
        this.intervalPanel = new JPanel(new SpringLayout());
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev11g.RangeIntervalClause"), this.intervalPanel);
        this.intervalTabIndex = this.tpPartitions.indexOfComponent(this.intervalPanel);
        this.initIntervalExpression();
        this.initAllIntervalTSList();
        this.initSelectedIntervalTSList();
        this.initIntervalTSButtons();
    }

    protected SpringLayout getIntervalLayout() {
        return (SpringLayout)this.intervalPanel.getLayout();
    }

    private void initIntervalExpression() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.IntervalExpression"));
        this.intervalPanel.add(label);
        this.setLabelConstraints(this.getIntervalLayout(), label, 10, 15);
        this.taInterval = new JTextArea();
        this.spInterval = new JScrollPane(this.taInterval);
        this.spInterval.setPreferredSize(new Dimension(395, 200));
        this.spInterval.setBorder(BorderFactory.createEtchedBorder(0));
        this.taInterval.setLineWrap(true);
        this.intervalPanel.add(this.spInterval);
        this.setObjectConstraints(this.getIntervalLayout(), this.spInterval, 10, 35);
    }

    private void initAllIntervalTSList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllTableSpaces"));
        this.intervalPanel.add(label);
        this.allIntervalTSModel = new DefaultListModel();
        this.allIntervalTSList = new JList(this.allIntervalTSModel);
        ListSelectionModel listSelectionModel = this.allIntervalTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIntervalTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allIntervalTSList);
        sp.setPreferredSize(new Dimension(144, 230));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.intervalPanel.add(sp);
        this.setLabelConstraints(this.getIntervalLayout(), label, 8, 264);
        this.setObjectConstraints(this.getIntervalLayout(), sp, 6, 282);
    }

    private void initSelectedIntervalTSList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.IntervalTableSpaces"));
        this.intervalPanel.add(label);
        this.selectedIntervalTSModel = new DefaultListModel();
        this.selectedIntervalTSList = new JList(this.selectedIntervalTSModel);
        ListSelectionModel listSelectionModel = this.selectedIntervalTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIntervalTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedIntervalTSList);
        sp.setPreferredSize(new Dimension(145, 230));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.intervalPanel.add(sp);
        this.setLabelConstraints(this.getIntervalLayout(), label, 292, 264);
        this.setObjectConstraints(this.getIntervalLayout(), sp, 290, 282);
    }

    private void initIntervalTSButtons() {
        this.bnAddIntervalTS = new JButton(ADD_CAPTION);
        this.bnAddIntervalTS.addActionListener(new AddIntervalTSActionListener());
        this.bnAddIntervalTS.setEnabled(false);
        this.intervalPanel.add(this.bnAddIntervalTS);
        this.setObjectConstraints(this.getIntervalLayout(), this.bnAddIntervalTS, 175, 370);
        this.bnRemoveIntervalTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveIntervalTS.setEnabled(false);
        this.bnRemoveIntervalTS.addActionListener(new RemoveIntervalTSActionListener());
        this.intervalPanel.add(this.bnRemoveIntervalTS);
        this.setObjectConstraints(this.getIntervalLayout(), this.bnRemoveIntervalTS, 175, 400);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddIntervalTS, this.bnRemoveIntervalTS);
    }

    @Override
    protected void initProperties() {
        PartitionListOraclev11g partList = (PartitionListOraclev11g)this.partList;
        if (partList != null) {
            this.cbSubpartType.setSelectedItem(partList.getSubpartitionType());
            this.cbRefConstraint.setSelectedItem(partList.getRefConstraint());
            this.ifSystemPartitions.setValue((long)partList.getSystemPartitions());
            this.taInterval.setText(partList.getIntervalExpression());
        } else {
            this.cbRefConstraint.setSelectedItem(null);
            this.ifSystemPartitions.setValue(1L);
        }
        super.initProperties();
    }

    @Override
    protected void reinitPartitioning(boolean partitioned) {
        super.reinitPartitioning(partitioned);
        this.allIntervalTSModel.clear();
        this.selectedIntervalTSModel.clear();
        if (partitioned) {
            this.initIntervalTablespaces((PartitionListOraclev11g)this.partList);
        }
    }

    private void initIntervalTablespaces(PartitionListOraclev11g partList) {
        if (partList != null) {
            Iterator tsIt = partList.getIntervalTablespaceSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedIntervalTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedIntervalTSModel.contains(ts)) continue;
            this.allIntervalTSModel.addElement(ts);
        }
    }

    @Override
    protected void enableRelevantPartitionFields(boolean partitioned) {
        super.enableRelevantPartitionFields(partitioned);
        String partType = "";
        if (partitioned) {
            partType = (String)this.cbPartType.getSelectedItem();
        }
        this.cbSubpartType.setEnabled(partType.equals("RANGE") || partType.equals("LIST") || partType.startsWith("HASH"));
        this.cbRefConstraint.setEnabled(partType.equals("REFERENCE"));
        this.ifSystemPartitions.setEnabled(partType.equals("SYSTEM"));
        if (this.intervalTabIndex > -1) {
            this.tpPartitions.setEnabledAt(this.intervalTabIndex, partType.equals("RANGE"));
        }
    }

    @Override
    protected boolean isSubpartitioned(String partType) {
        return !this.cbSubpartType.getSelectedItem().equals("") && (partType.equals("RANGE") || partType.equals("LIST") || partType.startsWith("HASH"));
    }

    @Override
    protected boolean isHashSubpartitioned(String partType) {
        return this.cbSubpartType.getSelectedItem().equals("HASH") && this.isSubpartitioned(partType);
    }

    @Override
    protected boolean isListSubpartitioned(String partType) {
        return this.cbSubpartType.getSelectedItem().equals("LIST");
    }

    @Override
    protected void setProperties(boolean partitioned) {
        if (partitioned) {
            if (this.partList == null) {
                this.partList = (PartitionListOraclev11g)this.getStorageDesign().getPartitionListSet().createPartitionList();
            }
            PartitionListOraclev11g partList = (PartitionListOraclev11g)this.partList;
            String partitionType = (String)this.cbPartType.getSelectedItem();
            String subpartitionType = "";
            FKProxyOracle refConstraint = null;
            int systemPartitions = 1;
            String intervalExpression = "";
            partList.getIntervalTablespaceSet().clear();
            if (partitionType.equals("RANGE")) {
                intervalExpression = this.taInterval.getText();
                Object[] intervalTSSet = this.selectedIntervalTSModel.toArray();
                for (int i = 0; i < intervalTSSet.length; ++i) {
                    Object ts = intervalTSSet[i];
                    if (!(ts instanceof TableSpaceOracle)) continue;
                    partList.setIntervalTablespaceSet(((TableSpaceOracle)ts).getObjectID());
                }
                subpartitionType = (String)this.cbSubpartType.getSelectedItem();
            } else if (partitionType.equals("LIST") || partitionType.startsWith("HASH")) {
                subpartitionType = (String)this.cbSubpartType.getSelectedItem();
            } else if (partitionType.equals("REFERENCE")) {
                refConstraint = (FKProxyOracle)this.cbRefConstraint.getSelectedItem();
            } else if (partitionType.equals("SYSTEM")) {
                systemPartitions = this.ifSystemPartitions.getIntValue();
            }
            partList.setSubpartitionType(subpartitionType);
            partList.setRefConstraint(refConstraint);
            partList.setSystemPartitions(systemPartitions);
            partList.setIntervalExpression(intervalExpression);
        }
        super.setProperties(partitioned);
    }

    private class RemoveIntervalTSActionListener
    implements ActionListener {
        private RemoveIntervalTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev11g.this.selectedIntervalTSModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev11g.this.selectedIntervalTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev11g.this.allIntervalTSModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev11g.this.allIntervalTSModel.addElement(ob);
                    PartitionPropertyTabOraclev11g.this.selectedIntervalTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AddIntervalTSActionListener
    implements ActionListener {
        private AddIntervalTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev11g.this.allIntervalTSModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev11g.this.allIntervalTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev11g.this.selectedIntervalTSModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev11g.this.selectedIntervalTSModel.addElement(ob);
                    PartitionPropertyTabOraclev11g.this.allIntervalTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedIntervalTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIntervalTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev11g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev11g.this.selectedIntervalTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev11g.this.bnRemoveIntervalTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev11g.this.bnRemoveIntervalTS.setEnabled(true);
                }
            }
        }
    }

    private class AllIntervalTSListSelectionHandler
    implements ListSelectionListener {
        private AllIntervalTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev11g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev11g.this.allIntervalTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev11g.this.bnAddIntervalTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev11g.this.bnAddIntervalTS.setEnabled(true);
                }
            }
        }
    }

    private class SubpartitionTypeListener
    implements ActionListener {
        private SubpartitionTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PartitionPropertyTabOraclev11g.this.useColumnProxies) {
                PartitionPropertyTabOraclev11g.this.allSubPartColumnsList.getSelectionModel().clearSelection();
                String type = (String)PartitionPropertyTabOraclev11g.this.cbPartType.getSelectedItem();
                if (PartitionPropertyTabOraclev11g.this.isListSubpartitioned(type) && PartitionPropertyTabOraclev11g.this.selectedSubPartColumnsModel.toArray().length > 1) {
                    PartitionPropertyTabOraclev11g.this.allSubPartColumnsModel.clear();
                    PartitionPropertyTabOraclev11g.this.selectedSubPartColumnsModel.clear();
                    PartitionPropertyTabOraclev11g.this.initSubPartColumns(PartitionPropertyTabOraclev11g.this.partList);
                }
            }
            PartitionPropertyTabOraclev11g.this.enableRelevantPartitionFields(PartitionPropertyTabOraclev11g.this.isPartitioned());
        }
    }
}

