/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v12c;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.ColumnProxyOraclev12c;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.ColumnPropertyDialogOraclev11g;

public class ColumnPropertyDialogOraclev12c
extends ColumnPropertyDialogOraclev11g {
    private ColumnProxyOraclev12c column;
    private JComboBox cbDefaultOnNull;
    private JComboBox cbInvisible;
    private JComboBox cbAutoIncrementDDL;
    private static final String TRIGGER = Messages.getString("ColumnPropertyDialogOraclev12c.Trigger");
    private static final String DEFAULT_CLAUSE = Messages.getString("ColumnPropertyDialogOraclev12c.DEFAULTClause");
    private static final String IDENTITY_CLAUSE = Messages.getString("ColumnPropertyDialogOraclev12c.IDENTITYClause");
    private static final String[] AUTOINCREMENTDDL = new String[]{"", NONE, TRIGGER, DEFAULT_CLAUSE, IDENTITY_CLAUSE};

    public ColumnPropertyDialogOraclev12c(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.column = (ColumnProxyOraclev12c)object;
    }

    @Override
    protected int initDefaultOnNull(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev12c.DefaultOnNull"));
        this.general.add(label);
        this.cbDefaultOnNull = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDefaultOnNull);
        this.cbDefaultOnNull.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefaultOnNull);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbDefaultOnNull, yCoord);
        return 30;
    }

    @Override
    protected int initInvisible(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev12c.Invisible"));
        this.general.add(label);
        this.cbInvisible = new JComboBox<String>(YES_NO);
        this.setBG(this.cbInvisible);
        this.cbInvisible.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInvisible);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbInvisible, yCoord);
        return 30;
    }

    @Override
    protected int initAutoIncrementDDL(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev12c.AutoIncrementDDL"));
        this.autoIncrement.add(label);
        this.cbAutoIncrementDDL = new JComboBox<String>(AUTOINCREMENTDDL);
        this.setBG(this.cbAutoIncrementDDL);
        this.cbAutoIncrementDDL.setPreferredSize(this.tfName.getPreferredSize());
        this.autoIncrement.add(this.cbAutoIncrementDDL);
        this.setLabelConstraints(this.getAutoIncrementLayout(), label, yCoord);
        this.setObjectConstraints(this.getAutoIncrementLayout(), this.cbAutoIncrementDDL, yCoord);
        return yCoord + 30;
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.cbDefaultOnNull.setSelectedItem(ColumnPropertyDialogOraclev12c.translateYesNoForDisplay(this.column.getDefaultOnNull()));
        this.cbInvisible.setSelectedItem(ColumnPropertyDialogOraclev12c.translateYesNoForDisplay(this.column.getInvisible()));
        this.cbAutoIncrementDDL.setSelectedItem(this.translate(this.column.getAutoIncrementDDL(), ColumnProxyOraclev12c.getAutoIncrementDDLChoices(), AUTOINCREMENTDDL));
        Column relationalColumn = this.column.getColumn();
        this.cbAutoIncrementDDL.setEnabled(relationalColumn.isAutoIncrementColumn());
        if (!(relationalColumn.isIdentityColumn() && this.column.getDatatypeString().indexOf("CHAR") == -1 || this.cbAutoIncrementDDL.getSelectedItem().equals(IDENTITY_CLAUSE))) {
            this.cbAutoIncrementDDL.removeItem(IDENTITY_CLAUSE);
        }
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            super.setProperties();
            this.column.setDefaultOnNull(ColumnPropertyDialogOraclev12c.translateYesNoForStorage((String)this.cbDefaultOnNull.getSelectedItem()));
            this.column.setInvisible(ColumnPropertyDialogOraclev12c.translateYesNoForStorage((String)this.cbInvisible.getSelectedItem()));
            this.column.setAutoIncrementDDL(this.translate((String)this.cbAutoIncrementDDL.getSelectedItem(), AUTOINCREMENTDDL, ColumnProxyOraclev12c.getAutoIncrementDDLChoices()));
        }
    }
}

