/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.ColumnPropertyDialogOraclev11g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ColumnPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private ColumnProxyOraclev9i column;
    private JTextField tfDataType;
    private JTextField tfScope;
    private JTextField tfNullsAllowed;
    private JTextField tfCluster;
    private JIntegerField ifPosInCluster;
    private JTextField tfDefaultValue;
    private JComboBox cbWithRowId;
    private JComboBox cbSubstitutable;
    private JComboBox cbElementType;
    protected JPanel autoIncrement;
    private JComboBox cbAutoIncrementUser;
    protected JPanel xmlTypeOptions;
    private JTextField tfXmlSchemaUrl;
    private JTextField tfXmlSchemaElement;
    protected JComboBox cbAllowAnySchema;
    protected JComboBox cbAllowNonSchema;
    protected JComboBox cbStoreAs;
    protected JComboBox cbLobStorageType;
    private JTextField tfLobSegmentName;
    private JComboBox cbTableSpace;
    private JComboBox cbStorageInRow;
    private JComboBox cbLogging;
    private JComboBox cbCache;
    private JIntegerField ifChunk;
    private JComboBox cbOldVersions;
    private JIntegerField ifPctVersion;
    protected JPanel xmlTypeStorage;
    private JIntegerField ifSCInitialExtent;
    private JIntegerField ifSCNextExtent;
    private JIntegerField ifSCMinExtents;
    private JTextField tfSCMaxExtents;
    private JIntegerField ifSCPctIncrease;
    private JComboBox cbSCBufferPool;
    private JIntegerField ifSCFreeLists;
    private JIntegerField ifSCFreeListsGroups;
    private JIntegerField ifFreePools;
    private JPanel columnCheckOptions;
    private JTextField tfConstraintName;
    private JTextArea taConstraint;
    private JComboBox cbInitially;
    private JComboBox cbDeferrable;
    private JComboBox cbEnable;
    private JComboBox cbValidate;
    private JComboBox cbExTable;
    private String comment;
    private String commentInRDBMS;
    private JPanel vArrayAndNT;
    private JTextField tfNTStorageTable;
    private JComboBox cbNTReturn;
    private JTextField tfLobSegname;
    private JTextArea taAdditionalNTS;
    private String notNullConstraintName;
    private JComboBox cbNNCInitially;
    private JComboBox cbNNCDeferrable;
    private JComboBox cbNNCEnable;
    private JComboBox cbNNCValidate;
    private JComboBox cbNNCExTable;
    private JPanel generalNNC;
    private JTextField tfNNCName;

    public ColumnPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.column = (ColumnProxyOraclev9i)object;
    }

    @Override
    protected int getDialogWidth() {
        return 500;
    }

    public void init() {
        this.setHeight(580);
        this.initCommentsView(230);
        this.initCommentsInRDBMS(230);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    protected Integer getRDBMSType() {
        return 7;
    }

    @Override
    public String getCaption() {
        return Messages.getString("ColumnPropertyDialogOraclev9i.ColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataType();
        this.initScope();
        this.initNullsAllowed();
        this.initDefaultValue();
        int yCoord = 170;
        yCoord += this.initDefaultOnNull(yCoord);
        yCoord += this.initComputed(yCoord);
        yCoord += this.initColumnExpression(yCoord);
        yCoord += this.initInvisible(yCoord);
        this.initCluster(yCoord);
        this.initPosInCluster(yCoord += 30);
        this.initWithRowId(yCoord += 30);
        this.initSubstitutable(yCoord += 30);
        this.initElementType(yCoord += 30);
        yCoord += 30;
        yCoord += this.initEncrypt(yCoord);
    }

    private void initDataType() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.DataType"));
        this.general.add(label);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEnabled(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDataType, 50);
    }

    private void initScope() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Scope"));
        this.general.add(label);
        this.tfScope = new JTextField("", 26);
        this.tfScope.setEnabled(false);
        this.general.add(this.tfScope);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfScope, 80);
    }

    private void initNullsAllowed() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.NullsAllowed"));
        this.general.add(label);
        this.tfNullsAllowed = new JTextField("", 26);
        this.tfNullsAllowed.setEnabled(false);
        this.general.add(this.tfNullsAllowed);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfNullsAllowed, 110);
    }

    private void initDefaultValue() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.DefaultValue"));
        this.general.add(label);
        this.tfDefaultValue = new JTextField("", 26);
        this.general.add(this.tfDefaultValue);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfDefaultValue, 140);
    }

    protected int initDefaultOnNull(int yCoord) {
        return 0;
    }

    protected int initComputed(int yCoord) {
        return 0;
    }

    protected int initColumnExpression(int yCoord) {
        return 0;
    }

    protected int initInvisible(int yCoord) {
        return 0;
    }

    private void initCluster(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Cluster"));
        this.general.add(label);
        this.tfCluster = new JTextField("", 26);
        this.tfCluster.setEnabled(false);
        this.general.add(this.tfCluster);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.tfCluster, yCoord);
    }

    private void initPosInCluster(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.PositionInCluster"));
        this.general.add(label);
        this.ifPosInCluster = new JIntegerField(0, 26);
        this.ifPosInCluster.setEnabled(false);
        this.general.add(this.ifPosInCluster);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.ifPosInCluster, yCoord);
    }

    private void initWithRowId(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.WithROWID"));
        this.general.add(label);
        this.cbWithRowId = new JComboBox<String>(YES_NO);
        this.setBG(this.cbWithRowId);
        this.cbWithRowId.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbWithRowId);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbWithRowId, yCoord);
    }

    protected int initEncrypt(int yCoord) {
        return 0;
    }

    @Override
    protected void addTabs() {
        this.initAutoIncrementView();
        this.initNNC();
        this.initColumnCheckOptionsView();
        this.initXMLTypeOptionsView();
        this.initXMLTypeStorageView();
        this.initVarrayAndNTView();
    }

    private void initAutoIncrementView() {
        this.autoIncrement = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.AutoIncrement"), this.autoIncrement);
        int yCoord = this.initAutoIncrementDDL(20);
        this.initAutoIncrementUser(yCoord);
    }

    protected SpringLayout getAutoIncrementLayout() {
        return (SpringLayout)this.autoIncrement.getLayout();
    }

    private void initXMLTypeOptionsView() {
        this.xmlTypeOptions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.XMLTypeCLOBOptions"), this.xmlTypeOptions);
        this.initXMLTypeOptions();
    }

    protected SpringLayout getXmlTypeLayout() {
        return (SpringLayout)this.xmlTypeOptions.getLayout();
    }

    private void initXMLTypeOptions() {
        this.initXmlSchemaUrl(20);
        this.initXmlSchemaElement(50);
        int yCoord = this.initAllowAnySchema(80);
        yCoord = this.initAllowNonSchema(yCoord);
        yCoord = this.initStoreAs(yCoord);
        yCoord = this.initLobStorageType(yCoord);
        yCoord = this.initLobSegmentName(yCoord);
        yCoord = this.initTableSpace(yCoord);
        yCoord = this.initStorageInRow(yCoord);
        yCoord = this.initLogging(yCoord);
        yCoord = this.initCache(yCoord);
        yCoord = this.initChunk(yCoord);
        yCoord = this.initOldVersions(yCoord);
        this.initPctVersion(yCoord);
    }

    private void initXmlSchemaUrl(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.XMLSchemaURL"));
        this.xmlTypeOptions.add(label);
        this.tfXmlSchemaUrl = new JTextField("", 26);
        this.xmlTypeOptions.add(this.tfXmlSchemaUrl);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.tfXmlSchemaUrl, yCoord);
    }

    private void initXmlSchemaElement(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.XMLSchemaElem"));
        this.xmlTypeOptions.add(label);
        this.tfXmlSchemaElement = new JTextField("", 26);
        this.xmlTypeOptions.add(this.tfXmlSchemaElement);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.tfXmlSchemaElement, yCoord);
    }

    protected int initAllowAnySchema(int yCoord) {
        return yCoord;
    }

    protected int initAllowNonSchema(int yCoord) {
        return yCoord;
    }

    private int initStoreAs(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.StoreAs"));
        this.xmlTypeOptions.add(label);
        this.cbStoreAs = this.getStorageDesign() instanceof StorageDesignOraclev11g ? new JComboBox<String>(ColumnProxyOraclev11g.getStoreAsValues11g()) : new JComboBox<String>(ColumnProxyOraclev9i.getStoreAsValues());
        this.cbStoreAs.addActionListener(new StoreAsListener());
        this.setBG(this.cbStoreAs);
        this.cbStoreAs.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbStoreAs);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbStoreAs, yCoord);
        return yCoord + 30;
    }

    protected int initLobStorageType(int yCoord) {
        return yCoord;
    }

    private int initLobSegmentName(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.LobSegmentName"));
        this.xmlTypeOptions.add(label);
        this.tfLobSegmentName = new JTextField("", 26);
        this.xmlTypeOptions.add(this.tfLobSegmentName);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.tfLobSegmentName, yCoord);
        return yCoord + 30;
    }

    private int initTableSpace(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.TableSpace"));
        this.xmlTypeOptions.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbTableSpace);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbTableSpace, yCoord);
        return yCoord + 30;
    }

    private int initStorageInRow(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.StorageInRow"));
        this.xmlTypeOptions.add(label);
        this.cbStorageInRow = new JComboBox<String>(ColumnProxyOraclev9i.getStorageInRowValues());
        this.setBG(this.cbStorageInRow);
        this.cbStorageInRow.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbStorageInRow);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbStorageInRow, yCoord);
        return yCoord + 30;
    }

    private int initLogging(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Logging"));
        this.xmlTypeOptions.add(label);
        this.cbLogging = new JComboBox<String>(this instanceof ColumnPropertyDialogOraclev11g ? ColumnProxyOraclev11g.getLoggingChoices11g() : EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbLogging);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbLogging, yCoord);
        return yCoord + 30;
    }

    private int initCache(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Cache"));
        this.xmlTypeOptions.add(label);
        this.cbCache = new JComboBox<String>(ColumnProxyOraclev9i.getCacheValues());
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbCache);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbCache, yCoord);
        return yCoord + 30;
    }

    private int initChunk(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Chunk"));
        this.xmlTypeOptions.add(label);
        this.ifChunk = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifChunk);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifChunk, yCoord);
        return yCoord + 30;
    }

    private int initOldVersions(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.OldVersions"));
        this.xmlTypeOptions.add(label);
        this.cbOldVersions = new JComboBox<String>(ColumnProxyOraclev9i.getOldVersionChoices());
        this.cbOldVersions.addActionListener(new VersionListener());
        this.setBG(this.cbOldVersions);
        this.cbOldVersions.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbOldVersions);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbOldVersions, yCoord);
        return yCoord + 30;
    }

    private int initPctVersion(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.PCTVersion"));
        this.xmlTypeOptions.add(label);
        this.ifPctVersion = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifPctVersion);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifPctVersion, yCoord);
        return yCoord + 30;
    }

    private void initXMLTypeStorageView() {
        this.xmlTypeStorage = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.XMLTypeStorage"), this.xmlTypeStorage);
        this.initSCInitialExtent(20);
        this.initSCNextExtent(50);
        this.initSCMinExtents(80);
        this.initSCMaxExtents(110);
        this.initSCPctIncrease(140);
        this.initSCBufferPool(170);
        this.initSCFreeLists(200);
        this.initSCFreeListsGroups(230);
        this.initFreePools(260);
    }

    protected SpringLayout getXmlTypeStorageLayout() {
        return (SpringLayout)this.xmlTypeStorage.getLayout();
    }

    private void initFreePools(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.FreePools"));
        this.xmlTypeStorage.add(label);
        this.ifFreePools = new JIntegerField(0, 26);
        this.xmlTypeStorage.add(this.ifFreePools);
        this.setLabelConstraints(this.getXmlTypeStorageLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeStorageLayout(), this.ifFreePools, yCoord);
    }

    private void initSCInitialExtent(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCInitialExtent"));
        this.xmlTypeStorage.add(label);
        this.ifSCInitialExtent = new JIntegerField(0, 26);
        this.xmlTypeStorage.add(this.ifSCInitialExtent);
        this.setLabelConstraints(this.getXmlTypeStorageLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeStorageLayout(), this.ifSCInitialExtent, yCoord);
    }

    private void initSCNextExtent(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCNextExtent"));
        this.xmlTypeStorage.add(label);
        this.ifSCNextExtent = new JIntegerField(0, 26);
        this.xmlTypeStorage.add(this.ifSCNextExtent);
        this.setLabelConstraints(this.getXmlTypeStorageLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeStorageLayout(), this.ifSCNextExtent, yCoord);
    }

    private void initSCMinExtents(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCMinExtents"));
        this.xmlTypeStorage.add(label);
        this.ifSCMinExtents = new JIntegerField(0, 26);
        this.xmlTypeStorage.add(this.ifSCMinExtents);
        this.setLabelConstraints(this.getXmlTypeStorageLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeStorageLayout(), this.ifSCMinExtents, yCoord);
    }

    private void initSCMaxExtents(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCMaxExtents"));
        this.xmlTypeStorage.add(label);
        this.tfSCMaxExtents = new JTextField("UNLIMITED", 26);
        this.xmlTypeStorage.add(this.tfSCMaxExtents);
        this.setLabelConstraints(this.getXmlTypeStorageLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeStorageLayout(), this.tfSCMaxExtents, yCoord);
    }

    private void initSCPctIncrease(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCPCTIncrease"));
        this.xmlTypeStorage.add(label);
        this.ifSCPctIncrease = new JIntegerField(0, 26);
        this.xmlTypeStorage.add(this.ifSCPctIncrease);
        this.setLabelConstraints(this.getXmlTypeStorageLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeStorageLayout(), this.ifSCPctIncrease, yCoord);
    }

    private void initSCBufferPool(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCBufferPool"));
        this.xmlTypeStorage.add(label);
        this.cbSCBufferPool = new JComboBox<String>(ColumnProxyOraclev9i.getSCBufferPoolValues());
        this.setBG(this.cbSCBufferPool);
        this.cbSCBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeStorage.add(this.cbSCBufferPool);
        this.setLabelConstraints(this.getXmlTypeStorageLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeStorageLayout(), this.cbSCBufferPool, yCoord);
    }

    private void initSCFreeLists(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCFreeLists"));
        this.xmlTypeStorage.add(label);
        this.ifSCFreeLists = new JIntegerField(0, 26);
        this.xmlTypeStorage.add(this.ifSCFreeLists);
        this.setLabelConstraints(this.getXmlTypeStorageLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeStorageLayout(), this.ifSCFreeLists, yCoord);
    }

    private void initSCFreeListsGroups(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCFreeListsGrps"));
        this.xmlTypeStorage.add(label);
        this.ifSCFreeListsGroups = new JIntegerField(0, 26);
        this.xmlTypeStorage.add(this.ifSCFreeListsGroups);
        this.setLabelConstraints(this.getXmlTypeStorageLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeStorageLayout(), this.ifSCFreeListsGroups, yCoord);
    }

    private void enableXMLTypeClobOptions(boolean enable) {
        if (this.getStorageDesign() instanceof StorageDesignOraclev11g) {
            this.cbLobStorageType.setEnabled(enable);
            boolean binaryXml = this.cbStoreAs.getSelectedItem().equals("BINARY XML");
            this.cbAllowAnySchema.setEnabled(binaryXml);
            this.cbAllowNonSchema.setEnabled(binaryXml);
        }
        this.tfLobSegmentName.setEnabled(enable);
        this.cbTableSpace.setEnabled(enable);
        this.cbStorageInRow.setEnabled(enable);
        this.cbLogging.setEnabled(enable);
        this.cbCache.setEnabled(enable);
        this.ifChunk.setEnabled(enable);
        this.cbOldVersions.setEnabled(enable);
        this.ifPctVersion.setEnabled(enable);
        JTabbedPane pane = this.getPane();
        int xmlTypeStorageTabIndex = pane.indexOfComponent(this.xmlTypeStorage);
        if (xmlTypeStorageTabIndex > -1) {
            pane.setEnabledAt(xmlTypeStorageTabIndex, enable);
        }
    }

    private void enableXMLTypeTabs(boolean enable) {
        int xmlTypeStorageTabIndex;
        JTabbedPane pane = this.getPane();
        int xmlTypeOptionsTabIndex = pane.indexOfComponent(this.xmlTypeOptions);
        if (xmlTypeOptionsTabIndex > -1) {
            pane.setEnabledAt(xmlTypeOptionsTabIndex, enable);
        }
        if ((xmlTypeStorageTabIndex = pane.indexOfComponent(this.xmlTypeStorage)) > -1) {
            pane.setEnabledAt(xmlTypeStorageTabIndex, enable);
        }
    }

    private void initVarrayAndNTView() {
        this.vArrayAndNT = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.VarrayAndNestedTable"), this.vArrayAndNT);
        this.initVarrayAndNT();
    }

    private void initVarrayAndNT() {
        this.initNTStorageTable();
        this.initNTReturn();
        this.initLOBSegname();
        this.initAdditionalNTS();
    }

    private void initNTStorageTable() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.NTStorageTable"));
        this.vArrayAndNT.add(label);
        this.tfNTStorageTable = new JTextField(26);
        this.vArrayAndNT.add(this.tfNTStorageTable);
        this.tfNTStorageTable.setEnabled(true);
        this.setLabelConstraints(this.getVarrayAndNTLayout(), label, 20);
        this.setObjectConstraints(this.getVarrayAndNTLayout(), this.tfNTStorageTable, 20);
    }

    private void initNTReturn() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.NTReturnAS"));
        this.vArrayAndNT.add(label);
        this.cbNTReturn = new JComboBox<String>(ColumnProxyOraclev9i.getReturnAsValues());
        this.setBG(this.cbNTReturn);
        this.cbNTReturn.setPreferredSize(this.tfName.getPreferredSize());
        this.vArrayAndNT.add(this.cbNTReturn);
        this.setLabelConstraints(this.getVarrayAndNTLayout(), label, 50);
        this.setObjectConstraints(this.getVarrayAndNTLayout(), this.cbNTReturn, 50);
    }

    private void initLOBSegname() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.LOBSegname"));
        this.vArrayAndNT.add(label);
        this.tfLobSegname = new JTextField(26);
        this.vArrayAndNT.add(this.tfLobSegname);
        this.tfLobSegname.setEnabled(true);
        this.setLabelConstraints(this.getVarrayAndNTLayout(), label, 80);
        this.setObjectConstraints(this.getVarrayAndNTLayout(), this.tfLobSegname, 80);
    }

    private void initAdditionalNTS() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.AdditionalNestedTableSettings"));
        this.vArrayAndNT.add(label);
        this.taAdditionalNTS = new JTextArea();
        JScrollPane sp = new JScrollPane(this.taAdditionalNTS);
        sp.setPreferredSize(new Dimension(395, 100));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.taAdditionalNTS.setLineWrap(true);
        this.taAdditionalNTS.setEnabled(true);
        this.vArrayAndNT.add(sp);
        this.setLabelConstraints(this.getVarrayAndNTLayout(), label, 110);
        this.setObjectConstraints(this.getVarrayAndNTLayout(), sp, 10, 130);
    }

    protected SpringLayout getVarrayAndNTLayout() {
        return (SpringLayout)this.vArrayAndNT.getLayout();
    }

    protected SpringLayout getColumnCheckOptionsLayout() {
        return (SpringLayout)this.columnCheckOptions.getLayout();
    }

    private void initColumnCheckOptionsView() {
        this.columnCheckOptions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.ColumnCheckOptions"), this.columnCheckOptions);
        this.initColumnCheckOptions();
    }

    private void initColumnCheckOptions() {
        this.initConstraintName();
        this.initConstraint();
        this.initInitially();
        this.initDeferrable();
        this.initEnable();
        this.initValidate();
        this.initExTable();
    }

    private void initConstraintName() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ConstraintName"));
        this.columnCheckOptions.add(label);
        this.tfConstraintName = new JTextField(26);
        this.columnCheckOptions.add(this.tfConstraintName);
        this.tfConstraintName.setEnabled(false);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), label, 20);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.tfConstraintName, 20);
    }

    private void initConstraint() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Constraint"));
        this.columnCheckOptions.add(label);
        this.taConstraint = new JTextArea();
        JScrollPane sp = new JScrollPane(this.taConstraint);
        sp.setPreferredSize(new Dimension(395, 80));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.taConstraint.setLineWrap(true);
        this.taConstraint.setEnabled(false);
        this.columnCheckOptions.add(sp);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), label, 50);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), sp, 10, 70);
    }

    private void initInitially() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Initially"));
        this.columnCheckOptions.add(label);
        this.cbInitially = new JComboBox<String>(NotNullConstraintOracle.getInitiallyChoices());
        this.setBG(this.cbInitially);
        this.cbInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbInitially);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), label, 170);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbInitially, 170);
    }

    private void initDeferrable() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Deferrable"));
        this.columnCheckOptions.add(label);
        this.cbDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeferrable);
        this.cbDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbDeferrable);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), label, 200);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbDeferrable, 200);
    }

    private void initEnable() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Enable"));
        this.columnCheckOptions.add(label);
        this.cbEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEnable);
        this.cbEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbEnable);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), label, 230);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbEnable, 230);
    }

    private void initValidate() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Validate"));
        this.columnCheckOptions.add(label);
        this.cbValidate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbValidate);
        this.cbValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbValidate);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), label, 260);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbValidate, 260);
    }

    private void initExTable() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ExceptionsTable"));
        this.columnCheckOptions.add(label);
        this.cbExTable = new JComboBox();
        this.setBG(this.cbExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().getElements().toArray(), this.cbExTable);
        }
        this.cbExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbExTable);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), label, 290);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbExTable, 290);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.column.getName());
        Column columnObject = this.column.getColumn();
        if (columnObject.getContainer().isBST() || columnObject.isNested()) {
            this.tfName.setEnabled(false);
        }
        this.notNullConstraintName = columnObject.getNotNullConstraintName();
        if (this.column.isNotNullConstraintNameChanged()) {
            this.tfNNCName.setText(this.column.getNncName());
        } else {
            this.tfNNCName.setText(this.notNullConstraintName);
        }
        this.cbNNCInitially.setSelectedItem(this.column.getNncInitially());
        this.cbNNCDeferrable.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getNncDeferrable()));
        this.cbNNCEnable.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getNncEnable()));
        this.cbNNCValidate.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getNncValidate()));
        this.cbNNCExTable.setSelectedItem(this.column.getNncExceptionsTable());
        this.tfName.setText(this.column.getName());
        this.tfDataType.setText(this.column.getDatatypeString());
        if (columnObject.getScope() == null) {
            this.tfScope.setText("");
        } else {
            this.tfScope.setText(columnObject.getScope().getName());
        }
        this.tfNullsAllowed.setText(this.column.getNullsAllowed() ? YES : NO);
        this.tfDefaultValue.setText(this.column.getDefaultValue());
        this.tfCluster.setText(this.column.getCluster());
        this.ifPosInCluster.setValue((long)this.column.getPositionInCluster());
        this.cbWithRowId.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getWithRowId()));
        this.cbWithRowId.setEnabled(columnObject.isReference());
        if (this.column.getDataType().toString().equals("XMLTYPE")) {
            this.cbStoreAs.setSelectedItem(this.column.getStoreAs());
            this.tfLobSegmentName.setText(this.column.getLobSegmentName());
            this.tfXmlSchemaUrl.setText(this.column.getXmlSchemaUrl());
            this.tfXmlSchemaElement.setText(this.column.getXmlSchemaElement());
            this.selectObject(this.cbTableSpace, this.column.getTablespace());
            this.cbStorageInRow.setSelectedItem(this.column.getStorageInRow());
            this.cbLogging.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getLogging()));
            this.cbCache.setSelectedItem(this.column.getCache());
            this.ifChunk.setValue((long)this.column.getChunk());
            this.cbOldVersions.setSelectedItem(this.column.getOldVersions());
            this.ifPctVersion.setValue((long)this.column.getPCTVersion());
            this.ifSCInitialExtent.setValue(this.column.getSCInitialExtent());
            this.ifSCNextExtent.setValue(this.column.getSCNextExtent());
            this.ifSCMinExtents.setValue((long)this.column.getSCMinExtents());
            this.tfSCMaxExtents.setText(this.column.getSCMaxExtents());
            this.ifSCPctIncrease.setValue((long)this.column.getSCPctIncrease());
            this.cbSCBufferPool.setSelectedItem(this.column.getSCBufferPool());
            this.ifSCFreeLists.setValue((long)this.column.getSCFreeLists());
            this.ifSCFreeListsGroups.setValue((long)this.column.getSCFreelistGroups());
            this.ifFreePools.setValue((long)this.column.getFreepools());
        } else {
            this.enableXMLTypeTabs(false);
        }
        this.tfConstraintName.setText(columnObject.getConstraintName());
        this.taConstraint.setText(columnObject.getConstraintsText(this.column.getName()));
        this.cbInitially.setSelectedItem(this.column.getInitially());
        this.cbDeferrable.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getDeferrable()));
        this.cbEnable.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getEnable()));
        this.cbValidate.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getValidate()));
        this.cbExTable.setSelectedItem(this.column.getExceptionsTable());
        this.tfNTStorageTable.setText(this.column.getNtStorageTable());
        this.cbNTReturn.setSelectedItem(this.column.getNtReturn());
        this.tfLobSegname.setText(this.column.getLobSegname());
        this.taAdditionalNTS.setText(this.column.getAdditionalNTS());
        this.cbSubstitutable.setSelectedItem(this.column.getSubtitutable());
        this.cbElementType.setSelectedItem(this.column.getElementType());
        this.cbAutoIncrementUser.setSelectedItem(this.column.getAutoIncrementUser());
        this.cbAutoIncrementUser.setEnabled(columnObject.isAutoIncrementColumn());
        this.comment = columnObject.getComment();
        this.commentInRDBMS = columnObject.getCommentInRDBMS();
        if (this.column.isCommentChanged()) {
            this.getCommentsList().insert(this.column.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.column.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.column.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        Datatype dt = columnObject.getDataType();
        this.setTabVarrayAndNTVisible(dt instanceof CollectionType);
        if ((dt instanceof StructuredType || dt instanceof CollectionType) && columnObject.isAllowSubtypeSubstitution()) {
            if (dt instanceof CollectionType) {
                this.cbSubstitutable.removeItemAt(3);
            }
        } else {
            this.cbSubstitutable.setEnabled(false);
        }
    }

    private void setTabVarrayAndNTVisible(boolean isVisible) {
        int indtab = this.getPane().indexOfComponent(this.vArrayAndNT);
        if (indtab > -1) {
            this.getPane().setEnabledAt(indtab, isVisible);
        }
    }

    private void initSubstitutable(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Substitutable"));
        label.setToolTipText(Messages.getString("ColumnPropertyDialogOraclev9i.SubstitutionForVARRAYAndNestedTable"));
        this.general.add(label);
        this.cbSubstitutable = new JComboBox<String>(ColumnProxyOraclev9i.getSubstitutableValues());
        this.cbSubstitutable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Datatype dt = ((Column)ColumnPropertyDialogOraclev9i.this.column.getObject()).getDataType();
                if (ColumnPropertyDialogOraclev9i.this.cbSubstitutable.getSelectedItem().equals("ONLY FOR TYPE")) {
                    ColumnPropertyDialogOraclev9i.this.cbElementType.removeAllItems();
                    ColumnPropertyDialogOraclev9i.this.cbElementType.setEnabled(true);
                    List listInheritor = ColumnPropertyDialogOraclev9i.this.getListInheritans(dt);
                    Iterator it = listInheritor.iterator();
                    while (it.hasNext()) {
                        ColumnPropertyDialogOraclev9i.this.cbElementType.addItem(it.next().toString());
                    }
                } else {
                    ColumnPropertyDialogOraclev9i.this.cbElementType.removeAllItems();
                    ColumnPropertyDialogOraclev9i.this.cbElementType.setEnabled(false);
                    ColumnPropertyDialogOraclev9i.this.cbElementType.addItem(dt.toString());
                }
            }
        });
        this.setBG(this.cbSubstitutable);
        this.cbSubstitutable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbSubstitutable.setToolTipText(Messages.getString("ColumnPropertyDialogOraclev9i.SubstitutionForVARRAYAndNestedTable"));
        this.general.add(this.cbSubstitutable);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbSubstitutable, yCoord);
    }

    private List getListInheritans(Datatype dt) {
        CollectionType ct;
        ArrayList listInheritor = new ArrayList();
        if (dt instanceof CollectionType && (ct = (CollectionType)dt).getDataType() instanceof StructuredType) {
            listInheritor.addAll(((StructuredType)ct.getDataType()).getAllInstantiableSubTypes(true));
        }
        if (dt instanceof StructuredType) {
            listInheritor.addAll(((StructuredType)dt).getAllInstantiableSubTypes(true));
        }
        return listInheritor;
    }

    private void initElementType(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ElementType"));
        this.general.add(label);
        this.cbElementType = new JComboBox();
        this.setBG(this.cbElementType);
        this.cbElementType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbElementType.setEnabled(false);
        this.general.add(this.cbElementType);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbElementType, yCoord);
    }

    protected int initAutoIncrementDDL(int yCoord) {
        return yCoord;
    }

    private void initAutoIncrementUser(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.AutoIncrementUser"));
        String tooltipText = Messages.getString("ColumnPropertyDialogOraclev9i.AutoIncrementUserTooltip");
        label.setToolTipText(tooltipText);
        this.autoIncrement.add(label);
        this.cbAutoIncrementUser = new JComboBox();
        this.setBG(this.cbAutoIncrementUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbAutoIncrementUser);
        }
        this.cbAutoIncrementUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbAutoIncrementUser.setToolTipText(tooltipText);
        this.cbAutoIncrementUser.setPreferredSize(this.tfName.getPreferredSize());
        this.autoIncrement.add(this.cbAutoIncrementUser);
        this.setLabelConstraints(this.getAutoIncrementLayout(), label, yCoord);
        this.setObjectConstraints(this.getAutoIncrementLayout(), this.cbAutoIncrementUser, yCoord);
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            this.column.setName(this.tfName.getText());
            this.column.setDefaultValue(this.tfDefaultValue.getText());
            this.column.setWithRowId(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbWithRowId.getSelectedItem()));
            JTabbedPane pane = this.getPane();
            int xmlTypeOptionsTabIndex = pane.indexOfComponent(this.xmlTypeOptions);
            if (xmlTypeOptionsTabIndex > -1 && pane.isEnabledAt(xmlTypeOptionsTabIndex)) {
                String storeAs = (String)this.cbStoreAs.getSelectedItem();
                this.column.setStoreAs(storeAs);
                this.column.setLobSegmentName(this.tfLobSegmentName.getText());
                this.column.setXmlSchemaUrl(this.tfXmlSchemaUrl.getText());
                this.column.setXmlSchemaElement(this.tfXmlSchemaElement.getText());
                if (!storeAs.equalsIgnoreCase("OBJECT RELATIONAL")) {
                    Object selected = this.cbTableSpace.getSelectedItem();
                    if (selected instanceof TableSpaceOraclev9i) {
                        this.column.setTablespace((TableSpaceOraclev9i)selected);
                    } else {
                        this.column.setTablespace(null);
                    }
                    this.column.setStorageInRow((String)this.cbStorageInRow.getSelectedItem());
                    this.column.setLogging(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
                    this.column.setCache((String)this.cbCache.getSelectedItem());
                    this.column.setChunk(this.ifChunk.getIntValue());
                    this.column.setOldVersions((String)this.cbOldVersions.getSelectedItem());
                    this.column.setPCTVersion(this.ifPctVersion.getIntValue());
                    this.column.setSCInitialExtent(this.ifSCInitialExtent.getIntValue());
                    this.column.setSCNextExtent(this.ifSCNextExtent.getIntValue());
                    this.column.setSCMinExtents(this.ifSCMinExtents.getIntValue());
                    this.column.setSCMaxExtents(this.tfSCMaxExtents.getText());
                    this.tfSCMaxExtents.setText(this.column.getSCMaxExtents());
                    this.column.setSCPctIncrease(this.ifSCPctIncrease.getIntValue());
                    this.column.setSCBufferPool((String)this.cbSCBufferPool.getSelectedItem());
                    this.column.setSCFreeLists(this.ifSCFreeLists.getIntValue());
                    this.column.setSCFreelistGroups(this.ifSCFreeListsGroups.getIntValue());
                    this.column.setFreepools(this.ifFreePools.getIntValue());
                }
            }
            this.column.setInitially((String)this.cbInitially.getSelectedItem());
            this.column.setDeferrable(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDeferrable.getSelectedItem()));
            this.column.setEnable(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbEnable.getSelectedItem()));
            this.column.setValidate(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbValidate.getSelectedItem()));
            Object selected = this.cbExTable.getSelectedItem();
            if (selected instanceof TableProxyOracle) {
                this.column.setExceptionsTable((TableProxyOracle)selected);
            } else {
                this.column.setExceptionsTable(null);
            }
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equals(commentText)) {
                this.column.setComment(commentText);
                this.column.setCommentChanged(true);
            } else {
                this.column.setComment("");
                this.column.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equals(commentInRDBMSText)) {
                this.column.setCommentInRDBMS(commentInRDBMSText);
                this.column.setCommentInRDBMSChanged(true);
            } else {
                this.column.setCommentInRDBMS("");
                this.column.setCommentInRDBMSChanged(false);
            }
            this.column.setNtStorageTable(this.tfNTStorageTable.getText());
            this.column.setNtReturn((String)this.cbNTReturn.getSelectedItem());
            this.column.setLobSegname(this.tfLobSegname.getText());
            this.column.setAdditionalNTS(this.taAdditionalNTS.getText());
            this.column.setSubtitutable((String)this.cbSubstitutable.getSelectedItem());
            this.column.setElementType((String)this.cbElementType.getSelectedItem());
            this.column.setAutoIncrementUser((UserOracle)this.cbAutoIncrementUser.getSelectedItem());
            if (!this.tfNNCName.getText().equals(this.notNullConstraintName)) {
                this.column.setNncName(this.tfNNCName.getText());
                this.column.setNotNullConstraintNameChanged(true);
            } else {
                this.column.setNotNullConstraintNameChanged(false);
            }
            this.column.setNncInitially((String)this.cbNNCInitially.getSelectedItem());
            this.column.setNncDeferrable(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbNNCDeferrable.getSelectedItem()));
            this.column.setNncEnable(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbNNCEnable.getSelectedItem()));
            this.column.setNncValidate(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbNNCValidate.getSelectedItem()));
            Object exttab = this.cbNNCExTable.getSelectedItem();
            if (exttab instanceof TableProxyOracle) {
                this.column.setNncExceptionsTable((TableProxyOracle)exttab);
            } else {
                this.column.setNncExceptionsTable(null);
            }
        }
    }

    private void initNNC() {
        this.generalNNC = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.ColumnNotNullConstraint"), this.generalNNC);
        this.initNNCName();
        this.initNNCInitially();
        this.initNNCDeferrable();
        this.initNNCEnable();
        this.initNNCValidate();
        this.initNNCExTable();
    }

    private void initNNCName() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ConstraintName"));
        this.generalNNC.add(label);
        this.tfNNCName = new JTextField("", 26);
        this.generalNNC.add(this.tfNNCName);
        this.setLabelConstraints(this.getNNCTypeLayout(), label, 20);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.tfNNCName, 20);
    }

    private void initNNCInitially() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Initially"));
        this.generalNNC.add(label);
        this.cbNNCInitially = new JComboBox<String>(NotNullConstraintOracle.getInitiallyChoices());
        this.setBG(this.cbNNCInitially);
        this.cbNNCInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCInitially);
        this.setLabelConstraints(this.getNNCTypeLayout(), label, 50);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCInitially, 50);
    }

    private void initNNCDeferrable() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Deferrable"));
        this.generalNNC.add(label);
        this.cbNNCDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNNCDeferrable);
        this.cbNNCDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCDeferrable);
        this.setLabelConstraints(this.getNNCTypeLayout(), label, 80);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCDeferrable, 80);
    }

    private void initNNCEnable() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Enable"));
        this.generalNNC.add(label);
        this.cbNNCEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNNCEnable);
        this.cbNNCEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCEnable);
        this.setLabelConstraints(this.getNNCTypeLayout(), label, 110);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCEnable, 110);
    }

    private void initNNCValidate() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Validate"));
        this.generalNNC.add(label);
        this.cbNNCValidate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNNCValidate);
        this.cbNNCValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCValidate);
        this.setLabelConstraints(this.getNNCTypeLayout(), label, 140);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCValidate, 140);
    }

    private void initNNCExTable() {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ExceptionsTable"));
        this.generalNNC.add(label);
        this.cbNNCExTable = new JComboBox();
        this.setBG(this.cbNNCExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().getElements().toArray(), this.cbNNCExTable);
        }
        this.cbNNCExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCExTable);
        this.setLabelConstraints(this.getNNCTypeLayout(), label, 170);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCExTable, 170);
    }

    private SpringLayout getNNCTypeLayout() {
        return (SpringLayout)this.generalNNC.getLayout();
    }

    private class StoreAsListener
    implements ActionListener {
        private StoreAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean objectRelational = ColumnPropertyDialogOraclev9i.this.cbStoreAs.getSelectedItem().equals("OBJECT RELATIONAL");
            ColumnPropertyDialogOraclev9i.this.enableXMLTypeClobOptions(!objectRelational);
            ColumnPropertyDialogOraclev9i.this.tfLobSegmentName.setEnabled(!objectRelational);
            if (ColumnPropertyDialogOraclev9i.this.getStorageDesign() instanceof StorageDesignOraclev11g) {
                ColumnPropertyDialogOraclev9i.this.cbLobStorageType.setEnabled(!objectRelational);
                boolean binaryXml = ColumnPropertyDialogOraclev9i.this.cbStoreAs.getSelectedItem().equals("BINARY XML");
                ColumnPropertyDialogOraclev9i.this.cbAllowAnySchema.setEnabled(binaryXml);
                ColumnPropertyDialogOraclev9i.this.cbAllowNonSchema.setEnabled(binaryXml);
            }
        }
    }

    private class VersionListener
    implements ActionListener {
        private VersionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)ColumnPropertyDialogOraclev9i.this.cbOldVersions.getSelectedItem()).equalsIgnoreCase(ColumnProxyOraclev9i.getOldVersionChoices()[0])) {
                ColumnPropertyDialogOraclev9i.this.ifPctVersion.setEnabled(false);
            } else {
                ColumnPropertyDialogOraclev9i.this.ifPctVersion.setEnabled(true);
            }
        }
    }
}

