/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;

public class DataFilePropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private DataFileOracle datafile;
    private JTextField tfFileName;
    private JPositiveIntegerField ifSize;
    private JComboBox cbMeasureUnit;
    private JComboBox cbReuse;
    private JComboBox cbAutoextend;
    private JPositiveIntegerField ifNextBlockSize;
    private JTextField tfMaxSise;

    public DataFilePropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.datafile = (DataFileOracle)object;
        this.setHeight(260);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DataFilePropertyDialogOraclev9i.DataFileProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initFileName();
        this.initSize();
        this.initResuse();
        this.initAutoextend();
        this.initNextBlockSize();
        this.initMaxSize();
    }

    private void initFileName() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogOraclev9i.FileName"));
        this.general.add(label);
        this.tfFileName = new JTextField("", 26);
        this.general.add(this.tfFileName);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfFileName, 50);
    }

    private void initSize() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogOraclev9i.Size"));
        this.general.add(label);
        this.ifSize = new JPositiveIntegerField(0, 16);
        this.general.add(this.ifSize);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifSize, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.cbMeasureUnit = new JComboBox<Object>(DataFileOracle.getMeasureUnitValues().toArray());
        this.general.add(this.cbMeasureUnit);
        this.cbMeasureUnit.setPreferredSize(new Dimension(50, this.tfName.getPreferredSize().height));
        this.setObjectConstraints(this.cbMeasureUnit, 80);
    }

    private void initResuse() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogOraclev9i.Reuse"));
        this.general.add(label);
        this.cbReuse = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReuse);
        this.cbReuse.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReuse);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbReuse, 110);
    }

    private void initAutoextend() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogOraclev9i.Autoextend"));
        this.general.add(label);
        this.cbAutoextend = new JComboBox<String>(DataFileOracle.getSwitchChoices());
        this.setBG(this.cbAutoextend);
        this.cbAutoextend.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoextend);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbAutoextend, 140);
    }

    private void initNextBlockSize() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogOraclev9i.NextBlockSize"));
        this.general.add(label);
        this.ifNextBlockSize = new JPositiveIntegerField(0, 26);
        this.general.add(this.ifNextBlockSize);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifNextBlockSize, 170);
    }

    private void initMaxSize() {
        JLabel label = new JLabel(Messages.getString("DataFilePropertyDialogOraclev9i.MaxSize"));
        this.general.add(label);
        this.tfMaxSise = new JTextField("UNLIMITED", 26);
        this.general.add(this.tfMaxSise);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfMaxSise, 200);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.datafile.getName());
        this.tfName.setText(this.datafile.getName());
        this.tfFileName.setText(this.datafile.getFileName());
        this.ifSize.setValue(this.datafile.getSize());
        this.cbMeasureUnit.setSelectedItem(this.datafile.getMeasureUnit());
        this.cbReuse.setSelectedItem(DataFilePropertyDialogOraclev9i.translateYesNoForDisplay(this.datafile.getReuse()));
        this.cbAutoextend.setSelectedItem(this.datafile.getAutoextend());
        this.ifNextBlockSize.setValue((long)this.datafile.getNextBlockSize());
        this.tfMaxSise.setText(this.datafile.getMaxSize());
        this.getCommentsList().insert(this.datafile.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.datafile != null) {
            this.datafile.setName(this.tfName.getText());
            this.datafile.setFileName(this.tfFileName.getText());
            this.datafile.setSize(this.ifSize.getIntValue());
            this.datafile.setMeasureUnit((String)this.cbMeasureUnit.getSelectedItem());
            this.datafile.setReuse(DataFilePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbReuse.getSelectedItem()));
            this.datafile.setAutoextend((String)this.cbAutoextend.getSelectedItem());
            this.datafile.setNextBlockSize(this.ifNextBlockSize.getIntValue());
            this.datafile.setMaxSize(this.tfMaxSise.getText());
            this.tfMaxSise.setText(this.datafile.getMaxSize());
            this.datafile.setComment(this.getCommentsList().getText());
        }
    }
}

