/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.LocalIndexPropertyDialogOraclev9i;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ListStorageTemplatePartitionPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private ListStorageTemplatePartitionOraclev9i template;
    private JTextField tfValueList;
    private JComboBox cbTableSpace;
    private JList list;
    private JPanel indexesButtonPanel;
    private DefaultListModel listModel;
    private JButton edit;

    public ListStorageTemplatePartitionPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.template = (ListStorageTemplatePartitionOraclev9i)object;
        this.setHeight(140);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.ListSubpartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initTableSpace();
    }

    private void initValueList() {
        JLabel label = new JLabel(Messages.getString("ListStorageTemplatePartitionPropertyDialogOraclev9i.ValueList"));
        this.general.add(label);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    @Override
    protected void addTabs() {
        this.initIndexesTab();
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initIndexesTab() {
        JPanel constraintPanel = new JPanel();
        JScrollPane pane = new JScrollPane(this.getList());
        pane.setPreferredSize(new Dimension(390, 60));
        constraintPanel.add((Component)this.getIndexesButtonPanel(), "North");
        constraintPanel.add((Component)pane, "Center");
        this.getPane().addTab(Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.LocalIndexes"), constraintPanel);
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.edit = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("ListStorageTemplatePartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListStorageTemplatePartitionPropertyDialogOraclev9i.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.edit);
            toolBar.addSeparator();
            this.indexesButtonPanel.add(toolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    private void editSelected() {
        Object selected = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev9i editor = new LocalIndexPropertyDialogOraclev9i(this.template.getDesign().getAppView(), this.getStorageDesign(), this.template, (StorageObject)selected);
        editor.show();
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    @Override
    public void initProperties() {
        this.initCaption(this.template.getName());
        this.tfName.setText(this.template.getName());
        this.tfValueList.setText(this.template.getValueList());
        this.selectObject(this.cbTableSpace, this.template.getTablespace());
        TableProxyOraclev9i table = null;
        if (this.template.getPartOfStorageTable() != null) {
            table = (TableProxyOraclev9i)this.template.getPartOfStorageTable();
        } else {
            SnapshotOracle snapshot;
            AbstractStorageObjectOracle owningPartition = this.template.getSubPartitionOf();
            PartitionListOracle partitionList = null;
            if (owningPartition instanceof PartitionOracle) {
                partitionList = ((PartitionOracle)owningPartition).getPartitionList();
            }
            if (partitionList != null && (table = (TableProxyOraclev9i)partitionList.getTable()) == null && (snapshot = partitionList.getSnapshot()) != null) {
                table = (TableProxyOraclev9i)snapshot.getImplementedTable();
            }
        }
        if (table != null) {
            IndexProxy[] indexSet = table.getIndexProxies();
            for (int i = 0; i < indexSet.length; ++i) {
                IndexProxyOracle index = (IndexProxyOracle)indexSet[i];
                if (index == null || !index.getIndexPartitioned().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(index);
            }
            Iterator bjiIt = table.getBjIndexes().iterator();
            while (bjiIt.hasNext()) {
                BitmapJoinIndexOraclev9i bji = (BitmapJoinIndexOraclev9i)bjiIt.next();
                if (!bji.getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                this.listModel.addElement(bji);
            }
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            LocalIndexProperties lip;
            StorageObject index;
            if (this.listModel.get(i) instanceof IndexProxyOraclev9i) {
                index = (IndexProxyOraclev9i)this.listModel.get(i);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.template, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setPartition(this.template);
                lip.setIndex(index);
                continue;
            }
            if (!(this.listModel.get(i) instanceof BitmapJoinIndexOraclev9i)) continue;
            index = (BitmapJoinIndexOraclev9i)this.listModel.get(i);
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.template, index);
            if (lip != null) continue;
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            lip.setPartition(this.template);
            lip.setIndex(index);
        }
        this.getCommentsList().insert(this.template.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.template != null) {
            this.template.setName(this.tfName.getText());
            this.template.setValueList(this.tfValueList.getText());
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.template.setTablespace((TableSpaceOracle)selected);
            } else {
                this.template.setTablespace(null);
            }
            this.template.setComment(this.getCommentsList().getText());
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ListStorageTemplatePartitionPropertyDialogOraclev9i.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Index) {
                this.setText(((Index)value).getName());
            } else {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }
}

