/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.SelectObjectsDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;

public class SegmentPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private static final Logger LOGGER = new Logger(SegmentPropertyDialogOraclev9i.class);
    private SegmentOraclev9i segment;
    private JComboBox cbTableSpace;
    private JIntegerField ifPctFree;
    private JIntegerField ifPctUsed;
    private JIntegerField ifInitrans;
    private JIntegerField ifMaxTrans;
    private JIntegerField ifSCInitialExtent;
    private JIntegerField ifSCNextExtent;
    private JIntegerField ifSCMinExtents;
    private JTextField tfSCMaxExtents;
    private JIntegerField ifSCPctIncrease;
    private JComboBox cbSCBufferPool;
    private JIntegerField ifSCFreeLists;
    private JIntegerField ifSCFreeListsGroups;
    private JPanel clusters;
    private DefaultListModel clusterListModel;
    private JList clusterList;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel indexes;
    private DefaultListModel indexListModel;
    private JList indexList;
    private JPanel snapshots;
    private DefaultListModel snapshotListModel;
    private JList snapshotList;
    private static GUIConfiguration configuration = GUIConfiguration.getInstance();
    private JCheckBox chCurrentlyUsed;

    public SegmentPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.segment = (SegmentOraclev9i)object;
        this.setHeight(500);
        this.initCommentsView(450);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    @Override
    public String getCaption() {
        return Messages.getString("SegmentPropertyDialogOracle.SegmentProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTableSpace();
        this.initPctFree();
        this.initPctUsed();
        this.initInitrans();
        this.initMaxTrans();
        this.initSCInitialExtent();
        this.initSCNextExtent();
        this.initSCMinExtents();
        this.initSCMaxExtents();
        this.initSCPctIncrease();
        this.initSCBufferPool();
        this.initSCFreeLists();
        this.initSCFreeListsGroups();
        this.initCurrentlyUsed();
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbTableSpace, 50);
    }

    private void initPctFree() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.PCTFree"));
        this.general.add(label);
        this.ifPctFree = new JIntegerField(0, 26);
        this.general.add(this.ifPctFree);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifPctFree, 80);
    }

    private void initPctUsed() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.PCTUsed"));
        this.general.add(label);
        this.ifPctUsed = new JIntegerField(0, 26);
        this.general.add(this.ifPctUsed);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifPctUsed, 110);
    }

    private void initInitrans() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.Initrans"));
        this.general.add(label);
        this.ifInitrans = new JIntegerField(0, 26);
        this.general.add(this.ifInitrans);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifInitrans, 140);
    }

    private void initMaxTrans() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.MaxTrans"));
        this.general.add(label);
        this.ifMaxTrans = new JIntegerField(0, 26);
        this.general.add(this.ifMaxTrans);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifMaxTrans, 170);
    }

    private void initSCInitialExtent() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCInitialExtent"));
        this.general.add(label);
        this.ifSCInitialExtent = new JIntegerField(0, 26);
        this.general.add(this.ifSCInitialExtent);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifSCInitialExtent, 200);
    }

    private void initSCNextExtent() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCNextExtent"));
        this.general.add(label);
        this.ifSCNextExtent = new JIntegerField(0, 26);
        this.general.add(this.ifSCNextExtent);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifSCNextExtent, 230);
    }

    private void initSCMinExtents() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCMinExtents"));
        this.general.add(label);
        this.ifSCMinExtents = new JIntegerField(0, 26);
        this.general.add(this.ifSCMinExtents);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.ifSCMinExtents, 260);
    }

    private void initSCMaxExtents() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCMaxExtents"));
        this.general.add(label);
        this.tfSCMaxExtents = new JTextField("UNLIMITED", 26);
        this.general.add(this.tfSCMaxExtents);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.tfSCMaxExtents, 290);
    }

    private void initSCPctIncrease() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCPCTIncrease"));
        this.general.add(label);
        this.ifSCPctIncrease = new JIntegerField(0, 26);
        this.general.add(this.ifSCPctIncrease);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.ifSCPctIncrease, 320);
    }

    private void initSCBufferPool() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCBufferPool"));
        this.general.add(label);
        this.cbSCBufferPool = new JComboBox<String>(SegmentOracle.getSCBufferPoolValues());
        this.setBG(this.cbSCBufferPool);
        this.cbSCBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSCBufferPool);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbSCBufferPool, 350);
    }

    private void initSCFreeLists() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCFreeLists"));
        this.general.add(label);
        this.ifSCFreeLists = new JIntegerField(0, 26);
        this.general.add(this.ifSCFreeLists);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.ifSCFreeLists, 380);
    }

    private void initSCFreeListsGroups() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.SCFreeListsGrps"));
        this.general.add(label);
        this.ifSCFreeListsGroups = new JIntegerField(0, 26);
        this.general.add(this.ifSCFreeListsGroups);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.ifSCFreeListsGroups, 410);
    }

    private void initCurrentlyUsed() {
        JLabel label = new JLabel(Messages.getString("SegmentPropertyDialogOracle.CurrentlyUsed"));
        this.general.add(label);
        this.chCurrentlyUsed = new JCheckBox();
        this.chCurrentlyUsed.setEnabled(false);
        this.general.add(this.chCurrentlyUsed);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.chCurrentlyUsed, 440);
        this.getGeneralLayout().getConstraints(this.chCurrentlyUsed).setX(this.getGeneralLayout().getConstraints(this.ifSCFreeListsGroups).getX());
    }

    @Override
    protected void addTabs() {
        this.initClustersView();
        this.initTablesView();
        this.initIndexesView();
        this.initSnapshotsView();
    }

    private void initClustersView() {
        this.clusters = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SegmentPropertyDialogOracle.Clusters"), this.clusters);
        this.initClusters();
    }

    private void initClusters() {
        if (this.isEditable()) {
            JButton bnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
            bnAdd.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.ApplyToClusters"));
            bnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList allObjects = new ArrayList();
                    ArrayList selectedObjects = new ArrayList();
                    Iterator it = SegmentPropertyDialogOraclev9i.this.getStorageDesign().getClusterSet().iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!SegmentPropertyDialogOraclev9i.this.clusterListModel.contains(obj)) {
                            allObjects.add(obj);
                            continue;
                        }
                        selectedObjects.add(obj);
                    }
                    SelectObjectsDialog dialog = new SelectObjectsDialog(SegmentPropertyDialogOraclev9i.this.getAppView(), allObjects, selectedObjects, Messages.getString("SegmentPropertyDialogOracle.SelectClusters"));
                    if (dialog.showDialog()) {
                        for (int i = SegmentPropertyDialogOraclev9i.this.clusterListModel.size() - 1; i >= 0; --i) {
                            Object obj = SegmentPropertyDialogOraclev9i.this.clusterListModel.elementAt(i);
                            try {
                                Method method = obj.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(obj, new Object[]{null});
                                SegmentPropertyDialogOraclev9i.this.clusterListModel.remove(i);
                                continue;
                            }
                            catch (Exception e1) {
                                LOGGER.warn(e1.getMessage(), e1);
                            }
                        }
                        for (Object next : selectedObjects) {
                            try {
                                Method method = next.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(next, SegmentPropertyDialogOraclev9i.this.segment);
                                if (SegmentPropertyDialogOraclev9i.this.clusterListModel.contains(next)) continue;
                                SegmentPropertyDialogOraclev9i.this.clusterListModel.addElement(next);
                            }
                            catch (Exception e1) {}
                        }
                    }
                }
            });
            JButton bnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            bnRemove.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.Remove"));
            bnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = SegmentPropertyDialogOraclev9i.this.clusterListModel.size() - 1; i >= 0; --i) {
                        if (!SegmentPropertyDialogOraclev9i.this.clusterList.isSelectedIndex(i)) continue;
                        Object obj = SegmentPropertyDialogOraclev9i.this.clusterListModel.elementAt(i);
                        try {
                            Method method = obj.getClass().getMethod("setSegment", SegmentOracle.class);
                            method.invoke(obj, new Object[]{null});
                            SegmentPropertyDialogOraclev9i.this.clusterListModel.remove(i);
                            continue;
                        }
                        catch (Exception e1) {
                            LOGGER.warn(e1.getMessage(), e1);
                        }
                    }
                }
            });
            JToolBar toolbar = new JToolBar(0);
            toolbar.setFloatable(false);
            toolbar.add(bnAdd);
            toolbar.add(bnRemove);
            toolbar.setPreferredSize(new Dimension(395, 34));
            this.clusters.add(toolbar);
            this.setObjectConstraints(this.getClusterLayout(), toolbar, 10, 12);
        }
        this.clusterListModel = new DefaultListModel();
        this.clusterList = new JList(this.clusterListModel);
        this.clusterList.addMouseListener(new ClusterListMouseListener());
        JScrollPane spTS = new JScrollPane(this.clusterList);
        spTS.setPreferredSize(new Dimension(395, 415));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusters.add(spTS);
        this.setObjectConstraints(this.getClusterLayout(), spTS, 10, 47);
    }

    protected SpringLayout getClusterLayout() {
        return (SpringLayout)this.clusters.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SegmentPropertyDialogOracle.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        if (this.isEditable()) {
            JButton bnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
            bnAdd.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.ApplyToTables"));
            bnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList allObjects = new ArrayList();
                    ArrayList selectedObjects = new ArrayList();
                    Iterator it = SegmentPropertyDialogOraclev9i.this.getStorageDesign().getTableProxySet().iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!SegmentPropertyDialogOraclev9i.this.tableListModel.contains(obj)) {
                            allObjects.add(obj);
                            continue;
                        }
                        selectedObjects.add(obj);
                    }
                    SelectObjectsDialog dialog = new SelectObjectsDialog(SegmentPropertyDialogOraclev9i.this.getAppView(), allObjects, selectedObjects, Messages.getString("SegmentPropertyDialogOracle.SelectTables"));
                    if (dialog.showDialog()) {
                        for (int i = SegmentPropertyDialogOraclev9i.this.tableListModel.size() - 1; i >= 0; --i) {
                            Object obj = SegmentPropertyDialogOraclev9i.this.tableListModel.elementAt(i);
                            try {
                                Method method = obj.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(obj, new Object[]{null});
                                SegmentPropertyDialogOraclev9i.this.tableListModel.remove(i);
                                continue;
                            }
                            catch (Exception e1) {
                                LOGGER.warn(e1.getMessage(), e1);
                            }
                        }
                        for (Object next : selectedObjects) {
                            try {
                                Method method = next.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(next, SegmentPropertyDialogOraclev9i.this.segment);
                                if (SegmentPropertyDialogOraclev9i.this.tableListModel.contains(next)) continue;
                                SegmentPropertyDialogOraclev9i.this.tableListModel.addElement(next);
                            }
                            catch (Exception e1) {}
                        }
                    }
                }
            });
            JButton bnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            bnRemove.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.Remove"));
            bnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = SegmentPropertyDialogOraclev9i.this.tableListModel.size() - 1; i >= 0; --i) {
                        if (!SegmentPropertyDialogOraclev9i.this.tableList.isSelectedIndex(i)) continue;
                        Object obj = SegmentPropertyDialogOraclev9i.this.tableListModel.elementAt(i);
                        try {
                            Method method = obj.getClass().getMethod("setSegment", SegmentOracle.class);
                            method.invoke(obj, new Object[]{null});
                            SegmentPropertyDialogOraclev9i.this.tableListModel.remove(i);
                            continue;
                        }
                        catch (Exception e1) {
                            LOGGER.warn(e1.getMessage(), e1);
                        }
                    }
                }
            });
            JToolBar toolbar = new JToolBar(0);
            toolbar.setFloatable(false);
            toolbar.add(bnAdd);
            toolbar.add(bnRemove);
            toolbar.setPreferredSize(new Dimension(395, 34));
            this.tables.add(toolbar);
            this.setObjectConstraints(this.getTableLayout(), toolbar, 10, 12);
        }
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tableList);
        spTS.setPreferredSize(new Dimension(395, 415));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTableLayout(), spTS, 10, 47);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SegmentPropertyDialogOracle.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        if (this.isEditable()) {
            JButton bnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
            bnAdd.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.ApplyToIndexes"));
            bnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList allObjects = new ArrayList();
                    ArrayList selectedObjects = new ArrayList();
                    Iterator it = SegmentPropertyDialogOraclev9i.this.getStorageDesign().getIndexProxySet().iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!SegmentPropertyDialogOraclev9i.this.indexListModel.contains(obj)) {
                            allObjects.add(obj);
                            continue;
                        }
                        selectedObjects.add(obj);
                    }
                    SelectObjectsDialog dialog = new SelectObjectsDialog(SegmentPropertyDialogOraclev9i.this.getAppView(), allObjects, selectedObjects, Messages.getString("SegmentPropertyDialogOracle.SelectIndexes"));
                    if (dialog.showDialog()) {
                        for (int i = SegmentPropertyDialogOraclev9i.this.indexListModel.size() - 1; i >= 0; --i) {
                            Object obj = SegmentPropertyDialogOraclev9i.this.indexListModel.elementAt(i);
                            try {
                                Method method = obj.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(obj, new Object[]{null});
                                SegmentPropertyDialogOraclev9i.this.indexListModel.remove(i);
                                continue;
                            }
                            catch (Exception e1) {
                                LOGGER.warn(e1.getMessage(), e1);
                            }
                        }
                        for (Object next : selectedObjects) {
                            try {
                                Method method = next.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(next, SegmentPropertyDialogOraclev9i.this.segment);
                                if (SegmentPropertyDialogOraclev9i.this.indexListModel.contains(next)) continue;
                                SegmentPropertyDialogOraclev9i.this.indexListModel.addElement(next);
                            }
                            catch (Exception e1) {}
                        }
                    }
                }
            });
            JButton bnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            bnRemove.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.Remove"));
            bnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = SegmentPropertyDialogOraclev9i.this.indexListModel.size() - 1; i >= 0; --i) {
                        if (!SegmentPropertyDialogOraclev9i.this.indexList.isSelectedIndex(i)) continue;
                        Object obj = SegmentPropertyDialogOraclev9i.this.indexListModel.elementAt(i);
                        try {
                            Method method = obj.getClass().getMethod("setSegment", SegmentOracle.class);
                            method.invoke(obj, new Object[]{null});
                            SegmentPropertyDialogOraclev9i.this.indexListModel.remove(i);
                            continue;
                        }
                        catch (Exception e1) {
                            LOGGER.warn(e1.getMessage(), e1);
                        }
                    }
                }
            });
            JToolBar toolbar = new JToolBar(0);
            toolbar.setFloatable(false);
            toolbar.add(bnAdd);
            toolbar.add(bnRemove);
            toolbar.setPreferredSize(new Dimension(395, 34));
            this.indexes.add(toolbar);
            this.setObjectConstraints(this.getIndexLayout(), toolbar, 10, 12);
        }
        this.indexListModel = new DefaultListModel();
        this.indexList = new JList(this.indexListModel);
        this.indexList.addMouseListener(new IndexListMouseListener());
        JScrollPane spTS = new JScrollPane(this.indexList);
        spTS.setPreferredSize(new Dimension(395, 415));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(spTS);
        this.setObjectConstraints(this.getIndexLayout(), spTS, 10, 47);
    }

    protected SpringLayout getIndexLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initSnapshotsView() {
        this.snapshots = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SegmentPropertyDialogOracle.Snapshots"), this.snapshots);
        this.initSnapshots();
    }

    private void initSnapshots() {
        if (this.isEditable()) {
            JButton bnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
            bnAdd.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.ApplyToSnapshots"));
            bnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList allObjects = new ArrayList();
                    ArrayList selectedObjects = new ArrayList();
                    Iterator it = SegmentPropertyDialogOraclev9i.this.getStorageDesign().getSnapshotSet().iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!SegmentPropertyDialogOraclev9i.this.snapshotListModel.contains(obj)) {
                            allObjects.add(obj);
                            continue;
                        }
                        selectedObjects.add(obj);
                    }
                    SelectObjectsDialog dialog = new SelectObjectsDialog(SegmentPropertyDialogOraclev9i.this.getAppView(), allObjects, selectedObjects, Messages.getString("SegmentPropertyDialogOracle.SelectSnapshots"));
                    if (dialog.showDialog()) {
                        for (int i = SegmentPropertyDialogOraclev9i.this.snapshotListModel.size() - 1; i >= 0; --i) {
                            Object obj = SegmentPropertyDialogOraclev9i.this.snapshotListModel.elementAt(i);
                            try {
                                Method method = obj.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(obj, new Object[]{null});
                                SegmentPropertyDialogOraclev9i.this.snapshotListModel.remove(i);
                                continue;
                            }
                            catch (Exception e1) {
                                LOGGER.warn(e1.getMessage(), e1);
                            }
                        }
                        for (Object next : selectedObjects) {
                            try {
                                Method method = next.getClass().getMethod("setSegment", SegmentOracle.class);
                                method.invoke(next, SegmentPropertyDialogOraclev9i.this.segment);
                                if (SegmentPropertyDialogOraclev9i.this.snapshotListModel.contains(next)) continue;
                                SegmentPropertyDialogOraclev9i.this.snapshotListModel.addElement(next);
                            }
                            catch (Exception e1) {}
                        }
                    }
                }
            });
            JButton bnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            bnRemove.setToolTipText(Messages.getString("SegmentPropertyDialogOracle.Remove"));
            bnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = SegmentPropertyDialogOraclev9i.this.snapshotListModel.size() - 1; i >= 0; --i) {
                        if (!SegmentPropertyDialogOraclev9i.this.snapshotList.isSelectedIndex(i)) continue;
                        Object obj = SegmentPropertyDialogOraclev9i.this.snapshotListModel.elementAt(i);
                        try {
                            Method method = obj.getClass().getMethod(Messages.getString("SegmentPropertyDialogOraclev9i.41"), SegmentOracle.class);
                            method.invoke(obj, new Object[]{null});
                            SegmentPropertyDialogOraclev9i.this.snapshotListModel.remove(i);
                            continue;
                        }
                        catch (Exception e1) {
                            LOGGER.warn(e1.getMessage(), e1);
                        }
                    }
                }
            });
            JToolBar toolbar = new JToolBar(0);
            toolbar.setFloatable(false);
            toolbar.add(bnAdd);
            toolbar.add(bnRemove);
            toolbar.setPreferredSize(new Dimension(395, 34));
            this.snapshots.add(toolbar);
            this.setObjectConstraints(this.getSnapshotLayout(), toolbar, 10, 12);
        }
        this.snapshotListModel = new DefaultListModel();
        this.snapshotList = new JList(this.snapshotListModel);
        this.snapshotList.addMouseListener(new SnapshotListMouseListener());
        JScrollPane spTS = new JScrollPane(this.snapshotList);
        spTS.setPreferredSize(new Dimension(395, 415));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.snapshots.add(spTS);
        this.setObjectConstraints(this.getSnapshotLayout(), spTS, 10, 47);
    }

    protected SpringLayout getSnapshotLayout() {
        return (SpringLayout)this.snapshots.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.segment.getName());
        this.tfName.setText(this.segment.getName());
        this.selectObject(this.cbTableSpace, this.segment.getTableSpace());
        this.ifPctFree.setValue((long)this.segment.getPCTFree());
        this.ifPctUsed.setValue((long)this.segment.getPCTUsed());
        this.ifInitrans.setValue((long)this.segment.getInitrans());
        this.ifMaxTrans.setValue((long)this.segment.getMaxTrans());
        this.ifSCInitialExtent.setValue(this.segment.getSCInitialExtent());
        this.ifSCNextExtent.setValue(this.segment.getSCNextExtent());
        this.ifSCMinExtents.setValue((long)this.segment.getSCMinExtents());
        this.tfSCMaxExtents.setText(this.segment.getSCMaxExtents());
        this.ifSCPctIncrease.setValue((long)this.segment.getSCPctIncrease());
        this.cbSCBufferPool.setSelectedItem(this.segment.getSCBufferPool());
        this.ifSCFreeLists.setValue((long)this.segment.getSCFreeLists());
        this.ifSCFreeListsGroups.setValue((long)this.segment.getSCFreelistGroups());
        Object[] cluster = this.getStorageDesign().getClusterSet().toArray();
        for (int i = 0; i < cluster.length; ++i) {
            if (((ClusterOraclev9i)cluster[i]).getSegment() != this.segment) continue;
            this.clusterListModel.addElement(cluster[i]);
        }
        Object[] table = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < table.length; ++i) {
            if (((TableProxyOraclev9i)table[i]).getSegment() != this.segment) continue;
            this.tableListModel.addElement(table[i]);
        }
        Object[] index = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < index.length; ++i) {
            if (((IndexProxyOraclev9i)index[i]).getSegment() != this.segment) continue;
            this.indexListModel.addElement(index[i]);
        }
        Object[] snapshot = this.getStorageDesign().getSnapshotSet().toArray();
        for (int i = 0; i < snapshot.length; ++i) {
            if (((SnapshotOraclev9i)snapshot[i]).getSegment() != this.segment) continue;
            this.snapshotListModel.addElement(snapshot[i]);
        }
        this.getCommentsList().insert(this.segment.getComment(), 0);
        boolean used = false;
        if (!(this.clusterListModel.isEmpty() && this.tableListModel.isEmpty() && this.indexListModel.isEmpty() && this.snapshotListModel.isEmpty())) {
            used = true;
        }
        this.chCurrentlyUsed.setSelected(used);
    }

    @Override
    protected void setProperties() {
        if (this.segment != null) {
            this.segment.setName(this.tfName.getText());
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.segment.setTableSpace((TableSpaceOracle)selected);
            } else {
                this.segment.setTableSpace(null);
            }
            this.segment.setPCTFree(this.ifPctFree.getIntValue());
            this.segment.setPCTUsed(this.ifPctUsed.getIntValue());
            this.segment.setInitrans(this.ifInitrans.getIntValue());
            this.segment.setMaxTrans(this.ifMaxTrans.getIntValue());
            this.segment.setSCInitialExtent(this.ifSCInitialExtent.getIntValue());
            this.segment.setSCNextExtent(this.ifSCNextExtent.getIntValue());
            this.segment.setSCMinExtents(this.ifSCMinExtents.getIntValue());
            this.segment.setSCMaxExtents(this.tfSCMaxExtents.getText());
            this.tfSCMaxExtents.setText(this.segment.getSCMaxExtents());
            this.segment.setSCPctIncrease(this.ifSCPctIncrease.getIntValue());
            this.segment.setSCBufferPool((String)this.cbSCBufferPool.getSelectedItem());
            this.segment.setSCFreeLists(this.ifSCFreeLists.getIntValue());
            this.segment.setSCFreelistGroups(this.ifSCFreeListsGroups.getIntValue());
            this.segment.setComment(this.getCommentsList().getText());
            this.segment.updateCurrentlyUsed();
            this.chCurrentlyUsed.setSelected(this.segment.isCurrentlyUsed());
        }
    }

    private class SnapshotListMouseListener
    extends MouseAdapter {
        private SnapshotListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SnapshotOraclev9i selected;
            if (e.getClickCount() == 2 && (selected = (SnapshotOraclev9i)SegmentPropertyDialogOraclev9i.this.snapshotList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        private IndexListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyOraclev9i selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyOraclev9i)SegmentPropertyDialogOraclev9i.this.indexList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyOraclev9i selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyOraclev9i)SegmentPropertyDialogOraclev9i.this.tableList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class ClusterListMouseListener
    extends MouseAdapter {
        private ClusterListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ClusterOraclev9i selected;
            if (e.getClickCount() == 2 && (selected = (ClusterOraclev9i)SegmentPropertyDialogOraclev9i.this.clusterList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }
}

