/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SynonymOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SynonymPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private SynonymOraclev9i synonym;
    private JComboBox cbUser;
    private JComboBox cbPublic;
    private JComboBox cbObjectUser;
    private JTextField tfObject;
    private JTextField tfDBLink;

    public SynonymPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.synonym = (SynonymOraclev9i)object;
        this.setHeight(230);
        this.initCommentsView();
        this.initNotesView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SynonymPropertyDialogOraclev9i.SynonymProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initPublic();
        this.initObjectUser();
        this.initObject();
        this.initDBLink();
    }

    private void initUser() {
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.User"));
        this.general.add(label);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initPublic() {
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.Public"));
        this.general.add(label);
        this.cbPublic = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPublic);
        this.cbPublic.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPublic);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbPublic, 80);
    }

    private void initObjectUser() {
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.ObjectOwner"));
        this.general.add(label);
        this.cbObjectUser = new JComboBox();
        this.setBG(this.cbObjectUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbObjectUser);
        }
        this.cbObjectUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbObjectUser);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbObjectUser, 110);
    }

    private void initObject() {
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.ObjectName"));
        this.general.add(label);
        this.tfObject = new JTextField("", 26);
        this.general.add(this.tfObject);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfObject, 140);
    }

    private void initDBLink() {
        JLabel label = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.DBLink"));
        this.general.add(label);
        this.tfDBLink = new JTextField("", 26);
        this.general.add(this.tfDBLink);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfDBLink, 170);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.synonym.getName());
        this.tfName.setText(this.synonym.getName());
        this.selectObject(this.cbUser, this.synonym.getUser());
        this.cbPublic.setSelectedItem(SynonymPropertyDialogOraclev9i.translateYesNoForDisplay(this.synonym.getPublic()));
        this.selectObject(this.cbObjectUser, this.synonym.getObjectUser());
        String objName = this.synonym.getObject();
        if (this.synonym.getObjNameHasQuotes()) {
            objName = '\"' + objName + '\"';
        }
        this.tfObject.setText(objName);
        this.tfDBLink.setText(this.synonym.getDBLink());
        this.getCommentsList().insert(this.synonym.getComment(), 0);
        this.taNotes.setText(this.synonym.getNotes());
    }

    @Override
    protected void setProperties() {
        if (this.synonym != null) {
            boolean hasQuotes;
            Object selected = this.cbUser.getSelectedItem();
            if (selected instanceof UserOracle) {
                this.synonym.setUser((UserOracle)selected);
            } else {
                this.synonym.setUser(null);
            }
            this.synonym.setName(this.tfName.getText());
            this.synonym.setPublic(SynonymPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbPublic.getSelectedItem()));
            selected = this.cbObjectUser.getSelectedItem();
            if (selected instanceof UserOracle) {
                this.synonym.setObjectUser((UserOracle)selected);
            } else {
                this.synonym.setObjectUser(null);
            }
            String trimmedObjName = this.tfObject.getText().trim();
            boolean bl = hasQuotes = trimmedObjName.startsWith("\"") && trimmedObjName.endsWith("\"");
            if (hasQuotes) {
                trimmedObjName = trimmedObjName.substring(1, trimmedObjName.length() - 1);
            }
            this.synonym.setObject(trimmedObjName);
            this.synonym.setObjNameHasQuotes(hasQuotes);
            this.synonym.setDBLink(this.tfDBLink.getText());
            this.synonym.setComment(this.getCommentsList().getText());
            this.synonym.setNotes(this.taNotes.getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedUser = this.cbUser.getSelectedItem();
        if (selectedUser instanceof UserOracle) {
            newName = ((UserOracle)selectedUser).getName() + '.' + newName;
        }
        return this.getStorageObject().allowName(newName, true);
    }
}

