/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private TableProxyOraclev9i table;
    private PartitionListOraclev9i partList;
    private static final String YES_PRESERVE = Messages.getString("TablePropertyDialogOracle.YES_PRESERVE_ROWS");
    private static final String YES_DELETE = Messages.getString("TablePropertyDialogOracle.YES_DELETE_ROWS");
    private static final String[] NO_PRESERVE_DELETE = new String[]{NO, YES_PRESERVE, YES_DELETE};
    private JComboBox cbUser;
    private JComboBox cbTemporary;
    private JComboBox cbTableSpace;
    private JComboBox cbOrganization;
    private JComboBox cbCluster;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JComboBox cbCache;
    private JComboBox cbMonitoring;
    private JComboBox cbParallel;
    private JPositiveIntegerField ifDegree;
    private JComboBox cbRowDependency;
    private JComboBox cbPartitioned;
    private JComboBox cbPartRowMovement;
    private JComboBox cbDataSegmentCompression;
    private JComboBox cbSnapshot;
    private JTextField tfBasedOnStructuredType;
    private JPositiveIntegerField ifIotCompress;
    private JPositiveIntegerField ifIotPctThreshold;
    private JComboBox cbIotIncluding;
    private JComboBox cbIotOverflowTablespace;
    private JComboBox cbIotOverflowLogging;
    private JComboBox cbIotOverflowSegment;
    private JComboBox cbIotMappingTable;
    private JPanel iotProperties;
    private JPanel supplementalLog;
    private JTextField tfSupplementalLogGroupName;
    private JComboBox cbSupplementalLogCondition;
    private JList allSupplementalColumnsList;
    private JList selectedSupplementalColumnsList;
    private DefaultListModel allSupplementalColumnsModel;
    private DefaultListModel selectedSupplementalColumnsModel;
    private JButton bnSupplementalAdd;
    private JButton bnSupplementalRemove;
    private JPanel clusterColumns;
    private JList allClusterColumnsList;
    private JList selectedClusterColumnsList;
    private DefaultListModel allClusterColumnsModel;
    private DefaultListModel selectedClusterColumnsModel;
    private JButton bnAddClusterColumn;
    private JButton bnRemoveClusterColumn;
    private JPanel hashPTS;
    private int hashPTSTabIndex;
    private JList allHashPTSList;
    private JList selectedHashPTSList;
    private DefaultListModel allHashPTSModel;
    private DefaultListModel selectedHashPTSModel;
    private JButton bnAddHashPTS;
    private JButton bnRemoveHashPTS;
    private JList allIOTOverflowHashPTSList;
    private JList selectedIOTOverflowHashPTSList;
    private DefaultListModel allIOTOverflowHashPTSModel;
    private DefaultListModel selectedIOTOverflowHashPTSModel;
    private JButton bnAddIOTOverflowHashPTS;
    private JButton bnRemoveIOTOverflowHashPTS;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel pnPartitioning;
    private JPanel pnPartGeneral;
    private JTabbedPane tpPartitions;
    private JComboBox cbPartType;
    private JComboBox cbUseSubpartitionsStorageTemplate;
    private JPositiveIntegerField ifHashPQuantity;
    private JPositiveIntegerField ifSubPartQuantity;
    private JPanel subPartColumns;
    private int subPartColumnsTabIndex;
    private JList allSubPartColumnsList;
    private JList selectedSubPartColumnsList;
    private DefaultListModel allSubPartColumnsModel;
    private DefaultListModel selectedSubPartColumnsModel;
    private JButton bnAddSubPartColumns;
    private JButton bnRemoveSubPartColumns;
    private JPanel subPartTS;
    private int subPartTSTabIndex;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private String comment;
    private String commentInRDBMS;
    private JPanel oidProperties;
    private JTextField tfOidIndexName;
    private JComboBox cbOidIndexSegment;
    private JTextField tfOidType;
    private JPanel xmlTypeProperties;
    private JTextField tfXmlSchemaUrl;
    private JTextField tfXmlSchemaElement;
    private JComboBox cbStoreAs;
    private JTextField tfLobSegmentName;
    private JComboBox cbXmlTypeTableSpace;
    private JComboBox cbStorageInRow;
    private JComboBox cbXmlTypeLogging;
    private JComboBox cbXmlTypeCache;
    private JPositiveIntegerField ifChunk;
    private JComboBox cbOldVersions;
    private JPositiveIntegerField ifPctVersion;
    private JPositiveIntegerField ifFreePools;
    private JPanel partitionsOrder;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    private JTable partitionsOrderTable;
    private List partitions;
    private DefaultListSelectionModel partSelectionModel;
    private PartitionsOrderModel partitionsOrderModel;
    private boolean ordered = false;

    public TablePropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.table = (TableProxyOraclev9i)object;
        this.partList = (PartitionListOraclev9i)this.table.getPartitionList();
        this.setHeight(650);
        this.initCommentsView(270);
        this.initCommentsInRDBMS(275);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogOracle.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.setObjectConstraints(this.tfName, 20);
        this.initUser();
        this.initTemporary();
        this.initTableSpace();
        this.initOrganization();
        this.initCluster();
        this.initLogging();
        this.initSegment();
        this.initCache();
        this.initMonitoring();
        this.initParallel();
        this.initDegree();
        this.initRowDependency();
        this.initPartitioned();
        this.initPartRowMovement();
        this.initDataSegmentCompression();
        this.initSnapshot();
        this.initBasedOnStructuredType();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    private void initUser() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.User"));
        this.general.add(label);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initTemporary() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Temporary"));
        this.general.add(label);
        this.cbTemporary = new JComboBox<String>(NO_PRESERVE_DELETE);
        this.setBG(this.cbTemporary);
        this.cbTemporary.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTemporary.addActionListener(new TemporaryListener());
        this.general.add(this.cbTemporary);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbTemporary, 80);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initOrganization() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Organization"));
        this.general.add(label);
        this.cbOrganization = new JComboBox<String>(TableProxyOracle.getOrganizationChoices());
        this.setBG(this.cbOrganization);
        this.cbOrganization.addActionListener(new OrganizationListener());
        this.cbOrganization.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOrganization);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbOrganization, 140);
    }

    private void initCluster() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Cluster"));
        this.general.add(label);
        this.cbCluster = new JComboBox();
        this.setBG(this.cbCluster);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getClusterSet().toArray(), this.cbCluster);
        }
        this.cbCluster.addActionListener(new ClusterListener());
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbLogging, 200);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbSegment, 230);
    }

    private void initCache() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.general.add(label);
        this.cbCache = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbCache, 260);
    }

    private void initMonitoring() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Monitoring"));
        this.general.add(label);
        this.cbMonitoring = new JComboBox<String>(YES_NO);
        this.setBG(this.cbMonitoring);
        this.cbMonitoring.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbMonitoring);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbMonitoring, 290);
    }

    private void initParallel() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Parallel"));
        this.general.add(label);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.addActionListener(new ParallelListener());
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbParallel, 320);
    }

    private void initDegree() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Degree"));
        this.general.add(label);
        this.ifDegree = new JPositiveIntegerField(0, 26);
        this.general.add(this.ifDegree);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.ifDegree, 350);
    }

    private void initRowDependency() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.RowDependency"));
        this.general.add(label);
        this.cbRowDependency = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRowDependency);
        this.cbRowDependency.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRowDependency);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbRowDependency, 380);
    }

    private void initPartitioned() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Partitioned"));
        this.general.add(label);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitioned.addActionListener(new PartitionedAction());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.cbPartitioned, 410);
    }

    private void initPartRowMovement() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.RowMovement"));
        this.general.add(label);
        this.cbPartRowMovement = new JComboBox<String>(TableProxyOracle.getParttitionedRowMovementChoices());
        this.setBG(this.cbPartRowMovement);
        this.cbPartRowMovement.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartRowMovement);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.cbPartRowMovement, 440);
    }

    private void initDataSegmentCompression() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.DataCompression"));
        this.general.add(label);
        this.cbDataSegmentCompression = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDataSegmentCompression);
        this.cbDataSegmentCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataSegmentCompression);
        this.setLabelConstraints(label, 470);
        this.setObjectConstraints(this.cbDataSegmentCompression, 470);
    }

    private List getSnapshots() {
        ArrayList<SnapshotOracle> result = new ArrayList<SnapshotOracle>();
        Iterator it = this.getStorageDesign().getSnapshotSet().iterator();
        while (it.hasNext()) {
            SnapshotOracle snapshot = (SnapshotOracle)it.next();
            TableProxyOracle snapshotTable = snapshot.getImplementedTable();
            if (snapshotTable != null && snapshotTable != this.getStorageObject()) continue;
            result.add(snapshot);
        }
        return result;
    }

    private void initSnapshot() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.ImplementAsSnapshot"));
        this.general.add(label);
        this.cbSnapshot = new JComboBox();
        this.cbSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePropertyDialogOraclev9i.this.snapshotChanged();
            }
        });
        this.setBG(this.cbSnapshot);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getSnapshots().toArray(), this.cbSnapshot);
        }
        this.cbSnapshot.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSnapshot);
        this.setLabelConstraints(label, 500);
        this.setObjectConstraints(this.cbSnapshot, 500);
    }

    private void initBasedOnStructuredType() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.StructuredType"));
        this.general.add(label);
        this.tfBasedOnStructuredType = new JTextField();
        this.setBG(this.tfBasedOnStructuredType);
        this.tfBasedOnStructuredType.setEnabled(false);
        this.tfBasedOnStructuredType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfBasedOnStructuredType);
        this.setLabelConstraints(label, 530);
        this.setObjectConstraints(this.tfBasedOnStructuredType, 530);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TablePropertyDialogOraclev9i.this.getStorageDesign().getTableProxySet().getElements());
                list.remove(TablePropertyDialogOraclev9i.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogOraclev9i.this.getAppView(), TablePropertyDialogOraclev9i.this.table, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 570);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 265, 570);
    }

    protected SpringLayout getIOTPropertiesLayout() {
        return (SpringLayout)this.iotProperties.getLayout();
    }

    protected SpringLayout getSupplementalLogLayout() {
        return (SpringLayout)this.supplementalLog.getLayout();
    }

    private void initIOTCompress() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTCompress"));
        this.iotProperties.add(label);
        this.ifIotCompress = new JPositiveIntegerField(0, 26);
        this.iotProperties.add(this.ifIotCompress);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 20);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotCompress, 20);
    }

    private void initIOTPCTThreshold() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTPCTThreshold"));
        this.iotProperties.add(label);
        this.ifIotPctThreshold = new JPositiveIntegerField(0, 26);
        this.iotProperties.add(this.ifIotPctThreshold);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 50);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotPctThreshold, 50);
    }

    private void initIOTIncluding() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTIncluding"));
        this.iotProperties.add(label);
        this.cbIotIncluding = new JComboBox();
        this.setBG(this.cbIotIncluding);
        this.cbIotIncluding.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotIncluding);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 80);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotIncluding, 80);
    }

    private void initIOTOverflowTablespace() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowTablespace"));
        this.iotProperties.add(label);
        this.cbIotOverflowTablespace = new JComboBox();
        this.setBG(this.cbIotOverflowTablespace);
        this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIotOverflowTablespace);
        this.cbIotOverflowTablespace.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowTablespace);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 110);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowTablespace, 110);
    }

    private void initIOTOverflowLogging() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowLogging"));
        this.iotProperties.add(label);
        this.cbIotOverflowLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbIotOverflowLogging);
        this.cbIotOverflowLogging.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowLogging);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 140);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowLogging, 140);
    }

    private void initIOTOverflowSegment() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowSegment"));
        this.iotProperties.add(label);
        this.cbIotOverflowSegment = new JComboBox();
        this.setBG(this.cbIotOverflowSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIotOverflowSegment);
        }
        this.cbIotOverflowSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowSegment);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 170);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowSegment, 170);
    }

    private void initIOTMappingTable() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.MappingTable"));
        this.iotProperties.add(label);
        this.cbIotMappingTable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIotMappingTable);
        this.cbIotMappingTable.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotMappingTable);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 200);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotMappingTable, 200);
    }

    @Override
    protected void addTabs() {
        this.initClusterColumnsView();
        this.initPartitioningView();
        this.initIOTPropertiesView();
        this.initSupplementalLogView();
        this.initOIDView();
        this.initXMLTypeView();
    }

    private void initXMLTypeView() {
        this.xmlTypeProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.XMLTypeProperties"), this.xmlTypeProperties);
        this.initXMLTypeProperties();
    }

    private void initXMLTypeProperties() {
        this.initXMLSchemaURL();
        this.initXMLSchemaElement();
        this.initStoreAs();
        this.initLobSegmentName();
        this.initXmlTypeTableSpace();
        this.initStorageInRow();
        this.initXmlTypeLogging();
        this.initXmlTypeCache();
        this.initChunk();
        this.initOldVersions();
        this.initPctVersion();
        this.initFreePools();
    }

    private void initStoreAs() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.StoreAs"));
        this.xmlTypeProperties.add(label);
        this.cbStoreAs = new JComboBox<String>(TableProxyOraclev9i.getStoreAsValues());
        this.cbStoreAs.addActionListener(new StoreAsListener());
        this.setBG(this.cbStoreAs);
        this.cbStoreAs.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStoreAs);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 80);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStoreAs, 80);
    }

    private void initXMLSchemaURL() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaURL"));
        this.xmlTypeProperties.add(label);
        this.tfXmlSchemaUrl = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaUrl);
        this.xmlTypeProperties.add(this.tfXmlSchemaUrl);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 20);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaUrl, 20);
    }

    private void initXMLSchemaElement() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaElem"));
        this.xmlTypeProperties.add(label);
        this.tfXmlSchemaElement = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaElement);
        this.xmlTypeProperties.add(this.tfXmlSchemaElement);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 50);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaElement, 50);
    }

    private void initLobSegmentName() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.LobSegmentName"));
        this.xmlTypeProperties.add(label);
        this.tfLobSegmentName = new JTextField("", 26);
        this.xmlTypeProperties.add(this.tfLobSegmentName);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 110);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfLobSegmentName, 110);
    }

    private void initXmlTypeTableSpace() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.xmlTypeProperties.add(label);
        this.cbXmlTypeTableSpace = new JComboBox();
        this.setBG(this.cbXmlTypeTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbXmlTypeTableSpace);
        }
        this.cbXmlTypeTableSpace.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeTableSpace);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 140);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeTableSpace, 140);
    }

    private void initStorageInRow() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.StorageInRow"));
        this.xmlTypeProperties.add(label);
        this.cbStorageInRow = new JComboBox<String>(TableProxyOracle.getStorageInRowValues());
        this.setBG(this.cbStorageInRow);
        this.cbStorageInRow.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStorageInRow);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 170);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStorageInRow, 170);
    }

    private void initXmlTypeLogging() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.xmlTypeProperties.add(label);
        this.cbXmlTypeLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbXmlTypeLogging);
        this.cbXmlTypeLogging.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeLogging);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 200);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeLogging, 200);
    }

    private void initXmlTypeCache() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.xmlTypeProperties.add(label);
        this.cbXmlTypeCache = new JComboBox<String>(TableProxyOracle.getXmlTypeCacheValues());
        this.setBG(this.cbXmlTypeCache);
        this.cbXmlTypeCache.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeCache);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 230);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeCache, 230);
    }

    private void initChunk() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Chunk"));
        this.xmlTypeProperties.add(label);
        this.ifChunk = new JPositiveIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifChunk);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 260);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifChunk, 260);
    }

    private void initOldVersions() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OldVersions"));
        this.xmlTypeProperties.add(label);
        this.cbOldVersions = new JComboBox<String>(TableProxyOraclev9i.getOldVersionChoices());
        this.cbOldVersions.addActionListener(new VersionListener());
        this.setBG(this.cbOldVersions);
        this.cbOldVersions.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbOldVersions);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 290);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbOldVersions, 290);
    }

    private void initPctVersion() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.PCTVersion"));
        this.xmlTypeProperties.add(label);
        this.ifPctVersion = new JPositiveIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifPctVersion);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 320);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifPctVersion, 320);
    }

    private void initFreePools() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.FreePools"));
        this.xmlTypeProperties.add(label);
        this.ifFreePools = new JPositiveIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifFreePools);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, 350);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifFreePools, 350);
    }

    private void enableXMLTypeClobOptions(boolean enable) {
        this.tfLobSegmentName.setEnabled(enable);
        this.cbXmlTypeTableSpace.setEnabled(enable);
        this.cbStorageInRow.setEnabled(enable);
        this.cbXmlTypeLogging.setEnabled(enable);
        this.cbXmlTypeCache.setEnabled(enable);
        this.ifChunk.setEnabled(enable);
        this.cbOldVersions.setEnabled(enable);
        this.ifPctVersion.setEnabled(enable);
        this.ifFreePools.setEnabled(enable);
    }

    protected SpringLayout getXMLTypePropertiesLayout() {
        return (SpringLayout)this.xmlTypeProperties.getLayout();
    }

    private void initOIDView() {
        this.oidProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.OIDProperties"), this.oidProperties);
        this.initOIDProperties();
    }

    private void initOIDProperties() {
        this.initOidType();
        this.initOidIndexName();
        this.initOidIndexSegment();
    }

    private void initOidType() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDType"));
        this.oidProperties.add(label);
        this.tfOidType = new JTextField();
        this.tfOidType.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.tfOidType.setEnabled(false);
        this.oidProperties.add(this.tfOidType);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), label, 20);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidType, 20);
    }

    private void initOidIndexName() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexName"));
        this.oidProperties.add(label);
        this.tfOidIndexName = new JTextField();
        this.tfOidIndexName.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.tfOidIndexName);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), label, 50);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidIndexName, 50);
    }

    private void initOidIndexSegment() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexSegment"));
        this.oidProperties.add(label);
        this.cbOidIndexSegment = new JComboBox();
        this.setBG(this.cbOidIndexSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbOidIndexSegment);
        }
        this.cbOidIndexSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.cbOidIndexSegment);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), label, 80);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.cbOidIndexSegment, 80);
    }

    protected SpringLayout getOIDPropertiesLayout() {
        return (SpringLayout)this.oidProperties.getLayout();
    }

    private void initSupplementalLogView() {
        this.supplementalLog = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.SupplementalLog"), this.supplementalLog);
        this.initSupplementalLog();
    }

    private void initSupplementalLog() {
        this.initSupplementalLogGroupName();
        this.initSupplementalLogCondition();
        this.initSupplementalLogColumns();
    }

    private void initSupplementalLogColumns() {
        this.initAllSupplementalColumnsList();
        this.initSelectedSupplementalColumnsList();
        this.initSupplementalButtons();
    }

    private void initAllSupplementalColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.supplementalLog.add(label);
        this.allSupplementalColumnsModel = new DefaultListModel();
        this.allSupplementalColumnsList = new JList(this.allSupplementalColumnsModel);
        ListSelectionModel listSelectionModel = this.allSupplementalColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSupplementalSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSupplementalColumnsList);
        sp.setPreferredSize(new Dimension(144, 470));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.supplementalLog.add(sp);
        this.setLabelConstraints(this.getSupplementalLogLayout(), label, 8, 84);
        this.setObjectConstraints(this.getSupplementalLogLayout(), sp, 6, 112);
    }

    private void initSelectedSupplementalColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.SupplementalColumns"));
        this.supplementalLog.add(label);
        this.selectedSupplementalColumnsModel = new DefaultListModel();
        this.selectedSupplementalColumnsList = new JList(this.selectedSupplementalColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedSupplementalColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSupplementalSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSupplementalColumnsList);
        sp.setPreferredSize(new Dimension(145, 470));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.supplementalLog.add(sp);
        this.setLabelConstraints(this.getSupplementalLogLayout(), label, 292, 84);
        this.setObjectConstraints(this.getSupplementalLogLayout(), sp, 290, 112);
    }

    private void initSupplementalButtons() {
        this.bnSupplementalAdd = new JButton(ADD_CAPTION);
        this.bnSupplementalAdd.addActionListener(new AddSupplementalColumnsActionListener());
        this.bnSupplementalAdd.setEnabled(false);
        this.supplementalLog.add(this.bnSupplementalAdd);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.bnSupplementalAdd, 175, 280);
        this.bnSupplementalRemove = new JButton(REMOVE_CAPTION);
        this.bnSupplementalRemove.setEnabled(false);
        this.bnSupplementalRemove.addActionListener(new RemoveSupplementalColumnsActionListener());
        this.supplementalLog.add(this.bnSupplementalRemove);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.bnSupplementalRemove, 175, 310);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnSupplementalAdd, this.bnSupplementalRemove);
    }

    private void initSupplementalLogGroupName() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.GroupName"));
        this.supplementalLog.add(label);
        this.tfSupplementalLogGroupName = new JTextField("", 26);
        this.supplementalLog.add(this.tfSupplementalLogGroupName);
        this.setLabelConstraints(this.getSupplementalLogLayout(), label, 20);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.tfSupplementalLogGroupName, 20);
    }

    private void initSupplementalLogCondition() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Condition"));
        this.supplementalLog.add(label);
        this.cbSupplementalLogCondition = new JComboBox<String>(TableProxyOraclev9i.suplementalLogConditionChoices);
        this.setBG(this.cbSupplementalLogCondition);
        this.cbSupplementalLogCondition.setPreferredSize(this.tfSupplementalLogGroupName.getPreferredSize());
        this.supplementalLog.add(this.cbSupplementalLogCondition);
        this.setLabelConstraints(this.getSupplementalLogLayout(), label, 50);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.cbSupplementalLogCondition, 50);
    }

    private void initIOTPropertiesView() {
        this.iotProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.IOTProperties"), this.iotProperties);
        this.initIOTProperties();
    }

    private void initIOTProperties() {
        this.initIOTCompress();
        this.initIOTPCTThreshold();
        this.initIOTIncluding();
        this.initIOTOverflowTablespace();
        this.initIOTOverflowLogging();
        this.initIOTOverflowSegment();
        this.initIOTMappingTable();
    }

    private void initClusterColumnsView() {
        this.clusterColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.ClusterColumns"), this.clusterColumns);
        this.initClusterColumns();
    }

    protected SpringLayout getClusterColumnsLayout() {
        return (SpringLayout)this.clusterColumns.getLayout();
    }

    private void initClusterColumns() {
        this.initAllClusterColumnsList();
        this.initSelectedClusterColumnsList();
        this.initClusterColumnsButtons();
    }

    private void initAllClusterColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.clusterColumns.add(label);
        this.allClusterColumnsModel = new DefaultListModel();
        this.allClusterColumnsList = new JList(this.allClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.allClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllClusterColumnListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allClusterColumnsList);
        sp.setPreferredSize(new Dimension(144, 560));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(sp);
        this.setLabelConstraints(this.getClusterColumnsLayout(), label, 12, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), sp, 10, 22);
    }

    private void initSelectedClusterColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedColumns"));
        this.clusterColumns.add(label);
        this.selectedClusterColumnsModel = new DefaultListModel();
        this.selectedClusterColumnsList = new JList(this.selectedClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedClusterColumnListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedClusterColumnsList);
        sp.setPreferredSize(new Dimension(145, 560));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(sp);
        this.setLabelConstraints(this.getClusterColumnsLayout(), label, 292, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), sp, 290, 22);
    }

    private void initClusterColumnsButtons() {
        this.bnAddClusterColumn = new JButton(ADD_CAPTION);
        this.bnAddClusterColumn.addActionListener(new AddClusterColumnsActionListener());
        this.bnAddClusterColumn.setEnabled(false);
        this.clusterColumns.add(this.bnAddClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnAddClusterColumn, 175, 240);
        this.bnRemoveClusterColumn = new JButton(REMOVE_CAPTION);
        this.bnRemoveClusterColumn.setEnabled(false);
        this.bnRemoveClusterColumn.addActionListener(new RemoveClusterColumnsActionListener());
        this.clusterColumns.add(this.bnRemoveClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnRemoveClusterColumn, 175, 270);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddClusterColumn, this.bnRemoveClusterColumn);
    }

    private void initPartitioningView() {
        this.pnPartitioning = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.Partitioning"), this.pnPartitioning);
        this.tpPartitions = new JTabbedPane();
        this.pnPartitioning.add((Component)this.tpPartitions, "Center");
        this.pnPartGeneral = new JPanel(new SpringLayout());
        this.hashPTS = new JPanel(new SpringLayout());
        this.subPartColumns = new JPanel(new SpringLayout());
        this.subPartTS = new JPanel(new SpringLayout());
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.General"), this.pnPartGeneral);
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.HashPartTableSpaces"), this.hashPTS);
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.SubPartColumns"), this.subPartColumns);
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.HashSubPartTableSpaces"), this.subPartTS);
        this.tpPartitions.addTab(Messages.getString("TablePropertyDialogOracle.PartitionsOrder"), this.partitionsOrder);
        this.hashPTSTabIndex = this.tpPartitions.indexOfComponent(this.hashPTS);
        this.subPartColumnsTabIndex = this.tpPartitions.indexOfComponent(this.subPartColumns);
        this.subPartTSTabIndex = this.tpPartitions.indexOfComponent(this.subPartTS);
        this.initPartitioning();
    }

    protected SpringLayout getHashPTSLayout() {
        return (SpringLayout)this.hashPTS.getLayout();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    protected SpringLayout getSubPartColumnsLayout() {
        return (SpringLayout)this.subPartColumns.getLayout();
    }

    protected SpringLayout getGeneralPartitioningLayout() {
        return (SpringLayout)this.pnPartGeneral.getLayout();
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    private void initPartitioning() {
        this.initGeneralPartitioning();
        this.initHashPTS();
        this.initSubPartColumns();
        this.initSubPartTS();
        this.initPartitionsOrder();
    }

    private void initGeneralPartitioning() {
        this.initPartType();
        this.initUseSubpartitionsStorageTemplate();
        this.initHashPQuantity();
        this.initSubPartQuantity();
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initHashPTS() {
        this.initAllHashPTSList();
        this.initSelectedHashPTSList();
        this.initHashPTSButtons();
        this.initAllIOTOverflowHashPTSList();
        this.initSelectedIOTOverflowHashPTSList();
        this.initIOTOverflowHashPTSButtons();
    }

    private void initSubPartColumns() {
        this.initAllSubPartColumnsList();
        this.initSelectedSubPartColumnsList();
        this.initSubPartColumnsButtons();
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initPartitionsOrder() {
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("TablePropertyDialogOracle.Properties"));
        btnProperties.addActionListener(new PartitionPropertiesAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            btnUp.setToolTipText(Messages.getString("TablePropertyDialogOracle.MoveUp"));
            btnUp.addActionListener(new MoveUpAction2());
            JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            btnDown.setToolTipText(Messages.getString("TablePropertyDialogOracle.MoveDown"));
            btnDown.addActionListener(new MoveDownAction2());
            toolBar.addSeparator();
            toolBar.add(btnUp);
            toolBar.add(btnDown);
        }
        buttonGeneral.add(toolBar);
        this.partitionsOrder.add((Component)buttonGeneral, "North");
        this.partitionsOrderModel = new PartitionsOrderModel();
        this.partSelectionModel = new DefaultListSelectionModel();
        this.partSelectionModel.setSelectionMode(2);
        this.partitionsOrderTable = new JTable(this.partitionsOrderModel);
        this.partitionsOrderTable.setSelectionModel(this.partSelectionModel);
        JScrollPane sp = new JScrollPane(this.partitionsOrderTable);
        sp.setPreferredSize(new Dimension(400, 500));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(sp);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), sp, 6, 40);
    }

    private void initPartType() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.PartitionType"));
        this.pnPartGeneral.add(label);
        this.cbPartType = new JComboBox<String>(PartitionListOraclev9i.getPartitionTypes());
        this.setBG(this.cbPartType);
        this.cbPartType.addActionListener(new PartitionTypeListener());
        this.cbPartType.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.cbPartType);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 20);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbPartType, 20);
    }

    private void initUseSubpartitionsStorageTemplate() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.UseSPTemplate"));
        this.pnPartGeneral.add(label);
        this.cbUseSubpartitionsStorageTemplate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbUseSubpartitionsStorageTemplate);
        this.cbUseSubpartitionsStorageTemplate.addActionListener(new PartitionTypeListener());
        this.cbUseSubpartitionsStorageTemplate.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.cbUseSubpartitionsStorageTemplate);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 50);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbUseSubpartitionsStorageTemplate, 50);
    }

    private void initHashPQuantity() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.HashPQuantity"));
        this.pnPartGeneral.add(label);
        this.ifHashPQuantity = new JPositiveIntegerField();
        this.ifHashPQuantity.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.ifHashPQuantity);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 80);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifHashPQuantity, 80);
    }

    private void initSubPartQuantity() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.SubPartQuantity"));
        this.pnPartGeneral.add(label);
        this.ifSubPartQuantity = new JPositiveIntegerField();
        this.ifSubPartQuantity.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.ifSubPartQuantity);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 110);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifSubPartQuantity, 110);
    }

    private void initAllHashPTSList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllTableSpaces"));
        this.hashPTS.add(label);
        this.allHashPTSModel = new DefaultListModel();
        this.allHashPTSList = new JList(this.allHashPTSModel);
        ListSelectionModel listSelectionModel = this.allHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allHashPTSList);
        sp.setPreferredSize(new Dimension(144, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 8, 54);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 6, 72);
    }

    private void initSelectedHashPTSList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.HashPTableSpaces"));
        this.hashPTS.add(label);
        this.selectedHashPTSModel = new DefaultListModel();
        this.selectedHashPTSList = new JList(this.selectedHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedHashPTSList);
        sp.setPreferredSize(new Dimension(145, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 292, 54);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 290, 72);
    }

    private void initHashPTSButtons() {
        this.bnAddHashPTS = new JButton(ADD_CAPTION);
        this.bnAddHashPTS.addActionListener(new AddHashPTSActionListener());
        this.bnAddHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddHashPTS, 175, 135);
        this.bnRemoveHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashPTS.setEnabled(false);
        this.bnRemoveHashPTS.addActionListener(new RemoveHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveHashPTS, 175, 165);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddHashPTS, this.bnRemoveHashPTS);
    }

    private void initAllIOTOverflowHashPTSList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllTableSpaces"));
        this.hashPTS.add(label);
        this.allIOTOverflowHashPTSModel = new DefaultListModel();
        this.allIOTOverflowHashPTSList = new JList(this.allIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.allIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIOTOverflowHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allIOTOverflowHashPTSList);
        sp.setPreferredSize(new Dimension(144, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 8, 294);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 6, 312);
    }

    private void initSelectedIOTOverflowHashPTSList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTOverflowTS"));
        this.hashPTS.add(label);
        this.selectedIOTOverflowHashPTSModel = new DefaultListModel();
        this.selectedIOTOverflowHashPTSList = new JList(this.selectedIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIOTOverflowHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedIOTOverflowHashPTSList);
        sp.setPreferredSize(new Dimension(145, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 292, 294);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 290, 312);
    }

    private void initIOTOverflowHashPTSButtons() {
        this.bnAddIOTOverflowHashPTS = new JButton(ADD_CAPTION);
        this.bnAddIOTOverflowHashPTS.addActionListener(new AddIOTOverflowHashPTSActionListener());
        this.bnAddIOTOverflowHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddIOTOverflowHashPTS, 175, 370);
        this.bnRemoveIOTOverflowHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
        this.bnRemoveIOTOverflowHashPTS.addActionListener(new RemoveIOTOverflowHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveIOTOverflowHashPTS, 175, 400);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddIOTOverflowHashPTS, this.bnRemoveIOTOverflowHashPTS);
    }

    private void reinitPartitioning(boolean use) {
        this.allColumnsModel.clear();
        this.selectedColumnsModel.clear();
        this.allSubPartColumnsModel.clear();
        this.selectedSubPartColumnsModel.clear();
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        this.allIOTOverflowHashPTSModel.clear();
        this.selectedIOTOverflowHashPTSModel.clear();
        this.allSubPartTSModel.clear();
        this.selectedSubPartTSModel.clear();
        this.cbPartType.setEnabled(use);
        String partType = "";
        if (use) {
            partType = (String)this.cbPartType.getSelectedItem();
        }
        this.enableRelevantPartitionFields(partType);
        if (use) {
            this.initPartColumns(this.partList);
            this.initHashPTS(this.partList);
            this.initIOTOverflowHashPTS(this.partList);
            this.initSubPartColumns(this.partList);
            this.initSubPartTS(this.partList);
        }
    }

    private void enableRelevantPartitionFields(String partType) {
        boolean partitioned = !partType.equals("");
        boolean hashByQuantity = false;
        boolean subpartitioned = false;
        boolean hashSubPart = false;
        if (partitioned) {
            hashByQuantity = partType.equalsIgnoreCase("HASH BY QUANTITY");
            hashSubPart = partType.equalsIgnoreCase("COMPOSITE BY HASH");
            subpartitioned = hashSubPart || partType.equalsIgnoreCase("COMPOSITE BY LIST");
        }
        this.cbUseSubpartitionsStorageTemplate.setEnabled(subpartitioned);
        this.ifHashPQuantity.setEnabled(hashByQuantity);
        this.ifSubPartQuantity.setEnabled(hashSubPart);
        this.allColumnsList.setEnabled(partitioned);
        this.selectedColumnsList.setEnabled(partitioned);
        this.bnAdd.setEnabled(partitioned && this.allColumnsList.getSelectedIndex() != -1);
        this.bnRemove.setEnabled(partitioned && this.selectedColumnsList.getSelectedIndex() != -1);
        this.tpPartitions.setEnabledAt(this.subPartColumnsTabIndex, subpartitioned);
        if (subpartitioned) {
            this.bnAddSubPartColumns.setEnabled(this.allSubPartColumnsList.getSelectedIndex() != -1);
            this.bnRemoveSubPartColumns.setEnabled(this.selectedSubPartColumnsList.getSelectedIndex() != -1);
        }
        this.tpPartitions.setEnabledAt(this.hashPTSTabIndex, hashByQuantity);
        if (hashByQuantity) {
            this.bnAddHashPTS.setEnabled(this.allHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveHashPTS.setEnabled(this.selectedHashPTSList.getSelectedIndex() != -1);
            boolean hashByQuantityIndexOrg = this.cbOrganization.getSelectedItem().equals("INDEX");
            this.allIOTOverflowHashPTSList.setEnabled(hashByQuantityIndexOrg);
            this.selectedIOTOverflowHashPTSList.setEnabled(hashByQuantityIndexOrg);
            this.bnAddIOTOverflowHashPTS.setEnabled(hashByQuantityIndexOrg && this.allIOTOverflowHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveIOTOverflowHashPTS.setEnabled(hashByQuantityIndexOrg && this.selectedIOTOverflowHashPTSList.getSelectedIndex() != -1);
        }
        boolean hashNoStorageTemplate = hashSubPart && ((String)this.cbUseSubpartitionsStorageTemplate.getSelectedItem()).equalsIgnoreCase(NO);
        this.tpPartitions.setEnabledAt(this.subPartTSTabIndex, hashNoStorageTemplate);
        if (hashNoStorageTemplate) {
            this.bnAddSubPartTS.setEnabled(this.allSubPartTSList.getSelectedIndex() != -1);
            this.bnRemoveSubPartTS.setEnabled(this.selectedSubPartTSList.getSelectedIndex() != -1);
        }
    }

    private void initPartColumns(PartitionListOraclev9i partList) {
        ColumnProxy[] columnSet = this.table.getColumnProxies();
        if (partList != null) {
            block0: for (String colId : partList.getColumnSet()) {
                for (int i = 0; i < columnSet.length; ++i) {
                    ColumnProxy col = columnSet[i];
                    if (!col.getObjectID().equals(colId)) continue;
                    this.selectedColumnsModel.addElement(col);
                    continue block0;
                }
            }
        }
        for (int i = 0; i < columnSet.length; ++i) {
            ColumnProxy col = columnSet[i];
            if (this.selectedColumnsModel.contains(col)) continue;
            this.allColumnsModel.addElement(col);
        }
    }

    private void initHashPTS(PartitionListOraclev9i partList) {
        if (partList != null) {
            Iterator tsIt = partList.getHashPartitionsTableSpacesSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedHashPTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedHashPTSModel.contains(ts)) continue;
            this.allHashPTSModel.addElement(ts);
        }
    }

    private void initIOTOverflowHashPTS(PartitionListOraclev9i partList) {
        if (partList != null) {
            Iterator tsIt = partList.getIOTOverflowHashPTSSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedIOTOverflowHashPTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedIOTOverflowHashPTSModel.contains(ts)) continue;
            this.allIOTOverflowHashPTSModel.addElement(ts);
        }
    }

    private void initSubPartColumns(PartitionListOraclev9i partList) {
        ColumnProxy[] columnSet = this.table.getColumnProxies();
        if (partList != null) {
            block0: for (String colId : partList.getSubPartitionsColumnsSet()) {
                for (int i = 0; i < columnSet.length; ++i) {
                    ColumnProxy col = columnSet[i];
                    if (!col.getObjectID().equals(colId)) continue;
                    this.selectedSubPartColumnsModel.addElement(col);
                    continue block0;
                }
            }
        }
        for (int i = 0; i < columnSet.length; ++i) {
            ColumnProxy col = columnSet[i];
            if (this.selectedSubPartColumnsModel.contains(col)) continue;
            this.allSubPartColumnsModel.addElement(col);
        }
    }

    private void initSubPartTS(PartitionListOraclev9i partList) {
        if (partList != null) {
            Iterator tsIt = partList.getSubPartitionsTableSpacesSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedSubPartTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedSubPartTSModel.contains(ts)) continue;
            this.allSubPartTSModel.addElement(ts);
        }
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.pnPartGeneral.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 380));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(sp);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 8, 144);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), sp, 6, 162);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedColumns"));
        this.pnPartGeneral.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 380));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(sp);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 292, 144);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), sp, 290, 162);
    }

    private void initButtons() {
        this.bnAdd = new JButton(ADD_CAPTION);
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.pnPartGeneral.add(this.bnAdd);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.bnAdd, 175, 245);
        this.bnRemove = new JButton(REMOVE_CAPTION);
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.pnPartGeneral.add(this.bnRemove);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.bnRemove, 175, 275);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void initAllSubPartColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.subPartColumns.add(label);
        this.allSubPartColumnsModel = new DefaultListModel();
        this.allSubPartColumnsList = new JList(this.allSubPartColumnsModel);
        ListSelectionModel listSelectionModel = this.allSubPartColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSubPartColumnsList);
        sp.setPreferredSize(new Dimension(144, 520));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(sp);
        this.setLabelConstraints(this.getSubPartColumnsLayout(), label, 8, 4);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), sp, 6, 22);
    }

    private void initSelectedSubPartColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedColumns"));
        this.subPartColumns.add(label);
        this.selectedSubPartColumnsModel = new DefaultListModel();
        this.selectedSubPartColumnsList = new JList(this.selectedSubPartColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSubPartColumnsList);
        sp.setPreferredSize(new Dimension(145, 520));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(sp);
        this.setLabelConstraints(this.getSubPartColumnsLayout(), label, 292, 4);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), sp, 290, 22);
    }

    private void initSubPartColumnsButtons() {
        this.bnAddSubPartColumns = new JButton(ADD_CAPTION);
        this.bnAddSubPartColumns.addActionListener(new AddSubPartColumnsActionListener());
        this.bnAddSubPartColumns.setEnabled(false);
        this.subPartColumns.add(this.bnAddSubPartColumns);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), this.bnAddSubPartColumns, 175, 230);
        this.bnRemoveSubPartColumns = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartColumns.setEnabled(false);
        this.bnRemoveSubPartColumns.addActionListener(new RemoveSubPartColumnsActionListener());
        this.subPartColumns.add(this.bnRemoveSubPartColumns);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), this.bnRemoveSubPartColumns, 175, 260);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddSubPartColumns, this.bnRemoveSubPartColumns);
    }

    private void initAllSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllTableSpaces"));
        this.subPartTS.add(label);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSubPartTSList);
        sp.setPreferredSize(new Dimension(144, 445));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 8, 54);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 6, 72);
    }

    private void initSelectedSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedTableSpaces"));
        this.subPartTS.add(label);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSubPartTSList);
        sp.setPreferredSize(new Dimension(145, 445));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 292, 54);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 290, 72);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(ADD_CAPTION);
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 175, 230);
        this.bnRemoveSubPartTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 175, 260);
        TablePropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    @Override
    public void initProperties() {
        this.ordered = false;
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        String basedOnStructuredType = this.table.getBasedOnStructuredType();
        this.tfBasedOnStructuredType.setText(basedOnStructuredType);
        this.selectObject(this.cbUser, this.table.getUser());
        this.selectObject(this.cbTableSpace, this.table.getTableSpace());
        this.cbOrganization.setSelectedItem(this.table.getOrganization());
        this.selectObject(this.cbCluster, this.table.getCluster());
        this.cbLogging.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getLogging()));
        this.selectObject(this.cbSegment, this.table.getSegment());
        this.cbCache.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getCache()));
        this.cbMonitoring.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getMonitoring()));
        this.cbRowDependency.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getRowDependency()));
        this.cbPartitioned.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getPartitioned()));
        this.cbPartRowMovement.setSelectedItem(this.table.getParttitionedRowMovement());
        this.cbDataSegmentCompression.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getDataSegmentCompression()));
        this.ifIotCompress.setValue((long)this.table.getIotCompress());
        this.ifIotPctThreshold.setValue((long)this.table.getIotPctThreshold());
        this.fillComboItems(this.table.getColumnProxies(), this.cbIotIncluding);
        this.cbIotIncluding.setSelectedItem(this.table.getIotIncluding());
        this.cbIotOverflowTablespace.setSelectedItem(this.table.getIotOverflowTablespace());
        this.cbIotOverflowLogging.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getIotOverflowLogging()));
        this.cbIotOverflowSegment.setSelectedItem(this.table.getIotOverflowSegment());
        this.cbIotMappingTable.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getIOTMappingTable()));
        this.cbSnapshot.setSelectedItem(this.table.getSnapshot());
        this.table.getPartitions().setForbiddenCreateElement(true);
        this.partitions = new ArrayList();
        this.table.getPartitions().addAllElementsTo(this.partitions);
        ColumnProxy[] columnSet = this.table.getColumnProxies();
        block0: for (String colId : this.table.getSuplementalLogColumnSet()) {
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy col = columnSet[i];
                if (!col.getObjectID().equals(colId)) continue;
                this.selectedSupplementalColumnsModel.addElement(col);
                continue block0;
            }
        }
        for (int i = 0; i < columnSet.length; ++i) {
            ColumnProxy col = columnSet[i];
            if (this.selectedSupplementalColumnsModel.contains(col)) continue;
            this.allSupplementalColumnsModel.addElement(col);
        }
        this.tfSupplementalLogGroupName.setText(this.table.getSuplementalLogGroupName());
        this.cbSupplementalLogCondition.setSelectedItem(this.table.getSuplementalLogConditions());
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.oidProperties), !basedOnStructuredType.equals(""));
        this.tfOidType.setText(this.table.getOidType());
        this.tfOidIndexName.setText(this.table.getOidIndexName());
        this.cbOidIndexSegment.setSelectedItem(this.table.getOidIndexSegment());
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.xmlTypeProperties), basedOnStructuredType.equalsIgnoreCase("XMLTYPE"));
        this.tfXmlSchemaUrl.setText(this.table.getXmlSchemaUrl());
        this.tfXmlSchemaElement.setText(this.table.getXmlSchemaElement());
        this.cbStoreAs.setSelectedItem(this.table.getStoreAs());
        this.tfLobSegmentName.setText(this.table.getLobSegmentName());
        this.selectObject(this.cbXmlTypeTableSpace, this.table.getXmlTypeTableSpace());
        this.cbStorageInRow.setSelectedItem(this.table.getStorageInRow());
        this.cbXmlTypeLogging.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getXmlTypeLogging()));
        this.cbXmlTypeCache.setSelectedItem(this.table.getXmlTypeCache());
        this.ifChunk.setValue((long)this.table.getChunk());
        this.cbOldVersions.setSelectedItem(this.table.getOldVersions());
        this.ifPctVersion.setValue((long)this.table.getPCTVersion());
        this.ifFreePools.setValue((long)this.table.getFreepools());
        block3: for (String colId : this.table.getClusterColumnsSet()) {
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy col = columnSet[i];
                if (!col.getObjectID().equals(colId)) continue;
                this.selectedClusterColumnsModel.addElement(col);
                continue block3;
            }
        }
        for (int i = 0; i < columnSet.length; ++i) {
            ColumnProxy col = columnSet[i];
            if (this.selectedClusterColumnsModel.contains(col)) continue;
            this.allClusterColumnsModel.addElement(col);
        }
        if (this.partList != null) {
            this.cbPartType.setSelectedItem(this.partList.getPartitionType());
            this.ifHashPQuantity.setValue((long)this.partList.getHashPQuantity());
            this.ifSubPartQuantity.setValue((long)this.partList.getSubPartitionsQuantity());
            this.cbUseSubpartitionsStorageTemplate.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.partList.getUseSubpartStorageTemplate()));
            this.reinitPartitioning(true);
        } else {
            this.ifHashPQuantity.setValue(1L);
            this.ifSubPartQuantity.setValue(1L);
            this.cbUseSubpartitionsStorageTemplate.setSelectedItem(NO);
        }
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        if (this.table.getTemporary().equals("NO")) {
            this.cbTemporary.setSelectedItem(NO);
        } else if (this.table.getTempPreserveRows().equals("YES")) {
            this.cbTemporary.setSelectedItem(YES_PRESERVE);
        } else {
            this.cbTemporary.setSelectedItem(YES_DELETE);
        }
        this.cbParallel.setSelectedItem(TablePropertyDialogOraclev9i.translateYesNoForDisplay(this.table.getParallel()));
        this.ifDegree.setText(this.table.getDegree());
        if (this.cbSnapshot.getSelectedItem() != null) {
            this.snapshotChanged();
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            String commentText;
            boolean result;
            this.table.setName(this.tfName.getText());
            Object selected = this.cbUser.getSelectedItem();
            if (selected instanceof UserOracle) {
                this.table.setUser((UserOracle)selected);
            } else {
                this.table.setUser(null);
            }
            if (this.cbTemporary.getSelectedItem().equals(NO)) {
                this.table.setTemporary("NO");
            } else {
                this.table.setTemporary("YES");
                if (this.cbTemporary.getSelectedItem().equals(YES_PRESERVE)) {
                    this.table.setTempPreserveRows("YES");
                } else {
                    this.table.setTempPreserveRows("NO");
                }
            }
            selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.table.setTableSpace((TableSpaceOracle)selected);
            } else {
                this.table.setTableSpace(null);
            }
            this.table.setOrganization((String)this.cbOrganization.getSelectedItem());
            selected = this.cbCluster.getSelectedItem();
            if (selected instanceof ClusterOracle) {
                this.table.setCluster((ClusterOracle)selected);
            } else {
                this.table.setCluster(null);
            }
            this.table.setLogging(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOracle) {
                this.table.setSegment((SegmentOracle)selected);
            } else {
                this.table.setSegment(null);
            }
            this.table.setCache(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbCache.getSelectedItem()));
            this.table.setMonitoring(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbMonitoring.getSelectedItem()));
            this.table.setParallel(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.table.setDegree(this.ifDegree.getText());
            this.table.setRowDependency(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbRowDependency.getSelectedItem()));
            this.table.setPartitioned(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.table.setParttitionedRowMovement((String)this.cbPartRowMovement.getSelectedItem());
            this.table.setDataSegmentCompression(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDataSegmentCompression.getSelectedItem()));
            this.table.setIotCompress(this.ifIotCompress.getIntValue());
            this.table.setIotPctThreshold(this.ifIotPctThreshold.getIntValue());
            selected = this.cbIotIncluding.getSelectedItem();
            if (selected instanceof ColumnProxy) {
                this.table.setIotIncluding((ColumnProxy)selected);
            } else {
                this.table.setIotIncluding(null);
            }
            selected = this.cbIotOverflowTablespace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.table.setIotOverflowTablespace((TableSpaceOracle)selected);
            } else {
                this.table.setIotOverflowTablespace(null);
            }
            this.table.setIotOverflowLogging(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbIotOverflowLogging.getSelectedItem()));
            selected = this.cbIotOverflowSegment.getSelectedItem();
            if (selected instanceof SegmentOracle) {
                this.table.setIotOverflowSegment((SegmentOracle)selected);
            } else {
                this.table.setIotOverflowSegment(null);
            }
            this.table.setIOTMappingTable(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbIotMappingTable.getSelectedItem()));
            selected = this.cbSnapshot.getSelectedItem();
            if (selected instanceof SnapshotOracle) {
                this.table.setSnapshot((SnapshotOracle)selected);
            } else {
                this.table.setSnapshot(null);
            }
            Object[] supplementalColumnSet = this.selectedSupplementalColumnsModel.toArray();
            this.table.clearSuplementalLogColumns();
            for (int i = 0; i < supplementalColumnSet.length; ++i) {
                Object ob = supplementalColumnSet[i];
                if (!(ob instanceof ColumnProxy)) continue;
                this.table.setSuplementalLogColumns(((ColumnProxy)ob).getObjectID());
            }
            this.table.setSuplementalLogGroupName(this.tfSupplementalLogGroupName.getText());
            this.table.setSuplementalLogConditions((String)this.cbSupplementalLogCondition.getSelectedItem());
            Object[] columnSet = this.selectedClusterColumnsModel.toArray();
            this.table.clear();
            for (int i = 0; i < columnSet.length; ++i) {
                Object ob = columnSet[i];
                if (!(ob instanceof ColumnProxy)) continue;
                this.table.setClusterColumns(((ColumnProxy)ob).getObjectID());
            }
            this.table.setOidIndexName(this.tfOidIndexName.getText());
            this.table.setOidIndexSegment((SegmentOracle)this.cbOidIndexSegment.getSelectedItem());
            this.table.setXmlSchemaUrl(this.tfXmlSchemaUrl.getText());
            this.table.setXmlSchemaElement(this.tfXmlSchemaElement.getText());
            String storeAs = (String)this.cbStoreAs.getSelectedItem();
            this.table.setStoreAs(storeAs);
            if (!storeAs.equalsIgnoreCase("OBJECT RELATIONAL")) {
                this.table.setLobSegmentName(this.tfLobSegmentName.getText());
                selected = this.cbXmlTypeTableSpace.getSelectedItem();
                if (selected instanceof TableSpaceOraclev9i) {
                    this.table.setXmlTypeTableSpace((TableSpaceOraclev9i)selected);
                } else {
                    this.table.setXmlTypeTableSpace(null);
                }
                this.table.setStorageInRow((String)this.cbStorageInRow.getSelectedItem());
                this.table.setXmlTypeLogging(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbXmlTypeLogging.getSelectedItem()));
                this.table.setXmlTypeCache((String)this.cbXmlTypeCache.getSelectedItem());
                this.table.setChunk(this.ifChunk.getIntValue());
                this.table.setOldVersions((String)this.cbOldVersions.getSelectedItem());
                this.table.setFreepools(this.ifFreePools.getIntValue());
                this.table.setPCTVersion(this.ifPctVersion.getIntValue());
            }
            if (result = String.valueOf(selected = this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(YES)) {
                Object ts;
                int i;
                if (this.partList == null) {
                    this.partList = (PartitionListOraclev9i)this.getStorageDesign().getPartitionListSet().createPartitionList();
                }
                this.partList.setPartitionType((String)this.cbPartType.getSelectedItem());
                this.partList.setUseSubpartStorageTemplate(TablePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbUseSubpartitionsStorageTemplate.getSelectedItem()));
                this.partList.setHashPQuantity(this.ifHashPQuantity.getIntValue());
                this.partList.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
                this.table.setPartitionList(this.partList);
                this.partList.clear();
                columnSet = this.selectedColumnsModel.toArray();
                for (int i2 = 0; i2 < columnSet.length; ++i2) {
                    Object ob = columnSet[i2];
                    if (!(ob instanceof ColumnProxyOraclev9i)) continue;
                    this.partList.setColumnIDs(((ColumnProxyOraclev9i)ob).getObjectID());
                }
                Object[] tsSet = this.selectedHashPTSModel.toArray();
                for (int i3 = 0; i3 < tsSet.length; ++i3) {
                    Object ts2 = tsSet[i3];
                    if (!(ts2 instanceof TableSpaceOraclev9i)) continue;
                    this.partList.setHashPTableSpaces(((TableSpaceOraclev9i)ts2).getObjectID());
                }
                Object[] tsIOTSet = this.selectedIOTOverflowHashPTSModel.toArray();
                for (i = 0; i < tsIOTSet.length; ++i) {
                    ts = tsIOTSet[i];
                    if (!(ts instanceof TableSpaceOraclev9i)) continue;
                    this.partList.setIOTOverflowHashPTSSet(((TableSpaceOraclev9i)ts).getObjectID());
                }
                columnSet = this.selectedSubPartColumnsModel.toArray();
                for (i = 0; i < columnSet.length; ++i) {
                    Object ob = columnSet[i];
                    if (!(ob instanceof RelationalObjectProxy)) continue;
                    this.partList.setSubPartitionsColumnIDs(((RelationalObjectProxy)ob).getObjectID());
                }
                tsSet = this.selectedSubPartTSModel.toArray();
                for (i = 0; i < tsSet.length; ++i) {
                    ts = tsSet[i];
                    if (!(ts instanceof TableSpaceOraclev9i)) continue;
                    this.partList.setSubPartitionsTableSpaces(((TableSpaceOraclev9i)ts).getObjectID());
                }
                if (this.ordered && this.table.getPartitions().size() == this.partitions.size()) {
                    this.ordered = false;
                    int size = this.table.getPartitions().size();
                    for (int i4 = 0; i4 < size; ++i4) {
                        this.table.getPartitions().justRemove(this.table.getPartitions().getElement(0));
                    }
                    for (int i5 = 0; i5 < this.partitions.size(); ++i5) {
                        if (this.partitions.get(i5) instanceof PartitionOracle) {
                            PartitionOracle p = (PartitionOracle)this.partitions.get(i5);
                            p.addObjectListener(this.table);
                            p.setParent(this.table.getPartitions());
                            this.table.getPartitions().add(p);
                            p.setPosition(i5 + 1);
                            continue;
                        }
                        this.table.getPartitions().add((ModelObject)this.partitions.get(i5));
                    }
                }
            } else if (this.partList != null) {
                this.table.setPartitionList(null);
                this.partList.remove();
                this.partList = null;
            }
            if (StringUtilities.isNotEmpty(commentText = this.getCommentsList().getText()) && !this.comment.equals(commentText)) {
                this.table.setComment(commentText);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equals(commentInRDBMSText)) {
                this.table.setCommentInRDBMS(commentInRDBMSText);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
        }
    }

    private void snapshotChanged() {
        boolean enable = this.cbSnapshot.getSelectedItem() == null;
        this.tfName.setEnabled(enable);
        this.cbUser.setEnabled(enable);
        this.cbTemporary.setEnabled(enable);
        this.cbTableSpace.setEnabled(enable);
        this.cbCluster.setEnabled(enable);
        this.cbLogging.setEnabled(enable);
        this.cbCache.setEnabled(enable);
        this.cbMonitoring.setEnabled(enable);
        this.cbParallel.setEnabled(enable);
        this.ifDegree.setEnabled(enable);
        this.cbPartRowMovement.setEnabled(enable);
        this.cbDataSegmentCompression.setEnabled(enable);
        this.bnPermissions.setEnabled(enable);
        try {
            this.getPane().setEnabledAt(1, enable);
            this.getPane().setEnabledAt(3, enable);
            this.getPane().setEnabledAt(4, enable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean moveToIndex(Object object, int index) {
        if (this.partitions.contains(object) && this.partitions.size() > index && index >= 0) {
            this.partitions.remove(object);
            this.partitions.add(index, object);
            return true;
        }
        return false;
    }

    private void setSelection(DefaultListSelectionModel selModel, int[] selection) {
        selModel.clearSelection();
        if (selection.length > 0) {
            for (int i = selection.length - 1; i > -1; --i) {
                selModel.addSelectionInterval(selection[i], selection[i]);
            }
        }
    }

    @Override
    protected void postProcessingInApply() {
        if (this.table != null) {
            this.table.getPartitions().setForbiddenCreateElement(true);
        }
    }

    @Override
    protected void clearOnDispose() {
        if (this.table != null) {
            this.table.getPartitions().setForbiddenCreateElement(!"YES".equals(this.table.getPartitioned()) || this.table.getPartitionList() == null || "HASH BY QUANTITY".equalsIgnoreCase(this.table.getPartitionList().getPartitionType()));
        }
    }

    private class MoveDownAction2
    implements ActionListener {
        private MoveDownAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = TablePropertyDialogOraclev9i.this.partitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < TablePropertyDialogOraclev9i.this.partitions.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = TablePropertyDialogOraclev9i.this.partitions.get(objectNumber);
                    TablePropertyDialogOraclev9i.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                TablePropertyDialogOraclev9i.this.setSelection(TablePropertyDialogOraclev9i.this.partSelectionModel, selection);
                TablePropertyDialogOraclev9i.this.ordered = true;
                TablePropertyDialogOraclev9i.this.partitionsOrderTable.updateUI();
            }
        }
    }

    private class MoveUpAction2
    implements ActionListener {
        private MoveUpAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = TablePropertyDialogOraclev9i.this.partitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = TablePropertyDialogOraclev9i.this.partitions.get(objectNumber);
                    TablePropertyDialogOraclev9i.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                TablePropertyDialogOraclev9i.this.setSelection(TablePropertyDialogOraclev9i.this.partSelectionModel, selection);
                TablePropertyDialogOraclev9i.this.ordered = true;
                TablePropertyDialogOraclev9i.this.partitionsOrderTable.updateUI();
            }
        }
    }

    private class PartitionsOrderModel
    extends AbstractTableModel {
        private PartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (TablePropertyDialogOraclev9i.this.partitions == null) {
                return 0;
            }
            return TablePropertyDialogOraclev9i.this.partitions.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TablePropertyDialogOracle.PartitionName");
            }
            if (column == 1) {
                return Messages.getString("TablePropertyDialogOracle.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StorageObject sel = (StorageObject)TablePropertyDialogOraclev9i.this.partitions.get(row);
            if (col == 0) {
                return sel.getName();
            }
            if (col == 1) {
                if (sel instanceof PartitionOracle) {
                    return ((PartitionOracle)sel).getValueList();
                }
                if (sel instanceof ListPartitionOracle) {
                    return ((ListPartitionOracle)sel).getColumns();
                }
                return "";
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.selectedSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.allSubPartTSModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.allSubPartTSModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.selectedSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.allSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.selectedSubPartTSModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.selectedSubPartTSModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.allSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.allSubPartTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class RemoveSubPartColumnsActionListener
    implements ActionListener {
        private RemoveSubPartColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.selectedSubPartColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddSubPartColumnsActionListener
    implements ActionListener {
        private AddSubPartColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.allSubPartColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedSubPartColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedSubPartColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemoveSubPartColumns.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemoveSubPartColumns.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (((String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem()).equalsIgnoreCase("LIST") || ((String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem()).equalsIgnoreCase("COMPOSITE BY LIST")) {
                    if (TablePropertyDialogOraclev9i.this.allSubPartColumnsList.getSelectedIndex() == -1 || TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.toArray().length >= 1) {
                        TablePropertyDialogOraclev9i.this.bnAddSubPartColumns.setEnabled(false);
                    } else {
                        TablePropertyDialogOraclev9i.this.bnAddSubPartColumns.setEnabled(true);
                    }
                } else if (TablePropertyDialogOraclev9i.this.allSubPartColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAddSubPartColumns.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAddSubPartColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveSupplementalColumnsActionListener
    implements ActionListener {
        private RemoveSupplementalColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.allSupplementalColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.allSupplementalColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddSupplementalColumnsActionListener
    implements ActionListener {
        private AddSupplementalColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.allSupplementalColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.allSupplementalColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.allSupplementalColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.allColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.allColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.selectedColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.selectedColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedListSupplementalSelectionHandler
    implements ListSelectionListener {
        private SelectedListSupplementalSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedSupplementalColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnSupplementalRemove.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnSupplementalRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSupplementalSelectionHandler
    implements ListSelectionListener {
        private AllListSupplementalSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.allSupplementalColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnSupplementalAdd.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnSupplementalAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemove.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (((String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem()).equalsIgnoreCase("LIST") || ((String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem()).equalsIgnoreCase("COMPOSITE BY LIST")) {
                    if (TablePropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1 || TablePropertyDialogOraclev9i.this.selectedColumnsModel.toArray().length >= 1) {
                        TablePropertyDialogOraclev9i.this.bnAdd.setEnabled(false);
                    } else {
                        TablePropertyDialogOraclev9i.this.bnAdd.setEnabled(TablePropertyDialogOraclev9i.this.isEditable());
                    }
                } else if (TablePropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAdd.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAdd.setEnabled(TablePropertyDialogOraclev9i.this.isEditable());
                }
            }
        }
    }

    private class RemoveIOTOverflowHashPTSActionListener
    implements ActionListener {
        private RemoveIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AddIOTOverflowHashPTSActionListener
    implements ActionListener {
        private AddIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemoveIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.allIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAddIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class RemoveHashPTSActionListener
    implements ActionListener {
        private RemoveHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.selectedHashPTSModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.selectedHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.allHashPTSModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.allHashPTSModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.selectedHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AddHashPTSActionListener
    implements ActionListener {
        private AddHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.allHashPTSModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.allHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.selectedHashPTSModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.selectedHashPTSModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.allHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.selectedHashPTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnRemoveHashPTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnRemoveHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev9i.this.allHashPTSList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev9i.this.bnAddHashPTS.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.bnAddHashPTS.setEnabled(true);
                }
            }
        }
    }

    public class PartitionTypeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String type = (String)TablePropertyDialogOraclev9i.this.cbPartType.getSelectedItem();
            TablePropertyDialogOraclev9i.this.allColumnsList.getSelectionModel().clearSelection();
            TablePropertyDialogOraclev9i.this.allSubPartColumnsList.getSelectionModel().clearSelection();
            if (type.equalsIgnoreCase("LIST") && TablePropertyDialogOraclev9i.this.selectedColumnsModel.toArray().length > 1) {
                TablePropertyDialogOraclev9i.this.allColumnsModel.clear();
                TablePropertyDialogOraclev9i.this.selectedColumnsModel.clear();
                TablePropertyDialogOraclev9i.this.initPartColumns(TablePropertyDialogOraclev9i.this.partList);
            }
            if (type.equalsIgnoreCase("COMPOSITE BY LIST") && TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.toArray().length > 1) {
                TablePropertyDialogOraclev9i.this.allSubPartColumnsModel.clear();
                TablePropertyDialogOraclev9i.this.selectedSubPartColumnsModel.clear();
                TablePropertyDialogOraclev9i.this.initSubPartColumns(TablePropertyDialogOraclev9i.this.partList);
            }
            TablePropertyDialogOraclev9i.this.enableRelevantPartitionFields(type);
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TablePropertyDialogOraclev9i.this.partitionsOrderTable.getSelectedRow();
            if (row > -1 && row < TablePropertyDialogOraclev9i.this.partitions.size()) {
                StorageObject selected = (StorageObject)TablePropertyDialogOraclev9i.this.partitions.get(row);
                selected.showPropertyDialog();
            }
        }
    }

    private class RemoveClusterColumnsActionListener
    implements ActionListener {
        private RemoveClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.selectedClusterColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.allClusterColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.allClusterColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.selectedClusterColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddClusterColumnsActionListener
    implements ActionListener {
        private AddClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.allClusterColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev9i.this.allClusterColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev9i.this.selectedClusterColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev9i.this.selectedClusterColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev9i.this.allClusterColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private SelectedClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class AllClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private AllClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.allClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class VersionListener
    implements ActionListener {
        private VersionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev9i.this.ifPctVersion.setEnabled(TablePropertyDialogOraclev9i.this.cbOldVersions.getSelectedItem().equals("PCT_VERSION"));
        }
    }

    private class StoreAsListener
    implements ActionListener {
        private StoreAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean objectRelational = TablePropertyDialogOraclev9i.this.cbStoreAs.getSelectedItem().equals("OBJECT RELATIONAL");
            TablePropertyDialogOraclev9i.this.enableXMLTypeClobOptions(!objectRelational);
        }
    }

    private class PartitionedAction
    implements ActionListener {
        private PartitionedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean partitioned = ((String)TablePropertyDialogOraclev9i.this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(AbstractPropertyDialog.YES);
            int partitionedTabIndex = TablePropertyDialogOraclev9i.this.getPane().indexOfComponent(TablePropertyDialogOraclev9i.this.pnPartitioning);
            if (partitionedTabIndex > -1) {
                TablePropertyDialogOraclev9i.this.getPane().setEnabledAt(partitionedTabIndex, partitioned);
            }
            TablePropertyDialogOraclev9i.this.reinitPartitioning(partitioned);
        }
    }

    private class ParallelListener
    implements ActionListener {
        private ParallelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev9i.this.ifDegree.setEnabled(TablePropertyDialogOraclev9i.this.cbParallel.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }

    private class OrganizationListener
    implements ActionListener {
        private OrganizationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String organization = (String)TablePropertyDialogOraclev9i.this.cbOrganization.getSelectedItem();
            if (organization != null) {
                boolean indexOrg = organization.equalsIgnoreCase("INDEX");
                TablePropertyDialogOraclev9i.this.cbCache.setEnabled(!indexOrg);
                TablePropertyDialogOraclev9i.this.ifIotCompress.setEnabled(indexOrg);
                TablePropertyDialogOraclev9i.this.ifIotPctThreshold.setEnabled(indexOrg);
                TablePropertyDialogOraclev9i.this.cbIotIncluding.setEnabled(indexOrg);
                TablePropertyDialogOraclev9i.this.cbIotOverflowTablespace.setEnabled(indexOrg);
                TablePropertyDialogOraclev9i.this.cbIotOverflowLogging.setEnabled(indexOrg);
                TablePropertyDialogOraclev9i.this.cbIotOverflowSegment.setEnabled(indexOrg);
                TablePropertyDialogOraclev9i.this.cbIotMappingTable.setEnabled(indexOrg);
            }
        }
    }

    private class ClusterListener
    implements ActionListener {
        private ClusterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(true);
                TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.allClusterColumnsList.getSelectedIndex() != -1);
                TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class TemporaryListener
    implements ActionListener {
        private TemporaryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev9i.this.cbTemporary.getSelectedItem().equals(AbstractPropertyDialog.NO)) {
                TablePropertyDialogOraclev9i.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbCluster.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbPartitioned.setSelectedItem(AbstractPropertyDialog.NO);
                TablePropertyDialogOraclev9i.this.cbPartitioned.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbTableSpace.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbPartRowMovement.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbLogging.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbMonitoring.setEnabled(false);
                TablePropertyDialogOraclev9i.this.cbParallel.setEnabled(false);
                TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev9i.this.cbCluster.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbPartitioned.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbTableSpace.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbPartRowMovement.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbLogging.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbMonitoring.setEnabled(true);
                TablePropertyDialogOraclev9i.this.cbParallel.setEnabled(true);
                if (TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev9i.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                    TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev9i.this.cbOrganization.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.cbSegment.setEnabled(false);
                    TablePropertyDialogOraclev9i.this.allClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev9i.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.allClusterColumnsList.getSelectedIndex() != -1);
                    TablePropertyDialogOraclev9i.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev9i.this.selectedClusterColumnsList.getSelectedIndex() != -1);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(TablePropertyDialogOraclev9i.this.getAppView(), TablePropertyDialogOraclev9i.this.getStorageDesign(), TablePropertyDialogOraclev9i.this.table);
            TablePropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }
}

