/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TableSpacePropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private TableSpaceOraclev9i tableSpace;
    private JTextField tfDatafiles;
    private JComboBox cbFileType;
    private JIntegerField ifMinExtLen;
    private JComboBox cbLogging;
    private JComboBox cbForceLogging;
    private JComboBox cbStatus;
    private JComboBox cbContents;
    private JComboBox cbCompression;
    private JIntegerField ifDSInitialExtent;
    private JIntegerField ifDSNextExtent;
    private JIntegerField ifDSMinExtents;
    private JTextField tfDSMaxExtents;
    private JIntegerField ifDSPctIncrease;
    private JComboBox cbExtentManagement;
    private JComboBox cbEMLocalSubType;
    private JIntegerField ifEMUniformSize;
    private JIntegerField ifBlockSize;
    private JComboBox cbSegmentManagement;
    private JComboBox cbFlashbackMode;
    private JPanel defaultStorage;
    private JPanel clusters;
    private DefaultListModel clusterListModel;
    private JList clusterList;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel indexes;
    private DefaultListModel indexListModel;
    private JList indexList;
    private JPanel snapshots;
    private DefaultListModel snapshotListModel;
    private JList snapshotList;
    private JPanel segments;
    private DefaultListModel segmentListModel;
    private JList segmentList;

    public TableSpacePropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.tableSpace = (TableSpaceOraclev9i)object;
        this.setHeight(580);
        this.initCommentsView(510);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableSpacePropertyDialogOracle.TableSpaceProperties");
    }

    @Override
    protected void initGeneralView() {
        int yIncr = 0;
        super.initGeneralView();
        this.initDataFiles();
        if (this.getStorageObject() instanceof TableSpaceOraclev10g) {
            this.initFileType(80);
            yIncr = 30;
        }
        this.initMinExtLen(80 + yIncr);
        this.initBlockSize(110 + yIncr);
        this.initLogging(140 + yIncr);
        this.initForceLogging(170 + yIncr);
        this.initStatus(200 + yIncr);
        this.initContents(230 + yIncr);
        if (this.getStorageObject() instanceof TableSpaceOraclev10g) {
            this.initCompression(260 + yIncr);
            yIncr += 30;
        }
        this.initExtentManagement(260 + yIncr);
        this.initEMLocalSubType(290 + yIncr);
        this.initEMUniformSize(320 + yIncr);
        this.initSegmentManagement(350 + yIncr);
        if (this.getStorageObject() instanceof TableSpaceOraclev10g) {
            this.initFlashbackMode(380 + yIncr);
            yIncr += 30;
        }
        if (this.isEditable()) {
            this.initPropagatePropsButton(390 + yIncr);
        }
    }

    private void initDataFiles() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.Datafiles"));
        this.general.add(label);
        this.tfDatafiles = new JTextField("", 26);
        this.tfDatafiles.setEnabled(false);
        this.general.add(this.tfDatafiles);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDatafiles, 50);
    }

    private void initFileType(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.FileType"));
        this.general.add(label);
        this.cbFileType = new JComboBox<String>(TableSpaceOraclev10g.getFileTypes());
        this.setBG(this.cbFileType);
        this.cbFileType.addActionListener(new FileTypeListener());
        this.cbFileType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFileType);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbFileType, ycoord);
    }

    private void initMinExtLen(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.MinExtLen"));
        this.general.add(label);
        this.ifMinExtLen = new JIntegerField(0, 26);
        this.general.add(this.ifMinExtLen);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.ifMinExtLen, ycoord);
    }

    private void initBlockSize(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.BlockSize"));
        this.general.add(label);
        this.ifBlockSize = new JIntegerField(0, 26);
        this.general.add(this.ifBlockSize);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.ifBlockSize, ycoord);
    }

    private void initLogging(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(TableSpaceOracle.getLogStates());
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbLogging, ycoord);
    }

    private void initForceLogging(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.ForceLogging"));
        this.general.add(label);
        this.cbForceLogging = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForceLogging);
        this.cbForceLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForceLogging);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbForceLogging, ycoord);
    }

    private void initStatus(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.Status"));
        this.general.add(label);
        this.cbStatus = new JComboBox<String>(TableSpaceOracle.getStatusStates());
        this.setBG(this.cbStatus);
        this.cbStatus.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStatus);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbStatus, ycoord);
    }

    private void initContents(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.Contents"));
        this.general.add(label);
        this.cbContents = new JComboBox<String>(TableSpaceOracle.getContentsStates());
        this.setBG(this.cbContents);
        this.cbContents.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbContents);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbContents, ycoord);
    }

    private void initCompression(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.DefaultCompression"));
        this.general.add(label);
        this.cbCompression = new JComboBox<String>(TableSpaceOraclev10g.getDSCompressionStates());
        this.setBG(this.cbCompression);
        this.cbCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompression);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbCompression, ycoord);
    }

    private void initSCInitialExtent() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.DSInitialExtent"));
        this.defaultStorage.add(label);
        this.ifDSInitialExtent = new JIntegerField(0, 26);
        this.defaultStorage.add(this.ifDSInitialExtent);
        this.setLabelConstraints(this.getDefaultStorageLayout(), label, 20);
        this.setObjectConstraints(this.getDefaultStorageLayout(), this.ifDSInitialExtent, 20);
    }

    private void initSCNextExtent() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.DSNextExtent"));
        this.defaultStorage.add(label);
        this.ifDSNextExtent = new JIntegerField(0, 26);
        this.defaultStorage.add(this.ifDSNextExtent);
        this.setLabelConstraints(this.getDefaultStorageLayout(), label, 50);
        this.setObjectConstraints(this.getDefaultStorageLayout(), this.ifDSNextExtent, 50);
    }

    private void initSCMinExtents() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.DSMinExtents"));
        this.defaultStorage.add(label);
        this.ifDSMinExtents = new JIntegerField(0, 26);
        this.defaultStorage.add(this.ifDSMinExtents);
        this.setLabelConstraints(this.getDefaultStorageLayout(), label, 80);
        this.setObjectConstraints(this.getDefaultStorageLayout(), this.ifDSMinExtents, 80);
    }

    private void initSCMaxExtents() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.DSMaxExtents"));
        this.defaultStorage.add(label);
        this.tfDSMaxExtents = new JTextField("UNLIMITED", 26);
        this.defaultStorage.add(this.tfDSMaxExtents);
        this.setLabelConstraints(this.getDefaultStorageLayout(), label, 110);
        this.setObjectConstraints(this.getDefaultStorageLayout(), this.tfDSMaxExtents, 110);
    }

    private void initSCPctIncrease() {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.DSPCTIncrease"));
        this.defaultStorage.add(label);
        this.ifDSPctIncrease = new JIntegerField(0, 26);
        this.defaultStorage.add(this.ifDSPctIncrease);
        this.setLabelConstraints(this.getDefaultStorageLayout(), label, 140);
        this.setObjectConstraints(this.getDefaultStorageLayout(), this.ifDSPctIncrease, 140);
    }

    private void initExtentManagement(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.ExtManagement"));
        this.general.add(label);
        this.cbExtentManagement = new JComboBox<String>(TableSpaceOracle.getExtManageStates());
        this.setBG(this.cbExtentManagement);
        this.cbExtentManagement.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtentManagement);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbExtentManagement, ycoord);
    }

    private void initEMLocalSubType(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.EMLocalSubType"));
        this.general.add(label);
        this.cbEMLocalSubType = new JComboBox<String>(TableSpaceOracle.getEmLocalSubtypeStates());
        this.setBG(this.cbEMLocalSubType);
        this.cbEMLocalSubType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEMLocalSubType);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbEMLocalSubType, ycoord);
    }

    private void initEMUniformSize(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.EMUniformSize"));
        this.general.add(label);
        this.ifEMUniformSize = new JIntegerField(0, 26);
        this.general.add(this.ifEMUniformSize);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.ifEMUniformSize, ycoord);
    }

    private void initSegmentManagement(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.SegManagement"));
        this.general.add(label);
        this.cbSegmentManagement = new JComboBox<String>(TableSpaceOraclev9i.getSegManageStates());
        this.setBG(this.cbSegmentManagement);
        this.cbSegmentManagement.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegmentManagement);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbSegmentManagement, ycoord);
    }

    private void initFlashbackMode(int ycoord) {
        JLabel label = new JLabel(Messages.getString("TableSpacePropertyDialogOracle.FlashbackMode"));
        this.general.add(label);
        this.cbFlashbackMode = new JComboBox<String>(TableSpaceOraclev10g.getFlashBackChoices());
        this.setBG(this.cbFlashbackMode);
        this.cbFlashbackMode.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFlashbackMode);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbFlashbackMode, ycoord);
    }

    private void initPropagatePropsButton(int ycoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("TableSpacePropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TableSpacePropertyDialogOraclev9i.this.getStorageDesign().getTableSpaceSet().getElementsList());
                list.remove(TableSpacePropertyDialogOraclev9i.this.tableSpace);
                new PropertiesPropagationDialog(TableSpacePropertyDialogOraclev9i.this.getAppView(), TableSpacePropertyDialogOraclev9i.this.tableSpace, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, ycoord);
    }

    @Override
    protected void addTabs() {
        this.initDefaultStorageView();
        this.initClustersView();
        this.initTablesView();
        this.initIndexesView();
        this.initSegmentsView();
        this.initSnapshotsView();
    }

    private void initDefaultStorageView() {
        this.defaultStorage = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogOracle.DefaultStorage"), this.defaultStorage);
        this.initDefaultStorage();
    }

    private SpringLayout getDefaultStorageLayout() {
        return (SpringLayout)this.defaultStorage.getLayout();
    }

    private void initDefaultStorage() {
        this.initSCInitialExtent();
        this.initSCNextExtent();
        this.initSCMinExtents();
        this.initSCMaxExtents();
        this.initSCPctIncrease();
    }

    private void initClustersView() {
        this.clusters = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogOracle.Clusters"), this.clusters);
        this.initClusters();
    }

    private void initClusters() {
        this.clusterListModel = new DefaultListModel();
        this.clusterList = new JList(this.clusterListModel);
        this.clusterList.addMouseListener(new ClusterListMouseListener());
        JScrollPane spTS = new JScrollPane(this.clusterList);
        spTS.setPreferredSize(new Dimension(395, 510));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusters.add(spTS);
        this.setObjectConstraints(this.getClusterLayout(), spTS, 10, 12);
    }

    protected SpringLayout getClusterLayout() {
        return (SpringLayout)this.clusters.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogOracle.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tableList);
        spTS.setPreferredSize(new Dimension(395, 510));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTableLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogOracle.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexListModel = new DefaultListModel();
        this.indexList = new JList(this.indexListModel);
        this.indexList.addMouseListener(new IndexListMouseListener());
        JScrollPane spTS = new JScrollPane(this.indexList);
        spTS.setPreferredSize(new Dimension(395, 510));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(spTS);
        this.setObjectConstraints(this.getIndexLayout(), spTS, 10, 12);
    }

    protected SpringLayout getIndexLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initSnapshotsView() {
        this.snapshots = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogOracle.Snapshots"), this.snapshots);
        this.initSnapshots();
    }

    private void initSnapshots() {
        this.snapshotListModel = new DefaultListModel();
        this.snapshotList = new JList(this.snapshotListModel);
        this.snapshotList.addMouseListener(new SnapshotListMouseListener());
        JScrollPane spTS = new JScrollPane(this.snapshotList);
        spTS.setPreferredSize(new Dimension(395, 510));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.snapshots.add(spTS);
        this.setObjectConstraints(this.getSnapshotLayout(), spTS, 10, 12);
    }

    protected SpringLayout getSnapshotLayout() {
        return (SpringLayout)this.snapshots.getLayout();
    }

    private void initSegmentsView() {
        this.segments = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogOracle.Segments"), this.segments);
        this.initSegments();
    }

    private void initSegments() {
        this.segmentListModel = new DefaultListModel();
        this.segmentList = new JList(this.segmentListModel);
        this.segmentList.addMouseListener(new SegmentListMouseListener());
        JScrollPane spTS = new JScrollPane(this.segmentList);
        spTS.setPreferredSize(new Dimension(395, 510));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.segments.add(spTS);
        this.setObjectConstraints(this.getSegmentLayout(), spTS, 10, 12);
    }

    protected SpringLayout getSegmentLayout() {
        return (SpringLayout)this.segments.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.tableSpace.getName());
        this.tfName.setText(this.tableSpace.getName());
        this.tfDatafiles.setText(this.tableSpace.getManagedFiles());
        this.ifMinExtLen.setValue((long)this.tableSpace.getMinExtLen());
        this.ifBlockSize.setValue((long)this.tableSpace.getBlockSize());
        this.cbLogging.setSelectedItem(this.tableSpace.getLogging());
        this.cbForceLogging.setSelectedItem(TableSpacePropertyDialogOraclev9i.translateYesNoForDisplay(this.tableSpace.getForceLogging()));
        this.cbStatus.setSelectedItem(this.tableSpace.getStatus());
        this.cbContents.setSelectedItem(this.tableSpace.getContents());
        this.ifDSInitialExtent.setValue(this.tableSpace.getDSInitialExtent());
        this.ifDSNextExtent.setValue(this.tableSpace.getDSNextExtent());
        this.ifDSMinExtents.setValue((long)this.tableSpace.getDSMinExtents());
        this.tfDSMaxExtents.setText(this.tableSpace.getDSMaxExtents());
        this.ifDSPctIncrease.setValue((long)this.tableSpace.getDSPctIncrease());
        this.cbExtentManagement.setSelectedItem(this.tableSpace.getExtentManagement());
        this.cbSegmentManagement.setSelectedItem(this.tableSpace.getSegmentManagement());
        this.cbEMLocalSubType.setSelectedItem(this.tableSpace.getEMLocalSubtype());
        this.ifEMUniformSize.setValue((long)this.tableSpace.getEMUniformSize());
        if (this.tableSpace instanceof TableSpaceOraclev10g) {
            TableSpaceOraclev10g tableSpace10g = (TableSpaceOraclev10g)this.tableSpace;
            this.cbFileType.setSelectedItem(tableSpace10g.getFileType());
            this.cbCompression.setSelectedItem(tableSpace10g.getDSCompression());
            this.cbFlashbackMode.setSelectedItem(tableSpace10g.getFlashBack());
        }
        Object[] cluster = this.getStorageDesign().getClusterSet().toArray();
        for (int i = 0; i < cluster.length; ++i) {
            if (((ClusterOracle)cluster[i]).getTableSpace() != this.tableSpace) continue;
            this.clusterListModel.addElement(cluster[i]);
        }
        Object[] table = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < table.length; ++i) {
            if (((TableProxyOracle)table[i]).getTableSpace() != this.tableSpace) continue;
            this.tableListModel.addElement(table[i]);
        }
        Object[] index = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < index.length; ++i) {
            if (((IndexProxyOracle)index[i]).getTableSpace() != this.tableSpace) continue;
            this.indexListModel.addElement(index[i]);
        }
        Object[] snapshot = this.getStorageDesign().getSnapshotSet().toArray();
        for (int i = 0; i < snapshot.length; ++i) {
            if (((SnapshotOracle)snapshot[i]).getTablespace() != this.tableSpace) continue;
            this.snapshotListModel.addElement(snapshot[i]);
        }
        Object[] segment = this.getStorageDesign().getSegmentSet().toArray();
        for (int i = 0; i < segment.length; ++i) {
            if (((SegmentOracle)segment[i]).getTableSpace() != this.tableSpace) continue;
            this.segmentListModel.addElement(segment[i]);
        }
        this.getCommentsList().insert(this.tableSpace.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.tableSpace != null) {
            this.tableSpace.setName(this.tfName.getText());
            this.tableSpace.setMinExtLen(this.ifMinExtLen.getIntValue());
            this.tableSpace.setBlockSize(this.ifBlockSize.getIntValue());
            this.tableSpace.setLogging((String)this.cbLogging.getSelectedItem());
            this.tableSpace.setForceLogging(TableSpacePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbForceLogging.getSelectedItem()));
            this.tableSpace.setStatus((String)this.cbStatus.getSelectedItem());
            this.tableSpace.setContents((String)this.cbContents.getSelectedItem());
            this.tableSpace.setDSInitialExtent(this.ifDSInitialExtent.getIntValue());
            this.tableSpace.setDSNextExtent(this.ifDSNextExtent.getIntValue());
            this.tableSpace.setDSMinExtents(this.ifDSMinExtents.getIntValue());
            this.tableSpace.setDSMaxExtents(this.tfDSMaxExtents.getText());
            this.tfDSMaxExtents.setText(this.tableSpace.getDSMaxExtents());
            this.tableSpace.setDSPctIncrease(this.ifDSPctIncrease.getIntValue());
            this.tableSpace.setExtentManagement((String)this.cbExtentManagement.getSelectedItem());
            this.tableSpace.setSegmentManagement((String)this.cbSegmentManagement.getSelectedItem());
            this.tableSpace.setEMLocalSubtype((String)this.cbEMLocalSubType.getSelectedItem());
            this.tableSpace.setEMUniformSize(this.ifEMUniformSize.getIntValue());
            if (this.tableSpace instanceof TableSpaceOraclev10g) {
                TableSpaceOraclev10g tableSpace10g = (TableSpaceOraclev10g)this.tableSpace;
                tableSpace10g.setFileType((String)this.cbFileType.getSelectedItem());
                tableSpace10g.setDSCompression((String)this.cbCompression.getSelectedItem());
                tableSpace10g.setFlashBack((String)this.cbFlashbackMode.getSelectedItem());
            }
            this.tableSpace.setComment(this.getCommentsList().getText());
        }
    }

    private class SegmentListMouseListener
    extends MouseAdapter {
        private SegmentListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SegmentOracle selected;
            if (e.getClickCount() == 2 && (selected = (SegmentOracle)TableSpacePropertyDialogOraclev9i.this.segmentList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class SnapshotListMouseListener
    extends MouseAdapter {
        private SnapshotListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SnapshotOracle selected;
            if (e.getClickCount() == 2 && (selected = (SnapshotOracle)TableSpacePropertyDialogOraclev9i.this.snapshotList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        private IndexListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyOracle selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyOracle)TableSpacePropertyDialogOraclev9i.this.indexList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyOracle selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyOracle)TableSpacePropertyDialogOraclev9i.this.tableList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class ClusterListMouseListener
    extends MouseAdapter {
        private ClusterListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ClusterOracle selected;
            if (e.getClickCount() == 2 && (selected = (ClusterOracle)TableSpacePropertyDialogOraclev9i.this.clusterList.getSelectedValue()) != null) {
                selected.showPropertyDialog();
            }
        }
    }

    private class FileTypeListener
    implements ActionListener {
        private FileTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TableSpacePropertyDialogOraclev9i.this.cbFileType.getSelectedItem().equals("BIGFILE")) {
                TableSpacePropertyDialogOraclev9i.this.cbExtentManagement.setEnabled(TableSpacePropertyDialogOraclev9i.this.cbExtentManagement.getSelectedItem().equals("DICTIONARY"));
            } else {
                TableSpacePropertyDialogOraclev9i.this.cbExtentManagement.setEnabled(true);
            }
        }
    }
}

