/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class PKPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private PKProxySqlServer pkey;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfTable;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JIntegerField ifFillFactor;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;

    public PKPropertyDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.pkey = (PKProxySqlServer)object;
        this.setHeight(200);
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.initCommentsView(60);
        this.initCommentsInRDBMS();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("PKPropertyDialogSqlServer.PKProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initClustered();
        this.initFileGroup();
        this.initFillFactor();
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServer.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initClustered() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServer.Clustered"));
        this.general.add(label);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbClustered, 80);
    }

    private void initFileGroup() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServer.Filegroup"));
        this.general.add(label);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbFilegroup, 110);
    }

    private void initFillFactor() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServer.FillFactor"));
        this.general.add(label);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifFillFactor, 140);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogSqlServer.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.columnList);
        sp.setPreferredSize(new Dimension(395, 150));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initCommentsInRDBMS() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServer.CommentsInRDBMS"));
        this.comments.add(label);
        this.setLabelConstraints(this.getCommentsLayout(), label, 10, 80);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 60));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 100);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.pkey.getName());
        this.tfName.setText(this.pkey.getName());
        ColumnProxy[] proxies = this.pkey.getColumnProxies();
        for (int i = 0; i < proxies.length; ++i) {
            ColumnProxy proxy = proxies[i];
            this.columnListModel.addElement(proxy);
        }
        this.tfTable.setText(this.pkey.getTableName());
        if (this.pkey.isClustered()) {
            this.cbClustered.setSelectedItem(YES);
        } else {
            this.cbClustered.setSelectedItem(NO);
        }
        if (((TableProxySqlServer)this.pkey.getTableProxy()).existClusteredIndex(this.pkey)) {
            this.cbClustered.setEnabled(false);
        } else {
            this.cbClustered.setEnabled(true);
        }
        DataBaseSqlServer db = ((TableProxySqlServer)this.pkey.getTableProxy()).getDatabase();
        if (db != null) {
            Iterator filegroups = ((StorageObjectCollection)db.getChild(0)).iterator();
            while (filegroups.hasNext()) {
                FileGroupSqlServer fg = (FileGroupSqlServer)filegroups.next();
                this.cbFilegroup.addItem(fg);
            }
        }
        this.ifFillFactor.setValue((long)this.pkey.getFillFactor());
        this.comment = this.pkey.getObject().getComment();
        this.commentInRDBMS = this.pkey.getObject().getCommentInRDBMS();
        if (this.pkey.isCommentChanged()) {
            this.getCommentsList().insert(this.pkey.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.pkey.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.pkey.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initColumnsSortOrder();
    }

    @Override
    protected void setProperties() {
        if (this.pkey != null) {
            this.pkey.setName(this.tfName.getText());
            if (((String)this.cbClustered.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.pkey.setClustered(true);
            } else {
                this.pkey.setClustered(false);
            }
            if (((TableProxySqlServer)this.pkey.getTableProxy()).existClusteredIndex(this.pkey)) {
                this.cbClustered.setEnabled(false);
            } else {
                this.cbClustered.setEnabled(true);
            }
            this.pkey.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.pkey.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.pkey.getFillFactor());
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.pkey.setComment(commentText);
                this.pkey.setCommentChanged(true);
            } else {
                this.pkey.setComment("");
                this.pkey.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.pkey.setCommentInRDBMS(commentInRDBMSText);
                this.pkey.setCommentInRDBMSChanged(true);
            } else {
                this.pkey.setCommentInRDBMS("");
                this.pkey.setCommentInRDBMSChanged(false);
            }
            this.applyColumnsSortOrder();
        }
    }

    protected void initColumnsView(int height) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogSqlServer.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        JScrollPane sp = new JScrollPane(this.columnsTable);
        sp.setPreferredSize(new Dimension(395, height));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(sp);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.pkey.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection colNodes = this.sortModel.getColumnsSortOrederColl();
        Iterator it = colNodes.iterator();
        Index ind = (Index)this.pkey.getObject();
        while (it.hasNext()) {
            ColumnsSortOrderModel.ColumnNode cn = (ColumnsSortOrderModel.ColumnNode)it.next();
            Column col = (Column)ind.getElementByID(cn.objectId);
            if (col == null) continue;
            ind.setColumnSortOrder(col, cn.sortOrder);
        }
    }
}

