/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.ColumnsPermissionsDialogSqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PermissionsPropertiesDialogSqlServer
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("PermissionsPropertiesDialogSqlServer.Edit");
    private static String COLUMN_CHECKED = "c";
    private StorageObject storageObject;
    private JPanel objectsPanel;
    private UserSetSqlServer usersSet;
    private RoleSetSqlServer rolesSet;
    private ApplicationView appView;
    private StorageDesignSqlServer storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private ColumnsPermissionsDialogSqlServer dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertiesDialogSqlServer.this.bnCancel.doClick();
        }
    };
    private UsersTable usersTable;
    private RolesTable rolesTable;

    public PermissionsPropertiesDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view.getFrame());
        this.appView = view;
        this.storageDesign = (StorageDesignSqlServer)storageDesign;
        this.storageObject = object;
        this.storageObject.setDialogVisible(true, this);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PermissionsPropertiesDialogSqlServer.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel bottomPanel = new JPanel();
        if (this.isEditable()) {
            if (this.storageObject instanceof TableProxySqlServer) {
                JButton bnColumns = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServer.Columns"));
                bnColumns.addActionListener(new ColumnsPermissionsListener(this));
                bnColumns.setCursor(Cursor.getPredefinedCursor(12));
                bnColumns.setMnemonic(79);
                bottomPanel.add((Component)bnColumns, "Before");
            }
            JButton bnOK = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServer.OK"));
            bnOK.addActionListener(new OKAction());
            bnOK.setMnemonic(79);
            bottomPanel.add(bnOK);
            this.getRootPane().setDefaultButton(bnOK);
            JButton bnApply = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServer.Apply"));
            bnApply.addActionListener(new ApplyAction());
            bnApply.setMnemonic(65);
            bottomPanel.add(bnApply);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("PermissionsPropertiesDialogSqlServer.Cancel") : Messages.getString("PermissionsPropertiesDialogSqlServer.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escape);
        bottomPanel.add(this.bnCancel);
        this.jpanel.add((Component)bottomPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.addTabs();
        this.initProperties();
        this.setModal(true);
    }

    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    public void initProperties() {
        int k;
        int i;
        for (i = 0; i < this.usersTable.getRowCount(); ++i) {
            UserSqlServer user = (UserSqlServer)this.usersTable.getValueAt(i, 0);
            for (k = 0; k < this.usersTable.getColumnCount(); ++k) {
                if (this.usersTable.getValueAt(i, k) instanceof JButton) {
                    JButton button = (JButton)this.usersTable.getValueAt(i, k);
                    if (this.getPermission(user, this.storageObject) != null) {
                        if (this.getPermission(user, this.storageObject).getPrivileges().indexOf(this.usersTable.getColumnName(k)) > -1) {
                            button.setText(CHECKED);
                            button.updateUI();
                            continue;
                        }
                        if (this.getPermission(user, this.storageObject).getPrivilegesWithGrantOption().indexOf(this.usersTable.getColumnName(k)) > -1) {
                            button.setText(CHECKED_WITH_GRANT_OPTION);
                            button.updateUI();
                            continue;
                        }
                        if (this.getPermission(user, this.storageObject).hasColPrivilege(this.usersTable.getColumnName(k))) {
                            button.setText(COLUMN_CHECKED);
                            button.updateUI();
                            continue;
                        }
                        button.setText(EMPTY_VALUE);
                        button.updateUI();
                        continue;
                    }
                    button.setText(EMPTY_VALUE);
                    button.updateUI();
                    continue;
                }
                if (k != this.usersTable.getColumnCount() - 1 || this.getPermission(user, this.storageObject) == null) continue;
                if (this.getPermission(user, this.storageObject).getAsRole() != null) {
                    this.usersTable.setValueAt(this.getPermission(user, this.storageObject).getAsRole(), i, k);
                    continue;
                }
                this.usersTable.setValueAt("", i, k);
            }
        }
        for (i = 0; i < this.rolesTable.getRowCount(); ++i) {
            RoleSqlServer role = (RoleSqlServer)this.rolesTable.getValueAt(i, 0);
            for (k = 0; k < this.rolesTable.getColumnCount(); ++k) {
                if (this.rolesTable.getValueAt(i, k) instanceof JButton) {
                    JButton btn = (JButton)this.rolesTable.getValueAt(i, k);
                    if (this.getPermission(role, this.storageObject) != null) {
                        if (this.getPermission(role, this.storageObject).getPrivileges().indexOf(this.rolesTable.getColumnName(k)) > -1) {
                            btn.setText(CHECKED);
                            btn.updateUI();
                            continue;
                        }
                        if (this.getPermission(role, this.storageObject).hasColPrivilege(this.rolesTable.getColumnName(k))) {
                            btn.setText(COLUMN_CHECKED);
                            btn.updateUI();
                            continue;
                        }
                        btn.setText(EMPTY_VALUE);
                        btn.updateUI();
                        continue;
                    }
                    btn.setText(EMPTY_VALUE);
                    btn.updateUI();
                    continue;
                }
                if (k != this.rolesTable.getColumnCount() - 1 || this.getPermission(role, this.storageObject) == null) continue;
                if (this.getPermission(role, this.storageObject).getAsRole() != null) {
                    this.rolesTable.setValueAt(this.getPermission(role, this.storageObject).getAsRole(), i, k);
                    continue;
                }
                this.rolesTable.setValueAt("", i, k);
            }
        }
    }

    protected void addTabs() {
        this.initUsersTable();
        this.initRolesTable();
    }

    private void initRolesTable() {
        this.rolesSet = this.storageDesign.getRoleSet();
        this.rolesTable = new RolesTable();
        this.rolesTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.rolesTable);
        scrollpane.setPreferredSize(new Dimension(800, 280));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertiesDialogSqlServer.Roles"), this.objectsPanel);
        this.rolesTable.updateUI();
        RolesModel tableModel = (RolesModel)this.rolesTable.getModel();
        for (int i = 0; i < this.rolesSet.size(); ++i) {
            RoleSqlServer role = (RoleSqlServer)this.rolesSet.getElement(i);
            String[] list = this.storageObject instanceof TableProxySqlServer ? (String[])PermissionsSqlServer.getTablePermissionsValues().toArray() : (String[])PermissionsSqlServer.getViewPermissionsValues().toArray();
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(role);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initUsersTable() {
        this.usersSet = this.storageDesign.getUserSet();
        if (this.storageObject instanceof TableProxySqlServer) {
            if (((TableProxySqlServer)this.storageObject).getUser() != null) {
                this.usersSet.remove(((TableProxySqlServer)this.storageObject).getUser());
            }
        } else if (this.storageObject instanceof TableViewProxySqlServer && ((TableViewProxySqlServer)this.storageObject).getUser() != null) {
            this.usersSet.remove(((TableViewProxySqlServer)this.storageObject).getUser());
        }
        this.usersTable = new UsersTable();
        this.usersTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.usersTable);
        scrollpane.setPreferredSize(new Dimension(800, 280));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertiesDialogSqlServer.Users"), this.objectsPanel);
        this.usersTable.updateUI();
        UsersModel tableModel = (UsersModel)this.usersTable.getModel();
        for (int i = 0; i < this.usersSet.size(); ++i) {
            UserSqlServer user = (UserSqlServer)this.usersSet.getElement(i);
            String[] list = this.storageObject instanceof TableProxySqlServer ? (String[])PermissionsSqlServer.getTablePermissionsValues().toArray() : (String[])PermissionsSqlServer.getViewPermissionsValues().toArray();
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(user);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    protected void setProperties() {
        RoleSqlServer selectedRole;
        JButton button;
        int k;
        PermissionsSqlServer perm;
        int i;
        for (i = 0; i < this.usersTable.getRowCount(); ++i) {
            UserSqlServer user = (UserSqlServer)this.usersTable.getValueAt(i, 0);
            perm = this.getPermission(user, this.storageObject);
            if (this.hasSelectedUserPrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setUser(user);
                    if (this.storageObject instanceof TableProxySqlServer) {
                        perm.setTable((TableProxySqlServer)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxySqlServer) {
                        perm.setView((TableViewProxySqlServer)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.usersTable.getColumnCount(); ++k) {
                    if (this.usersTable.getValueAt(i, k) instanceof JButton) {
                        button = (JButton)this.usersTable.getValueAt(i, k);
                        if (button.getText().equals(CHECKED)) {
                            perm.setPrivileges(this.usersTable.getColumnName(k));
                            continue;
                        }
                        if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        perm.setPrivilegesWithGrantOption(this.usersTable.getColumnName(k));
                        continue;
                    }
                    if (!(this.usersTable.getValueAt(i, k) instanceof RoleSqlServer) || this.getPermission(user, this.storageObject) == null) continue;
                    selectedRole = (RoleSqlServer)this.usersTable.getValueAt(i, k);
                    this.getPermission(user, this.storageObject).setAsRole(selectedRole);
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
        for (i = 0; i < this.rolesTable.getRowCount(); ++i) {
            RoleSqlServer role = (RoleSqlServer)this.rolesTable.getValueAt(i, 0);
            perm = this.getPermission(role, this.storageObject);
            if (this.hasSelectedRolePrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setRole(role);
                    if (this.storageObject instanceof TableProxySqlServer) {
                        perm.setTable((TableProxySqlServer)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxySqlServer) {
                        perm.setView((TableViewProxySqlServer)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.rolesTable.getColumnCount(); ++k) {
                    if (this.rolesTable.getValueAt(i, k) instanceof JButton) {
                        button = (JButton)this.rolesTable.getValueAt(i, k);
                        if (button.getText().equals(CHECKED)) {
                            perm.setPrivileges(this.rolesTable.getColumnName(k));
                            continue;
                        }
                        if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        perm.setPrivilegesWithGrantOption(this.rolesTable.getColumnName(k));
                        continue;
                    }
                    if (!(this.rolesTable.getValueAt(i, k) instanceof RoleSqlServer) || this.getPermission(role, this.storageObject) == null) continue;
                    selectedRole = (RoleSqlServer)this.rolesTable.getValueAt(i, k);
                    this.getPermission(role, this.storageObject).setAsRole(selectedRole);
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
    }

    public String getCaption() {
        return Messages.getString("PermissionsPropertiesDialogSqlServer.Permissions");
    }

    public UserSetSqlServer getUsersSet() {
        return this.usersSet;
    }

    private PermissionsSqlServer getPermission(StorageObject user, StorageObject proxy) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        while (it.hasNext()) {
            PermissionsSqlServer perm = (PermissionsSqlServer)it.next();
            if (perm.getUser() != user && perm.getRole() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
            return perm;
        }
        return null;
    }

    private boolean hasSelectedUserPrivileges(int row) {
        for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
            if (!(this.usersTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.usersTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (button.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!button.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedRolePrivileges(int row) {
        for (int k = 1; k < this.rolesTable.getColumnCount(); ++k) {
            if (!(this.rolesTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.rolesTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (button.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!button.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    public void setColumnPermissions(StorageObject user, String priv) {
        block5: {
            int row;
            block4: {
                row = 0;
                if (!(user instanceof UserSqlServer)) break block4;
                for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
                    if (this.usersTable.getValueAt(i, 0) != user) continue;
                    row = i;
                    break;
                }
                for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(k).equalsIgnoreCase(priv)) continue;
                    JButton button = (JButton)this.usersTable.getValueAt(row, k);
                    button.setText(COLUMN_CHECKED);
                    this.usersTable.updateUI();
                }
                break block5;
            }
            if (!(user instanceof RoleSqlServer)) break block5;
            for (int i = 0; i < this.rolesTable.getRowCount(); ++i) {
                if (this.rolesTable.getValueAt(i, 0) != user) continue;
                row = i;
                break;
            }
            for (int k = 1; k < this.rolesTable.getColumnCount(); ++k) {
                if (!((RolesModel)this.rolesTable.getModel()).getColumnName(k).equalsIgnoreCase(priv)) continue;
                JButton button = (JButton)this.rolesTable.getValueAt(row, k);
                button.setText(COLUMN_CHECKED);
                this.rolesTable.updateUI();
            }
        }
    }

    public void clearColumnPermissions(StorageObject user, String priv) {
        block5: {
            int row;
            block4: {
                row = 0;
                if (!(user instanceof UserSqlServer)) break block4;
                for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
                    if (this.usersTable.getValueAt(i, 0) != user) continue;
                    row = i;
                    break;
                }
                for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
                    JButton button;
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(k).equalsIgnoreCase(priv) || !(button = (JButton)this.usersTable.getValueAt(row, k)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                    button.setText(EMPTY_VALUE);
                }
                break block5;
            }
            if (!(user instanceof RoleSqlServer)) break block5;
            for (int i = 0; i < this.rolesTable.getRowCount(); ++i) {
                if (this.rolesTable.getValueAt(i, 0) != user) continue;
                row = i;
                break;
            }
            for (int k = 1; k < this.rolesTable.getColumnCount(); ++k) {
                JButton button;
                if (!((RolesModel)this.rolesTable.getModel()).getColumnName(k).equalsIgnoreCase(priv) || !(button = (JButton)this.rolesTable.getValueAt(row, k)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                button.setText(EMPTY_VALUE);
            }
        }
    }

    class ButtonRoleTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonRoleTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(table.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonUserTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonUserTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (currentButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(table.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setText(value == null ? "" : "  " + ((JButton)value).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertiesDialogSqlServer.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertiesDialogSqlServer.this.setProperties();
            PermissionsPropertiesDialogSqlServer.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertiesDialogSqlServer.this.setProperties();
            PermissionsPropertiesDialogSqlServer.this.storageObject.setDirty(true);
            PermissionsPropertiesDialogSqlServer.this.dispose();
        }
    }

    private class ColumnsPermissionsListener
    implements ActionListener {
        PermissionsPropertiesDialogSqlServer permDialog;

        public ColumnsPermissionsListener(PermissionsPropertiesDialogSqlServer permDialog) {
            this.permDialog = permDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StorageObject selectedUser = null;
            if (PermissionsPropertiesDialogSqlServer.this.tpane.getSelectedIndex() == 0) {
                if (PermissionsPropertiesDialogSqlServer.this.usersTable.getSelectedRow() > -1) {
                    selectedUser = (StorageObject)PermissionsPropertiesDialogSqlServer.this.usersTable.getValueAt(PermissionsPropertiesDialogSqlServer.this.usersTable.getSelectedRow(), 0);
                }
            } else if (PermissionsPropertiesDialogSqlServer.this.rolesTable.getSelectedRow() > -1) {
                selectedUser = (StorageObject)PermissionsPropertiesDialogSqlServer.this.rolesTable.getValueAt(PermissionsPropertiesDialogSqlServer.this.rolesTable.getSelectedRow(), 0);
            }
            if (selectedUser != null && (PermissionsPropertiesDialogSqlServer.this.dialog == null || PermissionsPropertiesDialogSqlServer.this.dialog.getUser() != selectedUser)) {
                PermissionsPropertiesDialogSqlServer.this.dialog = new ColumnsPermissionsDialogSqlServer(PermissionsPropertiesDialogSqlServer.this.appView, PermissionsPropertiesDialogSqlServer.this.storageDesign, PermissionsPropertiesDialogSqlServer.this.storageObject, selectedUser, this.permDialog);
            }
            if (PermissionsPropertiesDialogSqlServer.this.dialog != null) {
                PermissionsPropertiesDialogSqlServer.this.dialog.show();
            }
        }
    }

    public class RolesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            String[] perms = PermissionsPropertiesDialogSqlServer.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePrivilegesValues() : PermissionsSqlServer.getViewPrivilegesValues();
            return perms.length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            Object[] perms = PermissionsPropertiesDialogSqlServer.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePermissionsValues().toArray() : PermissionsSqlServer.getViewPermissionsValues().toArray();
            if (column == 0) {
                return Messages.getString("PermissionsPropertiesDialogSqlServer.Role");
            }
            if (column == this.getColumnCount() - 1) {
                return Messages.getString("PermissionsPropertiesDialogSqlServer.AsRole");
            }
            for (int i = 1; i < this.getColumnCount() - 1; ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!PermissionsPropertiesDialogSqlServer.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class RolesTable
    extends JTable {
        RolesModel dataModel;

        public RolesTable() {
            this.dataModel = new RolesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0 || col == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            if (col == this.getColumnCount() - 1) {
                RoleSetSqlServer roles = PermissionsPropertiesDialogSqlServer.this.storageDesign.getRoleSet();
                Vector<Object> vect = new Vector<Object>();
                vect.addElement("");
                for (int i = 0; i < roles.size(); ++i) {
                    if (((RoleSqlServer)roles.getElement(i)).getName().equalsIgnoreCase("PUBLIC")) continue;
                    vect.addElement(roles.getElement(i));
                }
                JComboBox combo = new JComboBox();
                combo.setModel(new DefaultComboBoxModel(vect));
                return new DefaultCellEditor(combo);
            }
            return new ButtonRoleTableCellEditor();
        }
    }

    class UsersTable
    extends JTable {
        UsersModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0 || col == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            if (col == this.getColumnCount() - 1) {
                RoleSetSqlServer roles = PermissionsPropertiesDialogSqlServer.this.storageDesign.getRoleSet();
                Vector<Object> vect = new Vector<Object>();
                vect.addElement("");
                for (int i = 0; i < roles.size(); ++i) {
                    if (((RoleSqlServer)roles.getElement(i)).getName().equalsIgnoreCase("PUBLIC")) continue;
                    vect.addElement(roles.getElement(i));
                }
                JComboBox combo = new JComboBox();
                combo.setModel(new DefaultComboBoxModel(vect));
                return new DefaultCellEditor(combo);
            }
            return new ButtonUserTableCellEditor();
        }
    }

    public class UsersModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] perms = PermissionsPropertiesDialogSqlServer.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePermissionsValues().toArray() : PermissionsSqlServer.getViewPermissionsValues().toArray();
            return perms.length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            Object[] perms = PermissionsPropertiesDialogSqlServer.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePermissionsValues().toArray() : PermissionsSqlServer.getViewPermissionsValues().toArray();
            if (column == 0) {
                return Messages.getString("PermissionsPropertiesDialogSqlServer.User");
            }
            if (column == this.getColumnCount() - 1) {
                return Messages.getString("PermissionsPropertiesDialogSqlServer.AsRole");
            }
            for (int i = 1; i < this.getColumnCount() - 1; ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!PermissionsPropertiesDialogSqlServer.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

