/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class RulePropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private RuleSqlServer rule;
    private JComboBox cbOwner;
    private JTextField tfExpression;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;

    public RulePropertyDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.rule = (RuleSqlServer)object;
        this.setHeight(360);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RulePropertyDialogSqlServer.RuleProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initExpression();
        this.initColumns();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("RulePropertyDialogSqlServer.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initExpression() {
        JLabel label = new JLabel(Messages.getString("RulePropertyDialogSqlServer.Expression"));
        this.general.add(label);
        this.tfExpression = new JTextField("", 26);
        this.general.add(this.tfExpression);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfExpression, 80);
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("RulePropertyDialogSqlServer.AllColumns"));
        this.general.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 180));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 12, 114);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 132);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("RulePropertyDialogSqlServer.SelectedColumns"));
        this.general.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 180));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 292, 114);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 290, 132);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("RulePropertyDialogSqlServer.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.general.add(this.bnAdd);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAdd, 175, 195);
        this.bnRemove = new JButton(Messages.getString("RulePropertyDialogSqlServer.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.general.add(this.bnRemove);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemove, 175, 225);
        RulePropertyDialogSqlServer.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.rule.getName());
        this.tfName.setText(this.rule.getName());
        Iterator users = this.rule.getDatabase().getUsers().iterator();
        while (users.hasNext()) {
            UserSqlServer user = (UserSqlServer)users.next();
            if (user.getName().equalsIgnoreCase("GUEST")) continue;
            this.cbOwner.addItem(user);
        }
        this.cbOwner.setSelectedItem(this.rule.getOwner());
        this.tfExpression.setText(this.rule.getExpression());
        Iterator columnSet = this.getStorageDesign().getColumnProxySet().iterator();
        while (columnSet.hasNext()) {
            ColumnProxySqlServer column = (ColumnProxySqlServer)columnSet.next();
            if (column.getTableProxy().getDatabase() != this.rule.getDatabase()) continue;
            if (this.rule.getColumnSet().contains(column.getName())) {
                this.addElementToSortedListModel(this.selectedColumnsModel, column);
                continue;
            }
            this.addElementToSortedListModel(this.allColumnsModel, column);
        }
        this.getCommentsList().insert(this.rule.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.rule != null) {
            this.rule.setOwner((UserSqlServer)this.cbOwner.getSelectedItem());
            this.rule.setName(this.tfName.getText());
            this.rule.setExpression(this.tfExpression.getText());
            Object[] columnSet = this.selectedColumnsModel.toArray();
            this.rule.clear();
            for (int i = 0; i < columnSet.length; ++i) {
                Object ob = columnSet[i];
                if (!(ob instanceof ColumnProxySqlServer)) continue;
                this.rule.setColumns(((ColumnProxySqlServer)ob).getName());
            }
            this.rule.setComment(this.getCommentsList().getText());
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RulePropertyDialogSqlServer.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RulePropertyDialogSqlServer.this.selectedColumnsList.getSelectedIndex() == -1) {
                    RulePropertyDialogSqlServer.this.bnRemove.setEnabled(false);
                } else {
                    RulePropertyDialogSqlServer.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (RulePropertyDialogSqlServer.this.isEditable() && !e.getValueIsAdjusting()) {
                if (RulePropertyDialogSqlServer.this.allColumnsList.getSelectedIndex() == -1) {
                    RulePropertyDialogSqlServer.this.bnAdd.setEnabled(false);
                } else {
                    RulePropertyDialogSqlServer.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RulePropertyDialogSqlServer.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = RulePropertyDialogSqlServer.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (RulePropertyDialogSqlServer.this.allColumnsModel.contains(ob)) continue;
                    RulePropertyDialogSqlServer.this.addElementToSortedListModel(RulePropertyDialogSqlServer.this.allColumnsModel, ob);
                    RulePropertyDialogSqlServer.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RulePropertyDialogSqlServer.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = RulePropertyDialogSqlServer.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (RulePropertyDialogSqlServer.this.selectedColumnsModel.contains(ob)) continue;
                    RulePropertyDialogSqlServer.this.addElementToSortedListModel(RulePropertyDialogSqlServer.this.selectedColumnsModel, ob);
                    RulePropertyDialogSqlServer.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }
}

