/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FKProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FKPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private FKProxySqlServerv2k5 fkey;
    private JTextField tfTable;
    private JTextField tfRefTable;
    private JTextField tfOnDelete;
    private JComboBox cbOnUpdate;
    private JComboBox cbForReplication;
    private JPanel columns;
    private JPanel refColumns;
    private JList columnList;
    private JList refColumnsList;
    private DefaultListModel columnListModel;
    private DefaultListModel refColumnsListModel;

    public FKPropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.fkey = (FKProxySqlServerv2k5)object;
        this.setHeight(230);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FKPropertyDialogSqlServerv2k5.FKProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initRefTable();
        this.initOnDelete();
        this.initOnUpdate();
        this.initForReplication();
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogSqlServerv2k5.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initRefTable() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogSqlServerv2k5.RefTable"));
        this.general.add(label);
        this.tfRefTable = new JTextField("", 26);
        this.tfRefTable.setEditable(false);
        this.general.add(this.tfRefTable);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfRefTable, 80);
    }

    private void initOnDelete() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogSqlServerv2k5.OnDelete"));
        this.general.add(label);
        this.tfOnDelete = new JTextField();
        this.setBG(this.tfOnDelete);
        this.tfOnDelete.setPreferredSize(this.tfName.getPreferredSize());
        this.tfOnDelete.setEnabled(false);
        this.general.add(this.tfOnDelete);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfOnDelete, 110);
    }

    private void initOnUpdate() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogSqlServerv2k5.OnUpdate"));
        this.general.add(label);
        this.cbOnUpdate = new JComboBox<String>(FKProxySqlServerv2k5.getOnChoices());
        this.setBG(this.cbOnUpdate);
        this.cbOnUpdate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnUpdate);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbOnUpdate, 140);
    }

    private void initForReplication() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogSqlServerv2k5.ApplyInReplication"));
        this.general.add(label);
        this.cbForReplication = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForReplication);
        this.cbForReplication.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForReplication);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbForReplication, 170);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initRefColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogSqlServerv2k5.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.columnList);
        sp.setPreferredSize(new Dimension(395, 180));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getRefColumnsLayout() {
        return (SpringLayout)this.refColumns.getLayout();
    }

    private void initRefColumnsView() {
        this.refColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogSqlServerv2k5.ReferencedColumns"), this.refColumns);
        this.initRefColumns();
    }

    private void initRefColumns() {
        this.refColumnsListModel = new DefaultListModel();
        this.refColumnsList = new JList(this.refColumnsListModel);
        this.refColumnsList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.refColumnsList);
        sp.setPreferredSize(new Dimension(395, 180));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.refColumns.add(sp);
        this.setObjectConstraints(this.getRefColumnsLayout(), sp, 10, 12);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.fkey.getName());
        this.tfName.setText(this.fkey.getName());
        this.tfTable.setText(this.fkey.getTable().getName());
        this.tfRefTable.setText(this.fkey.getReferenceTable());
        ColumnProxy[] proxies = this.fkey.getColumnProxies();
        for (int i = 0; i < proxies.length; ++i) {
            ColumnProxy proxy = proxies[i];
            this.columnListModel.addElement(proxy);
        }
        Column[] cols = this.fkey.getRefColumns();
        for (int i = 0; i < cols.length; ++i) {
            Column column = cols[i];
            this.refColumnsListModel.addElement(column);
        }
        this.tfOnDelete.setText(this.fkey.getStorageDesign().getValidFKRule(((Index)this.fkey.getObject()).getFKAssociation().getDeleteRule()));
        this.cbOnUpdate.setSelectedItem(this.fkey.getOnUpdate());
        this.cbForReplication.setSelectedItem(FKPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.fkey.getForReplication()));
        this.getCommentsList().insert(this.fkey.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.fkey != null) {
            this.fkey.setName(this.tfName.getText());
            this.fkey.setOnUpdate((String)this.cbOnUpdate.getSelectedItem());
            this.fkey.setForReplication(FKPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbForReplication.getSelectedItem()));
            this.fkey.setComment(this.getCommentsList().getText());
        }
    }
}

