/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.FKProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FKPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private FKProxyUDB fkIndex;
    private JTextField tfTable;
    private JTextField tfRefTable;
    private JTextField tfOnDelete;
    private JComboBox cbOnUpdate;
    private JPanel columns;
    private JPanel refColumns;
    private JList columnList;
    private JList refColumnsList;
    private DefaultListModel columnListModel;
    private DefaultListModel refColumnsListModel;

    public FKPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.fkIndex = (FKProxyUDB)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FKPropertyDialogUDB.FKProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initRefTable();
        this.initOnDelete();
        this.initOnUpdate();
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogUDB.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initRefTable() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogUDB.RefTable"));
        this.general.add(label);
        this.tfRefTable = new JTextField("", 26);
        this.tfRefTable.setEditable(false);
        this.general.add(this.tfRefTable);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfRefTable, 80);
    }

    private void initOnDelete() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogUDB.OnDelete"));
        this.general.add(label);
        this.tfOnDelete = new JTextField();
        this.setBG(this.tfOnDelete);
        this.tfOnDelete.setPreferredSize(this.tfName.getPreferredSize());
        this.tfOnDelete.setEnabled(false);
        this.general.add(this.tfOnDelete);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfOnDelete, 110);
    }

    private void initOnUpdate() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogUDB.OnUpdate"));
        this.general.add(label);
        this.cbOnUpdate = new JComboBox<String>(FKProxyUDB.getOnUpdateChoices());
        this.setBG(this.cbOnUpdate);
        this.cbOnUpdate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnUpdate);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbOnUpdate, 140);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initRefColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogUDB.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.columnList);
        sp.setPreferredSize(new Dimension(395, 150));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getRefColumnsLayout() {
        return (SpringLayout)this.refColumns.getLayout();
    }

    private void initRefColumnsView() {
        this.refColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogUDB.ReferencedColumns"), this.refColumns);
        this.initRefColumns();
    }

    private void initRefColumns() {
        this.refColumnsListModel = new DefaultListModel();
        this.refColumnsList = new JList(this.refColumnsListModel);
        this.refColumnsList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.refColumnsList);
        sp.setPreferredSize(new Dimension(395, 150));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.refColumns.add(sp);
        this.setObjectConstraints(this.getRefColumnsLayout(), sp, 10, 12);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.fkIndex.getName());
        this.tfName.setText(this.fkIndex.getName());
        this.tfTable.setText(this.fkIndex.getTable().getName());
        this.tfRefTable.setText(this.fkIndex.getReferenceTable());
        ColumnProxy[] proxies = this.fkIndex.getColumnProxies();
        for (int i = 0; i < proxies.length; ++i) {
            ColumnProxy proxy = proxies[i];
            this.columnListModel.addElement(proxy);
        }
        Column[] cols = this.fkIndex.getRefColumns();
        for (int i = 0; i < cols.length; ++i) {
            Column column = cols[i];
            this.refColumnsListModel.addElement(column);
        }
        String deleteRule = ((Index)this.fkIndex.getObject()).getFKAssociation().getDeleteRule();
        if (deleteRule.equalsIgnoreCase("SET DEFAULT")) {
            deleteRule = ((Index)this.fkIndex.getObject()).getFKAssociation().isMandatory() ? "RESTRICT" : "SET NULL";
        }
        this.tfOnDelete.setText(deleteRule);
        this.cbOnUpdate.setSelectedItem(this.fkIndex.getOnUpdate());
        this.getCommentsList().insert(this.fkIndex.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.fkIndex != null) {
            this.fkIndex.setName(this.tfName.getText());
            this.fkIndex.setOnUpdate((String)this.cbOnUpdate.getSelectedItem());
            this.fkIndex.setComment(this.getCommentsList().getText());
        }
    }
}

